/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.julielab.neo4j.plugins.auxiliaries.JulieNeo4jUtilities;
import java.lang.invoke.CallSite;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;

public class PropertyUtilities {
    public static void copyObjectToEntity(Object object, Entity node) {
        PropertyUtilities.copyObjectToEntity(object, node, (Set<String>)null);
    }

    public static void copyObjectToEntity(Object object, Entity node, String ... exclusions) {
        HashSet<String> exclusionSet = new HashSet<String>();
        for (String exclusion : exclusions) {
            exclusionSet.add(exclusion);
        }
        PropertyUtilities.copyObjectToEntity(object, node, exclusionSet);
    }

    public static void copyObjectToEntity(Object object, Entity node, Set<String> exclusions) {
        try {
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                String key = field.getName();
                JsonProperty[] jsonProperties = (JsonProperty[])field.getAnnotationsByType(JsonProperty.class);
                if (jsonProperties != null && jsonProperties[0].value() != null) {
                    key = jsonProperties[0].value();
                }
                if ((1 & field.getModifiers()) == 0 || exclusions != null && exclusions.contains(key)) continue;
                Object[] value = field.get(object);
                if (value != null) {
                    if (List.class.isAssignableFrom(value.getClass())) {
                        value = ((List)value).toArray();
                    }
                    node.setProperty(key, (Object)value);
                    continue;
                }
                node.removeProperty(key);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void mergeObjectIntoEntity(Object object, Entity node, String ... exclusions) {
        HashSet<String> exclusionSet = new HashSet<String>();
        for (String exclusion : exclusions) {
            exclusionSet.add(exclusion);
        }
        PropertyUtilities.mergeObjectIntoEntity(object, node, exclusionSet);
    }

    public static void mergeObjectIntoEntity(Object object, Entity node, Set<String> exclusions) {
        try {
            Field[] fields;
            for (Field field : fields = object.getClass().getFields()) {
                Object value;
                String key = field.getName();
                JsonProperty[] jsonProperties = (JsonProperty[])field.getAnnotationsByType(JsonProperty.class);
                if (jsonProperties != null && jsonProperties[0].value() != null) {
                    key = jsonProperties[0].value();
                }
                if ((1 & field.getModifiers()) == 0 || exclusions != null && exclusions.contains(key) || (value = field.get(object)) == null) continue;
                if (value.getClass().isArray()) {
                    PropertyUtilities.mergeArrayProperty(node, key, (Object[])value);
                    continue;
                }
                if (List.class.isAssignableFrom(value.getClass())) {
                    PropertyUtilities.mergeArrayProperty(node, key, ((List)value).toArray());
                    continue;
                }
                PropertyUtilities.setNonNullNodeProperty(node, key, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void mergeEntityIntoEntity(Node from, Node to, String ... exclusions) {
        HashSet<String> exclusionSet = new HashSet<String>();
        for (String exclusion : exclusions) {
            exclusionSet.add(exclusion);
        }
        PropertyUtilities.mergeJSONObjectIntoEntity(from, to, exclusionSet);
    }

    private static void mergeJSONObjectIntoEntity(Node from, Node to, Set<String> exclusions) {
        for (String key : from.getPropertyKeys()) {
            if (null != exclusions && exclusions.contains(key)) continue;
            Object value = from.getProperty(key);
            if (value.getClass().isArray()) {
                PropertyUtilities.mergeArrayProperty((Entity)to, key, (Object[])value);
                continue;
            }
            PropertyUtilities.setNonNullNodeProperty((Entity)to, key, value);
        }
    }

    public static <T> void mergeArrayProperty(Entity node, String key, Supplier<T[]> arraySupplier) {
        try {
            T[] value = arraySupplier.get();
            PropertyUtilities.mergeArrayProperty(node, key, value);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static <T> void mergeArrayProperty(Entity node, String key, T[] array) {
        try {
            if (null == array || array.length == 0) {
                return;
            }
            if (array[0] == null) {
                throw new IllegalArgumentException("An array was passed whose first element is null. This is not allowed.");
            }
            LinkedHashSet<Object> set = new LinkedHashSet<Object>();
            for (T o : array) {
                set.add(o);
            }
            if (node.hasProperty(key)) {
                Object storedArray = node.getProperty(key);
                for (int i = 0; i < Array.getLength(storedArray); ++i) {
                    set.add(Array.get(storedArray, i));
                }
            }
            Object[] newArray = (Object[])Array.newInstance(array[0].getClass(), set.size());
            try {
                set.toArray(newArray);
            }
            catch (ArrayStoreException e) {
                Object next = set.iterator().next();
                throw new IllegalArgumentException("Trying to merge array properties of different types (array class: " + newArray.getClass() + " element class: " + next.getClass() + ")");
            }
            node.setProperty(key, (Object)newArray);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while merging property \"" + key + "\" of property container \"" + node + "\" (value before merging: \"" + (node.hasProperty(key) ? node.getProperty(key) : null) + ")\" with data \"" + Arrays.toString(array) + "\" (object notation: \"" + array + "\").", e);
        }
    }

    public static <T> int addToArrayProperty(Entity node, String key, T value) {
        return PropertyUtilities.addToArrayProperty(node, key, value, false, false);
    }

    public static <T> int addToArrayProperty(Entity node, String key, T value, boolean allowDuplicates) {
        return PropertyUtilities.addToArrayProperty(node, key, value, allowDuplicates, false);
    }

    public static <T> int addToArrayProperty(Entity node, String key, T value, boolean allowDuplicates, boolean allowNullValues) {
        if (!allowNullValues && null == value) {
            return -1;
        }
        Object[] array = null;
        if (node.hasProperty(key)) {
            Object arrayProperty = node.getProperty(key);
            try {
                array = (Object[])arrayProperty;
            }
            catch (ClassCastException e) {
                array = JulieNeo4jUtilities.convertArray(arrayProperty);
            }
        } else {
            Object[] newArray = (Object[])Array.newInstance(value.getClass(), 1);
            newArray[0] = value;
            node.setProperty(key, (Object)newArray);
            return 0;
        }
        boolean valueFound = false;
        if (!allowDuplicates) {
            for (Object element : array) {
                if (!element.equals(value)) continue;
                valueFound = true;
                break;
            }
        }
        if (!valueFound || allowDuplicates) {
            Object[] newArray = (Object[])Array.newInstance(value.getClass(), array.length + 1);
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[newArray.length - 1] = value;
            node.setProperty(key, (Object)newArray);
            return newArray.length - 1;
        }
        return -1;
    }

    public static void setNonNullNodeProperty(Entity node, String key, Supplier<Object> value) {
        try {
            Object nonNulValue = value.get();
            PropertyUtilities.setNonNullNodeProperty(node, key, nonNulValue);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void setNonNullNodeProperty(Entity node, String key, Object value) {
        if (null == value) {
            return;
        }
        if (node.hasProperty(key)) {
            return;
        }
        node.setProperty(key, value);
    }

    public static void setNonNullNodeProperty(Entity node, String key, Object value, Object defaultValue) {
        if (node.hasProperty(key)) {
            return;
        }
        if (null != value) {
            node.setProperty(key, value);
        } else {
            node.setProperty(key, defaultValue);
        }
    }

    public static Object getNonNullNodeProperty(Entity node, String key) {
        if (null != node && node.hasProperty(key)) {
            return node.getProperty(key);
        }
        return null;
    }

    public static String getNodePropertiesAsString(Entity node) {
        ArrayList<CallSite> values = new ArrayList<CallSite>();
        for (String pk : node.getPropertyKeys()) {
            Object p = node.getProperty(pk);
            if (p.getClass().isArray()) {
                values.add((CallSite)((Object)(pk + ": " + Arrays.toString(JulieNeo4jUtilities.convertArray(p)))));
                continue;
            }
            values.add((CallSite)((Object)(pk + ": " + p)));
        }
        return StringUtils.join(values, (String)" ; ");
    }

    public static int findFirstValueInArrayProperty(Node term, String key, String value) {
        if (!term.hasProperty(key)) {
            return -1;
        }
        Object property = term.getProperty(key);
        Object[] array = JulieNeo4jUtilities.convertArray(property);
        for (int i = 0; i < array.length; ++i) {
            if (null != array[i] && array[i].equals(value)) {
                return i;
            }
            if (null != array[i] || null != value) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasSamePropertyValue(Entity term, String key, Object valueToCompare) {
        if (null != valueToCompare && !term.hasProperty(key)) {
            return false;
        }
        Object value = term.getProperty(key);
        return valueToCompare.equals(value);
    }

    public static boolean hasContradictingPropertyValue(Entity term, String key, Object valueToCompare) {
        if (null == term || null == valueToCompare || !term.hasProperty(key)) {
            return false;
        }
        Object value = term.getProperty(key);
        return !valueToCompare.equals(value);
    }

    public static boolean mergeProperties(Entity propContainer, Object ... properties) {
        boolean success = true;
        if (null != properties && properties.length > 0) {
            for (int i = 0; i < properties.length; i += 2) {
                String key = (String)properties[i];
                Object value = properties[i + 1];
                boolean passedValueIsArray = value.getClass().isArray();
                if (propContainer.hasProperty(key)) {
                    Object existingValue = propContainer.getProperty(key);
                    boolean existingValueIsArray = existingValue.getClass().isArray();
                    if (!existingValueIsArray && !value.equals(existingValue)) {
                        success = false;
                        continue;
                    }
                    if (existingValueIsArray != passedValueIsArray) {
                        throw new IllegalArgumentException("Trying to merge an array value with a non-array value.");
                    }
                    if (!existingValueIsArray) continue;
                    PropertyUtilities.mergeArrayProperty(propContainer, key, (Object[])value);
                    continue;
                }
                propContainer.setProperty(key, value);
            }
        }
        return success;
    }
}

