/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries;

import de.julielab.neo4j.plugins.auxiliaries.JulieNeo4jUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

public class JSON {
    @SafeVarargs
    public static <T> T[] json2JavaArray(JSONArray jsonArray, T ... exclusions) throws JSONException {
        if (null == jsonArray || jsonArray.length() == 0) {
            return null;
        }
        HashSet<T> exclusionSet = null;
        if (exclusions.length > 0) {
            exclusionSet = new HashSet<T>();
            for (T e : exclusions) {
                exclusionSet.add(e);
            }
        }
        Class<Object> listElementClass = jsonArray.get(0).getClass();
        ArrayList<Object> list = new ArrayList<Object>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object object = jsonArray.get(i);
            if (!(JSONObject.NULL == object || null != exclusionSet && exclusionSet.contains(object))) {
                list.add(object);
            }
            if (listElementClass.isAssignableFrom(object.getClass())) continue;
            listElementClass = !object.getClass().isAssignableFrom(listElementClass) ? Object.class : object.getClass();
        }
        return JulieNeo4jUtilities.convertListToArray(list, listElementClass);
    }

    public static String getString(JSONObject o, String key) throws JSONException {
        if (o.isNull(key)) {
            return null;
        }
        return o.getString(key);
    }

    public static JSONObject getJSONObject(JSONObject o, String key) throws JSONException {
        if (o.isNull(key)) {
            return null;
        }
        return o.getJSONObject(key);
    }

    public static JSONArray getJSONArray(JSONObject o, String key) throws JSONException {
        if (o.isNull(key)) {
            return null;
        }
        return o.getJSONArray(key);
    }

    public static boolean getBoolean(JSONObject o, String key, boolean defaultValue) throws JSONException {
        if (o.isNull(key)) {
            return defaultValue;
        }
        return o.getBoolean(key);
    }

    public static boolean getBoolean(JSONObject o, String key) throws JSONException {
        return JSON.getBoolean(o, key, false);
    }

    public static Integer getInt(JSONObject o, String key) throws JSONException {
        if (o.isNull(key)) {
            return null;
        }
        return o.getInt(key);
    }

    public static <T> Set<T> jsonArray2JavaSet(JSONArray jsonArray) throws JSONException {
        if (jsonArray == null) {
            return null;
        }
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            set.add(jsonArray.get(i));
        }
        return set;
    }
}

