/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries;

import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;

public class NodeUtilities
extends PropertyUtilities {
    public static Node getSingleNode(ResourceIterable<Node> iterable) {
        return NodeUtilities.getSingleNode((ResourceIterator<Node>)iterable.iterator());
    }

    public static Node getSingleNode(ResourceIterator<Node> iterator) {
        Node node = null;
        if (iterator.hasNext()) {
            node = (Node)iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalStateException("ResourceIterator has more than one element.");
            }
        }
        return node;
    }

    public static Node findSingleNodeByLabelAndProperty(GraphDatabaseService graphDb, Label label, String key, String value) {
        Node node = null;
        ResourceIterator resourceIterator = graphDb.findNodes(label, key, (Object)value);
        if (resourceIterator.hasNext()) {
            node = (Node)resourceIterator.next();
            if (resourceIterator.hasNext()) {
                ArrayList<String> properties = new ArrayList<String>();
                for (String propKey : node.getPropertyKeys()) {
                    properties.add(node.getProperty(propKey).toString());
                }
                throw new IllegalStateException("There is more then one node with label \"" + label + "\" and property value \"" + value + "\" for the property \"" + key + "\". First node was: " + node + " (properties: \"" + StringUtils.join(properties, (String)" ; ") + "\").");
            }
        }
        return node;
    }

    public static Node getSingleOtherNode(Node node, RelationshipType type) {
        Node otherNode = null;
        Iterator it = node.getRelationships(new RelationshipType[]{type}).iterator();
        if (it.hasNext()) {
            Relationship relationship = (Relationship)it.next();
            otherNode = relationship.getOtherNode(node);
            if (it.hasNext()) {
                ArrayList<String> properties = new ArrayList<String>();
                for (String key : node.getPropertyKeys()) {
                    properties.add(key + "=" + node.getProperty(key).toString());
                }
                throw new IllegalStateException("Node " + node + " (properties: " + StringUtils.join(properties, (String)" ; ") + ") is incident on more than one relationship of type  " + type + ".");
            }
        }
        return otherNode;
    }

    public static Node copyNode(GraphDatabaseService graphDb, Node source) {
        Node copy = graphDb.createNode();
        for (String key : source.getPropertyKeys()) {
            copy.setProperty(key, source.getProperty(key));
        }
        return copy;
    }

    public static String[] getNodePropertyAsStringArrayValue(Node node, String property) {
        if (!node.hasProperty(property)) {
            return null;
        }
        String[] ret = null;
        Object propertyValue = node.getProperty(property);
        if (propertyValue.getClass().equals(String.class)) {
            ret = new String[]{(String)propertyValue};
        } else if (propertyValue.getClass().equals(String[].class)) {
            ret = (String[])propertyValue;
        }
        return ret;
    }
}

