/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.evaluators;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;

public class PropertyEvaluator
implements Evaluator {
    private final Object propertyValue;
    private final boolean allProperties;
    private final boolean allValues;
    private final List<String> propertyKeyList;

    public PropertyEvaluator(String propertyKey, Object propertyValue) {
        this.propertyValue = propertyValue;
        this.allProperties = propertyKey.equals("*");
        this.allValues = propertyValue.equals("*");
        this.propertyKeyList = new ArrayList<String>(1);
        this.propertyKeyList.add(propertyKey);
    }

    public Evaluation evaluate(Path path) {
        Evaluation eval = Evaluation.EXCLUDE_AND_CONTINUE;
        if (this.allProperties && this.allValues) {
            return Evaluation.INCLUDE_AND_CONTINUE;
        }
        Node node = path.endNode();
        List<String> propertyKeys = this.allProperties ? node.getPropertyKeys() : this.propertyKeyList;
        block0: for (String propertyKey : propertyKeys) {
            if (!node.hasProperty(propertyKey)) continue;
            if (this.allValues) {
                return Evaluation.INCLUDE_AND_CONTINUE;
            }
            Object value = node.getProperty(propertyKey);
            if (value.getClass().isArray()) {
                Object[] valueArray;
                for (Object o : valueArray = (Object[])value) {
                    if (!o.equals(this.propertyValue)) continue;
                    eval = Evaluation.INCLUDE_AND_CONTINUE;
                    continue block0;
                }
                continue;
            }
            if (!value.equals(this.propertyValue)) continue;
            eval = Evaluation.INCLUDE_AND_CONTINUE;
        }
        return eval;
    }
}

