/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.datarepresentation.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import de.julielab.neo4j.plugins.datarepresentation.util.UncheckedJsonProcessingException;
import java.io.IOException;

public class ConceptsJsonSerializer {
    private static ObjectMapper mapper = new ObjectMapper().registerModule(new Jdk8Module());

    private ConceptsJsonSerializer() {
    }

    public static synchronized String toJson(Object serializable) {
        try {
            return mapper.writeValueAsString(serializable);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedJsonProcessingException(e);
        }
    }

    public static synchronized JsonNode toJsonTree(Object serializable) {
        return mapper.valueToTree(serializable);
    }

    public static synchronized <T> T fromJson(String json, Class<T> cls) throws IOException {
        return mapper.readValue(json, cls);
    }

    public static synchronized <T> T fromJson(String json, TypeReference<T> ref) throws IOException {
        return mapper.readValue(json, ref);
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

