/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.concepts;

import de.julielab.neo4j.plugins.concepts.ConceptAggregateManager;
import de.julielab.neo4j.plugins.concepts.ConceptEdgeTypes;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import de.julielab.neo4j.plugins.datarepresentation.RelationIdList;
import de.julielab.neo4j.plugins.datarepresentation.RelationRetrievalRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class IERelationRetrieval {
    private static final Label LABEL_GENEGROUP = Label.label((String)"AGGREGATE_GENEGROUP");
    private static final Label LABEL_TOP_ORTHOLOGY = Label.label((String)"AGGREGATE_TOP_ORTHOLOGY");

    public static List<Map<String, Object>> retrieve(RelationRetrievalRequest retrievalRequest, GraphDatabaseService dbms, Log log) {
        try (Transaction tx = dbms.beginTx();){
            RelationshipType[] relationTypes = (RelationshipType[])retrievalRequest.getRelationTypes().stream().map(RelationshipType::withName).toArray(RelationshipType[]::new);
            if (retrievalRequest.getBlist() == null || retrievalRequest.getBlist().getIds().isEmpty()) {
                List<Map<String, Object>> list = IERelationRetrieval.serveOneSidedRequest(tx, retrievalRequest.getAlist(), relationTypes, retrievalRequest.isInterInputRelationRetrievalEnabled());
                return list;
            }
            List<Map<String, Object>> list = IERelationRetrieval.serveTwoSidedRequest(tx, retrievalRequest.getAlist(), retrievalRequest.getBlist(), relationTypes);
            return list;
        }
    }

    private static List<Map<String, Object>> serveTwoSidedRequest(Transaction tx, RelationIdList aList, RelationIdList bList, RelationshipType[] relationTypes) {
        boolean aIsLarger = aList.getIds().size() > bList.getIds().size();
        List<Node> smallerList = IERelationRetrieval.getNodes(tx, aIsLarger ? bList : aList);
        String smallerListIdProperty = IERelationRetrieval.getIdEffectiveIdProperty(aIsLarger ? bList : aList);
        String largerListIdProperty = IERelationRetrieval.getIdEffectiveIdProperty(aIsLarger ? aList : bList);
        Set largerAggs = IERelationRetrieval.getNodes(tx, aIsLarger ? aList : bList).stream().map(IERelationRetrieval::findHighestOrthologyAggregate).collect(Collectors.toSet());
        ArrayList results = new ArrayList();
        HashMap<ImmutablePair<String, String>, Map> accumulator = new HashMap<ImmutablePair<String, String>, Map>();
        for (Node a : smallerList) {
            Node orthologyAggregate = IERelationRetrieval.findHighestOrthologyAggregate(a);
            List<Node> elementNodes = ConceptAggregateManager.getNonAggregateElements(orthologyAggregate);
            for (Node element : elementNodes) {
                Iterable relationships = element.getRelationships(relationTypes);
                for (Relationship r : relationships) {
                    Node otherNode = r.getOtherNode(element);
                    Node otherOrthologyAggregate = IERelationRetrieval.findHighestOrthologyAggregate(otherNode);
                    if (!largerAggs.contains(otherOrthologyAggregate)) continue;
                    String smallListNodeName = (String)orthologyAggregate.getProperty("preferredName");
                    String smallListNodeId = (String)orthologyAggregate.getProperty(smallerListIdProperty);
                    String largeListNodeName = (String)otherOrthologyAggregate.getProperty("preferredName");
                    String largeListNodeId = (String)otherOrthologyAggregate.getProperty(largerListIdProperty);
                    String arg1Name = aIsLarger ? largeListNodeName : smallListNodeName;
                    String arg1Id = aIsLarger ? largeListNodeId : smallListNodeId;
                    String arg2Name = aIsLarger ? smallListNodeName : largeListNodeName;
                    String arg2Id = aIsLarger ? smallListNodeId : largeListNodeId;
                    int count = (Integer)r.getProperty("totalCount");
                    accumulator.merge(new ImmutablePair<String, String>(arg1Id, arg2Id), IERelationRetrieval.makeResultLine(arg1Name, arg1Id, arg2Name, arg2Id, count), (m1, m2) -> {
                        m1.put("count", (Integer)m1.get("count") + (Integer)m2.get("count"));
                        return m1;
                    });
                }
            }
        }
        return accumulator.values().stream().collect(Collectors.toList());
    }

    private static List<Map<String, Object>> serveOneSidedRequest(Transaction tx, RelationIdList aList, RelationshipType[] relationTypes, boolean interInputRelationRetrievalEnabled) {
        List<Node> aNodes = IERelationRetrieval.getNodes(tx, aList);
        Map el2agg = aNodes.stream().collect(Collectors.toMap(Function.identity(), IERelationRetrieval::findHighestOrthologyAggregate));
        Set requestedAggregateIds = !interInputRelationRetrievalEnabled ? el2agg.values().stream().map(n -> n.getProperty(IERelationRetrieval.getIdEffectiveIdProperty(aList))).map(String.class::cast).collect(Collectors.toSet()) : null;
        HashMap<ImmutablePair<String, String>, Map> accumulator = new HashMap<ImmutablePair<String, String>, Map>();
        String effectiveIdProperty = IERelationRetrieval.getIdEffectiveIdProperty(aList);
        for (Node a : aNodes) {
            Node orthologyAggregate = el2agg.get(a);
            List<Node> elementNodes = ConceptAggregateManager.getNonAggregateElements(orthologyAggregate);
            for (Node element : elementNodes) {
                Iterable relationships = element.getRelationships(relationTypes);
                for (Relationship r : relationships) {
                    Node otherNode = r.getOtherNode(element);
                    String arg1Name = (String)orthologyAggregate.getProperty("preferredName");
                    String arg1Id = (String)orthologyAggregate.getProperty(effectiveIdProperty);
                    Node otherOrthologyAggregate = IERelationRetrieval.findHighestOrthologyAggregate(otherNode);
                    String arg2Name = (String)otherOrthologyAggregate.getProperty("preferredName");
                    String arg2Id = (String)otherOrthologyAggregate.getProperty(effectiveIdProperty);
                    if (!interInputRelationRetrievalEnabled && requestedAggregateIds.contains(arg2Id)) continue;
                    int count = (Integer)r.getProperty("totalCount");
                    accumulator.merge(new ImmutablePair<String, String>(arg1Id, arg2Id), IERelationRetrieval.makeResultLine(arg1Name, arg1Id, arg2Name, arg2Id, count), (m1, m2) -> {
                        m1.put("count", (Integer)m1.get("count") + (Integer)m2.get("count"));
                        return m1;
                    });
                }
            }
        }
        return accumulator.values().stream().collect(Collectors.toList());
    }

    private static Map<String, Object> makeResultLine(String arg1Name, String arg1Id, String arg2Name, String arg2Id, int count) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arg1Name", arg1Name);
        map.put("arg2Name", arg2Name);
        map.put("arg1Id", arg1Id);
        map.put("arg2Id", arg2Id);
        map.put("count", count);
        return map;
    }

    private static Node findHighestOrthologyAggregate(Node n) {
        Node currentNode = n;
        Iterable hasElementRelationships = currentNode.getRelationships(Direction.INCOMING, new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT});
        for (Relationship hasElement : hasElementRelationships) {
            Node aggregateNode = hasElement.getStartNode();
            if (!aggregateNode.hasLabel(LABEL_GENEGROUP) && !aggregateNode.hasLabel(LABEL_TOP_ORTHOLOGY)) continue;
            return IERelationRetrieval.findHighestOrthologyAggregate(aggregateNode);
        }
        return n;
    }

    private static List<Node> getNodes(Transaction tx, RelationIdList idListRequest) {
        ArrayList<Node> nodeListRequest = new ArrayList<Node>();
        for (String id : idListRequest.getIds()) {
            Node node = tx.findNode((Label)ConceptLabel.CONCEPT, IERelationRetrieval.getIdEffectiveIdProperty(idListRequest), (Object)id);
            if (node == null) continue;
            nodeListRequest.add(node);
        }
        return nodeListRequest;
    }

    private static String getIdEffectiveIdProperty(RelationIdList idListRequest) {
        return idListRequest.getIdProperty().equals("sourceIds") ? "sourceIds0" : idListRequest.getIdProperty();
    }
}

