/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.concepts;

import com.google.gson.stream.JsonReader;
import de.julielab.neo4j.plugins.auxiliaries.semedico.TermVariantComparator;
import de.julielab.neo4j.plugins.concepts.ConceptEdgeTypes;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import de.julielab.neo4j.plugins.concepts.MorphoLabel;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptTermInsertion {
    private static final Logger log = LoggerFactory.getLogger(ConceptTermInsertion.class);

    static void addConceptVariant(Transaction tx, String conceptVariants, String type) throws IOException {
        ConceptEdgeTypes variantRelationshipType;
        MorphoLabel variantNodeLabel;
        MorphoLabel variantsAggregationLabel;
        if (type.equals("writingVariants")) {
            variantsAggregationLabel = MorphoLabel.WRITING_VARIANTS;
            variantNodeLabel = MorphoLabel.WRITING_VARIANT;
            variantRelationshipType = ConceptEdgeTypes.HAS_VARIANTS;
        } else if (type.equals("acronyms")) {
            variantsAggregationLabel = MorphoLabel.ACRONYMS;
            variantNodeLabel = MorphoLabel.ACRONYM;
            variantRelationshipType = ConceptEdgeTypes.HAS_ACRONYMS;
        } else {
            throw new IllegalArgumentException("Unknown lexico-morphological type \"" + type + "\".");
        }
        try (StringReader stringReader = new StringReader(conceptVariants);){
            JsonReader jsonReader = new JsonReader(stringReader);
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                Node variantsNode;
                String conceptId = jsonReader.nextName();
                HashMap variantCountsInDocs = new HashMap();
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    String docId = jsonReader.nextName();
                    jsonReader.beginObject();
                    TreeMap<String, Integer> variantCounts = new TreeMap<String, Integer>(new TermVariantComparator());
                    while (jsonReader.hasNext()) {
                        String variant = jsonReader.nextName();
                        int count = jsonReader.nextInt();
                        if (variantCounts.containsKey(variant)) {
                            Integer currentCount = (Integer)variantCounts.get(variant);
                            variantCounts.put(variant, currentCount + count);
                            continue;
                        }
                        variantCounts.put(variant, count);
                    }
                    jsonReader.endObject();
                    variantCountsInDocs.put(docId, variantCounts);
                }
                jsonReader.endObject();
                if (variantCountsInDocs.isEmpty()) {
                    log.debug("Concept with ID " + conceptId + " has no writing variants / acronyms attached.");
                    continue;
                }
                Node concept = tx.findNode((Label)ConceptLabel.CONCEPT, "id", (Object)conceptId);
                if (null == concept) {
                    log.warn("Concept with ID " + conceptId + " was not found, cannot add writing variants / acronyms.");
                    continue;
                }
                Relationship hasVariantsRel = concept.getSingleRelationship((RelationshipType)variantRelationshipType, Direction.OUTGOING);
                if (null == hasVariantsRel) {
                    variantsNode = tx.createNode(new Label[]{variantsAggregationLabel});
                    hasVariantsRel = concept.createRelationshipTo(variantsNode, (RelationshipType)variantRelationshipType);
                }
                variantsNode = hasVariantsRel.getEndNode();
                for (String docId : variantCountsInDocs.keySet()) {
                    Map variantCounts = (Map)variantCountsInDocs.get(docId);
                    for (String variant : variantCounts.keySet()) {
                        String normalizedVariant = TermVariantComparator.normalizeVariant(variant);
                        Node variantNode = tx.findNode((Label)variantNodeLabel, "id", (Object)normalizedVariant);
                        if (null == variantNode) {
                            variantNode = tx.createNode(new Label[]{variantNodeLabel});
                            variantNode.setProperty("id", (Object)normalizedVariant);
                            variantNode.setProperty("name", (Object)variant);
                        }
                        Relationship specificElementRel = null;
                        for (Relationship elementRel : variantNode.getRelationships(Direction.INCOMING, new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT})) {
                            if (!elementRel.getStartNode().equals(variantsNode) || !elementRel.getEndNode().equals(variantNode)) continue;
                            specificElementRel = elementRel;
                            break;
                        }
                        if (null == specificElementRel) {
                            specificElementRel = variantsNode.createRelationshipTo(variantNode, (RelationshipType)ConceptEdgeTypes.HAS_ELEMENT);
                            specificElementRel.setProperty("documents", (Object)new String[0]);
                            specificElementRel.setProperty("counts", (Object)new int[0]);
                        }
                        Object[] documents = (String[])specificElementRel.getProperty("documents");
                        int[] counts = (int[])specificElementRel.getProperty("counts");
                        int docIndex = Arrays.binarySearch(documents, docId);
                        Integer count = (Integer)variantCounts.get(variant);
                        if (docIndex >= 0) {
                            counts[docIndex] = count;
                            continue;
                        }
                        int insertionPoint = -1 * (docIndex + 1);
                        String[] newDocuments = new String[documents.length + 1];
                        int[] newCounts = new int[newDocuments.length];
                        if (insertionPoint > 0) {
                            System.arraycopy(documents, 0, newDocuments, 0, insertionPoint);
                            System.arraycopy(counts, 0, newCounts, 0, insertionPoint);
                        }
                        newDocuments[insertionPoint] = docId;
                        newCounts[insertionPoint] = count;
                        if (insertionPoint < documents.length) {
                            System.arraycopy(documents, insertionPoint, newDocuments, insertionPoint + 1, documents.length - insertionPoint);
                            System.arraycopy(counts, insertionPoint, newCounts, insertionPoint + 1, counts.length - insertionPoint);
                        }
                        specificElementRel.setProperty("documents", (Object)newDocuments);
                        specificElementRel.setProperty("counts", (Object)newCounts);
                    }
                }
            }
            jsonReader.endObject();
            jsonReader.close();
        }
    }
}

