/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.concepts;

import de.julielab.neo4j.plugins.auxiliaries.semedico.NodeUtilities;
import de.julielab.neo4j.plugins.concepts.ConceptEdgeTypes;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import de.julielab.neo4j.plugins.concepts.ConceptLookup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptRetrieval {
    private static final Logger log = LoggerFactory.getLogger(ConceptRetrieval.class);

    public static Map<String, Object> getPathsFromFacetRoots(Transaction tx, List<String> conceptIds, String idProperty, String returnIdProperty, boolean sort, String facetId) {
        Evaluator rootConceptEvaluator = path -> {
            Node endNode = path.endNode();
            Iterator iterator = endNode.getRelationships(new RelationshipType[]{ConceptEdgeTypes.HAS_ROOT_CONCEPT}).iterator();
            if (iterator.hasNext()) {
                String[] facetIds;
                if (StringUtils.isBlank(facetId)) {
                    return Evaluation.INCLUDE_AND_CONTINUE;
                }
                for (String facetIdOfRootNode : facetIds = (String[])endNode.getProperty("facets")) {
                    if (!facetIdOfRootNode.equals(facetId)) continue;
                    return Evaluation.INCLUDE_AND_CONTINUE;
                }
            }
            return Evaluation.EXCLUDE_AND_CONTINUE;
        };
        ConceptEdgeTypes relType = StringUtils.isBlank(facetId) ? ConceptEdgeTypes.IS_BROADER_THAN : RelationshipType.withName((String)(ConceptEdgeTypes.IS_BROADER_THAN.name() + "_" + facetId));
        TraversalDescription td = tx.traversalDescription().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).depthFirst().relationships((RelationshipType)relType, Direction.INCOMING).evaluator(rootConceptEvaluator);
        Node[] startNodes = new Node[conceptIds.size()];
        for (int i = 0; i < conceptIds.size(); ++i) {
            Node node;
            String conceptId = conceptIds.get(i);
            Node node2 = node = idProperty.equals("sourceIds") ? ConceptLookup.lookupSingleConceptBySourceId(tx, conceptId) : tx.findNode((Label)ConceptLabel.CONCEPT, idProperty, (Object)conceptId);
            if (node == null) {
                throw new IllegalArgumentException("Could not find a node with ID " + conceptId + " for property " + idProperty);
            }
            startNodes[i] = node;
        }
        Traverser traverse = td.traverse(startNodes);
        ArrayList<String[]> pathsConceptIds = new ArrayList<String[]>();
        int c = 0;
        for (Path p : traverse) {
            log.info("Path nr. " + c++ + ":" + p.toString());
            String[] pathConceptIds = new String[p.length() + 1];
            Iterator nodesIt = p.nodes().iterator();
            boolean error = false;
            for (int i = p.length(); i >= 0; --i) {
                if (!nodesIt.hasNext()) {
                    throw new IllegalStateException("Length of path wrong, more nodes expected.");
                }
                Node n = (Node)nodesIt.next();
                if (!n.hasProperty(idProperty) && !n.hasProperty(idProperty + "0")) {
                    log.warn("Came across the concept " + n + " (" + NodeUtilities.getNodePropertiesAsString((Entity)n) + ") when computing root paths. But this concept does not have an ID.");
                    error = true;
                    break;
                }
                pathConceptIds[i] = (String)n.getProperty(returnIdProperty != null ? returnIdProperty : "id");
            }
            if (error) continue;
            pathsConceptIds.add(pathConceptIds);
        }
        if (sort) {
            pathsConceptIds.sort(Comparator.comparingInt(o -> ((String[])o).length));
        }
        HashMap<String, Object> pathsWrappedInMap = new HashMap<String, Object>();
        pathsWrappedInMap.put("paths", pathsConceptIds);
        return pathsWrappedInMap;
    }

    public static Map<String, Object> getChildrenOfConcepts(Transaction tx, List<String> conceptIds, Label label) {
        HashMap<String, Object> childrenByConceptId = new HashMap<String, Object>();
        for (String id : conceptIds) {
            HashMap<String, List> reltypesByNodeId = new HashMap<String, List>();
            HashSet<Node> childList = new HashSet<Node>();
            Node concept = tx.findNode(label, "id", (Object)id);
            if (null == concept) continue;
            for (Relationship rel : concept.getRelationships(Direction.OUTGOING)) {
                String reltype = rel.getType().name();
                Node child = rel.getEndNode();
                boolean isHollow = false;
                for (Label l : child.getLabels()) {
                    if (!l.equals((Object)ConceptLabel.HOLLOW)) continue;
                    isHollow = true;
                    break;
                }
                if (isHollow) continue;
                String childId = (String)child.getProperty("id");
                List reltypeList = reltypesByNodeId.computeIfAbsent(childId, k -> new ArrayList());
                reltypeList.add(reltype);
                childList.add(child);
            }
            HashMap<String, Cloneable> childrenAndReltypes = new HashMap<String, Cloneable>();
            childrenAndReltypes.put("children", childList);
            childrenAndReltypes.put("reltypes", reltypesByNodeId);
            childrenByConceptId.put(id, childrenAndReltypes);
        }
        return childrenByConceptId;
    }
}

