/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.concepts;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.julielab.neo4j.plugins.Indexes;
import de.julielab.neo4j.plugins.concepts.ConceptEdgeTypes;
import de.julielab.neo4j.plugins.concepts.ConceptInsertion;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import de.julielab.neo4j.plugins.concepts.ConceptRetrieval;
import de.julielab.neo4j.plugins.concepts.ConceptTermInsertion;
import de.julielab.neo4j.plugins.concepts.FacetRootsRetrieval;
import de.julielab.neo4j.plugins.concepts.IERelationInsertion;
import de.julielab.neo4j.plugins.concepts.IERelationRetrieval;
import de.julielab.neo4j.plugins.concepts.InsertionReport;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcepts;
import de.julielab.neo4j.plugins.datarepresentation.ImportMapping;
import de.julielab.neo4j.plugins.datarepresentation.RelationRetrievalRequest;
import de.julielab.neo4j.plugins.datarepresentation.constants.ImportIERelations;
import de.julielab.neo4j.plugins.datarepresentation.constants.NodeConstants;
import de.julielab.neo4j.plugins.datarepresentation.util.ConceptsJsonSerializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

@Path(value="/concept_manager")
public class ConceptManager {
    public static final String CM_REST_ENDPOINT = "concept_manager";
    public static final String INSERT_MAPPINGS = "insert_mappings";
    public static final String GET_CHILDREN_OF_CONCEPTS = "get_children_of_concepts";
    public static final String GET_PATHS_FROM_FACET_ROOTS = "get_paths_to_facetroots";
    public static final String INSERT_CONCEPTS = "insert_concepts";
    public static final String GET_FACET_ROOTS = "get_facet_roots";
    public static final String ADD_CONCEPT_TERM = "add_concept_term";
    public static final String INSERT_IE_RELATIONS = "insert_ie_relations";
    public static final String RETRIEVE_IE_RELATIONS = "retrieve_ie_relations";
    public static final String KEY_FACET = "facet";
    public static final String KEY_FACET_ID = "facetId";
    public static final String KEY_FACET_IDS = "facetIds";
    public static final String KEY_ID_PROPERTY = "id_property";
    public static final String KEY_RETURN_ID_PROPERTY = "return_id_property";
    public static final String KEY_LABEL = "label";
    public static final String KEY_SORT_RESULT = "sortResult";
    public static final String KEY_CONCEPT_IDS = "conceptIds";
    public static final String KEY_MAX_ROOTS = "maxRoots";
    public static final String KEY_CONCEPT_TERMS = "conceptTerms";
    public static final String KEY_CONCEPT_ACRONYMS = "conceptAcronyms";
    public static final String KEY_CONCEPTS = "concepts";
    public static final String KEY_TIME = "time";
    public static final String RET_KEY_CHILDREN = "children";
    public static final String RET_KEY_NUM_AGGREGATES = "numAggregates";
    public static final String RET_KEY_NUM_ELEMENTS = "numElements";
    public static final String RET_KEY_NUM_PROPERTIES = "numProperties";
    public static final String RET_KEY_NUM_CREATED_RELS = "numCreatedRelationships";
    public static final String RET_KEY_NUM_CREATED_CONCEPTS = "numCreatedConcepts";
    public static final String RET_KEY_PATHS = "paths";
    public static final String RET_KEY_RELTYPES = "reltypes";
    public static final String FULLTEXT_INDEX_CONCEPTS = "concepts";
    public static final int MAX_SRC_IDS = 10;
    public static final String UPDATE_CHILD_INFORMATION = "update_children_information";
    public static final String UNKNOWN_CONCEPT_SOURCE = "<unknown>";
    private final DatabaseManagementService dbms;
    private Log log;

    public ConceptManager(@Context DatabaseManagementService dbms, @Context Log log) {
        this.dbms = dbms;
        this.log = log;
    }

    public static void createIndexes(Transaction tx) {
        Indexes.createSinglePropertyIndexIfAbsent(tx, "ConceptId", ConceptLabel.CONCEPT, true, "native-btree-1.0", "id");
        Indexes.createSinglePropertyIndexIfAbsent(tx, "OriginalId", ConceptLabel.CONCEPT, false, "native-btree-1.0", "originalId");
        Indexes.createSinglePropertyIndexIfAbsent(tx, "FacetRoots", NodeConstants.Labels.ROOT, true, "native-btree-1.0", "name");
        for (int i = 0; i < 10; ++i) {
            Indexes.createSinglePropertyIndexIfAbsent(tx, "ConceptSrcId" + i, ConceptLabel.CONCEPT, false, "native-btree-1.0", "sourceIds" + i);
        }
    }

    public static Response getErrorResponse(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return Response.serverError().entity((Object)sw.toString()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get_children_of_concepts")
    public Object getChildrenOfConcepts(@QueryParam(value="conceptIds") String conceptIdsCsv, @QueryParam(value="label") String labelString) {
        Response.ResponseBuilder responseBuilder;
        block8: {
            ConceptLabel label = labelString != null ? Label.label((String)labelString) : ConceptLabel.CONCEPT;
            List<String> conceptIds = Arrays.asList(conceptIdsCsv.split(","));
            GraphDatabaseService graphDb = this.dbms.database("neo4j");
            Transaction tx = graphDb.beginTx();
            try {
                Map<String, Object> childrenByConceptId = ConceptRetrieval.getChildrenOfConcepts(tx, conceptIds, label);
                responseBuilder = Response.ok(childrenByConceptId);
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return ConceptManager.getErrorResponse(t);
                }
            }
            tx.close();
        }
        return responseBuilder;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get_paths_to_facetroots")
    public Object getPathsFromFacetRoots(@QueryParam(value="conceptIds") String conceptIdsCsv, @QueryParam(value="id_property") String idProperty, @QueryParam(value="return_id_property") String returnIdProperty, @QueryParam(value="sortResult") boolean sort, @QueryParam(value="facetId") String facetId) {
        Response response;
        block8: {
            List<String> conceptIds = Arrays.asList(conceptIdsCsv.split(","));
            GraphDatabaseService graphDb = this.dbms.database("neo4j");
            Transaction tx = graphDb.beginTx();
            try {
                Map<String, Object> pathsWrappedInMap = ConceptRetrieval.getPathsFromFacetRoots(tx, conceptIds, idProperty, returnIdProperty, sort, facetId);
                response = Response.ok(pathsWrappedInMap).build();
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return ConceptManager.getErrorResponse(t);
                }
            }
            tx.close();
        }
        return response;
    }

    public Object insertConcepts(InputStream is) {
        return this.insertConcepts(is, this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="insert_concepts")
    public Object insertConcepts(InputStream is, @Context Log log) {
        try {
            log.info("%s was called", new Object[]{INSERT_CONCEPTS});
            log.debug("Beginning processing of concept insertion.");
            GraphDatabaseService graphDb = this.dbms.database("neo4j");
            HashMap<String, Object> response = new HashMap<String, Object>();
            InsertionReport insertionReport = ConceptInsertion.insertConcepts(log, graphDb, is, response);
            log.info("Concept insertion complete.");
            log.info("%s is finished processing after %s ms. %s concepts and %s relationships have been created.", new Object[]{INSERT_CONCEPTS, response.get(KEY_TIME), insertionReport.numConcepts, insertionReport.numRelationships, response.get(KEY_TIME)});
            Response response2 = Response.ok(response).build();
            return response2;
        }
        catch (Throwable throwable) {
            log.error("Concept insertion failed", throwable);
            Response response = ConceptManager.getErrorResponse(throwable);
            return response;
        }
    }

    @POST
    @Path(value="update_children_information")
    public void updateChildrenInformation() {
        GraphDatabaseService graphDb = this.dbms.database("neo4j");
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterator conceptIt = tx.findNodes((Label)ConceptLabel.CONCEPT);
            while (conceptIt.hasNext()) {
                Node concept = (Node)conceptIt.next();
                Iterator relIt = concept.getRelationships(Direction.OUTGOING).iterator();
                HashSet<String> facetsContainingChildren = new HashSet<String>();
                while (relIt.hasNext()) {
                    String[] typeNameParts;
                    String lastPart;
                    Relationship rel = (Relationship)relIt.next();
                    String type = rel.getType().name();
                    if (!type.startsWith(ConceptEdgeTypes.IS_BROADER_THAN.toString()) || !(lastPart = (typeNameParts = type.split("_"))[typeNameParts.length - 1]).startsWith("fid")) continue;
                    facetsContainingChildren.add(lastPart);
                }
                if (facetsContainingChildren.size() == 0 && concept.hasProperty("childrenInFacets")) {
                    concept.removeProperty("childrenInFacets");
                    continue;
                }
                if (facetsContainingChildren.size() <= 0) continue;
                concept.setProperty("childrenInFacets", (Object)facetsContainingChildren.toArray(new String[0]));
            }
            tx.commit();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="insert_mappings")
    public int insertMappings(InputStream is) throws IOException {
        MappingIterator<ImportMapping> importMappingIterator = new ObjectMapper().readerFor(ImportMapping.class).readValues(is);
        this.log.info("Starting to insert mappings.");
        GraphDatabaseService graphDb = this.dbms.database("neo4j");
        try (Transaction tx = graphDb.beginTx();){
            int n = ConceptInsertion.insertMappings(tx, this.log, importMappingIterator);
            return n;
        }
    }

    public Object getFacetRoots(@Context UriInfo uriInfo) {
        return this.getFacetRoots(uriInfo, this.log);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get_facet_roots")
    public Object getFacetRoots(@Context UriInfo uriInfo, @Context Log log) {
        Response.ResponseBuilder responseBuilder;
        block11: {
            HashSet<String> requestedFacetIds = new HashSet<String>();
            MultivaluedMap queryParameters = uriInfo.getQueryParameters();
            HashMap<String, Set<String>> requestedConceptIds = new HashMap<String, Set<String>>();
            int maxRoots = 0;
            for (String param : queryParameters.keySet()) {
                if (param.equals(KEY_FACET_IDS)) {
                    requestedFacetIds.addAll(Arrays.asList(((String)queryParameters.getFirst((Object)param)).split(",")));
                    continue;
                }
                if (param.equals(KEY_MAX_ROOTS)) {
                    maxRoots = Integer.parseInt((String)queryParameters.getFirst((Object)param));
                    continue;
                }
                requestedFacetIds.add(param);
                requestedConceptIds.put(param, Set.of(((String)queryParameters.getFirst((Object)param)).split(",")));
            }
            GraphDatabaseService graphDb = this.dbms.database("neo4j");
            Transaction tx = graphDb.beginTx();
            try {
                Map<String, List<Node>> facetRoots = FacetRootsRetrieval.getFacetRoots(tx, requestedFacetIds, requestedConceptIds, maxRoots);
                responseBuilder = Response.ok(facetRoots);
                if (tx == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return ConceptManager.getErrorResponse(t);
                }
            }
            tx.close();
        }
        return responseBuilder;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="add_concept_term")
    public void addWritingVariants(String jsonParameterObject) throws IOException {
        ObjectMapper om = new ObjectMapper();
        Map parameterMap = om.readValue(jsonParameterObject, Map.class);
        String conceptVariants = (String)parameterMap.get(KEY_CONCEPT_TERMS);
        String conceptAcronyms = (String)parameterMap.get(KEY_CONCEPT_ACRONYMS);
        GraphDatabaseService graphDb = this.dbms.database("neo4j");
        try (Transaction tx = graphDb.beginTx();){
            if (null != conceptVariants) {
                ConceptTermInsertion.addConceptVariant(tx, conceptVariants, "writingVariants");
            }
            if (null != conceptAcronyms) {
                ConceptTermInsertion.addConceptVariant(tx, conceptAcronyms, "acronyms");
            }
            tx.commit();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="insert_ie_relations")
    public Response insertIERelations(InputStream is, @Context Log log) {
        GraphDatabaseService graphDb = this.dbms.database("neo4j");
        try {
            IERelationInsertion.insertRelations(is, graphDb, log);
            return Response.ok().build();
        }
        catch (Throwable t) {
            log.error("Error in IE relation insertion.", t);
            return ConceptManager.getErrorResponse(t);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="retrieve_ie_relations")
    public Response retrieveIERelations(InputStream is, @Context Log log) {
        GraphDatabaseService graphDb = this.dbms.database("neo4j");
        ObjectMapper om = new ObjectMapper();
        try {
            RelationRetrievalRequest relationRetrievalRequest = om.readValue(is, RelationRetrievalRequest.class);
            List<Map<String, Object>> retrievedRelations = IERelationRetrieval.retrieve(relationRetrievalRequest, graphDb, log);
            return Response.ok(retrievedRelations, (String)"application/json").build();
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error("Error in IE relation retrieval.", t);
            return ConceptManager.getErrorResponse(t);
        }
    }

    public void insertIERelations(InputStream is) {
        this.insertIERelations(is, this.log);
    }

    public void insertIERelations(ImportIERelations relations) {
        this.insertIERelations(new ByteArrayInputStream(ConceptsJsonSerializer.toJson(relations).getBytes(StandardCharsets.UTF_8)));
    }

    public void insertConcepts(ImportConcepts importConcepts) {
        this.insertConcepts(new ByteArrayInputStream(ConceptsJsonSerializer.toJson(importConcepts).getBytes(StandardCharsets.UTF_8)));
    }
}

