/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.concepts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import de.julielab.neo4j.plugins.auxiliaries.JulieNeo4jUtilities;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.CoordinatesMap;
import de.julielab.neo4j.plugins.auxiliaries.semedico.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.concepts.ConceptEdgeTypes;
import de.julielab.neo4j.plugins.concepts.ConceptInsertion;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import de.julielab.neo4j.plugins.concepts.ConceptLookup;
import de.julielab.neo4j.plugins.concepts.ConceptManager;
import de.julielab.neo4j.plugins.concepts.InsertionReport;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcept;
import de.julielab.neo4j.plugins.datarepresentation.ImportOptions;
import de.julielab.neo4j.plugins.util.AggregateConceptInsertionException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

@Path(value="/concept_aggregate_manager")
public class ConceptAggregateManager {
    public static final String COPY_AGGREGATE_PROPERTIES = "copy_aggregate_properties";
    public static final String BUILD_AGGREGATES_BY_PREFERRED_NAME = "build_aggregates_by_preferred_name";
    public static final String BUILD_AGGREGATES_BY_MAPPINGS = "build_aggregates_by_mappings";
    public static final String DELETE_AGGREGATES = "delete_aggregates";
    public static final String CAM_REST_ENDPOINT = "concept_aggregate_manager";
    public static final String KEY_LABEL = "label";
    public static final String KEY_AGGREGATED_LABEL = "aggregated_label";
    public static final String KEY_AGGREGATED_LABELS = "aggregated_labels";
    public static final String KEY_SKIP_EXISTING_PROPERTIES = "skip_existing_properties";
    public static final String KEY_ALLOWED_MAPPING_TYPES = "allowedMappingTypes";
    public static final String KEY_COPY_PROPERTIES = "copy_properties";
    public static final String KEY_NAME_PROPERTY = "name_property";
    public static final String RET_KEY_NUM_AGGREGATES = "numAggregates";
    public static final String RET_KEY_NUM_ELEMENTS = "numElements";
    public static final String RET_KEY_NUM_PROPERTIES = "numProperties";
    private final DatabaseManagementService dbms;

    public ConceptAggregateManager(@Context DatabaseManagementService dbms) {
        this.dbms = dbms;
    }

    static void insertAggregateConcept(Transaction tx, ImportConcept jsonConcept, CoordinatesMap nodesByCoordinates, InsertionReport insertionReport, ImportOptions importOptions, Log log) throws AggregateConceptInsertionException {
        try {
            List<String> copyProperties;
            boolean includeAggreationInHierarchy;
            Node aggregate;
            ConceptCoordinates aggCoordinates = jsonConcept.coordinates != null ? jsonConcept.coordinates : new ConceptCoordinates();
            String aggPrefName = jsonConcept.prefName;
            String aggOrgId = aggCoordinates.originalId;
            String aggOrgSource = aggCoordinates.originalSource;
            String aggSrcId = aggCoordinates.sourceId;
            String aggSource = aggCoordinates.source;
            if (null == aggSource) {
                aggSource = "<unknown>";
            }
            if (null != (aggregate = ConceptLookup.lookupConcept(tx, aggCoordinates))) {
                if (!aggregate.hasLabel((Label)ConceptLabel.HOLLOW)) {
                    return;
                }
                aggregate.removeLabel((Label)ConceptLabel.HOLLOW);
                aggregate.addLabel((Label)ConceptLabel.AGGREGATE);
            }
            if (aggregate == null) {
                aggregate = tx.createNode(new Label[]{ConceptLabel.AGGREGATE});
            }
            if (includeAggreationInHierarchy = jsonConcept.aggregateIncludeInHierarchy) {
                aggregate.addLabel((Label)ConceptLabel.CONCEPT);
            }
            List<ConceptCoordinates> elementCoords = jsonConcept.elementCoordinates;
            for (ConceptCoordinates elementCoordinates : elementCoords) {
                Object[] sourcesForSourceId;
                Node element;
                String elementSource = elementCoordinates.source;
                if (null == elementCoordinates.source) {
                    elementSource = "<unknown>";
                }
                if (null != (element = nodesByCoordinates.get(elementCoordinates)) && Arrays.binarySearch(sourcesForSourceId = NodeUtilities.getSourcesForSourceId(element, elementCoordinates.sourceId), elementSource) < 0) {
                    element = null;
                }
                log.debug("Looking up element by source ID %s and source %s", new Object[]{elementCoordinates.sourceId, elementSource});
                if (null == element) {
                    element = ConceptLookup.lookupConceptBySourceId(tx, elementCoordinates.sourceId, elementSource, false);
                }
                log.debug("Found element with source ID %s and source %s", new Object[]{elementCoordinates.sourceId, elementSource});
                if (null == element && importOptions.createHollowAggregateElements) {
                    element = ConceptInsertion.registerNewHollowConceptNode(tx, log, elementCoordinates, new Label[0]);
                }
                if (element == null) continue;
                aggregate.createRelationshipTo(element, (RelationshipType)ConceptEdgeTypes.HAS_ELEMENT);
            }
            if (null != aggPrefName) {
                aggregate.setProperty("preferredName", (Object)aggPrefName);
            }
            if (null != aggSrcId) {
                NodeUtilities.mergeSourceId(tx, aggregate, aggSrcId, aggSource, false);
                nodesByCoordinates.put(new ConceptCoordinates(aggCoordinates), aggregate);
            }
            if (null != aggOrgId) {
                aggregate.setProperty("originalId", (Object)aggOrgId);
            }
            if (null != aggOrgSource) {
                aggregate.setProperty("originalSource", (Object)aggOrgSource);
            }
            if (null != (copyProperties = jsonConcept.copyProperties) && !copyProperties.isEmpty()) {
                aggregate.setProperty("copyProperties", (Object)copyProperties.toArray(new String[0]));
            }
            List<String> generalLabels = jsonConcept.generalLabels;
            for (int i = 0; null != generalLabels && i < generalLabels.size(); ++i) {
                aggregate.addLabel(Label.label((String)generalLabels.get(i)));
            }
            String aggregateId = "atid" + SequenceManager.getNextSequenceValue(tx, "seqAggregateTerm");
            aggregate.setProperty("id", (Object)aggregateId);
            ++insertionReport.numConcepts;
        }
        catch (Exception e) {
            throw new AggregateConceptInsertionException("Aggregate concept creation failed for aggregate " + jsonConcept, e);
        }
    }

    public static int buildAggregatesForEqualNames(GraphDatabaseService graphDb, List<Label> nodeLabels, String nameProperty, List<Label> aggregatedLabels, String[] copyProperties, Log log) {
        List nodeIds;
        int createdAggregates = 0;
        Comparator<Node> nodeNameComparator = Comparator.comparing(n -> (String)n.getProperty(nameProperty));
        log.info("Acquiring all non-aggregate nodes with labels %s", new Object[]{nodeLabels});
        try (Transaction tx = graphDb.beginTx();){
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Label nodeLabel : nodeLabels) {
                ResourceIterable nodeIterable = () -> tx.findNodes(nodeLabel);
                for (Node node : nodeIterable) {
                    if (node.hasLabel((Label)ConceptLabel.AGGREGATE)) continue;
                    nodes.add(node);
                }
            }
            log.info("Found %s nodes with labels %s", new Object[]{nodes.size(), nodeLabels});
            log.info("Sorting %s nodes with labels %s by name", new Object[]{nodes.size(), nodeLabels});
            nodes.sort(nodeNameComparator);
            log.info("Sorting of nodes by name is done.");
            nodeIds = nodes.stream().map(Entity::getId).collect(Collectors.toList());
        }
        ArrayList<Node> equalNameNodes = new ArrayList<Node>();
        log.info("Creating equal-name aggregates for labels %s with labels %s", new Object[]{nodeLabels, aggregatedLabels});
        Label[] aggregatedLabelsArray = (Label[])aggregatedLabels.toArray(Label[]::new);
        Iterator nodeitId = nodeIds.iterator();
        int batchsize = 1000;
        ArrayList<Long> currentBatch = new ArrayList<Long>(batchsize);
        while (nodeitId.hasNext()) {
            currentBatch.add((Long)nodeitId.next());
            if (currentBatch.size() != batchsize && nodeitId.hasNext()) continue;
            Transaction tx = graphDb.beginTx();
            try {
                Iterator iterator = currentBatch.iterator();
                while (iterator.hasNext()) {
                    boolean equalTerm;
                    long nodeId = (Long)iterator.next();
                    Node n2 = tx.getNodeById(nodeId);
                    boolean bl = equalTerm = 0 == equalNameNodes.size() || 0 == nodeNameComparator.compare((Node)equalNameNodes.get(equalNameNodes.size() - 1), n2);
                    if (equalTerm) {
                        equalNameNodes.add(n2);
                        continue;
                    }
                    if (equalNameNodes.size() > 1) {
                        ConceptAggregateManager.createAggregate(tx, copyProperties, new HashSet<Node>(equalNameNodes), new String[]{ConceptLabel.AGGREGATE_EQUAL_NAMES.toString()}, aggregatedLabelsArray);
                        if (++createdAggregates % 10000 == 0) {
                            log.info("Created %s equal-name aggregates for labels %s with labels %s.", new Object[]{createdAggregates, nodeLabels, aggregatedLabels});
                        }
                        equalNameNodes.clear();
                        equalNameNodes.add(n2);
                        continue;
                    }
                    equalNameNodes.clear();
                    equalNameNodes.add(n2);
                }
                if (!nodeitId.hasNext() && equalNameNodes.size() > 1) {
                    ConceptAggregateManager.createAggregate(tx, copyProperties, new HashSet<Node>(equalNameNodes), new String[]{ConceptLabel.AGGREGATE_EQUAL_NAMES.toString()}, aggregatedLabelsArray);
                    ++createdAggregates;
                }
                tx.commit();
                currentBatch.clear();
                equalNameNodes.clear();
                equalNameNodes.stream().map(Entity::getId).forEach(currentBatch::add);
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        log.info("%s equal-name aggregates were created.", new Object[]{createdAggregates});
        return createdAggregates;
    }

    private static int addUniqueNameLabels(Transaction tx, Label nodeLabel, Log log) {
        ResourceIterable nodeIterable = () -> tx.findNodes(nodeLabel);
        int count = 0;
        for (Node n : nodeIterable) {
            if (n.hasLabel((Label)ConceptLabel.AGGREGATE)) continue;
            if (StreamSupport.stream(n.getRelationships(Direction.INCOMING, new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT}).spliterator(), false).anyMatch(r -> r.getOtherNode(n).hasLabel((Label)ConceptLabel.AGGREGATE_EQUAL_NAMES))) continue;
            n.addLabel((Label)ConceptLabel.AGGREGATE_EQUAL_NAMES);
            if (++count % 1000000 != 0) continue;
            log.info("Added %s label to %s unique-named nodes that are not actually an aggregate.", new Object[]{ConceptLabel.AGGREGATE_EQUAL_NAMES, count});
        }
        return count;
    }

    public static Map<String, Long> deleteAggregatesBatchWise(GraphDatabaseService graphDb, List<Label> aggregateLabels, Log log) {
        log.info("Removing all nodes with label %s", new Object[]{aggregateLabels});
        long numNodes = 0L;
        long numLabels = 0L;
        long numRel = 0L;
        for (Label aggregateLabel : aggregateLabels) {
            long numNodesInThisBatch;
            log.info("Deleting aggregate nodes with label %s", new Object[]{aggregateLabel});
            do {
                try (Transaction tx = graphDb.beginTx();){
                    numNodesInThisBatch = 0L;
                    long numRelInThisBatch = 0L;
                    ResourceIterator aggregates = tx.findNodes(aggregateLabel);
                    while (aggregates.hasNext() && numNodesInThisBatch < 10000L) {
                        Node aggregate = (Node)aggregates.next();
                        if (!aggregate.hasLabel((Label)ConceptLabel.AGGREGATE)) {
                            aggregate.removeLabel(aggregateLabel);
                            ++numLabels;
                            continue;
                        }
                        for (Relationship rel : aggregate.getRelationships()) {
                            rel.delete();
                            ++numRelInThisBatch;
                        }
                        aggregate.delete();
                        ++numNodesInThisBatch;
                    }
                    numRel += numRelInThisBatch;
                    tx.commit();
                    log.info("Deleted %s nodes", new Object[]{numNodes += numNodesInThisBatch});
                }
            } while (numNodesInThisBatch > 0L);
        }
        log.info("Finished deleting %s edges and %s nodes with label %s and removed %s %s labels from non-aggregate nodes", new Object[]{numRel, numNodes, aggregateLabels, numLabels, aggregateLabels});
        return Map.of("numNodes", numNodes, "numRelationships", numRel);
    }

    public static void deleteAggregates(Transaction tx, Label aggregateLabel, Log log) {
        log.info("Removing all nodes with label %s", new Object[]{aggregateLabel.name()});
        long numNodes = 0L;
        long numRel = 0L;
        ResourceIterable aggregates = () -> tx.findNodes(aggregateLabel);
        for (Node aggregate : aggregates) {
            if (!aggregate.hasLabel((Label)ConceptLabel.AGGREGATE)) {
                aggregate.removeLabel(aggregateLabel);
                continue;
            }
            for (Relationship rel : aggregate.getRelationships()) {
                rel.delete();
                ++numRel;
            }
            aggregate.delete();
            if (++numNodes % 10000L != 0L) continue;
            log.info("Deleted %s nodes", new Object[]{numNodes});
        }
        log.info("Finished deleting %s edges and %s nodes with label %s", new Object[]{numRel, numNodes, aggregateLabel.name()});
    }

    public static int buildAggregatesForMappings(Transaction tx, Set<String> allowedMappingTypes, Label allowedTermLabel, Label aggregatedTermsLabel, Log log) {
        log.info("Building aggregates for mappings " + allowedMappingTypes + " and terms with label " + allowedTermLabel);
        int numCreatedAggregates = 0;
        String[] copyProperties = new String[]{"preferredName", "synonyms", "writingVariants", "descriptions", "facets"};
        ConceptAggregateManager.deleteAggregates(tx, aggregatedTermsLabel, log);
        ConceptLabel label = null == allowedTermLabel ? ConceptLabel.CONCEPT : allowedTermLabel;
        ResourceIterable termIterable = () -> tx.findNodes(label);
        for (Node term : termIterable) {
            Set<Node> aggregateNodes = ConceptAggregateManager.getMatchingAggregates(term, allowedMappingTypes, aggregatedTermsLabel);
            if (aggregateNodes.size() > 1) {
                throw new IllegalStateException("Term with ID " + term.getProperty("id") + " is part of multiple aggregates of the same type, thus duplicates. The aggregate nodes are: " + aggregateNodes);
            }
            if (aggregateNodes.size() == 1) continue;
            HashSet<Node> elements = new HashSet<Node>();
            HashSet<Node> visited = new HashSet<Node>();
            ConceptAggregateManager.determineMappedSubgraph(allowedMappingTypes, allowedTermLabel, term, elements, visited);
            if (elements.size() > 1) {
                ConceptAggregateManager.createAggregate(tx, copyProperties, elements, allowedMappingTypes.toArray(new String[0]), aggregatedTermsLabel);
                ++numCreatedAggregates;
                continue;
            }
            term.addLabel(aggregatedTermsLabel);
        }
        return numCreatedAggregates;
    }

    public static String[] getPropertyValueOfElements(Node aggregate, String property) {
        if (!aggregate.hasLabel((Label)ConceptLabel.AGGREGATE)) {
            throw new IllegalArgumentException("Node " + NodeUtilities.getNodePropertiesAsString((Entity)aggregate) + " is not an aggregate.");
        }
        Iterable elementRels = aggregate.getRelationships(Direction.OUTGOING, new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT});
        ArrayList<String> elementValues = new ArrayList<String>();
        for (Relationship elementRel : elementRels) {
            String[] value = NodeUtilities.getNodePropertyAsStringArrayValue(elementRel.getEndNode(), property);
            for (int i = 0; value != null && i < value.length; ++i) {
                elementValues.add(value[i]);
            }
        }
        return elementValues.isEmpty() ? null : elementValues.toArray(new String[0]);
    }

    protected static void determineMappedSubgraph(Set<String> allowedMappingTypes, Label allowedTermLabel, Node term, Set<Node> elements, Set<Node> visited) {
        if (visited.contains(term)) {
            return;
        }
        visited.add(term);
        Iterable mappings = term.getRelationships(new RelationshipType[]{ConceptEdgeTypes.IS_MAPPED_TO});
        for (Relationship mapping : mappings) {
            String[] mappingTypes;
            if (!mapping.hasProperty("mappingType")) {
                throw new IllegalStateException("The mapping relationship " + mapping + " does not specify its type.");
            }
            for (String mappingType : mappingTypes = (String[])mapping.getProperty("mappingType")) {
                Node otherTerm;
                if (!allowedMappingTypes.contains(mappingType)) continue;
                if (null == allowedTermLabel || term.hasLabel(allowedTermLabel)) {
                    elements.add(term);
                }
                if (elements.contains(otherTerm = mapping.getOtherNode(term))) continue;
                if (null == allowedTermLabel || otherTerm.hasLabel(allowedTermLabel)) {
                    elements.add(otherTerm);
                }
                ConceptAggregateManager.determineMappedSubgraph(allowedMappingTypes, allowedTermLabel, otherTerm, elements, visited);
            }
        }
    }

    protected static Set<Node> getMatchingAggregates(Node conceptNode, Set<String> allowedMappingTypes, Label aggregateLabel) {
        HashSet<Node> aggregateNodes = new HashSet<Node>();
        Iterable elementRelationships = conceptNode.getRelationships(new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT});
        for (Relationship elementRelationship : elementRelationships) {
            Node aggregate = elementRelationship.getOtherNode(conceptNode);
            if (!aggregate.hasLabel(aggregateLabel) || !aggregate.hasLabel((Label)ConceptLabel.AGGREGATE) || !aggregate.hasProperty("mappingType")) continue;
            String[] mappingTypes = (String[])aggregate.getProperty("mappingType");
            List<String> mappingTypesList = Arrays.asList(mappingTypes);
            boolean correctMappingTypes = true;
            for (String mappingType : mappingTypesList) {
                if (allowedMappingTypes.contains(mappingType)) continue;
                correctMappingTypes = false;
                break;
            }
            for (String mappingType : allowedMappingTypes) {
                if (mappingTypesList.contains(mappingType)) continue;
                correctMappingTypes = false;
                break;
            }
            if (!correctMappingTypes) continue;
            aggregateNodes.add(aggregate);
        }
        return aggregateNodes;
    }

    private static void createAggregate(Transaction tx, String[] copyProperties, Set<Node> elementTerms, String[] mappingTypes, Label ... labels) {
        if (elementTerms.isEmpty()) {
            return;
        }
        Node aggregate = tx.createNode(labels);
        aggregate.addLabel((Label)ConceptLabel.AGGREGATE);
        aggregate.setProperty("copyProperties", (Object)copyProperties);
        aggregate.setProperty("mappingType", (Object)mappingTypes);
        for (Label termLabel : labels) {
            aggregate.addLabel(termLabel);
        }
        for (Node elementTerm : elementTerms) {
            aggregate.createRelationshipTo(elementTerm, (RelationshipType)ConceptEdgeTypes.HAS_ELEMENT);
        }
        String aggregateId = "atid" + SequenceManager.getNextSequenceValue(tx, "seqAggregateTerm");
        aggregate.setProperty("id", (Object)aggregateId);
    }

    /*
     * WARNING - void declaration
     */
    public static void copyAggregateProperties(Node aggregate, boolean skipExistingProperties, String[] copyProperties, CopyAggregatePropertiesStatistics copyStats) {
        String[] unskippedProperties = copyProperties;
        if (skipExistingProperties) {
            unskippedProperties = (String[])Arrays.stream(copyProperties).filter(Predicate.not(arg_0 -> ((Node)aggregate).hasProperty(arg_0))).toArray(String[]::new);
        }
        for (String copyProperty : unskippedProperties) {
            aggregate.removeProperty(copyProperty);
        }
        Iterable elementRels = aggregate.getRelationships(new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT});
        HashSet<String> divergentProperties = new HashSet<String>();
        HashMap<Object, Object> newAggregateProperties = new HashMap<Object, Object>();
        for (String string : unskippedProperties) {
            if (!aggregate.hasProperty(string)) continue;
            newAggregateProperties.put(string, aggregate.getProperties(new String[]{string}));
        }
        for (Relationship elementRel : elementRels) {
            Node term = elementRel.getEndNode();
            if (null != copyStats) {
                ++copyStats.numElements;
            }
            for (String copyProperty : unskippedProperties) {
                Object aggregateProperty;
                Object property;
                if (!term.hasProperty(copyProperty)) continue;
                if (null != copyStats) {
                    ++copyStats.numProperties;
                }
                if ((property = term.getProperty(copyProperty)).getClass().isArray()) {
                    Object[] mergedValue = PropertyUtilities.mergeArrayValue(newAggregateProperties.getOrDefault(copyProperty, null), JulieNeo4jUtilities.convertArray(property));
                    newAggregateProperties.put(copyProperty, mergedValue);
                    continue;
                }
                if (!newAggregateProperties.containsKey(copyProperty)) {
                    newAggregateProperties.put(copyProperty, property);
                }
                if ((aggregateProperty = newAggregateProperties.get(copyProperty)).equals(property)) continue;
                divergentProperties.add(copyProperty);
            }
        }
        for (String divergentProperty : divergentProperties) {
            void var11_26;
            HashMultiset propertyValues = HashMultiset.create();
            elementRels = aggregate.getRelationships(new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT});
            for (Relationship elementRel : elementRels) {
                Node term = elementRel.getEndNode();
                Multiset.Entry propertyValue = PropertyUtilities.getNonNullNodeProperty((Entity)term, divergentProperty);
                if (null == propertyValue) continue;
                propertyValues.add(propertyValue);
            }
            Object var11_25 = null;
            int maxCount = 0;
            for (Multiset.Entry entry : propertyValues.entrySet()) {
                if (entry.getCount() <= maxCount) continue;
                Object e = entry.getElement();
                maxCount = entry.getCount();
            }
            newAggregateProperties.put(divergentProperty, var11_26);
            for (Multiset.Entry propertyValue : propertyValues.elementSet()) {
                if (((Object)propertyValue).equals(var11_26)) continue;
                Object[] convert = JulieNeo4jUtilities.convertElementsIntoArray(propertyValue.getClass(), propertyValue);
                String divergentKey = divergentProperty + "_divergentProperty";
                Object[] mergedValue = PropertyUtilities.mergeArrayValue(newAggregateProperties.getOrDefault(divergentKey, null), convert);
                newAggregateProperties.put(divergentKey, mergedValue);
            }
        }
        String divergentPrefnameKey = "preferredName_divergentProperty";
        Object[] synonymsWithDivergentPrefNames = PropertyUtilities.mergeArrayValue(newAggregateProperties.getOrDefault("synonyms", null), (Object[])newAggregateProperties.get("preferredName_divergentProperty"));
        if (synonymsWithDivergentPrefNames != null) {
            newAggregateProperties.put("synonyms", synonymsWithDivergentPrefNames);
        }
        if (newAggregateProperties.containsKey("synonyms")) {
            String[] synonyms = (String[])newAggregateProperties.get("synonyms");
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<String> acceptedSynonyms = new ArrayList<String>();
            for (String synonym : synonyms) {
                String lowerCaseSynonym = synonym.toLowerCase();
                if (hashSet.contains(lowerCaseSynonym)) continue;
                hashSet.add(lowerCaseSynonym);
                acceptedSynonyms.add(synonym);
            }
            Collections.sort(acceptedSynonyms);
            newAggregateProperties.put("synonyms", acceptedSynonyms.toArray(new String[0]));
        }
        for (String string : newAggregateProperties.keySet()) {
            aggregate.setProperty(string, newAggregateProperties.get(string));
        }
    }

    public static List<Node> getNonAggregateElements(Node aggregate) {
        ArrayList<Node> elements = new ArrayList<Node>();
        ConceptAggregateManager.getNonAggregateElements(aggregate, elements);
        return elements;
    }

    public static void getNonAggregateElements(Node node, List<Node> elements) {
        if (!node.hasLabel((Label)ConceptLabel.AGGREGATE)) {
            elements.add(node);
            return;
        }
        Iterable hasElements = node.getRelationships(Direction.OUTGOING, new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT});
        for (Relationship hasElement : hasElements) {
            Node endNode = hasElement.getEndNode();
            if (endNode.hasLabel((Label)ConceptLabel.AGGREGATE)) {
                ConceptAggregateManager.getNonAggregateElements(endNode, elements);
                continue;
            }
            elements.add(endNode);
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="build_aggregates_by_preferred_name")
    public Response buildAggregatesByPreferredName(String jsonParameterObject, @Context Log log) {
        try {
            ObjectMapper om = new ObjectMapper();
            Map parameterMap = om.readValue(jsonParameterObject, Map.class);
            if (!parameterMap.containsKey("labels")) {
                throw new IllegalArgumentException("Parameter 'labels' not specified.");
            }
            List<Label> aggregatedLabels = List.of(ConceptLabel.AGGREGATE_EQUAL_NAMES);
            String nameProperty = "preferredName";
            if (parameterMap.containsKey(KEY_NAME_PROPERTY)) {
                nameProperty = (String)parameterMap.get(KEY_NAME_PROPERTY);
            }
            if (parameterMap.containsKey(KEY_AGGREGATED_LABELS)) {
                aggregatedLabels = ((List)parameterMap.get(KEY_AGGREGATED_LABELS)).stream().map(Label::label).collect(Collectors.toList());
            }
            List copyProperties = List.of("preferredName", "synonyms");
            if (parameterMap.containsKey(KEY_COPY_PROPERTIES)) {
                copyProperties = (List)parameterMap.get(KEY_COPY_PROPERTIES);
            }
            List<Label> targetLabels = ((List)parameterMap.get("labels")).stream().map(Label::label).collect(Collectors.toList());
            log.info("Creating equal-name-aggregates regarding the '%s' property for concepts with label %s and assigning them label %s", new Object[]{nameProperty, targetLabels, aggregatedLabels});
            GraphDatabaseService graphDb = this.dbms.database("neo4j");
            log.info("Beginning transaction for the creation of equal-name aggregates.");
            int createdAggregates = ConceptAggregateManager.buildAggregatesForEqualNames(graphDb, targetLabels, nameProperty, aggregatedLabels, (String[])copyProperties.toArray(String[]::new), log);
            log.info("Process for the creation of equal-name aggregates has finished.");
            return Response.ok((Object)createdAggregates).build();
        }
        catch (IOException e) {
            return ConceptManager.getErrorResponse(e);
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="build_aggregates_by_mappings")
    public Response buildAggregatesByMappings(String jsonParameterObject, @Context Log log) {
        try {
            int createdAggregates;
            ObjectMapper om = new ObjectMapper();
            Map parameterMap = om.readValue(jsonParameterObject, Map.class);
            HashSet<String> allowedMappingTypes = new HashSet<String>((List)parameterMap.get(KEY_ALLOWED_MAPPING_TYPES));
            Label aggregatedConceptsLabel = Label.label((String)((String)parameterMap.get(KEY_AGGREGATED_LABEL)));
            Label allowedConceptLabel = parameterMap.containsKey(KEY_LABEL) ? Label.label((String)((String)parameterMap.get(KEY_LABEL))) : null;
            log.info("Creating mapping aggregates for concepts with label {} and mapping types {}", new Object[]{allowedConceptLabel, allowedMappingTypes});
            GraphDatabaseService graphDb = this.dbms.database("neo4j");
            try (Transaction tx = graphDb.beginTx();){
                createdAggregates = ConceptAggregateManager.buildAggregatesForMappings(tx, allowedMappingTypes, allowedConceptLabel, aggregatedConceptsLabel, log);
                tx.commit();
            }
            return Response.ok((Object)createdAggregates).build();
        }
        catch (Throwable t) {
            return ConceptManager.getErrorResponse(t);
        }
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="delete_aggregates")
    public Response deleteAggregatesByMappings(@QueryParam(value="aggregated_labels") String aggregatedConceptsLabelString, @Context Log log) {
        try {
            ObjectMapper om = new ObjectMapper();
            String[] labelList = om.readValue(aggregatedConceptsLabelString, String[].class);
            List<Label> aggregatedConceptsLabels = Arrays.stream(labelList).map(Label::label).collect(Collectors.toList());
            GraphDatabaseService graphDb = this.dbms.database("neo4j");
            Map<String, Long> deletionCounts = ConceptAggregateManager.deleteAggregatesBatchWise(graphDb, aggregatedConceptsLabels, log);
            return Response.ok(deletionCounts).build();
        }
        catch (Throwable t) {
            return ConceptManager.getErrorResponse(t);
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="copy_aggregate_properties")
    public Object copyAggregateProperties(String jsonParameterObject, @Context Log log) {
        try {
            ObjectMapper om = new ObjectMapper();
            Map parameterMap = jsonParameterObject != null && !jsonParameterObject.isBlank() ? om.readValue(jsonParameterObject, Map.class) : Collections.emptyMap();
            boolean skipExistingProperties = Boolean.parseBoolean(parameterMap.getOrDefault(KEY_SKIP_EXISTING_PROPERTIES, "true"));
            List aggregateLabels = parameterMap.getOrDefault(KEY_AGGREGATED_LABELS, List.of(ConceptLabel.AGGREGATE.name())).stream().map(Label::label).collect(Collectors.toList());
            int batchSize = 100;
            int numAggregates = 0;
            log.info("Copying properties of aggregates with labels %s.", new Object[]{aggregateLabels});
            CopyAggregatePropertiesStatistics copyStats = new CopyAggregatePropertiesStatistics();
            GraphDatabaseService graphDb = this.dbms.database("neo4j");
            for (Label aggregateLabel : aggregateLabels) {
                ArrayDeque<String> aggregateIds = new ArrayDeque<String>();
                try (Transaction tx = graphDb.beginTx();
                     ResourceIterator aggregateIt = tx.findNodes(aggregateLabel);){
                    while (aggregateIt.hasNext()) {
                        Node aggregate = (Node)aggregateIt.next();
                        String aggregateId = (String)aggregate.getProperty("id");
                        if (aggregateId == null) {
                            throw new IllegalStateException("There are aggregate nodes without an ID.");
                        }
                        aggregateIds.add(aggregateId);
                    }
                }
                log.info("Retrieved %s aggregates. Now copying properties.", new Object[]{aggregateIds.size()});
                int numAggregatesProcessed = 0;
                do {
                    HashSet<String> alreadySeenIds = new HashSet<String>();
                    try (Transaction tx = graphDb.beginTx();){
                        log.info("Processing next batch of %s aggregates. Already seen aggregates through recursion are skipped.", new Object[]{batchSize});
                        for (int i = 0; i < batchSize && !aggregateIds.isEmpty(); ++i) {
                            String aggregateId = (String)aggregateIds.poll();
                            Node aggregate = tx.findNode((Label)ConceptLabel.AGGREGATE, "id", (Object)aggregateId);
                            numAggregates += this.copyAggregatePropertiesRecursively(aggregate, skipExistingProperties, copyStats, alreadySeenIds);
                            ++numAggregatesProcessed;
                        }
                        log.info("Processed %s aggregates", new Object[]{numAggregatesProcessed});
                        log.info("Committing aggregate property copy transaction.");
                        tx.commit();
                    }
                } while (!aggregateIds.isEmpty());
            }
            log.info("Finished the copying of properties for %s aggregate nodes.", new Object[]{numAggregates});
            HashMap<String, Integer> reportMap = new HashMap<String, Integer>();
            reportMap.put(RET_KEY_NUM_AGGREGATES, numAggregates);
            reportMap.put(RET_KEY_NUM_ELEMENTS, copyStats.numElements);
            reportMap.put(RET_KEY_NUM_PROPERTIES, copyStats.numProperties);
            return Response.ok(reportMap).build();
        }
        catch (Throwable t) {
            return ConceptManager.getErrorResponse(t);
        }
    }

    private int copyAggregatePropertiesRecursively(Node aggregate, boolean skipExistingProperties, CopyAggregatePropertiesStatistics copyStats, Set<String> alreadySeen) {
        int startSize = alreadySeen.size();
        String aggregateId = (String)aggregate.getProperty("id");
        if (alreadySeen.contains(aggregateId)) {
            return 0;
        }
        ArrayList<Node> elementAggregates = new ArrayList<Node>();
        Iterable elementRels = aggregate.getRelationships(Direction.OUTGOING, new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT});
        for (Relationship elementRel : elementRels) {
            Node endNode = elementRel.getEndNode();
            if (!endNode.hasLabel((Label)ConceptLabel.AGGREGATE) || alreadySeen.contains(endNode)) continue;
            elementAggregates.add(endNode);
        }
        for (Node elementAggregate : elementAggregates) {
            this.copyAggregatePropertiesRecursively(elementAggregate, skipExistingProperties, copyStats, alreadySeen);
        }
        if (aggregate.hasProperty("copyProperties")) {
            String[] copyProperties = (String[])aggregate.getProperty("copyProperties");
            ConceptAggregateManager.copyAggregateProperties(aggregate, skipExistingProperties, copyProperties, copyStats);
        }
        alreadySeen.add(aggregateId);
        return alreadySeen.size() - startSize;
    }

    public static class CopyAggregatePropertiesStatistics {
        public int numProperties = 0;
        public int numElements = 0;

        public String toString() {
            return "CopyAggregatePropertiesStatistics [numProperties=" + this.numProperties + ", numElements=" + this.numElements + "]";
        }
    }
}

