/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import de.julielab.neo4j.plugins.Indexes;
import java.util.Optional;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;

public class SequenceManager {
    private static final String SEQUENCE_INDEX = "sequenceIndex";

    public static int getNextSequenceValue(Transaction tx, String sequenceName) {
        Node sequence = SequenceManager.getSequence(tx, sequenceName);
        tx.acquireReadLock((Entity)sequence);
        tx.acquireWriteLock((Entity)sequence);
        int currentSequenceValue = (Integer)sequence.getProperty("value");
        sequence.setProperty("value", (Object)(currentSequenceValue + 1));
        return currentSequenceValue;
    }

    public static int getCurrentSequenceValue(Transaction tx, String sequenceName) {
        Node sequence = SequenceManager.getSequence(tx, sequenceName);
        int currentSequenceValue = (Integer)sequence.getProperty("value");
        return currentSequenceValue;
    }

    static Node getSequenceRoot(Transaction tx) {
        Node root = null;
        Optional sequenceRootOpt = tx.findNodes((Label)SequenceLabel.SEQUENCE_ROOT).stream().findAny();
        try {
            if (sequenceRootOpt.isEmpty()) {
                root = tx.createNode(new Label[]{SequenceLabel.SEQUENCE_ROOT});
                root.setProperty("name", (Object)"SequenceRoot");
            } else {
                root = (Node)sequenceRootOpt.get();
            }
        }
        catch (ConstraintViolationException e) {
            root.delete();
            root = tx.findNode((Label)SequenceLabel.SEQUENCE_ROOT, "name", (Object)"SequenceRoot");
        }
        return root;
    }

    private static synchronized Node getSequence(Transaction tx, String sequenceName) {
        try {
            Node sequence = tx.findNode((Label)SequenceLabel.SEQUENCE, "name", (Object)sequenceName);
            try {
                if (null == sequence) {
                    Node seqRoot = SequenceManager.getSequenceRoot(tx);
                    sequence = tx.createNode(new Label[]{SequenceLabel.SEQUENCE});
                    sequence.setProperty("name", (Object)sequenceName);
                    sequence.setProperty("value", (Object)0);
                    seqRoot.createRelationshipTo(sequence, (RelationshipType)EdgeTypes.HAS_SEQUENCE);
                }
            }
            catch (ConstraintViolationException e) {
                sequence.delete();
                sequence = tx.findNode((Label)SequenceLabel.SEQUENCE, "name", (Object)sequenceName);
            }
            return sequence;
        }
        catch (MultipleFoundException e) {
            throw new IllegalStateException("More than one sequence node for the sequence with name \"" + sequenceName + "\" was returned.", e);
        }
    }

    public static void createIndexes(Transaction tx) {
        Indexes.createSinglePropertyIndexIfAbsent(tx, "SequenceRootIndex", SequenceLabel.SEQUENCE_ROOT, true, "native-btree-1.0", "name");
        Indexes.createSinglePropertyIndexIfAbsent(tx, "SequenceIndex", SequenceLabel.SEQUENCE, true, "native-btree-1.0", "name");
    }

    public static enum SequenceLabel implements Label
    {
        SEQUENCE_ROOT,
        SEQUENCE;

    }

    public static enum EdgeTypes implements RelationshipType
    {
        HAS_SEQUENCE;

    }
}

