/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import de.julielab.neo4j.plugins.FullTextIndexUtils;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.concepts.ConceptEdgeTypes;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;

public class NodeUtilities
extends de.julielab.neo4j.plugins.auxiliaries.NodeUtilities {
    public static String getNodeRelationshipsString(Node n) {
        ArrayList<CallSite> relsStrings = new ArrayList<CallSite>();
        for (Relationship r : n.getRelationships()) {
            Node src = r.getStartNode();
            Node tgt = r.getEndNode();
            String srcLabel = NodeUtilities.getNodeIdentifier(src);
            String tgtLabel = NodeUtilities.getNodeIdentifier(tgt);
            String rType = r.getType().name();
            relsStrings.add((CallSite)((Object)(srcLabel + "-" + rType + "->" + tgtLabel)));
        }
        return StringUtils.join(relsStrings, "\n");
    }

    public static String getNodeIdentifier(Node n) {
        String identifier = String.valueOf(n.getId());
        if (n.hasProperty("id")) {
            identifier = (String)n.getProperty("id");
        }
        if (n.hasProperty("sourceIds")) {
            identifier = ((String[])n.getProperty("sourceIds"))[0];
        }
        if (n.hasProperty("name")) {
            identifier = (String)n.getProperty("name");
        }
        if (n.hasProperty("preferredName")) {
            identifier = (String)n.getProperty("preferredName");
        }
        return "(" + identifier + ":" + StringUtils.join(n.getLabels().iterator(), ",") + ")";
    }

    public static String[] getSourcesForSourceId(Node conceptNode, String sourceId) {
        int index = NodeUtilities.getSourceIdIndex(conceptNode, sourceId);
        if (index >= 0) {
            return (String[])conceptNode.getProperty("sources" + index);
        }
        return new String[0];
    }

    public static String[] getUniqueSourcesForSourceId(Node conceptNode, String sourceId) {
        int index = NodeUtilities.getSourceIdIndex(conceptNode, sourceId);
        if (index >= 0) {
            return (String[])conceptNode.getProperty("uniqueSourceId" + index);
        }
        return new String[0];
    }

    public static int getSourceIdIndex(Node concept, String sourceId) {
        int i = 0;
        String sourceIdProperty = "sourceIds" + i;
        while (concept.hasProperty(sourceIdProperty)) {
            String currentSourceId = (String)concept.getProperty(sourceIdProperty);
            if (currentSourceId.equals(sourceId)) {
                return i;
            }
            sourceIdProperty = "sourceIds" + ++i;
        }
        return -1;
    }

    public static String[] getSourceIdArray(Node concept) {
        return (String[])NodeUtilities.getSourceIds(concept).toArray(String[]::new);
    }

    public static String[] getSourceArray(Node concept) {
        return (String[])NodeUtilities.getSources(concept).toArray(String[]::new);
    }

    public static List<String> getSources(Node concept) {
        int i = 0;
        String sourceProperty = "sources" + i;
        ArrayList<String> sourceIds = new ArrayList<String>();
        while (concept.hasProperty(sourceProperty)) {
            Stream.of((String[])concept.getProperty(sourceProperty)).forEach(sourceIds::add);
            sourceProperty = "sources" + ++i;
        }
        return sourceIds;
    }

    public static List<String> getSourceIds(Node concept) {
        int i = 0;
        String sourceIdProperty = "sourceIds" + i;
        ArrayList<String> sourceIds = new ArrayList<String>();
        while (concept.hasProperty(sourceIdProperty)) {
            sourceIds.add((String)concept.getProperty(sourceIdProperty));
            sourceIdProperty = "sourceIds" + ++i;
        }
        return sourceIds;
    }

    public static boolean isSourceUnique(Node conceptNode, String srcId, String source) {
        Object[] sources;
        int sourceIndex;
        int sourceIdIndex = NodeUtilities.getSourceIdIndex(conceptNode, srcId);
        if (sourceIdIndex >= 0 && (sourceIndex = Arrays.binarySearch(sources = (String[])conceptNode.getProperty("sources" + sourceIdIndex), source)) >= 0) {
            boolean[] uniqueSources = (boolean[])conceptNode.getProperty("uniqueSourceId" + sourceIdIndex);
            return uniqueSources[sourceIndex];
        }
        return false;
    }

    public static Node mergeConceptNodesWithUniqueSourceId(Transaction tx, String srcId, List<Node> obsoleteNodes) {
        ResourceIterator<Object> conceptNodesIt = FullTextIndexUtils.getNodes(tx, "concepts", "sourceIds", srcId);
        Node firstNode = null;
        for (Object o : () -> conceptNodesIt) {
            String conceptPrefName;
            Node conceptNode = (Node)o;
            if (firstNode == null) {
                firstNode = conceptNode;
                continue;
            }
            String firstNodePrefName = (String)firstNode.getProperty("preferredName");
            boolean addConceptPrefToSynonyms = !firstNodePrefName.equals(conceptPrefName = (String)conceptNode.getProperty("preferredName"));
            PropertyUtilities.mergeEntityIntoEntity(conceptNode, firstNode, "labels", "sourceIds", "sources", "synonyms", "relationships", "coordinates", "parentCoordinates");
            String[] conceptSrcIds = (String[])conceptNode.getProperty("sourceIds");
            String[] conceptSources = (String[])conceptNode.getProperty("sources");
            boolean[] conceptUniqueMarkers = (boolean[])conceptNode.getProperty("uniqueSourceId");
            for (int i = 0; i < conceptSrcIds.length; ++i) {
                String conceptSrcId = conceptSrcIds[i];
                String conceptSource = conceptSources[i];
                boolean conceptUniqueSrcId = conceptUniqueMarkers[i];
                int idIndex = NodeUtilities.findFirstValueInArrayProperty(firstNode, "sourceIds", conceptSrcId);
                int sourceIndex = NodeUtilities.findFirstValueInArrayProperty(firstNode, "sources", conceptSource);
                if (StringUtils.isBlank(srcId) || (idIndex != -1 || sourceIndex != -1) && idIndex == sourceIndex) continue;
                NodeUtilities.addToArrayProperty((Entity)firstNode, "sourceIds", conceptSrcId, true);
                NodeUtilities.addToArrayProperty((Entity)firstNode, "sources", conceptSource, true);
                NodeUtilities.addToArrayProperty((Entity)firstNode, "uniqueSourceId", conceptUniqueSrcId, true);
            }
            String[] conceptSynonyms = (String[])conceptNode.getProperty("synonyms");
            NodeUtilities.mergeArrayProperty((Entity)firstNode, "synonyms", conceptSynonyms);
            if (addConceptPrefToSynonyms) {
                NodeUtilities.addToArrayProperty((Entity)firstNode, "synonyms", conceptPrefName);
            }
            String[] conceptFacets = (String[])conceptNode.getProperty("facets");
            NodeUtilities.mergeArrayProperty((Entity)firstNode, "facets", conceptFacets);
            Iterable labels = conceptNode.getLabels();
            for (Label label : labels) {
                firstNode.addLabel(label);
            }
            obsoleteNodes.add(conceptNode);
        }
        return firstNode;
    }

    public static Set<Node> getAggregatingNodes(Node node) {
        return StreamSupport.stream(node.getRelationships(Direction.INCOMING, new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT}).spliterator(), false).map(Relationship::getStartNode).collect(Collectors.toSet());
    }

    public static Set<Node> getParentNodes(Node node) {
        return StreamSupport.stream(node.getRelationships(Direction.INCOMING, new RelationshipType[]{ConceptEdgeTypes.IS_BROADER_THAN}).spliterator(), false).map(Relationship::getStartNode).collect(Collectors.toSet());
    }

    public static Set<Node> getElementNodes(Node aggregate) {
        if (!aggregate.hasLabel((Label)ConceptLabel.AGGREGATE)) {
            throw new IllegalArgumentException("The given node does not have the AGGREGATE label");
        }
        return StreamSupport.stream(aggregate.getRelationships(Direction.OUTGOING, new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT}).spliterator(), false).map(Relationship::getEndNode).collect(Collectors.toSet());
    }

    public static void mergeSourceId(Transaction tx, Node concept, String srcId, String source, boolean uniqueSourceId) {
        if (srcId == null) {
            return;
        }
        int sourceIdIndex = NodeUtilities.getSourceIdIndex(concept, srcId);
        if (sourceIdIndex >= 0) {
            String sourceProp = "sources" + sourceIdIndex;
            String uniqueSourceProp = "uniqueSourceId" + sourceIdIndex;
            Object[] presentSources = (String[])concept.getProperty(sourceProp);
            int index = Arrays.binarySearch(presentSources, source);
            if (index < 0) {
                int insertionPoint = -1 * (index + 1);
                String[] newSources = new String[presentSources.length + 1];
                newSources[insertionPoint] = source;
                System.arraycopy(presentSources, 0, newSources, 0, insertionPoint);
                System.arraycopy(presentSources, insertionPoint, newSources, insertionPoint + 1, presentSources.length - insertionPoint);
                concept.setProperty(sourceProp, (Object)newSources);
                boolean[] presentUniqueSources = (boolean[])concept.getProperty(uniqueSourceProp);
                boolean[] newUniqueSources = new boolean[presentSources.length + 1];
                newUniqueSources[insertionPoint] = uniqueSourceId;
                System.arraycopy(presentUniqueSources, 0, newUniqueSources, 0, insertionPoint);
                System.arraycopy(presentUniqueSources, insertionPoint, newUniqueSources, insertionPoint + 1, presentUniqueSources.length - insertionPoint);
                concept.setProperty(uniqueSourceProp, (Object)newUniqueSources);
            }
        } else {
            int sourcePropNum = NodeUtilities.getNumberSourceIds(tx, concept);
            int currentSourceIdPropNum = SequenceManager.getCurrentSequenceValue(tx, "num_sourceids_sequence");
            if (currentSourceIdPropNum < sourcePropNum + 1) {
                SequenceManager.getNextSequenceValue(tx, "num_sourceids_sequence");
            }
            String sourceIdProperty = "sourceIds" + sourcePropNum;
            String sourceProperty = "sources" + sourcePropNum;
            String uniqueSourceProperty = "uniqueSourceId" + sourcePropNum;
            concept.setProperty(sourceIdProperty, (Object)srcId);
            concept.setProperty(sourceProperty, (Object)new String[]{source});
            concept.setProperty(uniqueSourceProperty, (Object)new boolean[]{uniqueSourceId});
        }
    }

    private static int getNumberSourceIds(Transaction tx, Node concept) {
        int i = 0;
        String sourceIdProperty = "sourceIds" + i;
        while (concept.hasProperty(sourceIdProperty)) {
            sourceIdProperty = "sourceIds" + ++i;
        }
        return i;
    }
}

