/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class CoordinatesSet
implements Iterable<ConceptCoordinates> {
    private final Map<String, ConceptCoordinates> coordsByOriginalId = new HashMap<String, ConceptCoordinates>();
    private final Map<String, ConceptCoordinates> coordsBySourceId = new HashMap<String, ConceptCoordinates>();

    public boolean add(ConceptCoordinates coordinates) {
        if (coordinates.originalId != null && coordinates.originalSource == null) {
            throw new IllegalArgumentException("ConceptCoordinates \"" + coordinates + "\" specify an originalId but no originalSource.");
        }
        ConceptCoordinates c = coordinates.clone();
        ConceptCoordinates c2 = this.get(c);
        if (c2 != null) {
            if (c2.originalId == null && c.originalId != null) {
                c2.originalId = c.originalId;
                c2.originalSource = c.originalSource;
            }
            if (c2.sourceId == null && c.sourceId != null) {
                c2.sourceId = c.sourceId;
                c2.source = c.source;
            }
            return true;
        }
        if (c.originalId != null) {
            this.coordsByOriginalId.put(c.originalSource + ":" + c.originalId, c);
        }
        if (coordinates.sourceId != null) {
            this.coordsBySourceId.put(c.source + ":" + c.sourceId, c);
        }
        return false;
    }

    public ConceptCoordinates get(ConceptCoordinates coordinates) {
        ConceptCoordinates c;
        if (coordinates == null) {
            throw new IllegalArgumentException("The passed concept coordinates were null.");
        }
        ConceptCoordinates conceptCoordinates = c = coordinates.originalId != null ? this.coordsByOriginalId.get(coordinates.originalSource + ":" + coordinates.originalId) : null;
        if (c != null && c.originalSource.equals(coordinates.originalSource)) {
            return c;
        }
        c = this.coordsBySourceId.get(coordinates.source + ":" + coordinates.sourceId);
        if (c != null && c.sourceId.equals(coordinates.sourceId) && (c.source.equals(coordinates.source) || c.uniqueSourceId && coordinates.uniqueSourceId)) {
            return c;
        }
        return null;
    }

    public boolean contains(ConceptCoordinates coordinates) {
        return this.contains(coordinates, false);
    }

    public boolean contains(ConceptCoordinates coordinates, boolean merge) {
        boolean contains;
        boolean bl = contains = this.get(coordinates) != null;
        if (contains && merge) {
            return this.add(coordinates);
        }
        return contains;
    }

    @Override
    public Iterator<ConceptCoordinates> iterator() {
        HashSet<ConceptCoordinates> s = new HashSet<ConceptCoordinates>();
        s.addAll(this.coordsByOriginalId.values());
        s.addAll(this.coordsBySourceId.values());
        return s.iterator();
    }

    public boolean isEmpty() {
        return this.coordsByOriginalId.isEmpty() && this.coordsBySourceId.isEmpty();
    }
}

