/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import de.julielab.neo4j.plugins.auxiliaries.semedico.CoordinatesSet;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;

public class CoordinatesMap {
    private final CoordinatesSet keys = new CoordinatesSet();
    private final Map<ConceptCoordinates, Node> nodes = new HashMap<ConceptCoordinates, Node>();

    public void put(ConceptCoordinates key, Node node) {
        if (key == null || node == null) {
            throw new IllegalArgumentException("The coordinate key and the node value must both be non-null.");
        }
        boolean existed = this.keys.contains(key);
        if (!existed) {
            this.keys.add(key);
            this.nodes.put(key, node);
        }
    }

    public Node get(ConceptCoordinates key) {
        ConceptCoordinates coordinates = this.keys.get(key);
        return this.nodes.get(coordinates);
    }

    public boolean containsKey(ConceptCoordinates coordinates) {
        return this.keys.contains(coordinates);
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public int size() {
        return this.nodes.size();
    }
}

