/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins;

import de.julielab.neo4j.plugins.FacetManager;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.concepts.ConceptManager;
import java.util.List;
import java.util.Map;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/indexes")
public class Indexes {
    public static final String INDEXES_REST_ENDPOINT = "indexes";
    public static final String CREATE_INDEXES = "create_indexes";
    public static final String DB_NAME = "db_name";
    public static final String PROVIDER_NATIVE_1_0 = "native-btree-1.0";
    public static final String PROVIDER_LUCENE_NATIVE_1_0 = "lucene+native-3.0";
    private static final Logger log = LoggerFactory.getLogger(Indexes.class);
    private final DatabaseManagementService dbms;

    public Indexes(@Context DatabaseManagementService dbms) {
        this.dbms = dbms;
    }

    public static void createSinglePropertyIndexIfAbsent(Transaction tx, String indexName, Label label, boolean unique, String indexProvider, String property) {
        Schema schema = tx.schema();
        try {
            schema.getIndexByName(indexName);
        }
        catch (IllegalArgumentException e) {
            String indexCreationProcedure;
            String string = indexCreationProcedure = unique ? "createUniquePropertyConstraint" : "createIndex";
            if (indexProvider == null) {
                tx.execute("CALL db." + indexCreationProcedure + "($indexName, $label, $property)", Map.of("indexName", indexName, "label", List.of(label.name()), "property", List.of(property)));
            }
            tx.execute("CALL db." + indexCreationProcedure + "($indexName, $label, $property, $indexProvider)", Map.of("indexName", indexName, "label", List.of(label.name()), "property", List.of(property), "indexProvider", indexProvider));
        }
    }

    @PUT
    @Path(value="create_indexes")
    public void createIndexes(@QueryParam(value="db_name") String databaseName) {
        String effectiveDbName = databaseName == null ? "neo4j" : databaseName;
        GraphDatabaseService graphDb = this.dbms.database(effectiveDbName);
        this.createIndexes(graphDb);
    }

    public void createIndexes(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            ConceptManager.createIndexes(tx);
            SequenceManager.createIndexes(tx);
            FacetManager.createIndexes(tx);
            tx.commit();
        }
    }
}

