/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.julielab.neo4j.plugins.FacetManager;
import de.julielab.neo4j.plugins.auxiliaries.LogUtilities;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.PredefinedTraversals;
import de.julielab.neo4j.plugins.concepts.ConceptAggregateManager;
import de.julielab.neo4j.plugins.concepts.ConceptEdgeTypes;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import de.julielab.neo4j.plugins.concepts.ConceptManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.logging.Log;
import org.neo4j.server.rest.repr.RecursiveMappingRepresentation;
import org.neo4j.server.rest.repr.Representation;

@Path(value="/export")
public class Export {
    public static final String HYPERNYMS = "hypernyms";
    public static final String LINGPIPE_DICT = "lingpipe_dictionary";
    public static final String CONCEPT_TO_FACET = "concept_facet_map";
    public static final String CONCEPT_ID_MAPPING = "concept_id_mapping";
    public static final String PARAM_UNIQUE_KEYS = "unique_keys";
    public static final String PARAM_SOURCE_ID_PROPERTY = "source_id_property";
    public static final String PARAM_ADD_SOURCE_PREFIX = "add_source_prefix";
    public static final String PARAM_TARGET_ID_PROPERTY = "target_id_property";
    public static final String PARAM_FACET_NAMES = "facet_names";
    public static final String PARAM_LABELS = "labels";
    public static final String PARAM_LABEL = "label";
    public static final String PARAM_EXCLUSION_LABEL = "exclusion_label";
    @Deprecated
    public static final String PARAM_FURTHER_PROPERTIES = "further_properties";
    public static final int OUTPUTSTREAM_INIT_SIZE = 200000000;
    public static final int HYPERNYMS_CACHE_SIZE = 100000;
    private static final Logger log = Logger.getLogger(Export.class.getName());
    private final DatabaseManagementService dbms;

    public Export(@Context DatabaseManagementService dbms) {
        this.dbms = dbms;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="concept_id_mapping")
    public Object exportIdMapping(@QueryParam(value="source_id_property") String sourceIdProperty, @QueryParam(value="target_id_property") String targetIdProperty, @QueryParam(value="labels") String labelStrings, @Context Log log) {
        try {
            String[] stringArray;
            ObjectMapper om = new ObjectMapper();
            this.log(log, "info", "Exporting ID mapping data.", new Object[0]);
            if (null != labelStrings) {
                stringArray = om.readValue(labelStrings, String[].class);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ConceptLabel.CONCEPT.name();
            }
            String[] labelsArray = stringArray;
            String sProperty = sourceIdProperty != null ? sourceIdProperty : "sourceIds";
            String tProperty = targetIdProperty != null ? targetIdProperty : "id";
            this.log(log, "info", "Creating mapping file content with source property %s, target property %s and node labels %s", sourceIdProperty, targetIdProperty, labelStrings);
            return output -> {
                try {
                    this.createIdMapping(output, sProperty, tProperty, labelsArray);
                }
                catch (Exception e) {
                    this.log(log, "error", "Exception occurred during concept ID output streaming.", e);
                    e.printStackTrace();
                }
            };
        }
        catch (Throwable t) {
            this.log(log, "error", "Could not export concept ID mappings", t);
            return ConceptManager.getErrorResponse(t);
        }
    }

    public Object exportIdMapping(String sourceIdProperty, String targetIdProperty, String labelStrings) {
        return this.exportIdMapping(sourceIdProperty, targetIdProperty, labelStrings, LogUtilities.getLogger(Export.class));
    }

    private void log(@Nullable Log log, String level, String fmt, Object ... arguments) {
        if (log != null) {
            switch (level) {
                case "error": {
                    log.error(fmt, arguments);
                    break;
                }
                case "warn": {
                    log.warn(fmt, arguments);
                    break;
                }
                case "info": {
                    log.info(fmt, arguments);
                    break;
                }
                case "debug": {
                    log.debug(fmt, arguments);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported log level '" + level + "'.");
                }
            }
        }
    }

    private void createIdMapping(OutputStream os, String sourceIdProperty, String targetIdProperty, String[] labelsArray) throws Exception {
        GraphDatabaseService graphDb = this.dbms.database("neo4j");
        try (Transaction tx = graphDb.beginTx();){
            int numWritten = 0;
            for (String labelString : labelsArray) {
                Label label = Label.label((String)labelString);
                ResourceIterator terms = tx.findNodes(label);
                while (terms.hasNext()) {
                    String[] stringArray;
                    String[] stringArray2;
                    Node n = (Node)terms.next();
                    Object sourceIdObject = sourceIdProperty.equals("sourceIds") ? NodeUtilities.getSourceIdArray(n) : PropertyUtilities.getNonNullNodeProperty((Entity)n, sourceIdProperty);
                    Object targetIdObject = n.getProperty(targetIdProperty);
                    if (null == sourceIdObject || null == targetIdObject) continue;
                    if (sourceIdObject.getClass().isArray()) {
                        stringArray2 = (String[])sourceIdObject;
                    } else {
                        String[] stringArray3 = new String[1];
                        stringArray2 = stringArray3;
                        stringArray3[0] = (String)sourceIdObject;
                    }
                    String[] sourceIds = stringArray2;
                    if (targetIdObject.getClass().isArray()) {
                        stringArray = (String[])targetIdObject;
                    } else {
                        String[] stringArray4 = new String[1];
                        stringArray = stringArray4;
                        stringArray4[0] = (String)targetIdObject;
                    }
                    String[] targetIds = stringArray;
                    for (String sourceId : sourceIds) {
                        for (String targetId : targetIds) {
                            IOUtils.write((String)(sourceId + "\t" + targetId + "\n"), (OutputStream)os, (String)"UTF-8");
                        }
                        ++numWritten;
                    }
                }
            }
            log.info("Num written: " + numWritten);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="hypernyms")
    public Object exportHypernyms(@QueryParam(value="facet_names") String facetNames, @QueryParam(value="label") String conceptLabel, @Context Log log) throws Exception {
        Object[] facetNameArray;
        ObjectMapper om = new ObjectMapper();
        Object[] objectArray = facetNameArray = null != facetNames ? om.readValue(facetNames, String[].class) : null;
        if (null == facetNameArray) {
            log.info("Exporting hypernyms dictionary data for all facets.");
        } else {
            log.info("Exporting hypernyms dictionary data for the facets with names " + Arrays.toString(facetNameArray) + ".");
        }
        return arg_0 -> this.lambda$exportHypernyms$1((String[])facetNameArray, conceptLabel, log, arg_0);
    }

    private void writeHypernymList(String[] facetNames, String conceptLabelString, OutputStream output) throws IOException {
        Label conceptLabel = null;
        if (!StringUtils.isBlank(conceptLabelString)) {
            conceptLabel = Label.label((String)conceptLabelString);
        }
        HashMap<Node, Set<String>> cache = new HashMap<Node, Set<String>>(100000);
        GraphDatabaseService graphDb = this.dbms.database("neo4j");
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable facets;
            ArrayList<RelationshipType> relationshipTypeList = new ArrayList<RelationshipType>();
            if (facetNames != null && facetNames.length > 1 || !facetNames[0].equals("all")) {
                for (String facetName : facetNames) {
                    facets = () -> tx.findNodes((Label)FacetManager.FacetLabel.FACET, "name", (Object)facetName);
                    for (Node facet : facets) {
                        String facetId = (String)facet.getProperty("id");
                        RelationshipType reltype = RelationshipType.withName((String)(ConceptEdgeTypes.IS_BROADER_THAN + "_" + facetId));
                        relationshipTypeList.add(reltype);
                    }
                }
            } else {
                relationshipTypeList.add(ConceptEdgeTypes.IS_BROADER_THAN);
            }
            for (String facetName : facetNames) {
                log.info("Now creating hypernyms for facet with name " + facetName);
                facets = () -> tx.findNodes((Label)FacetManager.FacetLabel.FACET, "name", (Object)facetName);
                HashSet<Node> visitedNodes = new HashSet<Node>();
                for (Node facet : facets) {
                    Iterable rels = facet.getRelationships(Direction.OUTGOING, new RelationshipType[]{ConceptEdgeTypes.HAS_ROOT_CONCEPT});
                    for (Relationship rel : rels) {
                        Node rootTerm = rel.getEndNode();
                        if (null != conceptLabel && !rootTerm.hasLabel(conceptLabel)) continue;
                        this.writeHypernyms(rootTerm, visitedNodes, cache, output, relationshipTypeList.toArray(new RelationshipType[0]));
                    }
                }
            }
        }
    }

    public Set<String> load(Node n, Map<Node, Set<String>> cache, RelationshipType[] relationshipTypes) {
        Set<String> hypernyms = cache.get(n);
        if (null != hypernyms) {
            return hypernyms;
        }
        hypernyms = new HashSet<String>();
        cache.put(n, hypernyms);
        HashSet<Node> visitedNodes = new HashSet<Node>();
        visitedNodes.add(n);
        for (Relationship rel : n.getRelationships(Direction.INCOMING, relationshipTypes)) {
            Node directHypernym = rel.getStartNode();
            boolean isHollow = false;
            for (Label l : directHypernym.getLabels()) {
                if (!l.equals((Object)ConceptLabel.HOLLOW)) continue;
                isHollow = true;
                break;
            }
            if (isHollow || visitedNodes.contains(directHypernym)) continue;
            String directHypernymId = ((String)directHypernym.getProperty("id")).intern();
            hypernyms.add(directHypernymId);
            hypernyms.addAll(this.load(directHypernym, cache, relationshipTypes));
        }
        visitedNodes.remove(n);
        return hypernyms;
    }

    private void writeHypernyms(Node n, Set<Node> visitedNodes, Map<Node, Set<String>> cache, OutputStream os, RelationshipType[] relationshipTypes) throws IOException {
        if (visitedNodes.contains(n)) {
            return;
        }
        this.load(n, cache, relationshipTypes);
        visitedNodes.add(n);
        boolean isHollow = false;
        for (Label l : n.getLabels()) {
            if (!l.equals((Object)ConceptLabel.HOLLOW)) continue;
            isHollow = true;
            break;
        }
        if (isHollow) {
            return;
        }
        Set<String> hypernyms = cache.get(n);
        if (hypernyms.size() > 0) {
            IOUtils.write((String)(n.getProperty("id") + "\t" + StringUtils.join(hypernyms, "|") + "\n"), (OutputStream)os, (String)"UTF-8");
        }
        for (Relationship rel : n.getRelationships(Direction.OUTGOING, new RelationshipType[]{ConceptEdgeTypes.IS_BROADER_THAN})) {
            this.writeHypernyms(rel.getEndNode(), visitedNodes, cache, os, relationshipTypes);
        }
        if (visitedNodes.size() % 100000 == 0) {
            log.info("Finished " + visitedNodes.size() + ".");
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="lingpipe_dictionary")
    public String exportLingpipeDictionary(@QueryParam(value="labels") String labelsString, @QueryParam(value="exclusion_label") String exclusionLabelString, @QueryParam(value="source_id_property") String idProperties, @QueryParam(value="add_source_prefix") boolean addSourcePrefix, @QueryParam(value="unique_keys") boolean uniqueKeys, @Context Log log) throws IOException {
        Label[] labels;
        ObjectMapper om = new ObjectMapper();
        if (!labelsString.contains("[")) {
            Label[] labelArray;
            if (StringUtils.isBlank(labelsString)) {
                Label[] labelArray2 = new Label[1];
                labelArray = labelArray2;
                labelArray2[0] = ConceptLabel.CONCEPT;
            } else {
                Label[] labelArray3 = new Label[1];
                labelArray = labelArray3;
                labelArray3[0] = Label.label((String)labelsString);
            }
            labels = labelArray;
        } else {
            labels = (Label[])Arrays.stream(om.readValue(labelsString, String[].class)).map(Label::label).toArray(Label[]::new);
        }
        List<Object> propertiesToWrite = new ArrayList<String>();
        if (idProperties == null || idProperties.length() == 0) {
            propertiesToWrite.add("id");
        } else if (!idProperties.contains("[")) {
            Collections.addAll(propertiesToWrite, idProperties.split(","));
        } else {
            propertiesToWrite = Arrays.stream(om.readValue(idProperties, String[].class)).collect(Collectors.toList());
        }
        Map<String, String> sourcePropertyNamesByIdPropertyName = Map.of("id", "", "originalId", "originalSource", "sourceIds0", "sources0", "sourceIds1", "sources1", "sourceIds2", "sources2", "sourceIds3", "sources3", "sourceIds4", "sources4", "sourceIds5", "sources5", "sourceIds6", "sources6", "sourceIds7", "sources7");
        log.info("Exporting lingpipe dictionary data for nodes with labels \"" + Arrays.stream(labels).map(Label::name).collect(Collectors.joining(", ")) + "\", mapping their names to their properties " + propertiesToWrite + ".");
        Label[] exclusionLabels = null;
        if (!StringUtils.isBlank(exclusionLabelString)) {
            try {
                String[] exclusionLabelsJson = om.readValue(exclusionLabelString, String[].class);
                exclusionLabels = new Label[exclusionLabelsJson.length];
                for (int i = 0; i < exclusionLabelsJson.length; ++i) {
                    String string = exclusionLabelsJson[i];
                    exclusionLabels[i] = Label.label((String)string);
                }
            }
            catch (JsonParseException e) {
                Label exclusionLabel = Label.label((String)exclusionLabelString);
                exclusionLabels = new Label[]{exclusionLabel};
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200000000);
        GraphDatabaseService graphDb = this.dbms.database("neo4j");
        HashSet<String> writtenKeys = uniqueKeys ? new HashSet<String>() : null;
        try (GZIPOutputStream os = new GZIPOutputStream(baos);){
            for (Label label : labels) {
                try (Transaction tx = graphDb.beginTx();){
                    ResourceIterator conceptNodes = tx.findNodes(label);
                    int count = 0;
                    while (conceptNodes.hasNext()) {
                        Node node = (Node)conceptNodes.next();
                        ++count;
                        boolean termHasExclusionLabel = false;
                        for (int i = 0; null != exclusionLabels && i < exclusionLabels.length; ++i) {
                            Label exclusionLabel = exclusionLabels[i];
                            if (!node.hasLabel(exclusionLabel)) continue;
                            termHasExclusionLabel = true;
                            break;
                        }
                        if (!termHasExclusionLabel && node.hasProperty("id") && node.hasProperty("preferredName")) {
                            String idProperty = (String)propertiesToWrite.get(0);
                            String[] ids = NodeUtilities.getNodePropertyAsStringArrayValue(node, idProperty);
                            if (null == ids && node.hasLabel((Label)ConceptLabel.AGGREGATE)) {
                                ids = ConceptAggregateManager.getPropertyValueOfElements(node, idProperty);
                            }
                            if (null == ids) {
                                conceptNodes.close();
                                throw new IllegalArgumentException("A concept occurred that does not have a value for the property \"" + idProperty + "\": " + NodeUtilities.getNodePropertiesAsString((Entity)node));
                            }
                            int arraySize = ids.length;
                            ArrayList<String> categoryStrings = new ArrayList<String>();
                            for (int i = 0; i < arraySize; ++i) {
                                StringBuilder sb = new StringBuilder();
                                for (int j = 0; j < propertiesToWrite.size(); ++j) {
                                    int k;
                                    String sourceProperty;
                                    String property = (String)propertiesToWrite.get(j);
                                    ids = NodeUtilities.getNodePropertyAsStringArrayValue(node, property);
                                    String[] sources = null;
                                    if (addSourcePrefix) {
                                        sourceProperty = sourcePropertyNamesByIdPropertyName.get(property);
                                        if (sourceProperty == null) {
                                            throw new IllegalArgumentException("Dictionary creation with source prefix should be performed but the source property is unknown for ID property '" + property + "'.");
                                        }
                                        if (!sourceProperty.isEmpty()) {
                                            sources = NodeUtilities.getNodePropertyAsStringArrayValue(node, sourceProperty);
                                        } else {
                                            sources = new String[ids.length];
                                            for (k = 0; k < sources.length; ++k) {
                                                sources[k] = "id";
                                            }
                                        }
                                    }
                                    if (null == ids && node.hasLabel((Label)ConceptLabel.AGGREGATE)) {
                                        ids = ConceptAggregateManager.getPropertyValueOfElements(node, idProperty);
                                        if (addSourcePrefix) {
                                            sourceProperty = sourcePropertyNamesByIdPropertyName.get(property);
                                            if (sourceProperty == null) {
                                                throw new IllegalArgumentException("Dictionary creation with source prefix should be performed but the source property is unknown for ID property '" + property + "'.");
                                            }
                                            if (!sourceProperty.isEmpty()) {
                                                sources = ConceptAggregateManager.getPropertyValueOfElements(node, sourceProperty);
                                            } else {
                                                sources = new String[ids.length];
                                                for (k = 0; k < sources.length; ++k) {
                                                    sources[k] = "id";
                                                }
                                            }
                                        }
                                    }
                                    if (null == ids || ids.length == 0) {
                                        conceptNodes.close();
                                        throw new IllegalArgumentException("The property \"" + property + "\" does not contain a value for node " + node + " (properties: " + PropertyUtilities.getNodePropertiesAsString((Entity)node) + ")");
                                    }
                                    if (ids.length != arraySize) {
                                        conceptNodes.close();
                                        throw new IllegalArgumentException("The properties \"" + propertiesToWrite + "\" on term " + PropertyUtilities.getNodePropertiesAsString((Entity)node) + " do not have all the same number of value elements which is required for dictionary creation by this method.");
                                    }
                                    if (addSourcePrefix) {
                                        sb.append(sources[i]).append(":").append(ids[i]);
                                    } else {
                                        sb.append(ids[i]);
                                    }
                                    if (j >= propertiesToWrite.size() - 1) continue;
                                    sb.append("||");
                                }
                                categoryStrings.add(sb.toString());
                            }
                            for (String categoryString : categoryStrings) {
                                String preferredName = (String)node.getProperty("preferredName");
                                String[] synonyms = new String[]{};
                                if (node.hasProperty("synonyms")) {
                                    synonyms = (String[])node.getProperty("synonyms");
                                }
                                this.writeNormalizedDictionaryEntry(preferredName, categoryString, writtenKeys, os);
                                for (String synonString : synonyms) {
                                    this.writeNormalizedDictionaryEntry(synonString, categoryString, writtenKeys, os);
                                }
                                TraversalDescription acronymsTraversal = PredefinedTraversals.getAcronymsTraversal(tx);
                                Traverser traverse = acronymsTraversal.traverse(node);
                                for (Node acronymNode : traverse.nodes()) {
                                    String acronym = (String)acronymNode.getProperty("name");
                                    this.writeNormalizedDictionaryEntry(acronym, categoryString, writtenKeys, os);
                                }
                            }
                        }
                        if (count % 100000 != 0) continue;
                        log.info(count + " terms processed.");
                    }
                }
            }
        }
        log.info("Done exporting Lingpipe term dictionary.");
        byte[] bytes = baos.toByteArray();
        return Base64.getEncoder().encodeToString(bytes);
    }

    private void writeNormalizedDictionaryEntry(String name, String termId, Set<String> writtenKeys, OutputStream os) throws IOException {
        String normalizedName = StringUtils.normalizeSpace(name);
        if (normalizedName.length() > 2 && (writtenKeys == null || writtenKeys.add(normalizedName))) {
            IOUtils.write((String)(normalizedName + "\t" + termId + "\n"), (OutputStream)os, (String)"UTF-8");
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="concept_facet_map")
    public Representation exportTermFacetMapping(@QueryParam(value="label") String labelString) throws IOException {
        log.info("Exporting lingpipe dictionary data.");
        ConceptLabel label = !StringUtils.isBlank(labelString) ? Label.label((String)labelString) : ConceptLabel.CONCEPT;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200000000);
        GraphDatabaseService graphDb = this.dbms.database("neo4j");
        try (GZIPOutputStream os = new GZIPOutputStream(baos);
             Transaction tx = graphDb.beginTx();){
            ResourceIterable terms = () -> tx.findNodes(label);
            int count = 0;
            for (Node term : terms) {
                ++count;
                if (term.hasProperty("id") && term.hasProperty("facets")) {
                    String termId = (String)term.getProperty("id");
                    Object[] facetIds = (String[])term.getProperty("facets");
                    IOUtils.write((String)(termId + "\t" + StringUtils.join(facetIds, "|") + "\n"), (OutputStream)os, (String)"UTF-8");
                }
                if (count % 100000 != 0) continue;
                log.info(count + " terms processed.");
            }
            log.info("Done exporting mapping from term ID to corresponding facet IDs.");
        }
        return RecursiveMappingRepresentation.getObjectRepresentation(baos.toByteArray());
    }

    private /* synthetic */ void lambda$exportHypernyms$1(String[] facetNameArray, String conceptLabel, Log log, OutputStream output) throws IOException, WebApplicationException {
        try {
            this.writeHypernymList(facetNameArray, conceptLabel, output);
        }
        catch (Exception e) {
            log.error("Exception occurred during concept ID output streaming.", (Throwable)e);
            e.printStackTrace();
        }
    }
}

