/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.datarepresentation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcept;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacet;
import de.julielab.neo4j.plugins.datarepresentation.ImportOptions;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonPropertyOrder(value={"facet", "importOptions", "name_num_concepts", "concepts"})
public class ImportConcepts {
    public static final String NAME_FACET = "facet";
    public static final String NAME_IMPORT_OPTIONS = "importOptions";
    public static final String NAME_CONCEPTS = "concepts";
    public static final String NAME_NUM_CONCEPTS = "name_num_concepts";
    @JsonProperty(value="concepts")
    private Stream<ImportConcept> concepts;
    @JsonProperty(value="facet")
    private ImportFacet facet;
    @JsonProperty(value="importOptions")
    private ImportOptions importOptions;
    @JsonProperty(value="name_num_concepts")
    private long numConcepts = -1L;
    @JsonIgnore
    private List<ImportConcept> conceptsList;

    public ImportConcepts() {
    }

    public ImportConcepts(ImportFacet facet) {
        this.facet = facet;
    }

    public ImportConcepts(Stream<ImportConcept> conceptStream, ImportFacet facet) {
        this.concepts = conceptStream;
        this.facet = facet;
    }

    public ImportConcepts(Stream<ImportConcept> termList, ImportFacet importFacet, ImportOptions importOptions) {
        this(termList, importFacet);
        this.importOptions = importOptions;
    }

    public ImportConcepts(List<ImportConcept> concepts, ImportFacet importFacet) {
        this(concepts.stream(), importFacet);
        this.conceptsList = concepts;
    }

    public ImportConcepts(List<ImportConcept> concepts, ImportFacet importFacet, ImportOptions importOptions) {
        this(concepts.stream(), importFacet, importOptions);
        this.conceptsList = concepts;
    }

    public Stream<ImportConcept> getConcepts() {
        return this.concepts;
    }

    public void setConcepts(List<ImportConcept> concepts) {
        this.concepts = concepts.stream();
    }

    public void setConcepts(Stream<ImportConcept> concepts) {
        this.concepts = concepts;
    }

    public long getNumConcepts() {
        return this.numConcepts;
    }

    public void setNumConcepts(long numConcepts) {
        this.numConcepts = numConcepts;
    }

    @JsonIgnore
    public List<ImportConcept> getConceptsAsList() {
        if (this.conceptsList == null) {
            this.conceptsList = this.concepts.collect(Collectors.toList());
            this.concepts = this.conceptsList.stream();
        }
        return this.conceptsList;
    }

    public ImportFacet getFacet() {
        return this.facet;
    }

    public void setFacet(ImportFacet facet) {
        this.facet = facet;
    }

    public ImportOptions getImportOptions() {
        return this.importOptions;
    }

    public void setImportOptions(ImportOptions importOptions) {
        this.importOptions = importOptions;
    }
}

