/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.datarepresentation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportConceptRelationship;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ImportConcept {
    @JsonProperty(value="preferredName")
    public String prefName;
    @JsonProperty(value="descriptions")
    public List<String> descriptions = Collections.emptyList();
    @JsonProperty(value="synonyms")
    public List<String> synonyms = Collections.emptyList();
    @JsonProperty(value="writingVariants")
    public List<String> writingVariants = Collections.emptyList();
    @JsonProperty(value="coordinates")
    public ConceptCoordinates coordinates;
    @JsonProperty(value="parentCoordinates")
    public List<ConceptCoordinates> parentCoordinates = Collections.emptyList();
    @JsonProperty(value="relationships")
    public List<ImportConceptRelationship> relationships = Collections.emptyList();
    @JsonProperty(value="labels")
    public List<String> generalLabels = Collections.emptyList();
    @JsonProperty(value="displayName")
    public String displayName;
    @JsonProperty(value="qualifiers")
    public List<String> qualifiers = Collections.emptyList();
    @JsonProperty(value="aggregate")
    public boolean aggregate;
    @JsonProperty(value="elementCoordinates")
    public List<ConceptCoordinates> elementCoordinates = Collections.emptyList();
    @JsonProperty(value="copyProperties")
    public List<String> copyProperties = Collections.emptyList();
    @JsonProperty(value="aggregateIncludeInHierarchy")
    public boolean aggregateIncludeInHierarchy;
    @JsonIgnore
    public Map<String, Object> auxProperties;

    public ImportConcept(String preferredName, ConceptCoordinates coordinates) {
        this.prefName = preferredName;
        this.coordinates = coordinates;
    }

    public ImportConcept(String preferredName, String description, ConceptCoordinates coordinates) {
        this(preferredName, coordinates);
        if (description != null) {
            this.descriptions = Arrays.asList(description);
        }
    }

    public ImportConcept(String preferredName, List<String> synonyms, ConceptCoordinates coordinates) {
        this(preferredName, coordinates);
        this.synonyms = synonyms;
    }

    public ImportConcept(String preferredName, List<String> synonyms, String description, ConceptCoordinates coordinates) {
        this(preferredName, synonyms, coordinates);
        if (description != null) {
            this.descriptions = Arrays.asList(description);
        }
    }

    public ImportConcept(String preferredName, List<String> synonyms, String description, ConceptCoordinates coordinates, ConceptCoordinates parentCoordinates) {
        this(preferredName, synonyms, Arrays.asList(description), coordinates, Arrays.asList(parentCoordinates));
    }

    public ImportConcept(String preferredName, List<String> synonyms, String description, ConceptCoordinates coordinates, List<ConceptCoordinates> parentCoordinates) {
        this(preferredName, synonyms, Arrays.asList(description), coordinates, parentCoordinates);
    }

    public ImportConcept(String preferredName, List<String> synonyms, List<String> descriptions, ConceptCoordinates coordinates) {
        this(preferredName, synonyms, coordinates);
        this.descriptions = descriptions;
    }

    public ImportConcept(String preferredName, List<String> synonyms, List<String> descriptions, ConceptCoordinates coordinates, ConceptCoordinates parentCoordinates) {
        this(preferredName, synonyms, descriptions, coordinates);
        if (parentCoordinates == null) {
            throw new IllegalArgumentException("The passed parent coordinates are null which is invalid (pass an empty list instead).");
        }
        if (parentCoordinates != null) {
            this.parentCoordinates = Arrays.asList(parentCoordinates);
        }
    }

    public ImportConcept(String preferredName, List<String> synonyms, List<String> descriptions, ConceptCoordinates coordinates, List<ConceptCoordinates> parentCoordinates) {
        this(preferredName, synonyms, descriptions, coordinates);
        if (parentCoordinates == null) {
            throw new IllegalArgumentException("The passed parent coordinates are null which is invalid (pass an empty list instead).");
        }
        if (parentCoordinates != null) {
            this.parentCoordinates = parentCoordinates;
        }
    }

    public ImportConcept(String preferredName, ConceptCoordinates coordinates, ConceptCoordinates parentCoordinates) {
        this(preferredName, coordinates);
        if (parentCoordinates == null) {
            throw new IllegalArgumentException("The passed parent coordinates are null which is invalid (pass an empty list instead).");
        }
        if (parentCoordinates != null) {
            this.parentCoordinates = Arrays.asList(parentCoordinates);
        }
    }

    public ImportConcept(String preferredName, ConceptCoordinates coordinates, List<ConceptCoordinates> parentCoordinates) {
        this(preferredName, coordinates);
        if (parentCoordinates == null) {
            throw new IllegalArgumentException("The passed parent coordinates are null which is invalid (pass an empty list instead).");
        }
        if (parentCoordinates != null) {
            this.parentCoordinates = parentCoordinates;
        }
    }

    public ImportConcept(List<ConceptCoordinates> elementCoords, List<String> copyProperties) {
        this.elementCoordinates = elementCoords;
        this.copyProperties = copyProperties;
        this.aggregate = true;
    }

    public ImportConcept(ConceptCoordinates conceptCoordinates) {
        this.coordinates = conceptCoordinates;
    }

    public ImportConcept() {
    }

    public void putAuxProperty(String key, Object value) {
        if (this.auxProperties == null) {
            this.auxProperties = new HashMap<String, Object>();
        }
        this.auxProperties.put(key, value);
    }

    public Object getAuxProperty(String key) {
        if (this.auxProperties == null) {
            return null;
        }
        return this.auxProperties.get(key);
    }

    public void addRelationship(ImportConceptRelationship relationship) {
        if (this.relationships.isEmpty()) {
            this.relationships = new ArrayList<ImportConceptRelationship>();
        }
        this.relationships.add(relationship);
    }

    public void addGeneralLabel(String ... labels) {
        if (this.generalLabels.isEmpty()) {
            this.generalLabels = new ArrayList<String>();
        }
        try {
            for (String label : labels) {
                this.generalLabels.add(label);
            }
        }
        catch (UnsupportedOperationException e) {
            this.generalLabels = new ArrayList<String>(this.generalLabels);
            this.addGeneralLabel(labels);
        }
    }

    public void addCopyProperty(String property) {
        if (this.copyProperties.isEmpty()) {
            this.copyProperties = new ArrayList<String>();
        }
        this.copyProperties.add(property);
    }

    public void addQualifier(String speciesQualifier) {
        if (this.qualifiers.isEmpty()) {
            this.qualifiers = new ArrayList<String>();
        }
        this.qualifiers.add(speciesQualifier);
    }

    public void removeGeneralLabel(String ... labels) {
        if (this.generalLabels.isEmpty()) {
            return;
        }
        HashSet<String> removeLabels = new HashSet<String>(labels.length);
        for (String label : labels) {
            removeLabels.add(label);
        }
        this.generalLabels.removeIf(removeLabels::contains);
    }

    public void addParent(ConceptCoordinates parentCoordinates) {
        if (this.parentCoordinates.isEmpty()) {
            this.parentCoordinates = new ArrayList<ConceptCoordinates>();
        }
        this.parentCoordinates.add(parentCoordinates);
    }

    public void addParentIfNotExists(ConceptCoordinates parentCoordinates) {
        if (this.parentCoordinates.isEmpty() || !this.parentCoordinates.contains(parentCoordinates)) {
            this.addParent(parentCoordinates);
        }
    }

    public boolean hasParents() {
        return !this.parentCoordinates.isEmpty();
    }
}

