/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.datarepresentation;

import de.julielab.neo4j.plugins.datarepresentation.CoordinateType;

public class ConceptCoordinates
implements Cloneable {
    public String sourceId;
    public String source;
    public String originalId;
    public String originalSource;
    public boolean uniqueSourceId;

    public ConceptCoordinates() {
    }

    public ConceptCoordinates(String sourceId, String source, String originalId, String originalSource, boolean uniqueSourceId) {
        this.sourceId = sourceId;
        this.source = source;
        this.originalId = originalId;
        this.originalSource = originalSource;
        this.uniqueSourceId = uniqueSourceId;
    }

    public ConceptCoordinates(String sourceId, String source, String originalId, String originalSource) {
        this(sourceId, source, originalId, originalSource, false);
    }

    public ConceptCoordinates(String sourceId, String source, boolean uniqueSourceId) {
        this(sourceId, source, null, null, uniqueSourceId);
    }

    public ConceptCoordinates(String id, String source, CoordinateType src) {
        switch (src) {
            case OSRC: {
                this.originalId = id;
                this.originalSource = source;
                break;
            }
            case SRC: {
                this.sourceId = id;
                this.source = source;
            }
        }
    }

    public ConceptCoordinates(ConceptCoordinates coordinates) {
        this.originalId = coordinates.originalId;
        this.originalSource = coordinates.originalSource;
        this.sourceId = coordinates.sourceId;
        this.source = coordinates.source;
        this.uniqueSourceId = coordinates.uniqueSourceId;
    }

    public String toString() {
        return "org(" + this.originalId + ", " + this.originalSource + ") / src(" + this.sourceId + ", " + this.source + ")";
    }

    public ConceptCoordinates clone() {
        return new ConceptCoordinates(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.originalId == null ? 0 : this.originalId.hashCode());
        result = 31 * result + (this.originalSource == null ? 0 : this.originalSource.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.sourceId == null ? 0 : this.sourceId.hashCode());
        result = 31 * result + (this.uniqueSourceId ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConceptCoordinates other = (ConceptCoordinates)obj;
        if (this.originalId == null ? other.originalId != null : !this.originalId.equals(other.originalId)) {
            return false;
        }
        if (this.originalSource == null ? other.originalSource != null : !this.originalSource.equals(other.originalSource)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.sourceId == null ? other.sourceId != null : !this.sourceId.equals(other.sourceId)) {
            return false;
        }
        return this.uniqueSourceId == other.uniqueSourceId;
    }
}

