/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.concepts;

import de.julielab.neo4j.plugins.auxiliaries.semedico.CoordinatesSet;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;

public class InsertionReport {
    public final Set<String> createdRelationshipsCache = new HashSet<String>();
    public final Set<Node> existingConcepts = new HashSet<Node>();
    public final Set<String> omittedConcepts = new HashSet<String>();
    public final CoordinatesSet importedCoordinates = new CoordinatesSet();
    public int numRelationships = 0;
    public int numConcepts = 0;

    public void addCreatedRelationship(Node source, Node target, RelationshipType type) {
        this.createdRelationshipsCache.add(this.getRelationshipIdentifier(source, target, type));
    }

    public void addExistingConcept(Node concept) {
        this.existingConcepts.add(concept);
    }

    private String getRelationshipIdentifier(Node source, Node target, RelationshipType type) {
        return source.getId() + type.name() + target.getId();
    }

    public boolean relationshipAlreadyWasCreated(Node source, Node target, RelationshipType type) {
        return this.createdRelationshipsCache.contains(this.getRelationshipIdentifier(source, target, type));
    }

    public void addImportedCoordinates(ConceptCoordinates coordinates) {
        this.importedCoordinates.add(coordinates);
    }

    public void merge(InsertionReport other) {
        this.numConcepts += other.numConcepts;
        this.numRelationships += other.numRelationships;
    }
}

