/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.concepts;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import de.julielab.neo4j.plugins.concepts.ConceptLookup;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.CoordinateType;
import de.julielab.neo4j.plugins.datarepresentation.ImportIERelation;
import de.julielab.neo4j.plugins.datarepresentation.ImportIERelationArgument;
import de.julielab.neo4j.plugins.datarepresentation.ImportIERelationDocument;
import de.julielab.neo4j.plugins.datarepresentation.ImportIETypedRelations;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.logging.Log;

public class IERelationInsertion {
    private static final int BATCH_SIZE = 500;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void insertRelations(InputStream ieRelationsStream, GraphDatabaseService graphDb, Log log) {
        ObjectMapper mapper = new ObjectMapper().registerModule(new Jdk8Module());
        try {
            JsonParser parser = new JsonFactory(mapper).createParser(ieRelationsStream);
            Iterator<ImportIERelationDocument> documents = null;
            String idProperty = null;
            String idSource = null;
            String lastName = null;
            while (parser.nextToken() != null && documents == null) {
                JsonToken currentToken = parser.currentToken();
                if (currentToken == JsonToken.FIELD_NAME) {
                    lastName = parser.getCurrentName();
                    continue;
                }
                if (currentToken == JsonToken.VALUE_STRING) {
                    if (lastName != null && lastName.equals("id_property")) {
                        idProperty = parser.readValueAs(String.class);
                        continue;
                    }
                    if (lastName == null || !lastName.equals("id_source")) continue;
                    idSource = parser.readValueAs(String.class);
                    continue;
                }
                if (lastName == null || !lastName.equals("documents") || currentToken != JsonToken.START_ARRAY) continue;
                documents = parser.readValuesAs(ImportIERelationDocument.class);
            }
            if (parser.currentToken() == JsonToken.END_ARRAY) {
                return;
            }
            if (documents == null) {
                throw new IllegalArgumentException("No documents were given.");
            }
            ArrayList<ImportIERelationDocument> docBatch = new ArrayList<ImportIERelationDocument>(500);
            int retries = 0;
            while (documents.hasNext() || !docBatch.isEmpty()) {
                if (docBatch.isEmpty()) {
                    while (documents.hasNext() && docBatch.size() < 500) {
                        docBatch.add(documents.next());
                    }
                }
                try {
                    Transaction tx = graphDb.beginTx();
                    try {
                        IERelationInsertion.insertRelations(tx, idProperty, idSource, docBatch.iterator(), log);
                        tx.commit();
                        docBatch.clear();
                        retries = 0;
                    }
                    finally {
                        if (tx == null) continue;
                        tx.close();
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof DeadlockDetectedException)) throw t;
                    if (retries >= 5) continue;
                    ++retries;
                    log.debug("Deadlock was detected. Waiting 3000ms and trying again.");
                    try {
                        Thread.sleep(3000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        log.error("Interrupted while sleeping for a deadlock to solve itself.", (Throwable)e);
                        throw t;
                    }
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void insertRelations(Transaction tx, String idProperty, String idSource, Iterator<ImportIERelationDocument> documents, Log log) {
        HashSet<IERelationKey> seenDocLevelKeys = new HashSet<IERelationKey>();
        while (documents.hasNext()) {
            ImportIERelationDocument document = documents.next();
            seenDocLevelKeys.clear();
            ImportIETypedRelations typedRelations = document.getRelations();
            if (typedRelations == null) {
                throw new IllegalArgumentException("Passed a document that does not have any relations.");
            }
            for (String relationType : typedRelations.keySet()) {
                for (ImportIERelation relation : (List)typedRelations.get(relationType)) {
                    IERelationInsertion.insertIERelation(tx, idProperty, idSource, document.getName(), relationType, relation, seenDocLevelKeys, document.isDb(), log);
                }
            }
        }
    }

    private static void insertIERelation(Transaction tx, String idProperty, String idSource, String documentName, String relationType, ImportIERelation relation, Set<IERelationKey> seenDocLevelKeys, boolean dbEntry, Log log) {
        for (int i = 0; i < relation.getArgs().size(); ++i) {
            for (int j = i + 1; j < relation.getArgs().size(); ++j) {
                ImportIERelationArgument argument1 = relation.getArgs().get(i);
                ImportIERelationArgument argument2 = relation.getArgs().get(j);
                Node arg1 = IERelationInsertion.findConceptNode(tx, idProperty, idSource, argument1, log);
                Node arg2 = IERelationInsertion.findConceptNode(tx, idProperty, idSource, argument2, log);
                IERelationKey relationKey = new IERelationKey(relationType, new IEArgumentKey(argument1), new IEArgumentKey(argument2));
                if (arg1 != null && arg2 != null) {
                    if (!dbEntry) {
                        IERelationInsertion.storeRelationTypeCount(tx, arg1, arg2, documentName, relationType, relation.getCount(), seenDocLevelKeys.contains(relationKey));
                    } else {
                        IERelationInsertion.storeDBRelation(tx, arg1, arg2, documentName, relationType, relation.getMethod());
                    }
                }
                seenDocLevelKeys.add(relationKey);
            }
        }
    }

    private static void storeDBRelation(Transaction tx, Node arg1, Node arg2, String databaseName, String relationType, String method) {
        Pair<Relationship, Boolean> relExistedPair = IERelationInsertion.getRelationship(tx, arg1, arg2, relationType);
        Relationship rel = relExistedPair.getLeft();
        if (rel.hasProperty("db_names")) {
            Object[] dbNames = (String[])rel.getProperty("db_names");
            int index = Arrays.binarySearch(dbNames, databaseName);
            if (index < 0) {
                int insertionPoint = -1 * (index + 1);
                String[] newDbNames = new String[dbNames.length + 1];
                newDbNames[insertionPoint] = databaseName;
                System.arraycopy(dbNames, 0, newDbNames, 0, insertionPoint);
                System.arraycopy(dbNames, insertionPoint, newDbNames, insertionPoint + 1, dbNames.length - insertionPoint);
                rel.setProperty("db_names", (Object)newDbNames);
                String[] methods = (String[])rel.getProperty("db_methods");
                String[] newMethods = new String[methods.length + 1];
                newMethods[insertionPoint] = method != null && !method.isBlank() ? method : "<unknown>";
                System.arraycopy(methods, 0, newMethods, 0, insertionPoint);
                System.arraycopy(methods, insertionPoint, newMethods, insertionPoint + 1, methods.length - insertionPoint);
                rel.setProperty("db_methods", (Object)newMethods);
            }
        } else {
            rel.setProperty("db_names", (Object)new String[]{databaseName});
            rel.setProperty("db_methods", (Object)new String[]{method});
        }
    }

    private static Pair<Relationship, Boolean> getRelationship(Transaction tx, Node arg1, Node arg2, String relationType) {
        Relationship rel;
        RelationshipType relType = RelationshipType.withName((String)relationType);
        Optional<Relationship> relOpt = StreamSupport.stream(arg1.getRelationships(Direction.BOTH, new RelationshipType[]{relType}).spliterator(), false).filter(r -> r.getOtherNode(arg1).equals(arg2)).findAny();
        if (!relOpt.isPresent()) {
            Lock arg1Lock = tx.acquireWriteLock((Entity)arg1);
            Lock arg2Lock = tx.acquireWriteLock((Entity)arg2);
            relOpt = StreamSupport.stream(arg1.getRelationships(Direction.BOTH, new RelationshipType[]{relType}).spliterator(), false).filter(r -> r.getOtherNode(arg1).equals(arg2)).findAny();
            rel = relOpt.orElseGet(() -> arg1.createRelationshipTo(arg2, relType));
            arg1Lock.release();
            arg2Lock.release();
        } else {
            rel = relOpt.get();
        }
        return new ImmutablePair<Relationship, Boolean>(rel, relOpt.isPresent());
    }

    private static void storeRelationTypeCount(Transaction tx, Node arg1, Node arg2, String docId, String relationType, int count, boolean relationAlreadySeen) {
        Pair<Relationship, Boolean> relExistedPair = IERelationInsertion.getRelationship(tx, arg1, arg2, relationType);
        Relationship rel = relExistedPair.getLeft();
        Lock relLock = tx.acquireWriteLock((Entity)rel);
        Object[] docIds = rel.hasProperty("doc_ids") ? (String[])rel.getProperty("doc_ids") : new String[]{};
        int index = Arrays.binarySearch(docIds, docId);
        int oldCount = 0;
        if (index >= 0) {
            int[] counts = (int[])rel.getProperty("counts");
            oldCount = counts[index];
            counts[index] = relationAlreadySeen ? oldCount + count : count;
            rel.setProperty("counts", (Object)counts);
        } else {
            int insertionPoint = -1 * (index + 1);
            String[] newDocIds = new String[docIds.length + 1];
            newDocIds[insertionPoint] = docId;
            System.arraycopy(docIds, 0, newDocIds, 0, insertionPoint);
            System.arraycopy(docIds, insertionPoint, newDocIds, insertionPoint + 1, docIds.length - insertionPoint);
            rel.setProperty("doc_ids", (Object)newDocIds);
            int[] counts = rel.hasProperty("counts") ? (int[])rel.getProperty("counts") : new int[]{};
            int[] newCounts = new int[counts.length + 1];
            newCounts[insertionPoint] = count;
            System.arraycopy(counts, 0, newCounts, 0, insertionPoint);
            System.arraycopy(counts, insertionPoint, newCounts, insertionPoint + 1, docIds.length - insertionPoint);
            rel.setProperty("counts", (Object)newCounts);
        }
        int totalCount = relExistedPair.getRight() != false ? (Integer)rel.getProperty("totalCount") : 0;
        totalCount = relationAlreadySeen ? totalCount + count : totalCount - oldCount + count;
        rel.setProperty("totalCount", (Object)totalCount);
        relLock.release();
    }

    private static Node findConceptNode(Transaction tx, String defaultIdProperty, String defaultIdSource, ImportIERelationArgument argument, Log log) {
        String source;
        Node concept = null;
        String idProperty = argument.hasIdProperty() ? argument.getIdProperty() : defaultIdProperty;
        boolean isId = "id".equals(idProperty);
        boolean isOrgId = "originalId".equals(idProperty);
        boolean isSrcId = "sourceIds".equals(idProperty);
        if (!(isId || isOrgId || isSrcId)) {
            if (defaultIdProperty == null) {
                throw new IllegalArgumentException("The argument " + argument + " does not specify an idProperty and there is no default property set.");
            }
            idProperty = defaultIdProperty;
            isId = "id".equals(idProperty);
            isOrgId = "originalId".equals(idProperty);
        }
        if (isId) {
            concept = tx.findNode((Label)ConceptLabel.CONCEPT, "id", (Object)argument.getId());
        }
        String string = source = argument.hasSource() ? argument.getSource() : defaultIdSource;
        if (concept == null && !isId) {
            concept = ConceptLookup.lookupConcept(tx, new ConceptCoordinates(argument.getId(), source, isOrgId ? CoordinateType.OSRC : CoordinateType.SRC));
        }
        if (concept == null) {
            log.debug("Could not find a concept with ID '%s' for idProperty '%s' and source '%s'.", new Object[]{argument.getId(), idProperty, source});
        }
        return concept;
    }

    private static class IEArgumentKey
    implements Comparable<IEArgumentKey> {
        private final String id;
        private final String idProperty;
        private final String source;

        public IEArgumentKey(ImportIERelationArgument arg) {
            this.id = arg.getId();
            this.idProperty = arg.getIdProperty();
            this.source = arg.getSource();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IEArgumentKey that = (IEArgumentKey)o;
            return this.id.equals(that.id) && Objects.equals(this.idProperty, that.idProperty) && Objects.equals(this.source, that.source);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.idProperty, this.source);
        }

        @Override
        public int compareTo(IEArgumentKey o) {
            int cprop;
            if (!o.getClass().equals(IEArgumentKey.class)) {
                throw new IllegalArgumentException("Wrong class to compare with " + IEArgumentKey.class + ": " + o.getClass());
            }
            int cid = o.id.compareTo(this.id);
            if (cid != 0) {
                return cid;
            }
            int n = cprop = o.idProperty == null || this.idProperty == null ? this.getNullComparison(o.idProperty, this.idProperty) : o.idProperty.compareTo(this.idProperty);
            if (cprop != 0) {
                return cprop;
            }
            return o.source == null || this.source == null ? this.getNullComparison(o.source, this.source) : o.source.compareTo(this.source);
        }

        public int getNullComparison(Object o1, Object o2) {
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            return 0;
        }
    }

    private static class IERelationKey {
        private final Set<IEArgumentKey> argKeys;
        private final String relType;

        public IERelationKey(String relationType, IEArgumentKey argkey1, IEArgumentKey argkey2) {
            this.relType = relationType;
            this.argKeys = Set.of(argkey1, argkey2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IERelationKey that = (IERelationKey)o;
            return this.argKeys.equals(that.argKeys) && this.relType.equals(that.relType);
        }

        public int hashCode() {
            return Objects.hash(this.argKeys, this.relType);
        }
    }
}

