/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.concepts;

import de.julielab.neo4j.plugins.FacetManager;
import de.julielab.neo4j.plugins.auxiliaries.semedico.PredefinedTraversals;
import de.julielab.neo4j.plugins.concepts.ConceptEdgeTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetRootsRetrieval {
    private static final Logger log = LoggerFactory.getLogger(FacetRootsRetrieval.class);

    public static Map<String, List<Node>> getFacetRoots(Transaction tx, Set<String> requestedFacetId, Map<String, Set<String>> requestedConceptIds, int maxRoots) {
        HashMap<String, List<Node>> facetRoots = new HashMap<String, List<Node>>();
        log.info("Returning roots for facets " + requestedFacetId);
        Node facetGroupsNode = FacetManager.getFacetGroupsNode(tx);
        TraversalDescription facetTraversal = PredefinedTraversals.getFacetTraversal(tx, null, null);
        Traverser traverse = facetTraversal.traverse(facetGroupsNode);
        for (Path path : traverse) {
            Node facetNode = path.endNode();
            String facetId = (String)facetNode.getProperty("id");
            if (maxRoots > 0 && facetNode.hasProperty("numRoots") && (Long)facetNode.getProperty("numRoots") > (long)maxRoots) {
                log.info("Skipping facet with ID {} because it has more than {} root concepts ({}).", facetId, maxRoots, facetNode.getProperty("numRoots"));
            }
            Set<String> requestedIdSet = null;
            if (null != requestedConceptIds) {
                requestedIdSet = requestedConceptIds.get(facetId);
            }
            if (!requestedFacetId.contains(facetId)) continue;
            ArrayList<Node> roots = new ArrayList<Node>();
            Iterable relationships = facetNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{ConceptEdgeTypes.HAS_ROOT_CONCEPT});
            for (Relationship rel : relationships) {
                String rootId;
                Node rootConcept = rel.getEndNode();
                boolean include = true;
                if (null != requestedIdSet && !requestedIdSet.contains(rootId = (String)rootConcept.getProperty("id"))) {
                    include = false;
                }
                if (!include) continue;
                roots.add(rootConcept);
            }
            if (!(roots.isEmpty() || maxRoots > 0 && roots.size() > maxRoots)) {
                facetRoots.put(facetId, roots);
                continue;
            }
            log.info("Skipping facet with ID " + facetId + " because it has more than " + maxRoots + " root concepts (" + roots.size() + ").");
        }
        return facetRoots;
    }
}

