/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.concepts;

import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptLookup {
    public static final String SYSPROP_ID_CACHE_ENABLED = "de.julielab.neo4j.plugins.conceptlookup.nodeidcache.enabled";
    public static final String NAME_SOURCE_IDS_SEQUENCE = "num_sourceids_sequence";
    private static final Logger log = LoggerFactory.getLogger(ConceptLookup.class);

    public static Node lookupConcept(Transaction tx, ConceptCoordinates coordinates) {
        String orgId = coordinates.originalId;
        String orgSource = coordinates.originalSource;
        String srcId = coordinates.sourceId;
        String source = coordinates.source;
        boolean uniqueSourceId = coordinates.uniqueSourceId;
        log.trace("Looking up concept via original ID and source ({}, {}) and source ID and source ({}, {}).", orgId, orgSource, srcId, source);
        if (!(null != orgId && null != orgSource || null != srcId && null != source)) {
            log.debug("Neither original ID and original source nor source ID and source were given, returning null.");
            return null;
        }
        Node concept = null;
        ResourceIterator concepts = null;
        if (orgId != null) {
            concepts = tx.findNodes((Label)ConceptLabel.CONCEPT, "originalId", (Object)orgId);
        }
        if (concepts != null && concepts.hasNext()) {
            log.trace("Found concept by original ID {}", (Object)orgId);
            while (concepts.hasNext()) {
                Node foundConcept = (Node)concepts.next();
                if (!PropertyUtilities.hasSamePropertyValue((Entity)foundConcept, "originalSource", orgSource)) {
                    log.trace("Original source doesn't match; requested: {}, found concept has: {}", (Object)orgSource, (Object)NodeUtilities.getString(foundConcept, "originalSource"));
                    continue;
                }
                log.trace("Found existing concept for original ID {} and original source {}", (Object)orgId, (Object)orgSource);
                concept = foundConcept;
                concepts.close();
                break;
            }
        }
        if (null == concept && null != srcId && null != (concept = ConceptLookup.lookupConceptBySourceId(tx, srcId, source, uniqueSourceId))) {
            Object existingOrgId = NodeUtilities.getNonNullNodeProperty((Entity)concept, "originalId");
            Object existingOrgSrc = NodeUtilities.getNonNullNodeProperty((Entity)concept, "originalSource");
            if (!(null == existingOrgId || null == existingOrgSrc || null == orgId || null == orgSource || existingOrgId.equals(orgId) && existingOrgSrc.equals(orgSource))) {
                throw new IllegalStateException(String.format("Inconsistent data: A newly imported concept has original ID, original source (%s, %s) and source ID, source (%s, %s); the latter matches the found concept with ID %s but a this concept has an original ID and source (%s, %s)", orgId, orgSource, srcId, source, NodeUtilities.getNonNullNodeProperty((Entity)concept, "id"), existingOrgId, existingOrgSrc));
            }
        }
        if (null == concept) {
            log.trace("    Did not find an existing concept with original ID and source ({}, {}) or source ID and source ({}, {}).", orgId, orgSource, srcId, source);
        }
        return concept;
    }

    public static Node lookupConceptBySourceId(Transaction tx, String srcId, String source, boolean uniqueSourceId) {
        log.trace("Trying to look up existing concept by source ID and source ({}, {})", (Object)srcId, (Object)source);
        ArrayList<Node> foundNodes = new ArrayList<Node>();
        int maxNumSourceIds = SequenceManager.getCurrentSequenceValue(tx, NAME_SOURCE_IDS_SEQUENCE);
        Node soughtConcept = null;
        for (int i = 0; i < maxNumSourceIds && soughtConcept == null; ++i) {
            ResourceIterator indexHits = tx.findNodes((Label)ConceptLabel.CONCEPT, "sourceIds" + i, (Object)srcId);
            try {
                if (!indexHits.hasNext()) {
                    log.trace("    Did not find any concept with source ID {}", (Object)srcId);
                    return null;
                }
            }
            catch (QueryExecutionException e) {
                log.error("Could not find index hits for sourceId {} due to error", (Object)srcId, (Object)e);
                throw e;
            }
            while (indexHits.hasNext()) {
                Node conceptNode = (Node)indexHits.next();
                foundNodes.add(conceptNode);
            }
            boolean uniqueSourceIdNodeFound = false;
            for (Node conceptNode : foundNodes) {
                Object[] sources;
                boolean uniqueOnConceptNode;
                if (null == conceptNode) continue;
                if (uniqueSourceId && (uniqueOnConceptNode = NodeUtilities.isSourceUnique(conceptNode, srcId, source))) {
                    if (soughtConcept == null) {
                        soughtConcept = conceptNode;
                    } else if (uniqueSourceIdNodeFound) {
                        throw new IllegalStateException("There are multiple concept nodes with unique source ID " + srcId + ". This means that some sources define the ID as unique and others not. This can lead to an inconsistent database as happened in this case.");
                    }
                    log.trace("    Found existing concept with unique source ID {} which matches given unique source ID", (Object)srcId);
                    uniqueSourceIdNodeFound = true;
                }
                if (Arrays.binarySearch(sources = NodeUtilities.getSourcesForSourceId(conceptNode, srcId), source) < 0) {
                    log.debug("    Did not find a match for source ID " + srcId + " and source " + source);
                    conceptNode = null;
                } else {
                    log.debug("    Found existing concept for source ID " + srcId + " and source " + source);
                }
                if (soughtConcept == null) {
                    soughtConcept = conceptNode;
                    continue;
                }
                if (uniqueSourceIdNodeFound) continue;
                throw new IllegalStateException("There are multiple concept nodes with source ID " + srcId + " and source " + source);
            }
        }
        return soughtConcept;
    }

    public static Stream<Node> lookupConceptsBySourceId(Transaction tx, String srcId) {
        int maxNumSourceIds = SequenceManager.getCurrentSequenceValue(tx, NAME_SOURCE_IDS_SEQUENCE);
        Stream<Node> s = Stream.empty();
        for (int i = 0; i < maxNumSourceIds; ++i) {
            String srcIdProp = "sourceIds" + i;
            s = Stream.concat(s, tx.findNodes((Label)ConceptLabel.CONCEPT, srcIdProp, (Object)srcId).stream());
        }
        return s;
    }

    public static Node lookupSingleConceptBySourceId(Transaction tx, String srcId) {
        List concepts = ConceptLookup.lookupConceptsBySourceId(tx, srcId).collect(Collectors.toList());
        if (concepts.size() > 1) {
            throw new IllegalStateException("Found multiple (" + concepts.size() + ") concepts with source ID '" + srcId + "'.");
        }
        return concepts.isEmpty() ? null : (Node)concepts.get(0);
    }
}

