/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.concepts;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.collect.Sets;
import de.julielab.neo4j.plugins.FacetManager;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.CoordinatesMap;
import de.julielab.neo4j.plugins.auxiliaries.semedico.CoordinatesSet;
import de.julielab.neo4j.plugins.auxiliaries.semedico.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.concepts.ConceptAggregateManager;
import de.julielab.neo4j.plugins.concepts.ConceptEdgeTypes;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import de.julielab.neo4j.plugins.concepts.ConceptLookup;
import de.julielab.neo4j.plugins.concepts.ConceptManager;
import de.julielab.neo4j.plugins.concepts.InsertionReport;
import de.julielab.neo4j.plugins.datarepresentation.AddToNonFacetGroupCommand;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcept;
import de.julielab.neo4j.plugins.datarepresentation.ImportConceptRelationship;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcepts;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacet;
import de.julielab.neo4j.plugins.datarepresentation.ImportMapping;
import de.julielab.neo4j.plugins.datarepresentation.ImportOptions;
import de.julielab.neo4j.plugins.datarepresentation.util.ConceptsJsonSerializer;
import de.julielab.neo4j.plugins.util.ConceptInsertionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.logging.slf4j.Slf4jLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptInsertion {
    private static final Logger log = LoggerFactory.getLogger(ConceptInsertion.class);

    static void createRelationships(Log log, Transaction tx, List<ImportConcept> jsonConcepts, String facetId, CoordinatesMap nodesByCoordinates, ImportOptions importOptions, InsertionReport insertionReport) {
        log.debug("Creating relationship between inserted concepts.");
        Node facet = FacetManager.getFacetNode(tx, facetId);
        RelationshipType relBroaderThanInFacet = null;
        if (null != facet) {
            relBroaderThanInFacet = RelationshipType.withName((String)(ConceptEdgeTypes.IS_BROADER_THAN.toString() + "_" + facetId));
        }
        AddToNonFacetGroupCommand noFacetCmd = importOptions.noFacetCmd;
        Node noFacet = null;
        for (ImportConcept jsonConcept : jsonConcepts) {
            if (jsonConcept.aggregate && !jsonConcept.aggregateIncludeInHierarchy) continue;
            ConceptCoordinates coordinates = jsonConcept.coordinates;
            String srcId = coordinates.sourceId;
            Node concept = nodesByCoordinates.get(new ConceptCoordinates(coordinates));
            if (null == concept && insertionReport.omittedConcepts.contains(srcId)) continue;
            if (null == concept) {
                throw new IllegalStateException("No node for source ID " + srcId + " was created but the respective concept is included into the data for import and it is unknown why no node instance was created.");
            }
            List<ConceptCoordinates> parentCoordinateList = jsonConcept.parentCoordinates;
            if (parentCoordinateList != null && !parentCoordinateList.isEmpty()) {
                for (ConceptCoordinates parentCoordinates : parentCoordinateList) {
                    String parentSrcId = parentCoordinates.sourceId;
                    if (importOptions.cutParents.contains(parentSrcId)) {
                        log.debug("Concept node " + coordinates + " has a parent that is marked to be cut away. Concept will be a facet root.");
                        ConceptInsertion.createRelationshipIfNotExists(facet, concept, ConceptEdgeTypes.HAS_ROOT_CONCEPT, insertionReport);
                        continue;
                    }
                    Node parent = nodesByCoordinates.get(parentCoordinates);
                    if (null == parent) {
                        throw new IllegalStateException("The parent node of concept " + coordinates + " should have been created in the insertConcepts method before, but it is null. The parent coordinates are " + parentCoordinates);
                    }
                    if (insertionReport.importedCoordinates.contains(parentCoordinates) || insertionReport.existingConcepts.contains(parent)) {
                        ConceptInsertion.createRelationshipIfNotExists(parent, concept, ConceptEdgeTypes.IS_BROADER_THAN, insertionReport);
                        ConceptInsertion.createRelationshipIfNotExists(parent, concept, relBroaderThanInFacet, insertionReport);
                    } else {
                        log.debug("Concept with source ID \"" + srcId + "\" referenced the concept with source ID \"" + parentSrcId + "\" as its parent. However, that parent node does not exist.");
                        if (!importOptions.doNotCreateHollowParents) {
                            log.debug("Creating hollow parents is switched on. The parent will be created with the label \"" + ConceptLabel.HOLLOW + "\" and be connected to the facet root.");
                            parent.addLabel((Label)ConceptLabel.CONCEPT);
                            ConceptInsertion.createRelationshipIfNotExists(parent, concept, ConceptEdgeTypes.IS_BROADER_THAN, insertionReport);
                            ConceptInsertion.createRelationshipIfNotExists(parent, concept, relBroaderThanInFacet, insertionReport);
                            ConceptInsertion.createRelationshipIfNotExists(facet, parent, ConceptEdgeTypes.HAS_ROOT_CONCEPT, insertionReport);
                        } else {
                            assert (facet != null);
                            log.warn("Creating hollow parents is switched off. Hence the concept will be added as root concept for its facet (\"" + facet.getProperty("name") + "\").");
                            ConceptInsertion.createRelationshipIfNotExists(facet, concept, ConceptEdgeTypes.HAS_ROOT_CONCEPT, insertionReport);
                        }
                    }
                    if (!parent.hasLabel((Label)ConceptLabel.AGGREGATE) || parent.hasLabel((Label)ConceptLabel.CONCEPT)) continue;
                    throw new IllegalArgumentException("Concept with source ID " + srcId + " specifies source ID " + parentSrcId + " as parent. This node is an aggregate but not a CONCEPT itself and thus is not included in the hierarchy and cannot be the conceptual parent of other concepts. To achieve this, import the aggregate with the property aggregateIncludeInHierarchy set to true or build the aggregates in a way that assignes the CONCEPT label to them. The parent is " + NodeUtilities.getNodePropertiesAsString((Entity)parent) + " and has the following labels: " + StreamSupport.stream(parent.getLabels().spliterator(), false).map(Label::name).collect(Collectors.joining(", ")));
                }
            } else if (noFacetCmd != null && noFacetCmd.getParentCriteria().contains((Object)AddToNonFacetGroupCommand.ParentCriterium.NO_PARENT)) {
                if (null == noFacet) {
                    assert (facet != null);
                    noFacet = FacetManager.getNoFacet(tx, (String)facet.getProperty("id"));
                }
                ConceptInsertion.createRelationshipIfNotExists(noFacet, concept, ConceptEdgeTypes.HAS_ROOT_CONCEPT, insertionReport);
            } else if (null != facet) {
                ConceptInsertion.createRelationshipIfNotExists(facet, concept, ConceptEdgeTypes.HAS_ROOT_CONCEPT, insertionReport);
            }
            if (jsonConcept.relationships == null) continue;
            for (ImportConceptRelationship jsonRelationship : jsonConcept.relationships) {
                String rsTypeStr = jsonRelationship.type;
                ConceptCoordinates targetCoordinates = jsonRelationship.targetCoordinates;
                Node target = ConceptLookup.lookupConcept(tx, targetCoordinates);
                if (null == target) {
                    log.debug("Creating hollow relationship target with orig Id/orig source " + targetCoordinates);
                    target = ConceptInsertion.registerNewHollowConceptNode(tx, targetCoordinates, new Label[0]);
                }
                ConceptEdgeTypes type = ConceptEdgeTypes.valueOf(rsTypeStr);
                Object[] properties = null;
                if (jsonRelationship.properties != null) {
                    Set<String> propNames = jsonRelationship.properties.keySet();
                    properties = new Object[propNames.size() * 2];
                    int k = 0;
                    for (String propName : propNames) {
                        Object propValue = jsonRelationship.properties.get(propName);
                        properties[2 * k] = propName;
                        properties[2 * k + 1] = propValue;
                        ++k;
                    }
                }
                ConceptInsertion.createRelationShipIfNotExists(concept, target, type, insertionReport, Direction.OUTGOING, properties);
                ++insertionReport.numRelationships;
            }
        }
        log.debug("Finished 100% of concepts for relationship creation.");
    }

    static Node registerNewHollowConceptNode(Transaction tx, ConceptCoordinates coordinates, Label ... additionalLabels) {
        Node node = tx.createNode(new Label[]{ConceptLabel.HOLLOW});
        node.addLabel((Label)ConceptLabel.CONCEPT);
        for (Label label : additionalLabels) {
            node.addLabel(label);
        }
        log.trace("Created new HOLLOW concept node for coordinates {}", (Object)coordinates);
        if (!StringUtils.isBlank((String)coordinates.originalId)) {
            node.setProperty("originalId", (Object)coordinates.originalId);
            node.setProperty("originalSource", (Object)coordinates.originalSource);
        }
        NodeUtilities.mergeSourceId(tx, node, coordinates.sourceId, coordinates.source, coordinates.uniqueSourceId);
        return node;
    }

    static void insertConcept(Transaction tx, String facetId, ImportConcept jsonConcept, CoordinatesMap nodesByCoordinates, InsertionReport insertionReport, ImportOptions importOptions) {
        String prefName = jsonConcept.prefName;
        List<String> synonyms = jsonConcept.synonyms;
        List<String> generalLabels = jsonConcept.generalLabels;
        ConceptCoordinates coordinates = jsonConcept.coordinates;
        if (coordinates == null) {
            throw new IllegalArgumentException("The concept " + jsonConcept + " does not specify coordinates.");
        }
        if (!importOptions.merge && coordinates.sourceId == null) {
            throw new IllegalArgumentException("The concept " + jsonConcept + " does not specify a source ID.");
        }
        String srcId = coordinates.sourceId;
        String orgId = coordinates.originalId;
        String source = coordinates.source;
        String orgSource = coordinates.originalSource;
        boolean uniqueSourceId = coordinates.uniqueSourceId;
        boolean srcIduniqueMarkerChanged = false;
        if (StringUtils.isBlank((String)srcId) && !StringUtils.isBlank((String)orgId) && (StringUtils.isBlank((String)source) && !StringUtils.isBlank((String)orgSource) || source.equals(orgSource))) {
            srcId = orgId;
            source = orgSource;
        }
        if (StringUtils.isBlank((String)source)) {
            source = "<unknown>";
        }
        if (StringUtils.isBlank((String)orgId) ^ StringUtils.isBlank((String)orgSource)) {
            throw new IllegalArgumentException("Concept to be inserted defines only its original ID or its original source but not both. This is not allowed. The concept data was: " + jsonConcept);
        }
        if (importOptions.merge && jsonConcept.parentCoordinates != null && !jsonConcept.parentCoordinates.isEmpty()) {
            throw new IllegalArgumentException("Concept " + jsonConcept + " is supposed to be merged with an existing database concept but defines parents. This is currently not supported in merging mode.");
        }
        Node concept = nodesByCoordinates.get(coordinates);
        if (concept == null && !importOptions.merge) {
            throw new IllegalStateException("No concept node was found or created for import concept with coordinates " + coordinates + " and this is not a merging operation.");
        }
        if (concept == null) {
            return;
        }
        if (concept.hasLabel((Label)ConceptLabel.HOLLOW)) {
            log.trace("Got HOLLOW concept node with coordinates " + coordinates + " and will create full concept.");
            concept.removeLabel((Label)ConceptLabel.HOLLOW);
            concept.addLabel((Label)ConceptLabel.CONCEPT);
            Iterable relationships = concept.getRelationships(new RelationshipType[]{ConceptEdgeTypes.HAS_ROOT_CONCEPT});
            for (Relationship rel : relationships) {
                Node startNode = rel.getStartNode();
                if (!startNode.hasLabel((Label)FacetManager.FacetLabel.FACET)) continue;
                rel.delete();
            }
            String conceptId = "tid" + SequenceManager.getNextSequenceValue(tx, "seqTerm");
            concept.setProperty("id", (Object)conceptId);
        }
        if (!StringUtils.isBlank((String)coordinates.originalId) && !concept.hasProperty("originalId")) {
            concept.setProperty("originalId", (Object)coordinates.originalId);
            concept.setProperty("originalSource", (Object)coordinates.originalSource);
        }
        PropertyUtilities.setNonNullNodeProperty((Entity)concept, "preferredName", jsonConcept.prefName);
        PropertyUtilities.mergeArrayProperty((Entity)concept, "descriptions", () -> jsonConcept.descriptions.toArray(new String[0]));
        PropertyUtilities.mergeArrayProperty((Entity)concept, "writingVariants", () -> jsonConcept.writingVariants.toArray(new String[0]));
        PropertyUtilities.mergeArrayProperty((Entity)concept, "copyProperties", () -> jsonConcept.copyProperties.toArray(new String[0]));
        PropertyUtilities.mergeArrayProperty((Entity)concept, "synonyms", synonyms.stream().filter(s -> !s.equals(prefName)).toArray());
        PropertyUtilities.addToArrayProperty((Entity)concept, "facets", facetId);
        NodeUtilities.mergeSourceId(tx, concept, srcId, source, uniqueSourceId);
        for (int i = 0; null != generalLabels && i < generalLabels.size(); ++i) {
            concept.addLabel(Label.label((String)generalLabels.get(i)));
        }
        if (StringUtils.isBlank((String)prefName) && !insertionReport.existingConcepts.contains(concept)) {
            throw new IllegalArgumentException("Concept has no property \"preferredName\": " + jsonConcept);
        }
    }

    private static Relationship createRelationShipIfNotExists(Node source, Node target, RelationshipType type, InsertionReport insertionReport, Direction direction, Object ... properties) {
        if (null != properties && properties.length % 2 != 0) {
            throw new IllegalArgumentException("Property list must contain of key/value pairs but its length was odd.");
        }
        boolean relationShipExists = false;
        Relationship createdRelationship = null;
        if (insertionReport.relationshipAlreadyWasCreated(source, target, type)) {
            relationShipExists = true;
        } else if (insertionReport.existingConcepts.contains(source) && insertionReport.existingConcepts.contains(target)) {
            Iterable relationships = source.getRelationships(direction, new RelationshipType[]{type});
            for (Relationship relationship : relationships) {
                if (!relationship.getEndNode().equals(target)) continue;
                relationShipExists = PropertyUtilities.mergeProperties((Entity)relationship, properties);
            }
        }
        if (!relationShipExists) {
            createdRelationship = source.createRelationshipTo(target, type);
            for (int i = 0; null != properties && i < properties.length; i += 2) {
                String key = (String)properties[i];
                Object value = properties[i + 1];
                createdRelationship.setProperty(key, value);
            }
            insertionReport.addCreatedRelationship(source, target, type);
            ++insertionReport.numRelationships;
        }
        return createdRelationship;
    }

    private static void createRelationshipIfNotExists(Node source, Node target, RelationshipType type, InsertionReport insertionReport) {
        ConceptInsertion.createRelationShipIfNotExists(source, target, type, insertionReport, Direction.OUTGOING, new Object[0]);
    }

    public static void insertConcepts(GraphDatabaseService graphDb, ImportConcepts importConcepts, Map<String, Object> response) throws ConceptInsertionException {
        ConceptInsertion.insertConcepts((Log)new Slf4jLog(log), graphDb, new ByteArrayInputStream(ConceptsJsonSerializer.toJson(importConcepts).getBytes(StandardCharsets.UTF_8)), response);
    }

    public static InsertionReport insertConcepts(Log log, GraphDatabaseService graphDb, InputStream importConceptsStream, Map<String, Object> response) throws ConceptInsertionException {
        long time = System.currentTimeMillis();
        ObjectMapper mapper = new ObjectMapper().registerModule(new Jdk8Module());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        InsertionReport insertionReport = new InsertionReport();
        long numConcepts = -1L;
        log.debug("Parsing JSON stream. This is right before the synchronization block of the concept insertion process.");
        Class<ConceptManager> clazz = ConceptManager.class;
        synchronized (ConceptManager.class) {
            try {
                JsonParser parser = new JsonFactory(mapper).createParser(importConceptsStream);
                ImportFacet importFacet = null;
                ImportOptions importOptions = new ImportOptions();
                Iterator<ImportConcept> importConcepts = null;
                String lastName = null;
                while (parser.nextToken() != null && importConcepts == null) {
                    JsonToken currentToken = parser.currentToken();
                    if (currentToken == JsonToken.FIELD_NAME) {
                        lastName = parser.getCurrentName();
                        continue;
                    }
                    if (currentToken == JsonToken.START_OBJECT) {
                        if (lastName != null && lastName.equals("facet")) {
                            importFacet = parser.readValueAs(ImportFacet.class);
                            continue;
                        }
                        if (lastName != null && lastName.equals("importOptions")) {
                            importOptions = parser.readValueAs(ImportOptions.class);
                            continue;
                        }
                        if (lastName == null || !lastName.equals("name_num_concepts")) continue;
                        numConcepts = parser.readValueAs(Long.class);
                        continue;
                    }
                    if (lastName == null || !lastName.equals("concepts") || currentToken != JsonToken.START_ARRAY) continue;
                    importConcepts = parser.readValuesAs(ImportConcept.class);
                }
                log.info("Got %s concepts to import into facet %s with options %s.", new Object[]{numConcepts, importFacet, importOptions});
                String facetId = null;
                try (Transaction tx = graphDb.beginTx();){
                    Node facet = null;
                    log.debug("Handling import of facet.");
                    if (null != importFacet && importFacet.getId() != null) {
                        facetId = importFacet.getId();
                        log.info("Facet ID {} has been given to add the concepts to.", new Object[]{facetId});
                        boolean isNoFacet = importFacet.isNoFacet();
                        facet = isNoFacet ? FacetManager.getNoFacet(tx, facetId) : FacetManager.getFacetNode(tx, facetId);
                        if (null == facet) {
                            throw new IllegalArgumentException("The facet with ID \"" + facetId + "\" was not found. You must pass the ID of an existing facet or deliver all information required to create the facet from scratch. Then, the facetId must not be included in the request, it will be created dynamically.");
                        }
                    } else if (null != importFacet && importFacet.getName() != null) {
                        ResourceIterator facetIterator = tx.findNodes((Label)FacetManager.FacetLabel.FACET);
                        while (facetIterator.hasNext() && !(facet = (Node)facetIterator.next()).getProperty("name").equals(importFacet.getName())) {
                            facet = null;
                        }
                    }
                    if (null != importFacet && null == facet) {
                        facet = FacetManager.createFacet(tx, importFacet);
                    }
                    if (null != facet) {
                        facetId = (String)facet.getProperty("id");
                        log.debug("Facet {} was successfully created or determined by ID.", new Object[]{facetId});
                    } else {
                        log.debug("No facet was specified for this import. This is currently equivalent to specifying the merge import option, i.e. concept properties will be merged but no new nodes or relationships will be created.");
                        importOptions.merge = true;
                    }
                    tx.commit();
                }
                if (null != importConcepts) {
                    int batchsize = 10000;
                    log.debug("Beginning to create concept nodes and relationships.");
                    ArrayList<ImportConcept> buffer = new ArrayList<ImportConcept>(batchsize);
                    long imported = 0L;
                    while (importConcepts.hasNext()) {
                        InsertionReport bufferInsertionReport;
                        while (importConcepts.hasNext() && buffer.size() < batchsize) {
                            buffer.add(importConcepts.next());
                        }
                        log.debug("Importing a batch of %s concepts", new Object[]{batchsize});
                        try (Transaction tx = graphDb.beginTx();){
                            CoordinatesMap nodesByCoordinates = new CoordinatesMap();
                            bufferInsertionReport = ConceptInsertion.insertConcepts(tx, buffer, facetId, nodesByCoordinates, importOptions, log);
                            if (!nodesByCoordinates.isEmpty() && !importOptions.merge) {
                                log.debug("Beginning to create relationships between the imported concepts.");
                                ConceptInsertion.createRelationships(log, tx, buffer, facetId, nodesByCoordinates, importOptions, bufferInsertionReport);
                            } else {
                                log.debug("This is a property merging import, no relationships are created.");
                            }
                            insertionReport.merge(bufferInsertionReport);
                            buffer.clear();
                            tx.commit();
                        }
                        log.debug("Imported %s concepts", new Object[]{imported += (long)bufferInsertionReport.numConcepts});
                    }
                    response.put("numCreatedConcepts", insertionReport.numConcepts);
                    response.put("numCreatedRelationships", insertionReport.numRelationships);
                    log.info("Done creating %s concepts and %s relationships.", new Object[]{insertionReport.numConcepts, insertionReport.numRelationships});
                } else {
                    log.info("No concepts were included in the request.");
                }
                time = System.currentTimeMillis() - time;
                response.put("time", time);
                response.put("facetId", facetId);
                // ** MonitorExit[var11_8] (shouldn't be in output)
                return insertionReport;
            }
            catch (IOException e) {
                throw new ConceptInsertionException(e);
            }
        }
    }

    private static InsertionReport insertConcepts(Transaction tx, List<ImportConcept> concepts, String facetId, CoordinatesMap nodesByCoordinates, ImportOptions importOptions, Log log) throws ConceptInsertionException {
        long time = System.currentTimeMillis();
        InsertionReport insertionReport = new InsertionReport();
        CoordinatesSet toBeCreated = new CoordinatesSet();
        if (!importOptions.merge) {
            for (ImportConcept jsonConcept : concepts) {
                if (jsonConcept.parentCoordinates == null) continue;
                for (ConceptCoordinates parentCoordinates : jsonConcept.parentCoordinates) {
                    Node parentNode = ConceptLookup.lookupConcept(tx, parentCoordinates);
                    if (parentNode != null) {
                        insertionReport.addExistingConcept(parentNode);
                        nodesByCoordinates.put(parentCoordinates, parentNode);
                        continue;
                    }
                    toBeCreated.add(parentCoordinates);
                }
            }
        }
        ArrayList<Integer> importConceptsToRemove = new ArrayList<Integer>();
        for (int i = 0; i < concepts.size(); ++i) {
            ImportConcept jsonConcept = concepts.get(i);
            if (jsonConcept.coordinates == null) {
                if (jsonConcept.aggregate) continue;
                throw new IllegalArgumentException("Concept " + jsonConcept + " does not define concept coordinates.");
            }
            ConceptCoordinates coordinates = jsonConcept.coordinates;
            insertionReport.addImportedCoordinates(coordinates);
            if (nodesByCoordinates.containsKey(coordinates) || toBeCreated.contains(coordinates, true)) continue;
            Node conceptNode = ConceptLookup.lookupConcept(tx, coordinates);
            if (conceptNode != null) {
                insertionReport.addExistingConcept(conceptNode);
                nodesByCoordinates.put(coordinates, conceptNode);
                continue;
            }
            if (!importOptions.merge) {
                toBeCreated.add(coordinates);
                continue;
            }
            importConceptsToRemove.add(i);
        }
        for (ConceptCoordinates coordinates : toBeCreated) {
            Node conceptNode = ConceptInsertion.registerNewHollowConceptNode(tx, coordinates, new Label[0]);
            ++insertionReport.numConcepts;
            nodesByCoordinates.put(coordinates, conceptNode);
        }
        if (!importConceptsToRemove.isEmpty()) {
            log.info("removing " + importConceptsToRemove.size() + " input concepts that should be omitted because we are merging and don't have them in the database");
        }
        for (int index = importConceptsToRemove.size() - 1; index >= 0; --index) {
            concepts.remove((Integer)importConceptsToRemove.get(index));
        }
        log.info("Starting to insert " + concepts.size() + " concepts.");
        for (ImportConcept jsonConcept : concepts) {
            boolean isAggregate = jsonConcept.aggregate;
            if (isAggregate) {
                ConceptAggregateManager.insertAggregateConcept(tx, jsonConcept, nodesByCoordinates, insertionReport, importOptions, log);
                continue;
            }
            ConceptInsertion.insertConcept(tx, facetId, jsonConcept, nodesByCoordinates, insertionReport, importOptions);
        }
        log.debug(concepts.size() + " concepts inserted.");
        time = System.currentTimeMillis() - time;
        log.info(insertionReport.numConcepts + " new concepts - but not yet relationships - have been inserted. This took " + time + " ms (" + time / 1000L + " s)");
        return insertionReport;
    }

    private static boolean checkUniqueIdMarkerClash(Node conceptNode, String srcId, String source, boolean uniqueSourceId) {
        boolean uniqueOnConcept = NodeUtilities.isSourceUnique(conceptNode, srcId, source);
        return !uniqueOnConcept && uniqueOnConcept != uniqueSourceId;
    }

    public static int insertMappings(Transaction tx, Iterator<ImportMapping> mappings) {
        HashMap<String, Node> nodesBySrcId = new HashMap<String, Node>();
        InsertionReport insertionReport = new InsertionReport();
        int count = 0;
        for (ImportMapping mapping : () -> mappings) {
            Node n2;
            ++count;
            String id1 = mapping.id1;
            String id2 = mapping.id2;
            String mappingType = mapping.mappingType;
            log.debug("Inserting mapping " + id1 + " -" + mappingType + "- " + id2);
            if (StringUtils.isBlank((String)id1)) {
                throw new IllegalArgumentException("id1 in mapping \"" + mapping + "\" is missing.");
            }
            if (StringUtils.isBlank((String)id2)) {
                throw new IllegalArgumentException("id2 in mapping \"" + mapping + "\" is missing.");
            }
            if (StringUtils.isBlank((String)mappingType)) {
                throw new IllegalArgumentException("mappingType in mapping \"" + mapping + "\" is missing.");
            }
            Node n1 = (Node)nodesBySrcId.get(id1);
            if (null == n1) {
                Iterator indexHits = ConceptLookup.lookupConceptsBySourceId(tx, id1).iterator();
                if (indexHits.hasNext()) {
                    n1 = (Node)indexHits.next();
                }
                if (indexHits.hasNext()) {
                    log.error("More than one node for source ID {}", (Object)id1);
                    while (indexHits.hasNext()) {
                        log.error(NodeUtilities.getNodePropertiesAsString((Entity)indexHits.next()));
                    }
                    throw new IllegalStateException("More than one node for source ID " + id1);
                }
                if (null == n1) {
                    log.warn("There is no concept with source ID \"" + id1 + "\" as required by the mapping \"" + mapping + "\" Mapping is skipped.");
                    continue;
                }
                nodesBySrcId.put(id1, n1);
            }
            if (null == (n2 = (Node)nodesBySrcId.get(id2))) {
                n2 = ConceptLookup.lookupSingleConceptBySourceId(tx, id2);
                if (null == n2) {
                    log.warn("There is no concept with source ID \"" + id2 + "\" as required by the mapping \"" + mapping + "\" Mapping is skipped.");
                    continue;
                }
                nodesBySrcId.put(id2, n2);
            }
            if (mappingType.equalsIgnoreCase("LOOM")) {
                String[] n1Facets = (String[])n1.getProperty("facets");
                String[] n2Facets = (String[])n2.getProperty("facets");
                HashSet n2FacetSet = new HashSet();
                HashSet<String> n1FacetSet = new HashSet<String>(Arrays.asList(n1Facets));
                Collections.addAll(n2FacetSet, n2Facets);
                if (!Sets.intersection(n1FacetSet, n2FacetSet).isEmpty()) {
                    log.debug("Omitting LOOM mapping between " + id1 + " and " + id2 + " because both concepts appear in the same terminology. We assume that the conceptinology does not have two equal concepts and that LOOM is wrong here.");
                    continue;
                }
            }
            insertionReport.addExistingConcept(n1);
            insertionReport.addExistingConcept(n2);
            ConceptInsertion.createRelationShipIfNotExists(n1, n2, ConceptEdgeTypes.IS_MAPPED_TO, insertionReport, Direction.BOTH, "mappingType", new String[]{mappingType});
        }
        tx.commit();
        log.info("{} of {} new mappings successfully added.", (Object)insertionReport.numRelationships, (Object)count);
        return insertionReport.numRelationships;
    }
}

