/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import com.ibm.icu.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.Node;

public class TermNameAndSynonymComparator
implements Comparator<Node> {
    private final RuleBasedCollator collator = TermNameAndSynonymComparator.createComparisonCollator();

    @Override
    public int compare(Node o1, Node o2) {
        Object o2Name;
        Object o1Name = o1.getProperty("preferredName");
        int prefLabelComp = this.collator.compare(o1Name, o2Name = o2.getProperty("preferredName"));
        if (prefLabelComp != 0) {
            return prefLabelComp;
        }
        String o1Syns = this.getSortedAndNormalizedSynonyms(o1);
        String o2Syns = this.getSortedAndNormalizedSynonyms(o2);
        return o1Syns != null && o2Syns != null ? o1Syns.compareTo(o2Syns) : prefLabelComp;
    }

    private String getSortedAndNormalizedSynonyms(Node n) {
        if (n.hasProperty("synonyms")) {
            String[] synonyms = (String[])n.getProperty("synonyms");
            List<String> synonymsList = Arrays.asList(synonyms);
            Collections.sort(synonymsList);
            return StringUtils.join(synonymsList, (String)"");
        }
        return null;
    }

    private static RuleBasedCollator createComparisonCollator() {
        try {
            RuleBasedCollator collator = new RuleBasedCollator("");
            collator.setStrength(0);
            collator.freeze();
            return collator;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

