/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import de.julielab.neo4j.plugins.FacetManager;
import de.julielab.neo4j.plugins.concepts.ConceptEdgeTypes;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import de.julielab.neo4j.plugins.concepts.MorphoLabel;
import de.julielab.neo4j.plugins.evaluators.FacetGroupPathEvaluator;
import de.julielab.neo4j.plugins.evaluators.HasRelationShipEvaluator;
import de.julielab.neo4j.plugins.evaluators.NodeLabelEvaluator;
import de.julielab.neo4j.plugins.evaluators.PropertyEvaluator;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;

public class PredefinedTraversals {
    public static TraversalDescription getFacetTraversal(Transaction tx) {
        return PredefinedTraversals.getFacetTraversal(tx, null, null);
    }

    public static TraversalDescription getFacetTraversal(Transaction tx, String propertyKey, Object propertyValue) {
        if (StringUtils.isBlank((String)propertyKey)) {
            propertyKey = "*";
        }
        if (null == propertyValue || "".equals(propertyValue)) {
            propertyValue = "*";
        }
        TraversalDescription td = tx.traversalDescription().depthFirst().relationships((RelationshipType)FacetManager.EdgeTypes.HAS_FACET_GROUP).relationships((RelationshipType)FacetManager.EdgeTypes.HAS_FACET).evaluator(Evaluators.atDepth((int)2));
        if (!"*".equals(propertyKey) || !"*".equals(propertyValue)) {
            td = td.evaluator((Evaluator)new PropertyEvaluator(propertyKey, propertyValue));
        }
        return td;
    }

    public static TraversalDescription getFacetGroupTraversal(Transaction tx, String facetGroupName) {
        return tx.traversalDescription().depthFirst().relationships((RelationshipType)FacetManager.EdgeTypes.HAS_FACET_GROUP).evaluator((Evaluator)new FacetGroupPathEvaluator(facetGroupName));
    }

    public static TraversalDescription getAcronymsTraversal(Transaction tx) {
        return tx.traversalDescription().depthFirst().relationships((RelationshipType)ConceptEdgeTypes.HAS_ACRONYMS, Direction.OUTGOING).relationships((RelationshipType)ConceptEdgeTypes.HAS_ELEMENT, Direction.OUTGOING).evaluator((Evaluator)new NodeLabelEvaluator(MorphoLabel.ACRONYM));
    }

    public static TraversalDescription getWritingVariantsTraversal(Transaction tx) {
        return tx.traversalDescription().depthFirst().relationships((RelationshipType)ConceptEdgeTypes.HAS_VARIANTS, Direction.OUTGOING).relationships((RelationshipType)ConceptEdgeTypes.HAS_ELEMENT, Direction.OUTGOING).evaluator((Evaluator)new NodeLabelEvaluator(MorphoLabel.WRITING_VARIANT));
    }

    public static TraversalDescription getNonAggregateAggregateElements(Transaction tx) {
        return tx.traversalDescription().depthFirst().relationships((RelationshipType)ConceptEdgeTypes.HAS_ELEMENT).evaluator((Evaluator)new NodeLabelEvaluator(ConceptLabel.AGGREGATE, true));
    }

    public static TraversalDescription getTopAggregates(Transaction tx) {
        return tx.traversalDescription().breadthFirst().relationships((RelationshipType)ConceptEdgeTypes.HAS_ELEMENT).evaluator((Evaluator)new HasRelationShipEvaluator(Direction.INCOMING, new RelationshipType[]{ConceptEdgeTypes.HAS_ELEMENT}, false));
    }
}

