/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.julielab.neo4j.plugins.Indexes;
import de.julielab.neo4j.plugins.auxiliaries.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.PredefinedTraversals;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.concepts.ConceptEdgeTypes;
import de.julielab.neo4j.plugins.concepts.ConceptLabel;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacet;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacetGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.RecursiveMappingRepresentation;
import org.neo4j.server.rest.repr.Representation;

@javax.ws.rs.Path(value="/facet_manager")
public class FacetManager {
    public static final String KEY_FACETS = "facets";
    public static final String KEY_ID = "id";
    public static final String GET_FACETS = "get_facets";
    public static final String INSERT_FACETS = "insert_facets";
    public static final String GET_FACET_SIZE = "get_facet_size";
    public static final String PARAM_RETURN_HOLLOW_FACETS = "returnHollowFacets";
    private static final Logger log = Logger.getLogger(FacetManager.class.getName());
    private final DatabaseManagementService dbms;

    public FacetManager(@Context DatabaseManagementService dbms) {
        this.dbms = dbms;
    }

    public static Node createFacet(Transaction tx, ImportFacet jsonFacet) {
        log.info("Creating facet with the following data: " + jsonFacet);
        Collection<String> generalLabels = jsonFacet.getLabels();
        boolean isNoFacet = jsonFacet.isNoFacet();
        ImportFacetGroup jsonFacetGroup = jsonFacet.getFacetGroup();
        Node facetGroupsNode = isNoFacet ? FacetManager.getNoFacetGroupsNode(tx) : FacetManager.getFacetGroupsNode(tx);
        Node facetGroup = FacetManager.createFacetGroup(tx, facetGroupsNode, jsonFacetGroup);
        Node facet = tx.createNode(new Label[]{FacetLabel.FACET});
        PropertyUtilities.setNonNullNodeProperty((Entity)facet, "name", jsonFacet.getName());
        PropertyUtilities.setNonNullNodeProperty((Entity)facet, "shortName", jsonFacet.getShortName());
        PropertyUtilities.setNonNullNodeProperty((Entity)facet, "customId", jsonFacet.getCustomId());
        PropertyUtilities.setNonNullNodeProperty((Entity)facet, "labels", () -> jsonFacet.getLabels().toArray(new String[0]));
        PropertyUtilities.setNonNullNodeProperty((Entity)facet, "sourceType", jsonFacet.getSourceType());
        String facetId = "fid" + SequenceManager.getNextSequenceValue(tx, "seqFacet");
        facet.setProperty(KEY_ID, (Object)facetId);
        facetGroup.createRelationshipTo(facet, (RelationshipType)EdgeTypes.HAS_FACET);
        if (null != generalLabels) {
            for (String labelString : generalLabels) {
                Label label = Label.label((String)labelString);
                facet.addLabel(label);
            }
        }
        return facet;
    }

    private static int countFacetChildren(GraphDatabaseService graphDb, String fid) {
        int childCount = -1;
        try (Transaction tx = graphDb.beginTx();){
            RelationshipType dynRel = RelationshipType.withName((String)("IS_BROADER_THAN_" + fid));
            Node node = FacetManager.getFacetNode(tx, fid);
            Traverser traverser = tx.traversalDescription().breadthFirst().uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL).relationships((RelationshipType)ConceptEdgeTypes.HAS_ROOT_CONCEPT, Direction.OUTGOING).relationships(dynRel, Direction.OUTGOING).traverse(node);
            for (Node n : traverser.nodes()) {
                ++childCount;
            }
        }
        return childCount;
    }

    private static Node getFacetGroup(Transaction tx, Node facetGroupsNode, String facetGroupName) {
        TraversalDescription td = PredefinedTraversals.getFacetGroupTraversal(tx, facetGroupName);
        Traverser traverse = td.traverse(facetGroupsNode);
        TraversalMetadata metadata = traverse.metadata();
        if (metadata != null && metadata.getNumberOfPathsReturned() > 1) {
            throw new IllegalStateException("There is more than one path from the reference node to the facet group node with name '" + facetGroupName + "'.");
        }
        Iterator pathIterator = traverse.iterator();
        Node facetGroupNode = null;
        while (pathIterator.hasNext()) {
            Path path = (Path)pathIterator.next();
            if (path.length() != 1) continue;
            facetGroupNode = path.endNode();
        }
        return facetGroupNode;
    }

    private static Node createFacetGroup(Transaction tx, Node facetGroupsNode, ImportFacetGroup jsonFacetGroup) {
        List<String> labels;
        String facetGroupName = jsonFacetGroup.name;
        Node facetGroupNode = FacetManager.getFacetGroup(tx, facetGroupsNode, facetGroupName);
        if (null == facetGroupNode) {
            log.log(Level.FINE, "Facet group \"" + facetGroupName + "\" (ID: " + facetGroupName + ") does not exist and is created.");
            facetGroupNode = tx.createNode();
            PropertyUtilities.copyObjectToEntity((Object)jsonFacetGroup, (Entity)facetGroupNode, "labels");
            int nextSequenceValue = SequenceManager.getNextSequenceValue(tx, "seqFacetGroup");
            facetGroupNode.setProperty(KEY_ID, (Object)("fgid" + nextSequenceValue));
            facetGroupsNode.createRelationshipTo(facetGroupNode, (RelationshipType)EdgeTypes.HAS_FACET_GROUP);
        }
        if (null != (labels = jsonFacetGroup.labels)) {
            for (String labelString : labels) {
                Label label = Label.label((String)labelString);
                facetGroupNode.addLabel(label);
            }
        }
        if (null == facetGroupNode.getProperty("position")) {
            throw new IllegalArgumentException("The facet group \"" + facetGroupName + "\" does not have the required property \"position\". It must either be passed with the inserted facets or already exist.");
        }
        return facetGroupNode;
    }

    public static Node getFacetGroupsNode(Transaction tx) {
        return FacetManager.getGroupsNode(tx, FacetLabel.FACET_GROUPS, "facetGroups");
    }

    public static Node getNoFacetGroupsNode(Transaction tx) {
        return FacetManager.getGroupsNode(tx, FacetLabel.NO_FACET_GROUPS, "noFacet-Groups");
    }

    public static Node getGroupsNode(Transaction tx, Label label, String name) {
        Node facetGroupsNode = tx.findNode(label, "name", (Object)name);
        if (null == facetGroupsNode) {
            try {
                facetGroupsNode = tx.createNode(new Label[]{label});
                facetGroupsNode.setProperty("name", (Object)name);
            }
            catch (ConstraintViolationException e) {
                facetGroupsNode.delete();
                facetGroupsNode = tx.findNode(label, "name", (Object)name);
            }
        }
        return facetGroupsNode;
    }

    public static void createIndexes(Transaction tx) {
        Indexes.createSinglePropertyIndexIfAbsent(tx, "NoFacetIds", FacetLabel.FACET_GROUPS, true, "native-btree-1.0", "name");
        Indexes.createSinglePropertyIndexIfAbsent(tx, "NoFacetIds", FacetLabel.NO_FACET_GROUPS, true, "native-btree-1.0", "name");
        Indexes.createSinglePropertyIndexIfAbsent(tx, "FacetIds", FacetLabel.FACET, true, "native-btree-1.0", KEY_ID);
        Indexes.createSinglePropertyIndexIfAbsent(tx, "NoFacetIds", FacetLabel.NO_FACET, true, "native-btree-1.0", KEY_ID);
    }

    public static Node getFacetNode(Transaction tx, String facetId) {
        return tx.findNode((Label)FacetLabel.FACET, KEY_ID, (Object)facetId);
    }

    public static Node getNoFacet(Transaction tx, String facetId) {
        Node noFacetNode = tx.findNode((Label)FacetLabel.NO_FACET, KEY_ID, (Object)facetId);
        if (null == noFacetNode) {
            Node facetNode = FacetManager.getFacetNode(tx, facetId);
            noFacetNode = NodeUtilities.copyNode(tx, facetNode);
            noFacetNode.addLabel((Label)FacetLabel.NO_FACET);
            Node noFacetGroupsNode = FacetManager.getNoFacetGroupsNode(tx);
            Node facetGroupNode = NodeUtilities.getSingleOtherNode(facetNode, EdgeTypes.HAS_FACET);
            Node noFacetGroupNode = FacetManager.getFacetGroup(tx, noFacetGroupsNode, (String)facetGroupNode.getProperty("name"));
            if (null == noFacetGroupNode) {
                noFacetGroupNode = NodeUtilities.copyNode(tx, facetGroupNode);
                noFacetGroupsNode.createRelationshipTo(noFacetGroupNode, (RelationshipType)EdgeTypes.HAS_FACET_GROUP);
            }
            noFacetGroupNode.createRelationshipTo(noFacetNode, (RelationshipType)EdgeTypes.HAS_FACET);
        }
        return noFacetNode;
    }

    @GET
    @Produces(value={"text/plain"})
    @javax.ws.rs.Path(value="/{get_facet_size}")
    public int getFacetSize(@PathParam(value="id") String fid) {
        return FacetManager.countFacetChildren(this.dbms.database("neo4j"), fid);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{insert_facets}")
    public ListRepresentation insertFacets(String facetList) throws IOException {
        ObjectMapper om = new ObjectMapper();
        List<ImportFacet> input = om.readValue(facetList, new TypeReference<List<ImportFacet>>(){});
        ArrayList<Node> facets = new ArrayList<Node>();
        GraphDatabaseService graphDb = this.dbms.database("neo4j");
        try (Transaction tx = graphDb.beginTx();){
            for (ImportFacet importFacet : input) {
                Node facet = FacetManager.createFacet(tx, importFacet);
                facets.add(facet);
            }
            ArrayList<RecursiveMappingRepresentation> facetRepList = new ArrayList<RecursiveMappingRepresentation>();
            for (Node facet : facets) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", facet.getProperty("name"));
                map.put(KEY_ID, facet.getProperty(KEY_ID));
                RecursiveMappingRepresentation facetResponseRep = new RecursiveMappingRepresentation(Representation.MAP, map);
                facetRepList.add(facetResponseRep);
            }
            ListRepresentation listRepresentation = new ListRepresentation(Representation.MAP, facetRepList);
            tx.commit();
            ListRepresentation listRepresentation2 = listRepresentation;
            return listRepresentation2;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/{get_facets}")
    public MappingRepresentation getFacets(@PathParam(value="returnHollowFacets") Boolean returnHollowfacets) {
        RecursiveMappingRepresentation facetGroupsRep;
        GraphDatabaseService graphDb = this.dbms.database("neo4j");
        try (Transaction tx = graphDb.beginTx();){
            Node facetGroupsNode = FacetManager.getFacetGroupsNode(tx);
            TraversalDescription td = PredefinedTraversals.getFacetTraversal(tx);
            Traverser traverse = td.traverse(facetGroupsNode);
            HashMap<String, ArrayList<Node>> facetsByFacetGroupName = new HashMap<String, ArrayList<Node>>();
            HashMap<String, Node> facetGroupsMap = new HashMap<String, Node>();
            ArrayList facetGroupsWithFacetsList = new ArrayList();
            for (Path facetPath : traverse) {
                boolean isFacetWithoutPredefinedRoots;
                Node facet = facetPath.endNode();
                Object sourceType = facet.getProperty("sourceType");
                boolean bl = isFacetWithoutPredefinedRoots = !sourceType.equals("hierarchical");
                if (!isFacetWithoutPredefinedRoots) {
                    Iterator rootIt = facet.getRelationships(new RelationshipType[]{ConceptEdgeTypes.HAS_ROOT_CONCEPT}).iterator();
                    if (!rootIt.hasNext()) continue;
                    if (!returnHollowfacets.booleanValue()) {
                        boolean onlyHollowRoots = true;
                        while (rootIt.hasNext() && onlyHollowRoots) {
                            Node rootTerm = ((Relationship)rootIt.next()).getEndNode();
                            boolean isHollow = false;
                            for (Label label : rootTerm.getLabels()) {
                                if (!label.equals((Object)ConceptLabel.HOLLOW)) continue;
                                isHollow = true;
                                break;
                            }
                            if (isHollow) continue;
                            onlyHollowRoots = false;
                        }
                        if (onlyHollowRoots) continue;
                    }
                }
                Iterable facetRels = facet.getRelationships(Direction.INCOMING, new RelationshipType[]{EdgeTypes.HAS_FACET});
                Iterator onlyHollowRoots = facetRels.iterator();
                while (onlyHollowRoots.hasNext()) {
                    Relationship facetRel = (Relationship)onlyHollowRoots.next();
                    Node facetGroupNode = facetRel.getStartNode();
                    String facetGroupName = (String)facetGroupNode.getProperty("name");
                    facetGroupsMap.put(facetGroupName, facetGroupNode);
                    ArrayList<Node> facets = (ArrayList<Node>)facetsByFacetGroupName.get(facetGroupName);
                    if (facets == null) {
                        facets = new ArrayList<Node>();
                        facetsByFacetGroupName.put(facetGroupName, facets);
                    }
                    facets.add(facet);
                }
            }
            for (String facetGroupName : facetsByFacetGroupName.keySet()) {
                Node facetGroupNode = (Node)facetGroupsMap.get(facetGroupName);
                Object facets = facetsByFacetGroupName.get(facetGroupName);
                HashMap<String, Object> facetGroupMap = new HashMap<String, Object>();
                for (String propKey : facetGroupNode.getPropertyKeys()) {
                    facetGroupMap.put(propKey, facetGroupNode.getProperty(propKey));
                }
                ArrayList<String> facetGroupLabels = new ArrayList<String>();
                for (Label label : facetGroupNode.getLabels()) {
                    facetGroupLabels.add(label.name());
                }
                facetGroupMap.put("labels", facetGroupLabels);
                facetGroupMap.put(KEY_FACETS, facets);
                facetGroupsWithFacetsList.add(facetGroupMap);
            }
            HashMap ret = new HashMap();
            ret.put("facetGroups", facetGroupsWithFacetsList);
            facetGroupsRep = new RecursiveMappingRepresentation(Representation.MAP, ret);
            tx.commit();
        }
        return facetGroupsRep;
    }

    public static enum FacetLabel implements Label
    {
        FACET_GROUPS,
        NO_FACET_GROUPS,
        FACET,
        NO_FACET;

    }

    public static enum EdgeTypes implements RelationshipType
    {
        HAS_FACET_GROUP,
        HAS_FACET;

    }
}

