/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.datarepresentation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcept;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacet;
import de.julielab.neo4j.plugins.datarepresentation.ImportOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ImportConcepts {
    private Stream<ImportConcept> concepts;
    private List<ImportConcept> conceptsAsList;
    private ImportFacet facet;
    private ImportOptions importOptions;

    public ImportConcepts(ImportFacet facet) {
        this.facet = facet;
    }

    public ImportConcepts(Stream<ImportConcept> termList, ImportFacet facet) {
        this.concepts = termList;
        this.facet = facet;
    }

    public ImportConcepts(Stream<ImportConcept> termList, ImportFacet importFacet, ImportOptions importOptions) {
        this(termList, importFacet);
        this.importOptions = importOptions;
    }

    public ImportConcepts(List<ImportConcept> concepts, ImportFacet importFacet) {
        this((Stream<ImportConcept>)null, importFacet);
        this.conceptsAsList = concepts;
    }

    public ImportConcepts(List<ImportConcept> concepts, ImportFacet importFacet, ImportOptions importOptions) {
        this((Stream<ImportConcept>)null, importFacet, importOptions);
        this.conceptsAsList = concepts;
    }

    public Stream<ImportConcept> getConcepts() {
        if (this.conceptsAsList != null) {
            return this.conceptsAsList.stream();
        }
        return this.concepts;
    }

    @JsonIgnore
    public List<ImportConcept> getConceptsAsList() {
        if (this.conceptsAsList == null) {
            this.conceptsAsList = this.concepts.collect(Collectors.toCollection(ArrayList::new));
        }
        return this.conceptsAsList;
    }

    public ImportFacet getFacet() {
        return this.facet;
    }

    public ImportOptions getImportOptions() {
        return this.importOptions;
    }

    public void setConcepts(Stream<ImportConcept> concepts) {
        this.concepts = concepts;
    }

    public void setFacet(ImportFacet facet) {
        this.facet = facet;
    }

    public void setImportOptions(ImportOptions importOptions) {
        this.importOptions = importOptions;
    }
}

