/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import de.julielab.neo4j.plugins.ConceptManager;
import de.julielab.neo4j.plugins.auxiliaries.JSON;
import de.julielab.neo4j.plugins.auxiliaries.JulieNeo4jUtilities;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.auxiliaries.semedico.TermNameAndSynonymComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;

public class ConceptAggregateBuilder {
    private static final Logger log = Logger.getLogger(ConceptAggregateBuilder.class.getName());

    public static void buildAggregatesForEqualNames(GraphDatabaseService graphDb, String termPropertyKey, JSONArray propertyValues) throws JSONException {
        TermNameAndSynonymComparator nameAndSynonymComparator = new TermNameAndSynonymComparator();
        try (Transaction tx = graphDb.beginTx();){
            Index termIndex = graphDb.index().forNodes("termIndex");
            ResourceIterable aggregates = () -> graphDb.findNodes((Label)ConceptManager.ConceptLabel.AGGREGATE_EQUAL_NAMES);
            for (Node aggregate : aggregates) {
                for (Relationship rel : aggregate.getRelationships()) {
                    rel.delete();
                }
                aggregate.delete();
            }
            ResourceIterable termIterable = () -> graphDb.findNodes((Label)ConceptManager.ConceptLabel.CONCEPT);
            ArrayList<Node> terms = new ArrayList<Node>();
            for (Node term : termIterable) {
                terms.add(term);
            }
            Collections.sort(terms, nameAndSynonymComparator);
            String[] copyProperties = new String[]{"preferredName", "synonyms", "descriptions"};
            ArrayList<Node> equalNameTerms = new ArrayList<Node>();
            for (Node term : terms) {
                boolean equalTerm;
                boolean bl = equalTerm = 0 == equalNameTerms.size() || 0 == nameAndSynonymComparator.compare((Node)equalNameTerms.get(equalNameTerms.size() - 1), term);
                if (equalTerm) {
                    equalNameTerms.add(term);
                    continue;
                }
                if (equalNameTerms.size() > 1) {
                    ConceptAggregateBuilder.createAggregate(graphDb, copyProperties, new HashSet<Node>(equalNameTerms), new String[]{ConceptManager.ConceptLabel.AGGREGATE_EQUAL_NAMES.toString()}, (Index<Node>)termIndex, ConceptManager.ConceptLabel.AGGREGATE_EQUAL_NAMES);
                    for (Node equalNameTerm : equalNameTerms) {
                        NodeUtilities.mergeArrayProperty((PropertyContainer)equalNameTerm, termPropertyKey, JSON.json2JavaArray(propertyValues, new Object[0]));
                    }
                    equalNameTerms.clear();
                    equalNameTerms.add(term);
                    continue;
                }
                equalNameTerms.clear();
                equalNameTerms.add(term);
            }
            if (equalNameTerms.size() > 1) {
                ConceptAggregateBuilder.createAggregate(graphDb, copyProperties, new HashSet<Node>(equalNameTerms), new String[]{ConceptManager.ConceptLabel.AGGREGATE_EQUAL_NAMES.toString()}, (Index<Node>)termIndex, ConceptManager.ConceptLabel.AGGREGATE_EQUAL_NAMES);
            }
            for (Node term : equalNameTerms) {
                NodeUtilities.mergeArrayProperty((PropertyContainer)term, termPropertyKey, JSON.json2JavaArray(propertyValues, new Object[0]));
            }
            tx.success();
        }
    }

    public static void deleteAggregates(GraphDatabaseService graphDb, Label aggregateLabel) {
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable aggregates = () -> graphDb.findNodes(aggregateLabel);
            for (Node aggregate : aggregates) {
                if (!aggregate.hasLabel((Label)ConceptManager.ConceptLabel.AGGREGATE)) {
                    aggregate.removeLabel(aggregateLabel);
                    continue;
                }
                for (Relationship rel : aggregate.getRelationships()) {
                    rel.delete();
                }
                aggregate.delete();
            }
            tx.success();
        }
    }

    public static void buildAggregatesForMappings(GraphDatabaseService graphDb, Set<String> allowedMappingTypes, Label allowedTermLabel, Label aggregatedTermsLabel) {
        log.info("Building aggregates for mappings " + allowedMappingTypes + " and terms with label " + allowedTermLabel);
        String[] copyProperties = new String[]{"preferredName", "synonyms", "writingVariants", "descriptions", "facets"};
        try (Transaction tx = graphDb.beginTx();){
            Index termIndex = graphDb.index().forNodes("termIndex");
            ConceptAggregateBuilder.deleteAggregates(graphDb, aggregatedTermsLabel);
            ConceptManager.ConceptLabel label = null == allowedTermLabel ? ConceptManager.ConceptLabel.CONCEPT : allowedTermLabel;
            ResourceIterable termIterable = () -> graphDb.findNodes(label);
            for (Node term : termIterable) {
                Set<Node> aggregateNodes = ConceptAggregateBuilder.getMatchingAggregates(term, allowedMappingTypes, aggregatedTermsLabel);
                if (aggregateNodes.size() > 1) {
                    throw new IllegalStateException("Term with ID " + term.getProperty("id") + " is part of multiple aggregates of the same type, thus duplicates. The aggregate nodes are: " + aggregateNodes);
                }
                if (aggregateNodes.size() == 1) continue;
                HashSet<Node> elements = new HashSet<Node>();
                HashSet<Node> visited = new HashSet<Node>();
                ConceptAggregateBuilder.determineMappedSubgraph(allowedMappingTypes, allowedTermLabel, term, elements, visited);
                if (elements.size() > 1) {
                    ConceptAggregateBuilder.createAggregate(graphDb, copyProperties, elements, allowedMappingTypes.toArray(new String[allowedMappingTypes.size()]), (Index<Node>)termIndex, aggregatedTermsLabel);
                    continue;
                }
                term.addLabel(aggregatedTermsLabel);
            }
            tx.success();
        }
    }

    protected static void determineMappedSubgraph(Set<String> allowedMappingTypes, Label allowedTermLabel, Node term, Set<Node> elements, Set<Node> visited) {
        if (visited.contains(term)) {
            return;
        }
        visited.add(term);
        Iterable mappings = term.getRelationships(new RelationshipType[]{ConceptManager.EdgeTypes.IS_MAPPED_TO});
        for (Relationship mapping : mappings) {
            if (!mapping.hasProperty("mappingType")) {
                throw new IllegalStateException("The mapping relationship " + mapping + " does not specify its type.");
            }
            String[] mappingTypes = (String[])mapping.getProperty("mappingType");
            for (int i = 0; i < mappingTypes.length; ++i) {
                Node otherTerm;
                String mappingType = mappingTypes[i];
                if (!allowedMappingTypes.contains(mappingType)) continue;
                if (null == allowedTermLabel || term.hasLabel(allowedTermLabel)) {
                    elements.add(term);
                }
                if (elements.contains(otherTerm = mapping.getOtherNode(term))) continue;
                if (null == allowedTermLabel || otherTerm.hasLabel(allowedTermLabel)) {
                    elements.add(otherTerm);
                }
                ConceptAggregateBuilder.determineMappedSubgraph(allowedMappingTypes, allowedTermLabel, otherTerm, elements, visited);
            }
        }
    }

    protected static Set<Node> getMatchingAggregates(Node conceptNode, Set<String> allowedMappingTypes, Label aggregateLabel) {
        HashSet<Node> aggregateNodes = new HashSet<Node>();
        Iterable elementRelationships = conceptNode.getRelationships(new RelationshipType[]{ConceptManager.EdgeTypes.HAS_ELEMENT});
        for (Relationship elementRelationship : elementRelationships) {
            Node aggregate = elementRelationship.getOtherNode(conceptNode);
            if (!aggregate.hasLabel(aggregateLabel) || !aggregate.hasLabel((Label)ConceptManager.ConceptLabel.AGGREGATE) || !aggregate.hasProperty("mappingType")) continue;
            String[] mappingTypes = (String[])aggregate.getProperty("mappingType");
            List<String> mappingTypesList = Arrays.asList(mappingTypes);
            boolean correctMappingTypes = true;
            for (String mappingType : mappingTypesList) {
                if (allowedMappingTypes.contains(mappingType)) continue;
                correctMappingTypes = false;
            }
            for (String mappingType : allowedMappingTypes) {
                if (mappingTypesList.contains(mappingType)) continue;
                correctMappingTypes = false;
            }
            if (!correctMappingTypes) continue;
            aggregateNodes.add(aggregate);
        }
        return aggregateNodes;
    }

    private static Node createAggregate(GraphDatabaseService graphDb, String[] copyProperties, Set<Node> elementTerms, String[] mappingTypes, Index<Node> termIndex, Label ... labels) {
        if (elementTerms.isEmpty()) {
            return null;
        }
        Node aggregate = graphDb.createNode(labels);
        aggregate.addLabel((Label)ConceptManager.ConceptLabel.AGGREGATE);
        aggregate.setProperty("copyProperties", (Object)copyProperties);
        aggregate.setProperty("mappingType", (Object)mappingTypes);
        for (int i = 0; i < labels.length; ++i) {
            Label termLabel = labels[i];
            aggregate.addLabel(termLabel);
        }
        for (Node elementTerm : elementTerms) {
            aggregate.createRelationshipTo(elementTerm, (RelationshipType)ConceptManager.EdgeTypes.HAS_ELEMENT);
        }
        String aggregateId = "atid" + SequenceManager.getNextSequenceValue(graphDb, "seqAggregateTerm");
        aggregate.setProperty("id", (Object)aggregateId);
        termIndex.putIfAbsent((PropertyContainer)aggregate, "id", (Object)aggregateId);
        return aggregate;
    }

    public static void copyAggregateProperties(Node aggregate, String[] copyProperties, CopyAggregatePropertiesStatistics copyStats) {
        for (int i = 0; i < copyProperties.length; ++i) {
            String copyProperty = copyProperties[i];
            aggregate.removeProperty(copyProperty);
        }
        Iterable elementRels = aggregate.getRelationships(new RelationshipType[]{ConceptManager.EdgeTypes.HAS_ELEMENT});
        HashSet<String> divergentProperties = new HashSet<String>();
        for (Relationship elementRel : elementRels) {
            Node term = elementRel.getEndNode();
            if (null != copyStats) {
                ++copyStats.numElements;
            }
            for (String string : copyProperties) {
                Object property;
                if (!term.hasProperty(string)) continue;
                if (null != copyStats) {
                    ++copyStats.numProperties;
                }
                if ((property = term.getProperty(string)).getClass().isArray()) {
                    PropertyUtilities.mergeArrayProperty((PropertyContainer)aggregate, string, JulieNeo4jUtilities.convertArray(property));
                    continue;
                }
                PropertyUtilities.setNonNullNodeProperty((PropertyContainer)aggregate, string, property);
                Object aggregateProperty = PropertyUtilities.getNonNullNodeProperty((PropertyContainer)aggregate, string);
                if (aggregateProperty.equals(property)) continue;
                divergentProperties.add(string);
            }
        }
        for (String divergentProperty : divergentProperties) {
            HashMultiset<Object> propertyValues = HashMultiset.create();
            elementRels = aggregate.getRelationships(new RelationshipType[]{ConceptManager.EdgeTypes.HAS_ELEMENT});
            for (Relationship elementRel : elementRels) {
                Node term = elementRel.getEndNode();
                Object object = PropertyUtilities.getNonNullNodeProperty((PropertyContainer)term, divergentProperty);
                if (null == object) continue;
                propertyValues.add(object);
            }
            Object majorityValue = null;
            int maxCount = 0;
            for (Multiset.Entry entry : propertyValues.entrySet()) {
                if (entry.getCount() <= maxCount) continue;
                majorityValue = entry.getElement();
                maxCount = entry.getCount();
            }
            aggregate.setProperty(divergentProperty, majorityValue);
            for (Object e : propertyValues.elementSet()) {
                if (e.equals(majorityValue)) continue;
                Object[] convert = JulieNeo4jUtilities.convertElementsIntoArray(e.getClass(), e);
                PropertyUtilities.mergeArrayProperty((PropertyContainer)aggregate, divergentProperty + "_divergentProperty", convert);
            }
        }
        PropertyUtilities.mergeArrayProperty((PropertyContainer)aggregate, "synonyms", (Object[])PropertyUtilities.getNonNullNodeProperty((PropertyContainer)aggregate, "preferredName_divergentProperty"));
        if (aggregate.hasProperty("synonyms")) {
            String[] synonyms = (String[])aggregate.getProperty("synonyms");
            HashSet<String> lowerCaseSynonyms = new HashSet<String>();
            ArrayList<String> acceptedSynonyms = new ArrayList<String>();
            for (int i = 0; i < synonyms.length; ++i) {
                String synonym = synonyms[i];
                String lowerCaseSynonym = synonym.toLowerCase();
                if (lowerCaseSynonyms.contains(lowerCaseSynonym)) continue;
                lowerCaseSynonyms.add(lowerCaseSynonym);
                acceptedSynonyms.add(synonym);
            }
            Collections.sort(acceptedSynonyms);
            aggregate.setProperty("synonyms", (Object)acceptedSynonyms.toArray(new String[acceptedSynonyms.size()]));
        }
    }

    public static class CopyAggregatePropertiesStatistics {
        public int numProperties = 0;
        public int numElements = 0;

        public String toString() {
            return "CopyAggregatePropertiesStatistics [numProperties=" + this.numProperties + ", numElements=" + this.numElements + "]";
        }
    }
}

