/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import de.julielab.neo4j.plugins.FacetManager;
import de.julielab.neo4j.plugins.auxiliaries.JSON;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.ConceptAggregateBuilder;
import de.julielab.neo4j.plugins.auxiliaries.semedico.CoordinatesMap;
import de.julielab.neo4j.plugins.auxiliaries.semedico.CoordinatesSet;
import de.julielab.neo4j.plugins.auxiliaries.semedico.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.PredefinedTraversals;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.auxiliaries.semedico.TermVariantComparator;
import de.julielab.neo4j.plugins.datarepresentation.AddToNonFacetGroupCommand;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportOptions;
import de.julielab.neo4j.plugins.datarepresentation.PushConceptsToSetCommand;
import de.julielab.neo4j.plugins.datarepresentation.constants.NodeConstants;
import de.julielab.neo4j.plugins.util.AggregateConceptInsertionException;
import de.julielab.neo4j.plugins.util.ConceptInsertionException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.RecursiveMappingRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="This plugin discloses special operation for efficient access to the FacetConcepts for Semedico.")
public class ConceptManager
extends ServerPlugin {
    private static final String UNKNOWN_CONCEPT_SOURCE = "<unknown>";
    public static final String INSERT_MAPPINGS = "insert_mappings";
    public static final String BUILD_AGGREGATES_BY_NAME_AND_SYNONYMS = "build_aggregates_by_name_and_synonyms";
    public static final String BUILD_AGGREGATES_BY_MAPPINGS = "build_aggregates_by_mappings";
    public static final String DELETE_AGGREGATES = "delete_aggregates";
    public static final String COPY_AGGREGATE_PROPERTIES = "copy_aggregate_properties";
    public static final String CREATE_SCHEMA_INDEXES = "create_schema_indexes";
    public static final String GET_CHILDREN_OF_CONCEPTS = "get_children_of_concepts";
    public static final String GET_NUM_CONCEPTS = "get_num_concepts";
    public static final String GET_PATHS_FROM_FACETROOTS = "get_paths_to_facetroots";
    public static final String INSERT_CONCEPTS = "insert_concepts";
    public static final String GET_FACET_ROOTS = "get_facet_roots";
    public static final String ADD_CONCEPT_CONCEPT = "add_concept_term";
    public static final String KEY_AMOUNT = "amount";
    public static final String KEY_CREATE_HOLLOW_PARENTS = "createHollowParents";
    public static final String KEY_FACET = "facet";
    public static final String KEY_FACET_ID = "facetId";
    public static final String KEY_FACET_IDS = "facetIds";
    public static final String KEY_FACET_PROP_KEY = "propertyKey";
    public static final String KEY_FACET_PROP_VALUE = "propertyValue";
    public static final String KEY_ID_TYPE = "idType";
    public static final String KEY_IMPORT_OPTIONS = "importOptions";
    public static final String KEY_LABEL = "label";
    public static final String KEY_SORT_RESULT = "sortResult";
    public static final String KEY_CONCEPT_IDS = "conceptIds";
    public static final String KEY_MAX_ROOTS = "maxRoots";
    public static final String KEY_CONCEPT_PROP_KEY = "conceptPropertyKey";
    public static final String KEY_CONCEPT_PROP_VALUE = "conceptPropertyValue";
    public static final String KEY_CONCEPT_PROP_VALUES = "conceptPropertyValues";
    public static final String KEY_CONCEPT_PUSH_CMD = "conceptPushCommand";
    public static final String KEY_AGGREGATED_LABEL = "aggregatedLabel";
    public static final String KEY_ALLOWED_MAPPING_TYPES = "allowedMappingTypes";
    public static final String KEY_CONCEPT_TERMS = "conceptTerms";
    public static final String KEY_CONCEPT_ACRONYMS = "conceptAcronyms";
    public static final String KEY_CONCEPTS = "concepts";
    public static final String KEY_TIME = "time";
    public static final String KEY_MAPPINGS = "mappings";
    private static final Logger log = LoggerFactory.getLogger(ConceptManager.class);
    public static final String POP_CONCEPTS_FROM_SET = "pop_concepts_from_set";
    public static final String PUSH_CONCEPTS_TO_SET = "push_concepts_to_set";
    public static final String RET_KEY_CHILDREN = "children";
    public static final String RET_KEY_NUM_AGGREGATES = "numAggregates";
    public static final String RET_KEY_NUM_CREATED_RELS = "numCreatedRelationships";
    public static final String RET_KEY_NUM_CREATED_CONCEPTS = "numCreatedConcepts";
    public static final String RET_KEY_NUM_ELEMENTS = "numElements";
    public static final String RET_KEY_NUM_PROPERTIES = "numProperties";
    public static final String RET_KEY_PATHS = "paths";
    public static final String RET_KEY_RELTYPES = "reltypes";
    public static final String RET_KEY_CONCEPTS = "concepts";
    public static final String CONCEPT_MANAGER_ENDPOINT = "db/data/ext/" + ConceptManager.class.getSimpleName() + "/graphdb/";
    private static final int CONCEPT_INSERT_BATCH_SIZE = 10000;
    public static final String UPDATE_CHILDREN_INFORMATION = "update_children_information";

    @Name(value="build_aggregates_by_mappings")
    @Description(value="Creates concept aggregates with respect to 'IS_MAPPED_TO' relationships.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void buildAggregatesByMappings(@Source GraphDatabaseService graphDb, @Description(value="The allowed types for IS_MAPPED_TO relationships to be included in aggregation building.") @Parameter(name="allowedMappingTypes") String allowedMappingTypesArray, @Description(value="Label for concepts that have been processed by the aggregation algorithm. Such concepts can be aggregate concepts (with the label AGGREGATE) or just plain concepts (with the label CONCEPT) that are not an element of an aggregate.") @Parameter(name="aggregatedLabel") String aggregatedConceptsLabelString, @Description(value="Label to restrict the concepts to that are considered for aggregation creation.") @Parameter(name="label", optional=true) String allowedConceptLabelString) throws JSONException {
        JSONArray allowedMappingTypesJson = new JSONArray(allowedMappingTypesArray);
        HashSet<String> allowedMappingTypes = new HashSet<String>();
        for (int i = 0; i < allowedMappingTypesJson.length(); ++i) {
            allowedMappingTypes.add(allowedMappingTypesJson.getString(i));
        }
        Label aggregatedConceptsLabel = Label.label((String)aggregatedConceptsLabelString);
        Label allowedConceptLabel = StringUtils.isBlank((String)allowedConceptLabelString) ? null : Label.label((String)allowedConceptLabelString);
        log.info("Creating mapping aggregates for concepts with label {} and mapping types {}", (Object)allowedConceptLabel, (Object)allowedMappingTypesJson);
        ConceptAggregateBuilder.buildAggregatesForMappings(graphDb, allowedMappingTypes, allowedConceptLabel, aggregatedConceptsLabel);
    }

    @Name(value="delete_aggregates")
    @Description(value="Deletes aggregates with respect to a specific aggregate label. Only real aggregates are actually deleted, plain concepts that are 'their own' aggregates just lose the label.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void deleteAggregatesByMappigs(@Source GraphDatabaseService graphDb, @Description(value="Label for concepts that have been processed by the aggregation algorithm. Such concepts can be aggregate concepts (with the label AGGREGATE) or just plain concepts (with the label CONCEPT) that are not an element of an aggregate.") @Parameter(name="aggregatedLabel") String aggregatedConceptsLabelString) throws JSONException {
        Label aggregatedConceptsLabel = Label.label((String)aggregatedConceptsLabelString);
        ConceptAggregateBuilder.deleteAggregates(graphDb, aggregatedConceptsLabel);
    }

    @Name(value="build_aggregates_by_name_and_synonyms")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public void buildAggregatesByNameAndSynonyms(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="conceptPropertyKey") String conceptPropertyKey, @Description(value="TODO") @Parameter(name="conceptPropertyValues") String propertyValues) throws JSONException {
        JSONArray jsonPropertyValues = new JSONArray(propertyValues);
        ConceptAggregateBuilder.buildAggregatesForEqualNames(graphDb, conceptPropertyKey, jsonPropertyValues);
    }

    @Name(value="copy_aggregate_properties")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation copyAggregateProperties(@Source GraphDatabaseService graphDb) {
        int numAggregates = 0;
        ConceptAggregateBuilder.CopyAggregatePropertiesStatistics copyStats = new ConceptAggregateBuilder.CopyAggregatePropertiesStatistics();
        try (Transaction tx = graphDb.beginTx();){
            try (ResourceIterator aggregateIt = graphDb.findNodes((Label)ConceptLabel.AGGREGATE);){
                while (aggregateIt.hasNext()) {
                    Node aggregate = (Node)aggregateIt.next();
                    numAggregates += this.copyAggregatePropertiesRecursively(aggregate, copyStats, new HashSet<Node>());
                }
            }
            tx.success();
        }
        HashMap<String, Object> reportMap = new HashMap<String, Object>();
        reportMap.put(RET_KEY_NUM_AGGREGATES, numAggregates);
        reportMap.put(RET_KEY_NUM_ELEMENTS, copyStats.numElements);
        reportMap.put(RET_KEY_NUM_PROPERTIES, copyStats.numProperties);
        return new RecursiveMappingRepresentation(Representation.MAP, reportMap);
    }

    private int copyAggregatePropertiesRecursively(Node aggregate, ConceptAggregateBuilder.CopyAggregatePropertiesStatistics copyStats, Set<Node> alreadySeen) {
        if (alreadySeen.contains(aggregate)) {
            return 0;
        }
        ArrayList<Node> elementAggregates = new ArrayList<Node>();
        Iterable elementRels = aggregate.getRelationships(Direction.OUTGOING, new RelationshipType[]{EdgeTypes.HAS_ELEMENT});
        for (Relationship elementRel : elementRels) {
            Node endNode = elementRel.getEndNode();
            if (!endNode.hasLabel((Label)ConceptLabel.AGGREGATE) || alreadySeen.contains(endNode)) continue;
            elementAggregates.add(endNode);
        }
        for (Node elementAggregate : elementAggregates) {
            this.copyAggregatePropertiesRecursively(elementAggregate, copyStats, alreadySeen);
        }
        if (aggregate.hasProperty("copyProperties")) {
            String[] copyProperties = (String[])aggregate.getProperty("copyProperties");
            ConceptAggregateBuilder.copyAggregateProperties(aggregate, copyProperties, copyStats);
        }
        alreadySeen.add(aggregate);
        return alreadySeen.size();
    }

    private void createRelationships(GraphDatabaseService graphDb, JSONArray jsonConcepts, Node facet, CoordinatesMap nodesByCoordinates, ImportOptions importOptions, InsertionReport insertionReport) throws JSONException {
        log.info("Creating relationship between inserted concepts.");
        Index idIndex = graphDb.index().forNodes("termIndex");
        String facetId = null;
        if (null != facet) {
            facetId = (String)facet.getProperty("id");
        }
        RelationshipType relBroaderThanInFacet = null;
        if (null != facet) {
            relBroaderThanInFacet = RelationshipType.withName((String)(EdgeTypes.IS_BROADER_THAN.toString() + "_" + facetId));
        }
        AddToNonFacetGroupCommand noFacetCmd = importOptions.noFacetCmd;
        Node noFacet = null;
        int quarter = jsonConcepts.length() / 4;
        int numQuarter = 1;
        long totalTime = 0L;
        long relCreationTime = 0L;
        for (int i = 0; i < jsonConcepts.length(); ++i) {
            int j;
            long time = System.currentTimeMillis();
            JSONObject jsonConcept = jsonConcepts.getJSONObject(i);
            if (JSON.getBoolean(jsonConcept, "aggregate") && !JSON.getBoolean(jsonConcept, "aggregateIncludeInHierarchy")) continue;
            JSONObject coordinates = jsonConcept.getJSONObject("coordinates");
            String srcId = coordinates.getString("sourceId");
            Node concept = nodesByCoordinates.get(new ConceptCoordinates(coordinates));
            if (null == concept && insertionReport.omittedConcepts.contains(srcId)) continue;
            if (null == concept) {
                throw new IllegalStateException("No node for source ID " + srcId + " was created but the respective concept is included into the data for import and it is unknown why no node instance was created.");
            }
            if (jsonConcept.has("parentCoordinates") && jsonConcept.getJSONArray("parentCoordinates").length() > 0) {
                JSONArray parentCoordinateArray = jsonConcept.getJSONArray("parentCoordinates");
                for (j = 0; j < parentCoordinateArray.length(); ++j) {
                    ConceptCoordinates parentCoordinates = new ConceptCoordinates(parentCoordinateArray.getJSONObject(j));
                    String parentSrcId = parentCoordinates.sourceId;
                    if (importOptions.cutParents.contains(parentSrcId)) {
                        log.debug("Concept node " + coordinates + " has a parent that is marked to be cut away. Concept will be a facet root.");
                        this.createRelationshipIfNotExists(facet, concept, EdgeTypes.HAS_ROOT_CONCEPT, insertionReport);
                        continue;
                    }
                    Node parent = nodesByCoordinates.get(parentCoordinates);
                    if (null == parent) {
                        throw new IllegalStateException("The parent node of concept " + coordinates + " should have been created in the insertConcepts method before, but it is null. The parent coordinates are " + parentCoordinates);
                    }
                    if (insertionReport.importedCoordinates.contains(parentCoordinates) || insertionReport.existingConcepts.contains(parent)) {
                        log.trace("Parent with " + parentCoordinates + " was found by source ID for concept " + coordinates + ".");
                        long creationTime = System.currentTimeMillis();
                        this.createRelationshipIfNotExists(parent, concept, EdgeTypes.IS_BROADER_THAN, insertionReport);
                        this.createRelationshipIfNotExists(parent, concept, relBroaderThanInFacet, insertionReport);
                        relCreationTime += System.currentTimeMillis() - creationTime;
                    } else {
                        log.debug("Concept with source ID \"" + srcId + "\" referenced the concept with source ID \"" + parentSrcId + "\" as its parent. However, that parent node does not exist.");
                        if (!importOptions.doNotCreateHollowParents) {
                            log.debug("Creating hollow parents is switched on. The parent will be created with the label \"" + (Object)((Object)ConceptLabel.HOLLOW) + "\" and be connected to the facet root.");
                            parent.addLabel((Label)ConceptLabel.CONCEPT);
                            this.createRelationshipIfNotExists(parent, concept, EdgeTypes.IS_BROADER_THAN, insertionReport);
                            this.createRelationshipIfNotExists(parent, concept, relBroaderThanInFacet, insertionReport);
                            this.createRelationshipIfNotExists(facet, parent, EdgeTypes.HAS_ROOT_CONCEPT, insertionReport);
                        } else {
                            log.warn("Creating hollow parents is switched off. Hence the concept will be added as root concept for its facet (\"" + facet.getProperty("name") + "\").");
                            this.createRelationshipIfNotExists(facet, concept, EdgeTypes.HAS_ROOT_CONCEPT, insertionReport);
                        }
                    }
                    if (null == parent || !parent.hasLabel((Label)ConceptLabel.AGGREGATE) || parent.hasLabel((Label)ConceptLabel.CONCEPT)) continue;
                    throw new IllegalArgumentException("Concept with source ID " + srcId + " specifies source ID " + parentSrcId + " as parent. This node is an aggregate but not a CONCEPT itself and thus is not included in the hierarchy and cannot be the conceptual parent of other concepts. To achieve this, import the aggregate with the property " + "aggregateIncludeInHierarchy" + " set to true or build the aggregates in a way that assignes the CONCEPT label to them. The parent is " + NodeUtilities.getNodePropertiesAsString((PropertyContainer)parent) + " and has the following labels: " + StreamSupport.stream(parent.getLabels().spliterator(), false).map(Label::name).collect(Collectors.joining(", ")));
                }
            } else if (noFacetCmd != null && noFacetCmd.getParentCriteria().contains((Object)AddToNonFacetGroupCommand.ParentCriterium.NO_PARENT)) {
                if (null != noFacetCmd && null == noFacet) {
                    noFacet = FacetManager.getNoFacet(graphDb, (String)facet.getProperty("id"));
                }
                this.createRelationshipIfNotExists(noFacet, concept, EdgeTypes.HAS_ROOT_CONCEPT, insertionReport);
            } else if (null != facet) {
                log.trace("Installing concept with source ID " + srcId + " (ID: " + concept.getProperty("id") + ") as root for facet " + facet.getProperty("name") + "(ID: " + facet.getProperty("id") + ")");
                this.createRelationshipIfNotExists(facet, concept, EdgeTypes.HAS_ROOT_CONCEPT, insertionReport);
            }
            if (jsonConcept.has("relationships")) {
                log.info("Adding explicitly specified relationships");
                JSONArray jsonRelationships = jsonConcept.getJSONArray("relationships");
                for (j = 0; j < jsonRelationships.length(); ++j) {
                    String targetSource;
                    JSONObject jsonRelationship = jsonRelationships.getJSONObject(j);
                    String rsTypeStr = jsonRelationship.getString("type");
                    String targetOrgId = JSON.getString(jsonRelationship, "targetOriginalId");
                    String targetOrgSource = JSON.getString(jsonRelationship, "targetOriginalSource");
                    String targetSrcId = JSON.getString(jsonRelationship, "targetSrcId");
                    Node target = this.lookupConcept(new ConceptCoordinates(targetSrcId, targetSource = JSON.getString(jsonRelationship, "targetSource"), targetOrgId, targetOrgSource, JSON.getBoolean(jsonConcept, "uniqueSourceId", false)), (Index<Node>)idIndex);
                    if (null == target) {
                        log.debug("Creating hollow relationship target with orig Id/orig source (" + targetOrgId + "," + targetOrgSource + ") and source Id/source : (" + targetSrcId + ", " + targetSource + ")");
                        target = graphDb.createNode(new Label[]{ConceptLabel.CONCEPT, ConceptLabel.HOLLOW});
                        PropertyUtilities.addToArrayProperty((PropertyContainer)target, "sourceIds", targetSrcId);
                        PropertyUtilities.addToArrayProperty((PropertyContainer)target, "sources", targetSource);
                        if (null != targetOrgId) {
                            target.setProperty("originalId", (Object)targetOrgId);
                        }
                        if (null != targetOrgSource) {
                            target.setProperty("originalSource", (Object)targetOrgSource);
                        }
                        if (null != targetOrgId) {
                            idIndex.add((PropertyContainer)target, "originalId", (Object)targetOrgId);
                        }
                        if (null != targetSrcId) {
                            idIndex.add((PropertyContainer)target, "sourceIds", (Object)targetSrcId);
                        }
                    }
                    EdgeTypes type = EdgeTypes.valueOf(rsTypeStr);
                    Object[] properties = null;
                    if (jsonRelationship.has("properties")) {
                        JSONObject relProps = jsonRelationship.getJSONObject("properties");
                        JSONArray propNames = relProps.names();
                        properties = new Object[propNames.length() * 2];
                        for (int k = 0; k < propNames.length(); ++k) {
                            String propName = propNames.getString(k);
                            Object propValue = relProps.get(propName);
                            properties[2 * k] = propName;
                            properties[2 * k + 1] = propValue;
                        }
                    }
                    this.createRelationShipIfNotExists(concept, target, type, insertionReport, Direction.OUTGOING, properties);
                    ++insertionReport.numRelationships;
                }
            }
            totalTime += System.currentTimeMillis() - time;
            if (i < numQuarter * quarter) continue;
            log.info("Finished " + 25 * numQuarter + "% of concepts for relationship creation.");
            log.info("Relationship creation took " + relCreationTime + "ms.");
            log.info("Total time consumption for creation of " + insertionReport.numRelationships + " relationships until now: " + totalTime + "ms.");
            ++numQuarter;
        }
        log.info("Finished 100% of concepts for relationship creation.");
    }

    private void createIndexIfAbsent(GraphDatabaseService graphDb, Label label, String key, boolean unique) {
        try (Transaction tx = graphDb.beginTx();){
            Schema schema = graphDb.schema();
            boolean indexExists = false;
            for (IndexDefinition id : schema.getIndexes(label)) {
                for (String propertyKey : id.getPropertyKeys()) {
                    if (!propertyKey.equals(key)) continue;
                    indexExists = true;
                }
            }
            if (!indexExists) {
                log.info("Creating index for label " + label + " on property " + key + " (unique: " + unique + ").");
                schema.constraintFor(label).assertPropertyIsUnique(key).create();
                tx.success();
            }
        }
    }

    private Relationship createRelationshipIfNotExists(Node source, Node target, RelationshipType type, InsertionReport insertionReport) {
        return this.createRelationShipIfNotExists(source, target, type, insertionReport, Direction.OUTGOING, new Object[0]);
    }

    private Relationship createRelationShipIfNotExists(Node source, Node target, RelationshipType type, InsertionReport insertionReport, Direction direction, Object ... properties) {
        if (null != properties && properties.length % 2 != 0) {
            throw new IllegalArgumentException("Property list must contain of key/value pairs but its length was odd.");
        }
        boolean relationShipExists = false;
        Relationship createdRelationship = null;
        if (insertionReport.relationshipAlreadyWasCreated(source, target, type)) {
            relationShipExists = true;
        } else if (insertionReport.existingConcepts.contains(source) && insertionReport.existingConcepts.contains(target)) {
            Iterable relationships = source.getRelationships(direction, new RelationshipType[]{type});
            for (Relationship relationship : relationships) {
                if (!relationship.getEndNode().equals(target)) continue;
                relationShipExists = true;
                if (PropertyUtilities.mergeProperties((PropertyContainer)relationship, properties)) continue;
                relationShipExists = false;
            }
        }
        if (!relationShipExists) {
            createdRelationship = source.createRelationshipTo(target, type);
            for (int i = 0; null != properties && i < properties.length; i += 2) {
                String key = (String)properties[i];
                Object value = properties[i + 1];
                createdRelationship.setProperty(key, value);
            }
            insertionReport.addCreatedRelationship(source, target, type);
            ++insertionReport.numRelationships;
        }
        return createdRelationship;
    }

    @Name(value="create_schema_indexes")
    @Description(value="Creates uniqueness constraints (and thus, indexes), on the following label / property combinations: CONCEPT / id; CONCEPT / originalId; FACET / id; NO_FACET / id; ROOT / name. This should be done after the main initial import because node insertion with uniqueness switched on costs significant insertion performance.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void createSchemaIndexes(@Source GraphDatabaseService graphDb) {
        this.createIndexIfAbsent(graphDb, ConceptLabel.CONCEPT, "id", true);
        this.createIndexIfAbsent(graphDb, ConceptLabel.CONCEPT, "originalId", true);
        this.createIndexIfAbsent(graphDb, FacetManager.FacetLabel.FACET, "id", true);
        this.createIndexIfAbsent(graphDb, FacetManager.FacetLabel.NO_FACET, "id", true);
        this.createIndexIfAbsent(graphDb, NodeConstants.Labels.ROOT, "name", true);
    }

    @Name(value="get_children_of_concepts")
    @Description(value="Returns all non-hollow children of concepts identified via the conceptIds parameter. The return format is a map from the children's id to respective child concept. This endpoint has been created due to performance reasons. All tried Cypher queries to achieve the same behaviour were less performant (tested for version 2.0.0 M3).")
    @PluginTarget(value=GraphDatabaseService.class)
    public MappingRepresentation getChildrenOfConcepts(@Source GraphDatabaseService graphDb, @Description(value="JSON array of concept IDs for which to return their children.") @Parameter(name="conceptIds") String conceptIdArray, @Description(value="The label agsinst which the given concept IDs are resolved. Defaults to 'CONCEPT'.") @Parameter(name="label", optional=true) String labelString) throws JSONException {
        ConceptLabel label = ConceptLabel.CONCEPT;
        if (!StringUtils.isBlank((String)labelString)) {
            label = Label.label((String)labelString);
        }
        JSONArray conceptIds = new JSONArray(conceptIdArray);
        try (Transaction tx = graphDb.beginTx();){
            HashMap<String, Object> childrenByConceptId = new HashMap<String, Object>();
            for (int i = 0; i < conceptIds.length(); ++i) {
                HashMap<String, ArrayList<String>> reltypesByNodeId = new HashMap<String, ArrayList<String>>();
                HashSet<Node> childList = new HashSet<Node>();
                String conceptId = conceptIds.getString(i);
                Node concept = NodeUtilities.findSingleNodeByLabelAndProperty(graphDb, label, "id", conceptId);
                if (null == concept) continue;
                for (Relationship rel : concept.getRelationships(Direction.OUTGOING)) {
                    String reltype = rel.getType().name();
                    Node child = rel.getEndNode();
                    boolean isHollow = false;
                    for (Label l : child.getLabels()) {
                        if (!l.equals((Object)ConceptLabel.HOLLOW)) continue;
                        isHollow = true;
                    }
                    if (isHollow) continue;
                    String childId = (String)child.getProperty("id");
                    ArrayList<String> reltypeList = (ArrayList<String>)reltypesByNodeId.get(childId);
                    if (null == reltypeList) {
                        reltypeList = new ArrayList<String>();
                        reltypesByNodeId.put(childId, reltypeList);
                    }
                    reltypeList.add(reltype);
                    childList.add(child);
                }
                HashMap<String, Cloneable> childrenAndReltypes = new HashMap<String, Cloneable>();
                childrenAndReltypes.put(RET_KEY_CHILDREN, childList);
                childrenAndReltypes.put(RET_KEY_RELTYPES, reltypesByNodeId);
                childrenByConceptId.put(conceptId, childrenAndReltypes);
            }
            RecursiveMappingRepresentation recursiveMappingRepresentation = new RecursiveMappingRepresentation(Representation.MAP, childrenByConceptId);
            return recursiveMappingRepresentation;
        }
    }

    @Name(value="get_num_concepts")
    @Description(value="Returns the number of concepts in the database, i.e. the number of nodes with the \"CONCEPT\" label.")
    @PluginTarget(value=GraphDatabaseService.class)
    public long getNumConcepts(@Source GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable concepts = () -> graphDb.findNodes((Label)ConceptLabel.CONCEPT);
            long count = 0L;
            for (Node concept : concepts) {
                ++count;
            }
            long l = count;
            return l;
        }
    }

    @Name(value="get_paths_to_facetroots")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation getPathsFromFacetroots(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="conceptIds") String conceptIdsJsonString, @Description(value="TODO") @Parameter(name="idType") String idType, @Description(value="TODO") @Parameter(name="sortResult") boolean sort, final @Description(value="TODO") @Parameter(name="facetId") String facetId) throws JSONException {
        JSONArray conceptIds = new JSONArray(conceptIdsJsonString);
        Evaluator rootConceptEvaluator = new Evaluator(){

            public Evaluation evaluate(Path path) {
                Node endNode = path.endNode();
                Iterator iterator = endNode.getRelationships(new RelationshipType[]{EdgeTypes.HAS_ROOT_CONCEPT}).iterator();
                if (iterator.hasNext()) {
                    String[] facetIds;
                    if (StringUtils.isBlank((String)facetId)) {
                        return Evaluation.INCLUDE_AND_CONTINUE;
                    }
                    for (String facetIdOfRootNode : facetIds = (String[])endNode.getProperty("facets")) {
                        if (!facetIdOfRootNode.equals(facetId)) continue;
                        return Evaluation.INCLUDE_AND_CONTINUE;
                    }
                }
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
        EdgeTypes relType = StringUtils.isBlank((String)facetId) ? EdgeTypes.IS_BROADER_THAN : RelationshipType.withName((String)(EdgeTypes.IS_BROADER_THAN.name() + "_" + facetId));
        TraversalDescription td = graphDb.traversalDescription().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).depthFirst().relationships((RelationshipType)relType, Direction.INCOMING).evaluator(rootConceptEvaluator);
        try (Transaction tx = graphDb.beginTx();){
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < conceptIds.length(); ++i) {
                String conceptId = conceptIds.getString(i);
                conceptId = QueryParser.escape((String)conceptId);
                sb.append(idType).append(":").append(conceptId);
                if (i >= conceptIds.length() - 1) continue;
                sb.append(" ");
            }
            String conceptQuery = sb.toString();
            Index conceptIndex = graphDb.index().forNodes("termIndex");
            IndexHits indexHits = conceptIndex.query((Object)conceptQuery);
            ResourceIterator startNodeIterator = indexHits.iterator();
            Node[] startNodes = new Node[indexHits.size()];
            for (int i = 0; i < indexHits.size(); ++i) {
                if (!startNodeIterator.hasNext()) {
                    throw new IllegalStateException(indexHits.size() + " index hits for start nodes expected but iterator expired unexpectedly.");
                }
                startNodes[i] = (Node)startNodeIterator.next();
            }
            Traverser traverse = td.traverse(startNodes);
            ArrayList<String[]> pathsConceptIds = new ArrayList<String[]>();
            int c = 0;
            for (Path p : traverse) {
                log.info("Path nr. " + c++ + ":" + p.toString());
                String[] pathConceptIds = new String[p.length() + 1];
                Iterator nodesIt = p.nodes().iterator();
                boolean error = false;
                for (int i = p.length(); i >= 0; --i) {
                    if (!nodesIt.hasNext()) {
                        throw new IllegalStateException("Length of path wrong, more nodes expected.");
                    }
                    Node n = (Node)nodesIt.next();
                    if (!n.hasProperty("id")) {
                        log.warn("Came across the concept " + n + " (" + NodeUtilities.getNodePropertiesAsString((PropertyContainer)n) + ") when computing root paths. But this concept does not have an ID.");
                        error = true;
                        break;
                    }
                    pathConceptIds[i] = (String)n.getProperty("id");
                }
                if (error) continue;
                pathsConceptIds.add(pathConceptIds);
            }
            if (sort) {
                Collections.sort(pathsConceptIds, new Comparator<String[]>(){

                    @Override
                    public int compare(String[] o1, String[] o2) {
                        return o1.length - o2.length;
                    }
                });
            }
            HashMap<String, Object> pathsWrappedInMap = new HashMap<String, Object>();
            pathsWrappedInMap.put(RET_KEY_PATHS, pathsConceptIds);
            RecursiveMappingRepresentation recursiveMappingRepresentation = new RecursiveMappingRepresentation(Representation.MAP, pathsWrappedInMap);
            return recursiveMappingRepresentation;
        }
    }

    private void insertAggregateConcept(GraphDatabaseService graphDb, Index<Node> conceptIndex, JSONObject jsonConcept, CoordinatesMap nodesByCoordinates, InsertionReport insertionReport, ImportOptions importOptions) throws AggregateConceptInsertionException {
        try {
            JSONArray copyProperties;
            boolean includeAggreationInHierarchy;
            JSONObject aggCoordinates = jsonConcept.has("coordinates") ? jsonConcept.getJSONObject("coordinates") : new JSONObject();
            String aggOrgId = JSON.getString(aggCoordinates, "originalId");
            String aggOrgSource = JSON.getString(aggCoordinates, "originalSource");
            String aggSrcId = JSON.getString(aggCoordinates, "sourceId");
            String aggSource = JSON.getString(aggCoordinates, "source");
            if (null == aggSource) {
                aggSource = UNKNOWN_CONCEPT_SOURCE;
            }
            log.trace("Looking up aggregate ({}, {}) / ({}, {}), original/source coordinates.", aggOrgId, aggOrgSource, aggSrcId, aggSource);
            Node aggregate = this.lookupConcept(new ConceptCoordinates(aggCoordinates, false), conceptIndex);
            if (null != aggregate) {
                String isHollowMessage = "";
                if (aggregate.hasLabel((Label)ConceptLabel.HOLLOW)) {
                    isHollowMessage = ", however it is hollow and its properties will be set now.";
                }
                log.trace("    aggregate does already exist {}", (Object)isHollowMessage);
                if (!aggregate.hasLabel((Label)ConceptLabel.HOLLOW)) {
                    return;
                }
                aggregate.removeLabel((Label)ConceptLabel.HOLLOW);
                aggregate.addLabel((Label)ConceptLabel.AGGREGATE);
            }
            if (aggregate == null) {
                log.trace("    aggregate is being created");
                aggregate = graphDb.createNode(new Label[]{ConceptLabel.AGGREGATE});
            }
            boolean bl = includeAggreationInHierarchy = jsonConcept.has("aggregateIncludeInHierarchy") && jsonConcept.getBoolean("aggregateIncludeInHierarchy");
            if (includeAggreationInHierarchy) {
                aggregate.addLabel((Label)ConceptLabel.CONCEPT);
            }
            JSONArray elementCoords = jsonConcept.getJSONArray("elementCoordinates");
            log.trace("    looking up aggregate elements");
            for (int i = 0; i < elementCoords.length(); ++i) {
                Node element;
                JSONObject elementCoord = elementCoords.getJSONObject(i);
                String elementSrcId = elementCoord.getString("id");
                String elementSource = elementCoord.getString("source");
                if (null == elementSource) {
                    elementSource = UNKNOWN_CONCEPT_SOURCE;
                }
                if (null != (element = nodesByCoordinates.get(new ConceptCoordinates(elementSrcId, elementSource, false)))) {
                    String[] srcIds = (String[])element.getProperty("sourceIds");
                    String[] sources = element.hasProperty("sources") ? (String[])element.getProperty("sources") : new String[]{};
                    for (int j = 0; j < srcIds.length; ++j) {
                        String source;
                        String srcId = srcIds[j];
                        String string = source = sources.length > j ? sources[j] : null;
                        if (!srcId.equals(elementSrcId) || elementSource == null && source == null || elementSource.equals(source)) break;
                        element = null;
                    }
                    if (null != element) {
                        log.trace("\tFound element with source ID and source ({}, {}) in in-memory map.", (Object)elementSrcId, (Object)elementSource);
                    }
                }
                if (null == element) {
                    element = this.lookupConceptBySourceId(elementSrcId, elementSource, false, conceptIndex);
                }
                if (null == element && importOptions.createHollowAggregateElements) {
                    element = graphDb.createNode(new Label[]{ConceptLabel.CONCEPT, ConceptLabel.HOLLOW});
                    log.trace("    Creating HOLLOW element with source coordinates ({}, {})", (Object)elementSrcId, (Object)elementSource);
                    PropertyUtilities.addToArrayProperty((PropertyContainer)element, "sourceIds", elementSrcId);
                    PropertyUtilities.addToArrayProperty((PropertyContainer)element, "sources", elementSource);
                    conceptIndex.add((PropertyContainer)element, "sourceIds", (Object)elementSrcId);
                }
                if (element == null) continue;
                aggregate.createRelationshipTo(element, (RelationshipType)EdgeTypes.HAS_ELEMENT);
            }
            if (null != aggSrcId) {
                int idIndex = PropertyUtilities.findFirstValueInArrayProperty(aggregate, "sourceIds", aggSrcId);
                int sourceIndex = PropertyUtilities.findFirstValueInArrayProperty(aggregate, "sources", aggSource);
                if (!StringUtils.isBlank((String)aggSrcId) && (idIndex == -1 && sourceIndex == -1 || idIndex != sourceIndex)) {
                    PropertyUtilities.addToArrayProperty((PropertyContainer)aggregate, "sourceIds", aggSrcId, true);
                    PropertyUtilities.addToArrayProperty((PropertyContainer)aggregate, "sources", aggSource, true);
                }
                nodesByCoordinates.put(new ConceptCoordinates(aggCoordinates), aggregate);
                conceptIndex.add((PropertyContainer)aggregate, "sourceIds", (Object)aggSrcId);
            }
            if (null != aggOrgId) {
                aggregate.setProperty("originalId", (Object)aggOrgId);
            }
            if (null != aggOrgSource) {
                aggregate.setProperty("originalSource", (Object)aggOrgSource);
            }
            if (null != (copyProperties = JSON.getJSONArray(jsonConcept, "copyProperties")) && copyProperties.length() > 0) {
                aggregate.setProperty("copyProperties", (Object)JSON.json2JavaArray(copyProperties, new Object[0]));
            }
            JSONArray generalLabels = JSON.getJSONArray(jsonConcept, "labels");
            for (int i = 0; null != generalLabels && i < generalLabels.length(); ++i) {
                aggregate.addLabel(Label.label((String)generalLabels.getString(i)));
            }
            String aggregateId = "atid" + SequenceManager.getNextSequenceValue(graphDb, "seqAggregateTerm");
            aggregate.setProperty("id", (Object)aggregateId);
            conceptIndex.add((PropertyContainer)aggregate, "id", (Object)aggregateId);
            ++insertionReport.numConcepts;
        }
        catch (Exception e) {
            throw new AggregateConceptInsertionException("Aggregate concept creation failed for aggregate " + jsonConcept, e);
        }
    }

    private void insertConcept(GraphDatabaseService graphDb, String facetId, Index<Node> conceptIndex, JSONObject jsonConcept, CoordinatesMap nodesByCoordinates, InsertionReport insertionReport, ImportOptions importOptions) throws JSONException {
        String prefName = JSON.getString(jsonConcept, "preferredName");
        JSONArray synonyms = JSON.getJSONArray(jsonConcept, "synonyms");
        JSONArray generalLabels = JSON.getJSONArray(jsonConcept, "labels");
        JSONObject coordinatesJson = jsonConcept.getJSONObject("coordinates");
        ConceptCoordinates coordinates = new ConceptCoordinates(coordinatesJson);
        if (!jsonConcept.has("coordinates") || coordinatesJson.length() == 0) {
            throw new IllegalArgumentException("The concept " + jsonConcept.toString(2) + " does not specify coordinates.");
        }
        String srcId = importOptions.merge ? JSON.getString(coordinatesJson, "sourceId") : coordinatesJson.getString("sourceId");
        String orgId = JSON.getString(coordinatesJson, "originalId");
        String source = JSON.getString(coordinatesJson, "source");
        String orgSource = JSON.getString(coordinatesJson, "originalSource");
        boolean uniqueSourceId = JSON.getBoolean(coordinatesJson, "uniqueSourceId", false);
        boolean srcIduniqueMarkerChanged = false;
        if (StringUtils.isBlank((String)srcId) && !StringUtils.isBlank((String)orgId) && (StringUtils.isBlank((String)source) && !StringUtils.isBlank((String)orgSource) || source.equals(orgSource))) {
            srcId = orgId;
            source = orgSource;
        }
        if (StringUtils.isBlank((String)source)) {
            source = UNKNOWN_CONCEPT_SOURCE;
        }
        if (StringUtils.isBlank((String)orgId) ^ StringUtils.isBlank((String)orgSource)) {
            throw new IllegalArgumentException("Concept to be inserted defines only its original ID or its original source but not both. This is not allowed. The concept data was: " + jsonConcept);
        }
        if (importOptions.merge && jsonConcept.has("parentCoordinates")) {
            throw new IllegalArgumentException("Concept " + jsonConcept + " is supposed to be merged with an existing database concept but defines parents. This is currently not supported in merging mode.");
        }
        Node concept = nodesByCoordinates.get(coordinates);
        if (concept == null && !importOptions.merge) {
            throw new IllegalStateException("No concept node was found or created for import concept with coordinates " + coordinatesJson + " and this is not a merging operation.");
        }
        if (concept == null) {
            return;
        }
        if (concept.hasLabel((Label)ConceptLabel.HOLLOW)) {
            log.trace("Got HOLLOW concept node with coordinates " + coordinatesJson + " and will create full concept.");
            concept.removeLabel((Label)ConceptLabel.HOLLOW);
            concept.addLabel((Label)ConceptLabel.CONCEPT);
            Iterable relationships = concept.getRelationships(new RelationshipType[]{EdgeTypes.HAS_ROOT_CONCEPT});
            for (Relationship rel : relationships) {
                Node startNode = rel.getStartNode();
                if (!startNode.hasLabel((Label)FacetManager.FacetLabel.FACET)) continue;
                rel.delete();
            }
            String conceptId = "tid" + SequenceManager.getNextSequenceValue(graphDb, "seqTerm");
            concept.setProperty("id", (Object)conceptId);
            conceptIndex.putIfAbsent((PropertyContainer)concept, "id", (Object)conceptId);
        }
        if (!StringUtils.isBlank((String)coordinates.originalId) && !concept.hasProperty("originalId")) {
            concept.setProperty("originalId", (Object)coordinates.originalId);
            concept.setProperty("originalSource", (Object)coordinates.originalSource);
        }
        PropertyUtilities.mergeJSONObjectIntoPropertyContainer(jsonConcept, (PropertyContainer)concept, "labels", "sourceIds", "sources", "synonyms", "coordinates", "parentCoordinates", "relationships");
        int idIndex = PropertyUtilities.findFirstValueInArrayProperty(concept, "sourceIds", srcId);
        int sourceIndex = PropertyUtilities.findFirstValueInArrayProperty(concept, "sources", source);
        if (!StringUtils.isBlank((String)srcId) && (idIndex == -1 && sourceIndex == -1 || idIndex != sourceIndex)) {
            if (concept.hasProperty("sourceIds")) {
                srcIduniqueMarkerChanged = this.checkUniqueIdMarkerClash(concept, srcId, uniqueSourceId);
            }
            PropertyUtilities.addToArrayProperty((PropertyContainer)concept, "sourceIds", srcId, true);
            PropertyUtilities.addToArrayProperty((PropertyContainer)concept, "sources", source, true);
            PropertyUtilities.addToArrayProperty((PropertyContainer)concept, "uniqueSourceId", uniqueSourceId, true);
        }
        PropertyUtilities.mergeArrayProperty((PropertyContainer)concept, "synonyms", JSON.json2JavaArray(synonyms, prefName));
        PropertyUtilities.addToArrayProperty((PropertyContainer)concept, "facets", facetId);
        for (int i = 0; null != generalLabels && i < generalLabels.length(); ++i) {
            concept.addLabel(Label.label((String)generalLabels.getString(i)));
        }
        if (srcIduniqueMarkerChanged) {
            log.warn("Merging concept nodes with unique source ID " + srcId + " because on concept with this source ID and source " + source + " the ID was declared non-unique in the past but unique now. Properties from all nodes are merged together and relationships are moved from obsolete nodes to the single remaining node. This is experimental and might lead to errors.");
            ArrayList<Node> obsoleteNodes = new ArrayList<Node>();
            Node mergedNode = NodeUtilities.mergeConceptNodesWithUniqueSourceId(srcId, conceptIndex, obsoleteNodes);
            for (Node obsoleteNode : obsoleteNodes) {
                Iterable relationships = obsoleteNode.getRelationships();
                for (Relationship rel : relationships) {
                    Node startNode = rel.getStartNode();
                    Node endNode = rel.getEndNode();
                    if (startNode.getId() == obsoleteNode.getId()) {
                        startNode = mergedNode;
                    }
                    if (endNode.getId() == obsoleteNode.getId()) {
                        endNode = mergedNode;
                    }
                    this.createRelationShipIfNotExists(startNode, endNode, rel.getType(), insertionReport, Direction.OUTGOING, rel.getAllProperties());
                    rel.delete();
                    obsoleteNode.delete();
                }
            }
        }
        if (StringUtils.isBlank((String)prefName) && !insertionReport.existingConcepts.contains(concept)) {
            throw new IllegalArgumentException("Concept has no property \"preferredName\": " + jsonConcept);
        }
    }

    private boolean checkUniqueIdMarkerClash(Node conceptNode, String srcId, boolean uniqueSourceId) {
        boolean uniqueOnConcept = NodeUtilities.isSourceUnique(conceptNode, srcId);
        return !uniqueOnConcept && uniqueOnConcept != uniqueSourceId;
    }

    private InsertionReport insertConcepts(GraphDatabaseService graphDb, JSONArray jsonConcepts, String facetId, CoordinatesMap nodesByCoordinates, ImportOptions importOptions) throws ConceptInsertionException {
        try {
            JSONObject jsonConcept;
            long time = System.currentTimeMillis();
            InsertionReport insertionReport = new InsertionReport();
            Index conceptIndex = null;
            IndexManager indexManager = graphDb.index();
            conceptIndex = indexManager.forNodes("termIndex");
            CoordinatesSet toBeCreated = new CoordinatesSet();
            if (!importOptions.merge) {
                for (int i = 0; i < jsonConcepts.length(); ++i) {
                    JSONObject jsonConcept2 = jsonConcepts.getJSONObject(i);
                    if (!jsonConcept2.has("parentCoordinates") || jsonConcept2.getJSONArray("parentCoordinates").length() <= 0) continue;
                    JSONArray parentCoordinatesArray = jsonConcept2.getJSONArray("parentCoordinates");
                    for (int j = 0; j < parentCoordinatesArray.length(); ++j) {
                        ConceptCoordinates parentCoordinates = new ConceptCoordinates(parentCoordinatesArray.getJSONObject(j));
                        Node parentNode = this.lookupConcept(parentCoordinates, (Index<Node>)conceptIndex);
                        if (parentNode != null) {
                            insertionReport.addExistingConcept(parentNode);
                            nodesByCoordinates.put(parentCoordinates, parentNode);
                            continue;
                        }
                        toBeCreated.add(parentCoordinates);
                    }
                }
            }
            ArrayList<Integer> importConceptsToRemove = new ArrayList<Integer>();
            for (int i = 0; i < jsonConcepts.length(); ++i) {
                jsonConcept = jsonConcepts.getJSONObject(i);
                ConceptCoordinates coordinates = null;
                if (!jsonConcept.has("coordinates")) {
                    if (JSON.getBoolean(jsonConcept, "aggregate")) continue;
                    throw new IllegalArgumentException("Concept " + jsonConcept + " does not define concept coordinates.");
                }
                coordinates = new ConceptCoordinates(jsonConcept.getJSONObject("coordinates"));
                insertionReport.addImportedCoordinates(coordinates);
                if (nodesByCoordinates.containsKey(coordinates) || toBeCreated.contains(coordinates, true)) continue;
                Node conceptNode = this.lookupConcept(coordinates, (Index<Node>)conceptIndex);
                if (conceptNode != null) {
                    insertionReport.addExistingConcept(conceptNode);
                    nodesByCoordinates.put(coordinates, conceptNode);
                    continue;
                }
                if (!importOptions.merge) {
                    toBeCreated.add(coordinates);
                    continue;
                }
                importConceptsToRemove.add(i);
            }
            for (ConceptCoordinates coordinates : toBeCreated) {
                Node conceptNode = this.registerNewHollowConceptNode(graphDb, coordinates, (Index<Node>)conceptIndex, new Label[0]);
                ++insertionReport.numConcepts;
                nodesByCoordinates.put(coordinates, conceptNode);
            }
            log.info("removing " + importConceptsToRemove.size() + " input concepts that should be omitted because we are merging and don't have them in the database");
            for (int index = importConceptsToRemove.size() - 1; index >= 0; --index) {
                jsonConcepts.remove(((Integer)importConceptsToRemove.get(index)).intValue());
            }
            importConceptsToRemove = null;
            log.info("Starting to insert " + jsonConcepts.length() + " concepts.");
            for (int i = 0; i < jsonConcepts.length(); ++i) {
                jsonConcept = jsonConcepts.getJSONObject(i);
                boolean isAggregate = JSON.getBoolean(jsonConcept, "aggregate");
                if (isAggregate) {
                    this.insertAggregateConcept(graphDb, (Index<Node>)conceptIndex, jsonConcept, nodesByCoordinates, insertionReport, importOptions);
                    continue;
                }
                this.insertConcept(graphDb, facetId, (Index<Node>)conceptIndex, jsonConcept, nodesByCoordinates, insertionReport, importOptions);
            }
            log.debug(jsonConcepts.length() + " concepts inserted.");
            time = System.currentTimeMillis() - time;
            log.info(insertionReport.numConcepts + " new concepts - but not yet relationships - have been inserted. This took " + time + " ms (" + time / 1000L + " s)");
            return insertionReport;
        }
        catch (JSONException e) {
            throw new ConceptInsertionException(e);
        }
    }

    private Node registerNewHollowConceptNode(GraphDatabaseService graphDb, ConceptCoordinates coordinates, Index<Node> conceptIndex, Label ... additionalLabels) {
        Node node = graphDb.createNode(new Label[]{ConceptLabel.HOLLOW});
        for (int i = 0; i < additionalLabels.length; ++i) {
            Label label = additionalLabels[i];
            node.addLabel(label);
        }
        log.trace("Created new HOLLOW concept node for coordinates {}", (Object)coordinates);
        if (!StringUtils.isBlank((String)coordinates.originalId)) {
            node.setProperty("originalId", (Object)coordinates.originalId);
            node.setProperty("originalSource", (Object)coordinates.originalSource);
        }
        node.setProperty("sourceIds", (Object)new String[]{coordinates.sourceId});
        node.setProperty("sources", (Object)new String[]{coordinates.source});
        node.setProperty("uniqueSourceId", (Object)new boolean[]{coordinates.uniqueSourceId});
        if (!StringUtils.isBlank((String)coordinates.sourceId)) {
            conceptIndex.putIfAbsent((PropertyContainer)node, "sourceIds", (Object)coordinates.sourceId);
        }
        if (!StringUtils.isBlank((String)coordinates.originalId)) {
            conceptIndex.putIfAbsent((PropertyContainer)node, "originalId", (Object)coordinates.originalId);
        }
        return node;
    }

    public Representation insertConcepts(GraphDatabaseService graphDb, String conceptsWithFacet) throws JSONException, ConceptInsertionException {
        JSONObject input = new JSONObject(conceptsWithFacet);
        JSONObject jsonFacet = JSON.getJSONObject(input, KEY_FACET);
        JSONArray jsonConcepts = input.getJSONArray("concepts");
        JSONObject importOptionsJson = JSON.getJSONObject(input, KEY_IMPORT_OPTIONS);
        return this.insertConcepts(graphDb, jsonFacet != null ? jsonFacet.toString() : null, jsonConcepts.toString(), importOptionsJson != null ? importOptionsJson.toString() : null);
    }

    @Name(value="insert_concepts")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation insertConcepts(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="facet", optional=true) String facetJson, @Description(value="TODO") @Parameter(name="concepts", optional=true) String conceptsJson, @Description(value="TODO") @Parameter(name="importOptions", optional=true) String importOptionsJsonString) throws JSONException, ConceptInsertionException {
        ImportOptions importOptions;
        log.info("{} was called", (Object)INSERT_CONCEPTS);
        long time = System.currentTimeMillis();
        Gson gson = new Gson();
        log.debug("Parsing input.");
        JSONObject jsonFacet = null;
        JSONArray jsonConcepts = null;
        JSONObject importOptionsJson = null;
        JSONObject jSONObject = jsonFacet = !StringUtils.isEmpty((String)facetJson) ? new JSONObject(facetJson) : null;
        if (null != conceptsJson) {
            jsonConcepts = new JSONArray(conceptsJson);
            log.info("Got {} input concepts for import.", (Object)jsonConcepts.length());
        } else {
            log.info("Got 0 input concepts for import.");
        }
        if (null != importOptionsJsonString) {
            importOptionsJson = new JSONObject(importOptionsJsonString);
            importOptions = gson.fromJson(importOptionsJson.toString(), ImportOptions.class);
        } else {
            importOptions = new ImportOptions();
        }
        HashMap<String, Object> report = new HashMap<String, Object>();
        InsertionReport insertionReport = new InsertionReport();
        log.debug("Beginning processing of concept insertion.");
        try (Transaction tx = graphDb.beginTx();){
            Node facet = null;
            String facetId = null;
            log.debug("Handling import of facet.");
            if (null != jsonFacet && jsonFacet.has("id")) {
                facetId = jsonFacet.getString("id");
                log.info("Facet ID {} has been given to add the concepts to.", (Object)facetId);
                boolean isNoFacet = JSON.getBoolean(jsonFacet, "noFacet");
                facet = isNoFacet ? FacetManager.getNoFacet(graphDb, facetId) : FacetManager.getFacetNode(graphDb, facetId);
                if (null == facet) {
                    throw new IllegalArgumentException("The facet with ID \"" + facetId + "\" was not found. You must pass the ID of an existing facet or deliver all information required to create the facet from scratch. Then, the facetId must not be included in the request, it will be created dynamically.");
                }
            } else if (null != jsonFacet && jsonFacet.has("name")) {
                ResourceIterator facetIterator = graphDb.findNodes((Label)FacetManager.FacetLabel.FACET);
                while (facetIterator.hasNext() && !(facet = (Node)facetIterator.next()).getProperty("name").equals(jsonFacet.getString("name"))) {
                    facet = null;
                }
            }
            if (null != jsonFacet && null == facet) {
                facet = FacetManager.createFacet(graphDb, jsonFacet);
            }
            if (null != facet) {
                facetId = (String)facet.getProperty("id");
                log.debug("Facet {} was successfully created or determined by ID.", (Object)facetId);
            } else {
                log.debug("No facet was specified for this import. This is currently equivalent to specifying the merge import option, i.e. concept properties will be merged but no new nodes or relationships will be created.");
                importOptions.merge = true;
            }
            if (null != jsonConcepts) {
                log.debug("Beginning to create concept nodes and relationships.");
                CoordinatesMap nodesByCoordinates = new CoordinatesMap();
                insertionReport = this.insertConcepts(graphDb, jsonConcepts, facetId, nodesByCoordinates, importOptions);
                if (!nodesByCoordinates.isEmpty() && !importOptions.merge) {
                    this.createRelationships(graphDb, jsonConcepts, facet, nodesByCoordinates, importOptions, insertionReport);
                } else {
                    log.info("This is a property merging import, no relationships are created.");
                }
                time = System.currentTimeMillis() - time;
                report.put(RET_KEY_NUM_CREATED_CONCEPTS, insertionReport.numConcepts);
                report.put(RET_KEY_NUM_CREATED_RELS, insertionReport.numRelationships);
                report.put(KEY_FACET_ID, facetId);
                report.put(KEY_TIME, time);
                log.debug("Done creating concepts and relationships.");
            } else {
                log.info("No concepts were included in the request.");
            }
            tx.success();
        }
        log.info("Concept insertion complete.");
        log.info("insert_concepts is finished processing after " + time + " ms. " + insertionReport.numConcepts + " concepts and " + insertionReport.numRelationships + " relationships have been created.");
        return new RecursiveMappingRepresentation(Representation.MAP, report);
    }

    private Node lookupConcept(ConceptCoordinates coordinates, Index<Node> conceptIndex) {
        Node concept;
        String orgId = coordinates.originalId;
        String orgSource = coordinates.originalSource;
        String srcId = coordinates.sourceId;
        String source = coordinates.source;
        boolean uniqueSourceId = coordinates.uniqueSourceId;
        log.trace("Looking up concept via original ID and source ({}, {}) and source ID and source ({}, {}).", orgId, orgSource, srcId, source);
        if (!(null != orgId && null != orgSource || null != srcId && null != source)) {
            log.debug("Neither original ID and original source nor source ID and source were given, returning null.");
            return null;
        }
        Node node = concept = null != orgId ? (Node)conceptIndex.get("originalId", (Object)orgId).getSingle() : null;
        if (concept != null) {
            log.trace("Found concept by original ID {}", (Object)orgId);
        }
        if (null != concept) {
            if (!PropertyUtilities.hasSamePropertyValue((PropertyContainer)concept, "originalSource", orgSource)) {
                log.trace("Original source doesn't match; requested: {}, found concept has: {}", (Object)orgSource, (Object)NodeUtilities.getString(concept, "originalSource"));
                concept = null;
            } else {
                log.trace("Found existing concept for original ID {} and original source {}", (Object)orgId, (Object)orgSource);
            }
        }
        if (null == concept && null != srcId && null != (concept = this.lookupConceptBySourceId(srcId, source, uniqueSourceId, conceptIndex))) {
            Object existingOrgId = NodeUtilities.getNonNullNodeProperty((PropertyContainer)concept, "originalId");
            Object existingOrgSrc = NodeUtilities.getNonNullNodeProperty((PropertyContainer)concept, "originalSource");
            if (!(null == existingOrgId || null == existingOrgSrc || null == orgId || null == orgSource || existingOrgId.equals(orgId) && existingOrgSrc.equals(orgSource))) {
                throw new IllegalStateException(String.format("Inconsistent data: A newly imported concept has original ID, original source (%s, %s) and source ID, source (%s, %s); the latter matches the found concept with ID %s but a this concept has an original ID and source (%s, %s)", orgId, orgSource, srcId, source, NodeUtilities.getNonNullNodeProperty((PropertyContainer)concept, "id"), existingOrgId, existingOrgSrc));
            }
        }
        if (null == concept) {
            log.trace("    Did not find an existing concept with original ID and source ({}, {}) or source ID and source ({}, {}).", orgId, orgSource, srcId, source);
        }
        return concept;
    }

    private Node lookupConceptBySourceId(String srcId, String source, boolean uniqueSourceId, Index<Node> conceptIndex) {
        log.trace("Trying to look up existing concept by source ID and source ({}, {})", (Object)srcId, (Object)source);
        IndexHits indexHits = conceptIndex.get("sourceIds", (Object)srcId);
        if (!indexHits.hasNext()) {
            log.trace("    Did not find any concept with source ID {}", (Object)srcId);
        }
        Node soughtConcept = null;
        boolean uniqueSourceIdNodeFound = false;
        while (indexHits.hasNext()) {
            Set<String> sources;
            boolean uniqueOnConceptNode;
            Node conceptNode = (Node)indexHits.next();
            if (null == conceptNode) continue;
            if (uniqueSourceId && (uniqueOnConceptNode = NodeUtilities.isSourceUnique(conceptNode, srcId))) {
                if (soughtConcept == null) {
                    soughtConcept = conceptNode;
                } else if (uniqueSourceIdNodeFound) {
                    throw new IllegalStateException("There are multiple concept nodes with unique source ID " + srcId + ". This means that some sources define the ID as unique and others not. This can lead to an inconsistent database as happened in this case.");
                }
                log.trace("    Found existing concept with unique source ID {} which matches given unique source ID", (Object)srcId);
                uniqueSourceIdNodeFound = true;
            }
            if (!(sources = NodeUtilities.getSourcesForSourceId(conceptNode, srcId)).contains(source)) {
                log.debug("    Did not find a match for source ID " + srcId + " and source " + source);
                conceptNode = null;
            } else {
                log.debug("    Found existing concept for source ID " + srcId + " and source " + source);
            }
            if (soughtConcept == null) {
                soughtConcept = conceptNode;
                continue;
            }
            if (uniqueSourceIdNodeFound) continue;
            throw new IllegalStateException("There are multiple concept nodes with source ID " + srcId + " and source " + source);
        }
        return soughtConcept;
    }

    @Name(value="pop_concepts_from_set")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation popConceptsFromSet(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="label") String labelString, @Description(value="TODO") @Parameter(name="amount") int amount) {
        Label label = Label.label((String)labelString);
        ArrayList<Node> poppedConcepts = new ArrayList<Node>(amount);
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable nodesWithLabel = () -> graphDb.findNodes(label);
            Node concept = null;
            ResourceIterator it = nodesWithLabel.iterator();
            for (int popCount = 0; it.hasNext() && popCount < amount; ++popCount) {
                concept = (Node)it.next();
                poppedConcepts.add(concept);
            }
            tx.success();
        }
        tx = graphDb.beginTx();
        var7_7 = null;
        try {
            for (Node concept : poppedConcepts) {
                concept.removeLabel(label);
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("concepts", poppedConcepts);
        return new RecursiveMappingRepresentation(Representation.MAP, retMap);
    }

    @Name(value="push_concepts_to_set")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public long pushConceptsToSet(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="conceptPushCommand") String conceptPushCommandString, @Description(value="The amount of concepts to push into the set. If equal or less than zero or omitted, all concepts will be pushed.") @Parameter(name="amount", optional=true) Integer amount) {
        Gson gson = new Gson();
        PushConceptsToSetCommand cmd = gson.fromJson(conceptPushCommandString, PushConceptsToSetCommand.class);
        Label setLabel = Label.label((String)cmd.setName);
        HashSet<String> facetsWithSpecifiedGeneralLabel = new HashSet<String>();
        PushConceptsToSetCommand.ConceptSelectionDefinition eligibleConceptDefinition = cmd.eligibleConceptDefinition;
        PushConceptsToSetCommand.ConceptSelectionDefinition excludeDefinition = cmd.excludeConceptDefinition;
        Label facetLabel = null;
        if (null != eligibleConceptDefinition && null != eligibleConceptDefinition.facetLabel) {
            facetLabel = Label.label((String)eligibleConceptDefinition.facetLabel);
        }
        String facetPropertyKey = null != eligibleConceptDefinition ? eligibleConceptDefinition.facetPropertyKey : "*";
        String facetPropertyValue = null != eligibleConceptDefinition ? eligibleConceptDefinition.facetPropertyValue : "*";
        try (Transaction tx = graphDb.beginTx();){
            Node facetGroupsNode = FacetManager.getFacetGroupsNode(graphDb);
            TraversalDescription facetTraversal = PredefinedTraversals.getFacetTraversal(graphDb, facetPropertyKey, facetPropertyValue);
            Traverser traverse = facetTraversal.traverse(facetGroupsNode);
            for (Path path : traverse) {
                Node facetNode = path.endNode();
                if (null != facetLabel && !facetNode.hasLabel(facetLabel)) continue;
                facetsWithSpecifiedGeneralLabel.add((String)facetNode.getProperty("id"));
            }
            tx.success();
        }
        log.info("Deconceptined " + facetsWithSpecifiedGeneralLabel.size() + " facets with given restrictions.");
        long numberOfConceptsAdded = 0L;
        long numberOfConceptsToAdd = null != amount && amount > 0 ? (long)amount.intValue() : Long.MAX_VALUE;
        Transaction tx = graphDb.beginTx();
        Object object = null;
        try {
            ConceptLabel eligibleConceptLabel = ConceptLabel.CONCEPT;
            if (null != eligibleConceptDefinition && !StringUtils.isBlank((String)eligibleConceptDefinition.conceptLabel)) {
                eligibleConceptLabel = Label.label((String)eligibleConceptDefinition.conceptLabel);
            }
            ResourceIterator conceptIt = graphDb.findNodes((Label)eligibleConceptLabel);
            while (conceptIt.hasNext() && numberOfConceptsAdded < numberOfConceptsToAdd) {
                for (int i = 0; conceptIt.hasNext() && i < 10000 && numberOfConceptsAdded < numberOfConceptsToAdd; ++i) {
                    Node concept = (Node)conceptIt.next();
                    if (null != excludeDefinition) {
                        Label conceptLabel;
                        boolean exclude = false;
                        String conceptPropertyKey = excludeDefinition.conceptPropertyKey;
                        String conceptPropertyValue = excludeDefinition.conceptPropertyValue;
                        Label label = conceptLabel = excludeDefinition.conceptLabel == null ? null : Label.label((String)excludeDefinition.conceptLabel);
                        if (concept.hasProperty(conceptPropertyKey)) {
                            Object property = concept.getProperty(conceptPropertyKey);
                            if (property.getClass().isArray()) {
                                Object[] propertyArray;
                                for (Object o : propertyArray = (Object[])property) {
                                    if (!o.equals(conceptPropertyValue)) continue;
                                    exclude = true;
                                    break;
                                }
                            } else if (property.equals(conceptPropertyValue)) {
                                exclude = true;
                            }
                        }
                        if (concept.hasLabel(conceptLabel)) {
                            exclude = true;
                        }
                        if (exclude) continue;
                    }
                    boolean hasFacetWithCorrectGeneralLabel = false;
                    if (null != eligibleConceptDefinition) {
                        String[] facetIds;
                        if (concept.hasLabel((Label)ConceptLabel.HOLLOW)) continue;
                        if (!concept.hasProperty("facets")) {
                            log.warn("Concept with internal ID " + concept.getId() + " has no facets property.");
                            continue;
                        }
                        for (String facetId : facetIds = (String[])concept.getProperty("facets")) {
                            if (!facetsWithSpecifiedGeneralLabel.contains(facetId)) continue;
                            hasFacetWithCorrectGeneralLabel = true;
                            break;
                        }
                    }
                    if (!hasFacetWithCorrectGeneralLabel && null != eligibleConceptDefinition) continue;
                    concept.addLabel(setLabel);
                    ++numberOfConceptsAdded;
                }
            }
            tx.success();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        log.info("Finished pushing " + numberOfConceptsAdded + " concepts to set \"" + cmd.setName + "\".");
        return numberOfConceptsAdded;
    }

    @Name(value="update_children_information")
    @Description(value="Updates - or creates - the information which concept has children in which facets. This information is used in Semedico to either render an 'opening' arrow next to a concept to display its children, or no 'drill-down' option depending on whether the concept in question has children in the facet it is shown in or not.")
    @PluginTarget(value=GraphDatabaseService.class)
    public String updateChildrenInformation(@Source GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterator conceptIt = graphDb.findNodes((Label)ConceptLabel.CONCEPT);
            while (conceptIt.hasNext()) {
                Node concept = (Node)conceptIt.next();
                Iterator relIt = concept.getRelationships(Direction.OUTGOING).iterator();
                HashSet<String> facetsContainingChildren = new HashSet<String>();
                while (relIt.hasNext()) {
                    String[] typeNameParts;
                    String lastPart;
                    Relationship rel = (Relationship)relIt.next();
                    String type = rel.getType().name();
                    if (!type.startsWith(EdgeTypes.IS_BROADER_THAN.toString()) || !(lastPart = (typeNameParts = type.split("_"))[typeNameParts.length - 1]).startsWith("fid")) continue;
                    facetsContainingChildren.add(lastPart);
                }
                if (facetsContainingChildren.size() == 0 && concept.hasProperty("childrenInFacets")) {
                    concept.removeProperty("childrenInFacets");
                    continue;
                }
                if (facetsContainingChildren.size() <= 0) continue;
                concept.setProperty("childrenInFacets", (Object)facetsContainingChildren.toArray(new String[facetsContainingChildren.size()]));
            }
            tx.success();
            String string = "success";
            return string;
        }
    }

    @Name(value="include_concepts")
    @Description(value="This is only a remedy for a problem we shouldnt have, delete in the future.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void includeConcepts(@Source GraphDatabaseService graphDb) throws JSONException {
        Label includeLabel = Label.label((String)"INCLUDE");
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable concepts = () -> graphDb.findNodes(includeLabel);
            for (Node concept : concepts) {
                concept.removeLabel(includeLabel);
            }
            tx.success();
        }
        HashSet<String> facetIds = new HashSet<String>();
        try (Transaction tx = graphDb.beginTx();){
            Node facetGroupsNode = FacetManager.getFacetGroupsNode(graphDb);
            TraversalDescription facetTraversal = PredefinedTraversals.getFacetTraversal(graphDb, null, null);
            Traverser traverse = facetTraversal.traverse(facetGroupsNode);
            for (Path path : traverse) {
                Node facetNode = path.endNode();
                facetIds.add((String)facetNode.getProperty("id"));
            }
            log.info("Including concepts from facets " + facetIds);
            tx.success();
        }
        tx = graphDb.beginTx();
        var5_5 = null;
        try {
            ResourceIterable concepts = () -> graphDb.findNodes((Label)ConceptLabel.CONCEPT);
            block29: for (Node concept : concepts) {
                if (!concept.hasProperty("facets")) {
                    log.info("Doesnt have facets: " + PropertyUtilities.getNodePropertiesAsString((PropertyContainer)concept));
                    continue;
                }
                String[] facets = (String[])concept.getProperty("facets");
                for (int i = 0; i < facets.length; ++i) {
                    String string = facets[i];
                    if (!facetIds.contains(string)) continue;
                    concept.addLabel(includeLabel);
                    continue block29;
                }
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Name(value="exclude_concepts")
    @Description(value="This is only a remedy for a problem we shouldnt have, delete in the future.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void excludeConcepts(@Source GraphDatabaseService graphDb) throws JSONException {
        ResourceIterable concepts;
        Label includeLabel = Label.label((String)"INCLUDE");
        Label excludeLabel = Label.label((String)"EXCLUDE");
        Label mappingAggregateLabel = Label.label((String)"MAPPING_AGGREGATE");
        try (Transaction tx = graphDb.beginTx();){
            concepts = () -> graphDb.findNodes((Label)ConceptLabel.CONCEPT);
            for (Node concept : concepts) {
                if (!concept.hasLabel(includeLabel)) {
                    concept.addLabel(excludeLabel);
                    concept.removeLabel(mappingAggregateLabel);
                    concept.removeLabel((Label)ConceptLabel.AGGREGATE);
                    concept.removeLabel((Label)ConceptLabel.CONCEPT);
                    continue;
                }
                concept.addLabel(mappingAggregateLabel);
            }
            tx.success();
        }
        tx = graphDb.beginTx();
        var6_6 = null;
        try {
            concepts = () -> graphDb.findNodes((Label)ConceptLabel.AGGREGATE);
            for (Node a : concepts) {
                a.removeLabel((Label)ConceptLabel.AGGREGATE);
                a.removeLabel(mappingAggregateLabel);
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Name(value="insert_mappings")
    @Description(value="Adds a set of concept mappings to the database. Here, a 'mapping' between two concepts means that those concepts are 'similar' to one another. The actual similarity - e.g. 'equal' or 'related' - is defined by the type of the mapping. Here, all mappings are interpreted as being symmetric. That does not mean that two relationships are created but that reading commands don't care about the relationship direction.")
    @PluginTarget(value=GraphDatabaseService.class)
    public int insertMappings(@Source GraphDatabaseService graphDb, @Description(value="An array of mappings in JSON format. Each mapping is an object with the keys for \"id1\", \"id2\" and \"mappingType\", respectively.") @Parameter(name="mappings") String mappingsJson) throws JSONException {
        JSONArray mappings = new JSONArray(mappingsJson);
        log.info("Starting to insert " + mappings.length() + " mappings.");
        try (Transaction tx = graphDb.beginTx();){
            Index conceptIndex = graphDb.index().forNodes("termIndex");
            HashMap<String, Node> nodesBySrcId = new HashMap<String, Node>(mappings.length());
            InsertionReport insertionReport = new InsertionReport();
            for (int i = 0; i < mappings.length(); ++i) {
                Node n2;
                JSONObject mapping = mappings.getJSONObject(i);
                String id1 = mapping.getString("id1");
                String id2 = mapping.getString("id2");
                String mappingType = mapping.getString("mappingType");
                log.debug("Inserting mapping " + id1 + " -" + mappingType + "- " + id2);
                if (StringUtils.isBlank((String)id1)) {
                    throw new IllegalArgumentException("id1 in mapping \"" + mapping + "\" is missing.");
                }
                if (StringUtils.isBlank((String)id2)) {
                    throw new IllegalArgumentException("id2 in mapping \"" + mapping + "\" is missing.");
                }
                if (StringUtils.isBlank((String)mappingType)) {
                    throw new IllegalArgumentException("mappingType in mapping \"" + mapping + "\" is missing.");
                }
                Node n1 = (Node)nodesBySrcId.get(id1);
                if (null == n1) {
                    IndexHits indexHits = conceptIndex.get("sourceIds", (Object)id1);
                    if (indexHits.size() > 1) {
                        log.error("More than one node for source ID {}", (Object)id1);
                        for (Node n : indexHits) {
                            log.error(NodeUtilities.getNodePropertiesAsString((PropertyContainer)n));
                        }
                        throw new IllegalStateException("More than one node for source ID " + id1);
                    }
                    n1 = (Node)indexHits.getSingle();
                    if (null == n1) {
                        log.warn("There is no concept with source ID \"" + id1 + "\" as required by the mapping \"" + mapping + "\" Mapping is skipped.");
                        continue;
                    }
                    nodesBySrcId.put(id1, n1);
                }
                if (null == (n2 = (Node)nodesBySrcId.get(id2))) {
                    n2 = (Node)conceptIndex.get("sourceIds", (Object)id2).getSingle();
                    if (null == n2) {
                        log.warn("There is no concept with source ID \"" + id2 + "\" as required by the mapping \"" + mapping + "\" Mapping is skipped.");
                        continue;
                    }
                    nodesBySrcId.put(id2, n2);
                }
                if (mappingType.equalsIgnoreCase("LOOM")) {
                    String facet;
                    int j;
                    String[] n1Facets = (String[])n1.getProperty("facets");
                    String[] n2Facets = (String[])n2.getProperty("facets");
                    HashSet<String> n1FacetSet = new HashSet<String>();
                    HashSet<String> n2FacetSet = new HashSet<String>();
                    for (j = 0; j < n1Facets.length; ++j) {
                        facet = n1Facets[j];
                        n1FacetSet.add(facet);
                    }
                    for (j = 0; j < n2Facets.length; ++j) {
                        facet = n2Facets[j];
                        n2FacetSet.add(facet);
                    }
                    if (!Sets.intersection(n1FacetSet, n2FacetSet).isEmpty()) {
                        log.debug("Omitting LOOM mapping between " + id1 + " and " + id2 + " because both concepts appear in the same conceptinology. We assume that the conceptinology does not have two equal concepts and that LOOM is wrong here.");
                        continue;
                    }
                }
                insertionReport.addExistingConcept(n1);
                insertionReport.addExistingConcept(n2);
                this.createRelationShipIfNotExists(n1, n2, EdgeTypes.IS_MAPPED_TO, insertionReport, Direction.BOTH, "mappingType", new String[]{mappingType});
            }
            tx.success();
            log.info(insertionReport.numRelationships + " of " + mappings.length() + " new mappings successfully added.");
            int n = insertionReport.numRelationships;
            return n;
        }
    }

    @Name(value="get_facet_roots")
    @Description(value="Returns root concepts for the facets with specified IDs. Can also be restricted to particular roots which is useful for facets that have a lot of roots.")
    @PluginTarget(value=GraphDatabaseService.class)
    public MappingRepresentation getFacetRoots(@Source GraphDatabaseService graphDb, @Description(value="An array of facet IDs in JSON format.") @Parameter(name="facetIds") String facetIdsJson, @Description(value="An array of concept IDs to restrict the retrieval to.") @Parameter(name="conceptIds", optional=true) String conceptIdsJson, @Description(value="Restricts the facets to those that have at most the specified number of roots.") @Parameter(name="maxRoots", optional=true) long maxRoots) throws JSONException {
        HashMap<String, Object> facetRoots = new HashMap<String, Object>();
        JSONArray facetIdsArray = new JSONArray(facetIdsJson);
        HashSet<String> requestedFacetIds = new HashSet<String>();
        for (int i = 0; i < facetIdsArray.length(); ++i) {
            requestedFacetIds.add(facetIdsArray.getString(i));
        }
        HashMap requestedConceptIds = null;
        if (!StringUtils.isBlank((String)conceptIdsJson) && !conceptIdsJson.equals("null")) {
            JSONObject conceptIdsObject = new JSONObject(conceptIdsJson);
            requestedConceptIds = new HashMap();
            JSONArray facetIds = conceptIdsObject.names();
            for (int i = 0; null != facetIds && i < facetIds.length(); ++i) {
                String facetId = facetIds.getString(i);
                JSONArray requestedRootIdsForFacet = conceptIdsObject.getJSONArray(facetId);
                HashSet<String> idSet = new HashSet<String>();
                for (int j = 0; j < requestedRootIdsForFacet.length(); ++j) {
                    idSet.add(requestedRootIdsForFacet.getString(j));
                }
                requestedConceptIds.put(facetId, idSet);
            }
        }
        try (Transaction tx = graphDb.beginTx();){
            log.info("Returning roots for facets " + requestedFacetIds);
            Node facetGroupsNode = FacetManager.getFacetGroupsNode(graphDb);
            TraversalDescription facetTraversal = PredefinedTraversals.getFacetTraversal(graphDb, null, null);
            Traverser traverse = facetTraversal.traverse(facetGroupsNode);
            for (Path path : traverse) {
                Node facetNode = path.endNode();
                String facetId = (String)facetNode.getProperty("id");
                if (maxRoots > 0L && facetNode.hasProperty("numRoots") && (Long)facetNode.getProperty("numRoots") > maxRoots) {
                    log.info("Skipping facet with ID {} because it has more than {} root concepts ({}).", facetId, maxRoots, facetNode.getProperty("numRoots"));
                }
                Set requestedIdSet = null;
                if (null != requestedConceptIds) {
                    requestedIdSet = (Set)requestedConceptIds.get(facetId);
                }
                if (!requestedFacetIds.contains(facetId)) continue;
                ArrayList<Node> roots = new ArrayList<Node>();
                Iterable relationships = facetNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{EdgeTypes.HAS_ROOT_CONCEPT});
                for (Relationship rel : relationships) {
                    String rootId;
                    Node rootConcept = rel.getEndNode();
                    boolean include = true;
                    if (null != requestedIdSet && !requestedIdSet.contains(rootId = (String)rootConcept.getProperty("id"))) {
                        include = false;
                    }
                    if (!include) continue;
                    roots.add(rootConcept);
                }
                if (!(roots.isEmpty() || maxRoots > 0L && (long)roots.size() > maxRoots)) {
                    facetRoots.put(facetId, roots);
                    continue;
                }
                log.info("Skipping facet with ID " + facetId + " because it has more than " + maxRoots + " root concepts (" + roots.size() + ").");
            }
            tx.success();
        }
        return new RecursiveMappingRepresentation(Representation.MAP, facetRoots);
    }

    @Name(value="add_concept_term")
    @Description(value="Allows to add writing variants and acronyms to concepts in the database. For each type of data (variants and acronyms) there is a parameter of its own. It is allowed to omit a parameter value. The expected format is {'tid1': {'docID1': {'variant1': count1, 'variant2': count2, ...}, 'docID2': {...}}, 'tid2':...} for both variants and acronyms.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void addWritingVariants(@Source GraphDatabaseService graphDb, @Description(value="A JSON object mapping concept IDs to an array of writing variants to add to the existing writing variants.") @Parameter(name="conceptTerms", optional=true) String conceptVariants, @Description(value="A JSON object mapping concept IDs to an array of acronyms to add to the existing concept acronyms.") @Parameter(name="conceptAcronyms", optional=true) String conceptAcronyms) throws JSONException {
        if (null != conceptVariants) {
            this.addConceptVariant(graphDb, conceptVariants, "writingVariants");
        }
        if (null != conceptAcronyms) {
            this.addConceptVariant(graphDb, conceptAcronyms, "acronyms");
        }
    }

    private void addConceptVariant(GraphDatabaseService graphDb, String conceptVariants, String type) {
        EdgeTypes variantRelationshipType;
        MorphoLabel variantNodeLabel;
        MorphoLabel variantsAggregationLabel;
        if (type.equals("writingVariants")) {
            variantsAggregationLabel = MorphoLabel.WRITING_VARIANTS;
            variantNodeLabel = MorphoLabel.WRITING_VARIANT;
            variantRelationshipType = EdgeTypes.HAS_VARIANTS;
        } else if (type.equals("acronyms")) {
            variantsAggregationLabel = MorphoLabel.ACRONYMS;
            variantNodeLabel = MorphoLabel.ACRONYM;
            variantRelationshipType = EdgeTypes.HAS_ACRONYMS;
        } else {
            throw new IllegalArgumentException("Unknown lexico-morphological type \"" + type + "\".");
        }
        try (StringReader stringReader = new StringReader(conceptVariants);){
            JsonReader jsonReader = new JsonReader(stringReader);
            try (Transaction tx = graphDb.beginTx();){
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    Node variantsNode;
                    String conceptId = jsonReader.nextName();
                    HashMap variantCountsInDocs = new HashMap();
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        String docId = jsonReader.nextName();
                        jsonReader.beginObject();
                        TreeMap<String, Integer> variantCounts = new TreeMap<String, Integer>(new TermVariantComparator());
                        while (jsonReader.hasNext()) {
                            String variant = jsonReader.nextName();
                            int count = jsonReader.nextInt();
                            if (variantCounts.containsKey(variant)) {
                                Integer currentCount = (Integer)variantCounts.get(variant);
                                variantCounts.put(variant, currentCount + count);
                                continue;
                            }
                            variantCounts.put(variant, count);
                        }
                        jsonReader.endObject();
                        variantCountsInDocs.put(docId, variantCounts);
                    }
                    jsonReader.endObject();
                    if (variantCountsInDocs.isEmpty()) {
                        log.debug("Concept with ID " + conceptId + " has no writing variants / acronyms attached.");
                        continue;
                    }
                    Node concept = graphDb.findNode((Label)ConceptLabel.CONCEPT, "id", (Object)conceptId);
                    if (null == concept) {
                        log.warn("Concept with ID " + conceptId + " was not found, cannot add writing variants / acronyms.");
                        continue;
                    }
                    Relationship hasVariantsRel = concept.getSingleRelationship((RelationshipType)variantRelationshipType, Direction.OUTGOING);
                    if (null == hasVariantsRel) {
                        variantsNode = graphDb.createNode(new Label[]{variantsAggregationLabel});
                        hasVariantsRel = concept.createRelationshipTo(variantsNode, (RelationshipType)variantRelationshipType);
                    }
                    variantsNode = hasVariantsRel.getEndNode();
                    for (String docId : variantCountsInDocs.keySet()) {
                        Map variantCounts = (Map)variantCountsInDocs.get(docId);
                        for (String variant : variantCounts.keySet()) {
                            String normalizedVariant = TermVariantComparator.normalizeVariant(variant);
                            Node variantNode = graphDb.findNode((Label)variantNodeLabel, "id", (Object)normalizedVariant);
                            if (null == variantNode) {
                                variantNode = graphDb.createNode(new Label[]{variantNodeLabel});
                                variantNode.setProperty("id", (Object)normalizedVariant);
                                variantNode.setProperty("name", (Object)variant);
                            }
                            Relationship specificElementRel = null;
                            for (Relationship elementRel : variantNode.getRelationships(Direction.INCOMING, new RelationshipType[]{EdgeTypes.HAS_ELEMENT})) {
                                if (!elementRel.getStartNode().equals(variantsNode) || !elementRel.getEndNode().equals(variantNode)) continue;
                                specificElementRel = elementRel;
                                break;
                            }
                            if (null == specificElementRel) {
                                specificElementRel = variantsNode.createRelationshipTo(variantNode, (RelationshipType)EdgeTypes.HAS_ELEMENT);
                                specificElementRel.setProperty("documents", (Object)new String[0]);
                                specificElementRel.setProperty("counts", (Object)new int[0]);
                            }
                            Object[] documents = (String[])specificElementRel.getProperty("documents");
                            int[] counts = (int[])specificElementRel.getProperty("counts");
                            int docIndex = Arrays.binarySearch(documents, docId);
                            Integer count = (Integer)variantCounts.get(variant);
                            if (docIndex >= 0) {
                                counts[docIndex] = count;
                                continue;
                            }
                            int insertionPoint = -1 * (docIndex + 1);
                            String[] newDocuments = new String[documents.length + 1];
                            int[] newCounts = new int[newDocuments.length];
                            if (insertionPoint > 0) {
                                System.arraycopy(documents, 0, newDocuments, 0, insertionPoint);
                                System.arraycopy(counts, 0, newCounts, 0, insertionPoint);
                            }
                            newDocuments[insertionPoint] = docId;
                            newCounts[insertionPoint] = count;
                            if (insertionPoint < documents.length) {
                                System.arraycopy(documents, insertionPoint, newDocuments, insertionPoint + 1, documents.length - insertionPoint);
                                System.arraycopy(counts, insertionPoint, newCounts, insertionPoint + 1, counts.length - insertionPoint);
                            }
                            specificElementRel.setProperty("documents", (Object)newDocuments);
                            specificElementRel.setProperty("counts", (Object)newCounts);
                        }
                    }
                }
                jsonReader.endObject();
                jsonReader.close();
                tx.success();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String[] getPropertyValueOfElements(Node aggregate, String property) {
        if (!aggregate.hasLabel((Label)ConceptLabel.AGGREGATE)) {
            throw new IllegalArgumentException("Node " + NodeUtilities.getNodePropertiesAsString((PropertyContainer)aggregate) + " is not an aggregate.");
        }
        Iterable elementRels = aggregate.getRelationships(Direction.OUTGOING, new RelationshipType[]{EdgeTypes.HAS_ELEMENT});
        ArrayList<String> elementValues = new ArrayList<String>();
        for (Relationship elementRel : elementRels) {
            String[] value = NodeUtilities.getNodePropertyAsStringArrayValue(elementRel.getEndNode(), property);
            for (int i = 0; value != null && i < value.length; ++i) {
                elementValues.add(value[i]);
            }
        }
        return elementValues.isEmpty() ? null : elementValues.toArray(new String[elementValues.size()]);
    }

    public static enum MorphoLabel implements Label
    {
        WRITING_VARIANTS,
        ACRONYMS,
        WRITING_VARIANT,
        ACRONYM;

    }

    public static enum ConceptLabel implements Label
    {
        AGGREGATE,
        AGGREGATE_EQUAL_NAMES,
        HOLLOW,
        CONCEPT,
        AGGREGATE_ELEMENT;

    }

    private class InsertionReport {
        public Set<String> createdRelationshipsCache = new HashSet<String>();
        public Set<Node> existingConcepts = new HashSet<Node>();
        public Set<String> omittedConcepts = new HashSet<String>();
        public CoordinatesSet importedCoordinates = new CoordinatesSet();
        public int numRelationships = 0;
        public int numConcepts = 0;

        private InsertionReport() {
        }

        public void addCreatedRelationship(Node source, Node target, RelationshipType type) {
            this.createdRelationshipsCache.add(this.getRelationshipIdentifier(source, target, type));
        }

        public void addExistingConcept(Node concept) {
            this.existingConcepts.add(concept);
        }

        private String getRelationshipIdentifier(Node source, Node target, RelationshipType type) {
            return source.getId() + type.name() + target.getId();
        }

        public boolean relationshipAlreadyWasCreated(Node source, Node target, RelationshipType type) {
            return this.createdRelationshipsCache.contains(this.getRelationshipIdentifier(source, target, type));
        }

        public void addImportedCoordinates(ConceptCoordinates coordinates) {
            this.importedCoordinates.add(coordinates);
        }
    }

    public static enum EdgeTypes implements RelationshipType
    {
        HAS_ELEMENT,
        HAS_ROOT_CONCEPT,
        HAS_SAME_NAMES,
        IS_BROADER_THAN,
        IS_MAPPED_TO,
        HAS_VARIANTS,
        HAS_ACRONYMS;

    }
}

