/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.datarepresentation;

import com.google.gson.annotations.SerializedName;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacetTermRelationship;
import de.julielab.neo4j.plugins.datarepresentation.TermCoordinates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ImportConcept {
    @SerializedName(value="preferredName")
    public String prefName;
    @SerializedName(value="descriptions")
    public List<String> descriptions;
    @SerializedName(value="synonyms")
    public List<String> synonyms;
    @SerializedName(value="writingVariants")
    public List<String> writingVariants;
    @SerializedName(value="coordinates")
    public ConceptCoordinates coordinates;
    @SerializedName(value="parentCoordinates")
    public List<ConceptCoordinates> parentCoordinates;
    @SerializedName(value="relationships")
    public List<ImportFacetTermRelationship> relationships;
    @SerializedName(value="generalLabels")
    public List<String> generalLabels;
    @SerializedName(value="displayName")
    public String displayName;
    @SerializedName(value="qualifiers")
    public List<String> qualifiers;
    @SerializedName(value="obsolete")
    public Boolean obsolete;
    @SerializedName(value="aggregate")
    public Boolean aggregate;
    @SerializedName(value="elementSrcIds")
    @Deprecated
    public List<String> elementSrcIds;
    @SerializedName(value="elementSources")
    @Deprecated
    public List<String> elementSources;
    @SerializedName(value="elementCoordinates")
    public List<TermCoordinates> elementCoordinates;
    @SerializedName(value="copyProperties")
    public List<String> copyProperties;
    @SerializedName(value="aggregateSources")
    @Deprecated
    public List<String> aggregateSources;
    @SerializedName(value="aggregateIncludeInHierarchy")
    public Boolean aggregateIncludeInHierarchy;

    public ImportConcept(String preferredName, ConceptCoordinates coordinates) {
        this.prefName = preferredName;
        this.coordinates = coordinates;
    }

    public ImportConcept(String preferredName, String description, ConceptCoordinates coordinates) {
        this(preferredName, coordinates);
        this.descriptions = Arrays.asList(description);
    }

    public ImportConcept(String preferredName, List<String> synonyms, ConceptCoordinates coordinates) {
        this(preferredName, coordinates);
        this.synonyms = synonyms;
    }

    public ImportConcept(String preferredName, List<String> synonyms, String description, ConceptCoordinates coordinates) {
        this(preferredName, synonyms, coordinates);
        this.descriptions = Arrays.asList(description);
    }

    public ImportConcept(String preferredName, List<String> synonyms, String description, ConceptCoordinates coordinates, ConceptCoordinates parentCoordinates) {
        this(preferredName, synonyms, Arrays.asList(description), coordinates, Arrays.asList(parentCoordinates));
    }

    public ImportConcept(String preferredName, List<String> synonyms, String description, ConceptCoordinates coordinates, List<ConceptCoordinates> parentCoordinates) {
        this(preferredName, synonyms, Arrays.asList(description), coordinates, parentCoordinates);
    }

    public ImportConcept(String preferredName, List<String> synonyms, List<String> descriptions, ConceptCoordinates coordinates) {
        this(preferredName, synonyms, coordinates);
        this.descriptions = descriptions;
    }

    public ImportConcept(String preferredName, List<String> synonyms, List<String> descriptions, ConceptCoordinates coordinates, ConceptCoordinates parentCoordinates) {
        this(preferredName, synonyms, descriptions, coordinates);
        this.parentCoordinates = Arrays.asList(parentCoordinates);
    }

    public ImportConcept(String preferredName, List<String> synonyms, List<String> descriptions, ConceptCoordinates coordinates, List<ConceptCoordinates> parentCoordinates) {
        this(preferredName, synonyms, descriptions, coordinates);
        this.parentCoordinates = parentCoordinates;
    }

    public ImportConcept(String preferredName, List<String> synonyms, List<String> descriptions, ConceptCoordinates coordinates, List<ConceptCoordinates> parentCoordinates, Boolean obsolete) {
        this(preferredName, synonyms, descriptions, coordinates);
        this.parentCoordinates = parentCoordinates;
        this.obsolete = obsolete;
    }

    public ImportConcept(String preferredName, ConceptCoordinates coordinates, ConceptCoordinates parentCoordinates) {
        this(preferredName, coordinates);
        this.parentCoordinates = Arrays.asList(parentCoordinates);
    }

    public ImportConcept(String preferredName, ConceptCoordinates coordinates, List<ConceptCoordinates> parentCoordinates) {
        this(preferredName, coordinates);
        this.parentCoordinates = parentCoordinates;
    }

    public ImportConcept(List<TermCoordinates> elementCoords, List<String> copyProperties) {
        this.elementCoordinates = elementCoords;
        this.copyProperties = copyProperties;
        this.aggregate = true;
    }

    public ImportConcept(ConceptCoordinates conceptCoordinates) {
        this.coordinates = conceptCoordinates;
    }

    public ImportConcept() {
    }

    public void addRelationship(ImportFacetTermRelationship relationship) {
        if (null == this.relationships) {
            this.relationships = new ArrayList<ImportFacetTermRelationship>();
        }
        this.relationships.add(relationship);
    }

    public void addGeneralLabel(String ... labels) {
        if (null == this.generalLabels) {
            this.generalLabels = new ArrayList<String>();
        }
        try {
            for (int i = 0; i < labels.length; ++i) {
                String label = labels[i];
                this.generalLabels.add(label);
            }
        }
        catch (UnsupportedOperationException e) {
            this.generalLabels = new ArrayList<String>(this.generalLabels);
            this.addGeneralLabel(labels);
        }
    }

    public void addElementSourceId(String sourceId) {
        if (null == this.elementSrcIds) {
            this.elementSrcIds = new ArrayList<String>();
        }
        this.elementSrcIds.add(sourceId);
    }

    public void addCopyProperty(String property) {
        if (null == this.copyProperties) {
            this.copyProperties = new ArrayList<String>();
        }
        this.copyProperties.add(property);
    }

    public void addQualifier(String speciesQualifier) {
        if (null == this.qualifiers) {
            this.qualifiers = new ArrayList<String>();
        }
        this.qualifiers.add(speciesQualifier);
    }

    public void removeGeneralLabel(String ... labels) {
        if (null == this.generalLabels || this.generalLabels.isEmpty()) {
            return;
        }
        HashSet<String> removeLabels = new HashSet<String>(labels.length);
        for (int i = 0; i < labels.length; ++i) {
            String label = labels[i];
            removeLabels.add(label);
        }
        Iterator<String> existingLabels = this.generalLabels.iterator();
        while (existingLabels.hasNext()) {
            String existingLabel = existingLabels.next();
            if (!removeLabels.contains(existingLabel)) continue;
            existingLabels.remove();
        }
    }

    public void addParent(ConceptCoordinates parentCoordinates) {
        if (this.parentCoordinates == null) {
            this.parentCoordinates = new ArrayList<ConceptCoordinates>();
        }
        this.parentCoordinates.add(parentCoordinates);
    }

    public void addParentIfNotExists(ConceptCoordinates parentCoordinates) {
        if (this.parentCoordinates == null || this.parentCoordinates.isEmpty() || !this.parentCoordinates.contains(parentCoordinates)) {
            this.addParent(parentCoordinates);
        }
    }

    public boolean hasParents() {
        return this.parentCoordinates != null && !this.parentCoordinates.isEmpty();
    }
}

