/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import java.util.NoSuchElementException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;

public class SequenceManager {
    private static final String SEQUENCE_INDEX = "sequenceIndex";

    public static int getNextSequenceValue(GraphDatabaseService graphDb, String seqFacetGroup) {
        try (Transaction tx = graphDb.beginTx();){
            Node sequence = SequenceManager.getSequence(graphDb, seqFacetGroup);
            tx.acquireReadLock((PropertyContainer)sequence);
            tx.acquireWriteLock((PropertyContainer)sequence);
            int currentSequenceValue = (Integer)sequence.getProperty("value");
            sequence.setProperty("value", (Object)(currentSequenceValue + 1));
            tx.success();
            int n = currentSequenceValue;
            return n;
        }
    }

    static Node getSequenceRoot(GraphDatabaseService graphDb) {
        Index rootIndex = graphDb.index().forNodes("rootNodeIndex");
        Node seqRoot = (Node)rootIndex.get("name", (Object)"sequencesRoot").getSingle();
        if (null == seqRoot) {
            seqRoot = graphDb.createNode();
            seqRoot.setProperty("name", (Object)"sequencesRoot");
            rootIndex.add((PropertyContainer)seqRoot, "name", (Object)"sequencesRoot");
        }
        return seqRoot;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized Node getSequence(GraphDatabaseService graphDb, String seqFacetGroup) {
        Index seqIndex = graphDb.index().forNodes(SEQUENCE_INDEX);
        try (IndexHits indexHits = seqIndex.get("name", (Object)seqFacetGroup);){
            Node sequence = (Node)indexHits.getSingle();
            if (null == sequence) {
                Node seqRoot = SequenceManager.getSequenceRoot(graphDb);
                sequence = graphDb.createNode();
                sequence.setProperty("name", (Object)seqFacetGroup);
                sequence.setProperty("value", (Object)0);
                seqIndex.putIfAbsent((PropertyContainer)sequence, "name", (Object)seqFacetGroup);
                seqRoot.createRelationshipTo(sequence, (RelationshipType)EdgeTypes.HAS_SEQUENCE);
            }
            Node node = sequence;
            return node;
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("More than one sequence node for the sequence with name \"" + seqFacetGroup + "\" was returned.", e);
        }
    }

    static enum Labels implements Label
    {
        SEQUENCE_ROOT;

    }

    static enum EdgeTypes implements RelationshipType
    {
        HAS_SEQUENCE;

    }
}

