/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import de.julielab.neo4j.plugins.ConceptManager;
import de.julielab.neo4j.plugins.FacetManager;
import de.julielab.neo4j.plugins.evaluators.FacetGroupPathEvaluator;
import de.julielab.neo4j.plugins.evaluators.HasRelationShipEvaluator;
import de.julielab.neo4j.plugins.evaluators.NodeLabelEvaluator;
import de.julielab.neo4j.plugins.evaluators.PropertyEvaluator;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;

public class PredefinedTraversals {
    public static TraversalDescription getFacetTraversal(GraphDatabaseService graphDb) {
        return PredefinedTraversals.getFacetTraversal(graphDb, null, null);
    }

    public static TraversalDescription getFacetTraversal(GraphDatabaseService graphDb, String propertyKey, Object propertyValue) {
        if (StringUtils.isBlank((String)propertyKey)) {
            propertyKey = "*";
        }
        if (null == propertyValue || "".equals(propertyValue)) {
            propertyValue = "*";
        }
        TraversalDescription td = graphDb.traversalDescription().depthFirst().relationships((RelationshipType)FacetManager.EdgeTypes.HAS_FACET_GROUP).relationships((RelationshipType)FacetManager.EdgeTypes.HAS_FACET).evaluator(Evaluators.atDepth((int)2));
        if (!"*".equals(propertyKey) || !"*".equals(propertyValue)) {
            td = td.evaluator((Evaluator)new PropertyEvaluator(propertyKey, propertyValue));
        }
        return td;
    }

    public static TraversalDescription getFacetGroupTraversal(GraphDatabaseService graphDb, String facetGroupName) {
        TraversalDescription td = graphDb.traversalDescription().depthFirst().relationships((RelationshipType)FacetManager.EdgeTypes.HAS_FACET_GROUP).evaluator((Evaluator)new FacetGroupPathEvaluator(facetGroupName));
        return td;
    }

    public static TraversalDescription getAcronymsTraversal(GraphDatabaseService graphDb) {
        TraversalDescription td = graphDb.traversalDescription().depthFirst().relationships((RelationshipType)ConceptManager.EdgeTypes.HAS_ACRONYMS, Direction.OUTGOING).relationships((RelationshipType)ConceptManager.EdgeTypes.HAS_ELEMENT, Direction.OUTGOING).evaluator((Evaluator)new NodeLabelEvaluator(ConceptManager.MorphoLabel.ACRONYM));
        return td;
    }

    public static TraversalDescription getWritingVariantsTraversal(GraphDatabaseService graphDb) {
        TraversalDescription td = graphDb.traversalDescription().depthFirst().relationships((RelationshipType)ConceptManager.EdgeTypes.HAS_VARIANTS, Direction.OUTGOING).relationships((RelationshipType)ConceptManager.EdgeTypes.HAS_ELEMENT, Direction.OUTGOING).evaluator((Evaluator)new NodeLabelEvaluator(ConceptManager.MorphoLabel.WRITING_VARIANT));
        return td;
    }

    public static TraversalDescription getNonAggregateAggregateElements(GraphDatabaseService graphDb) {
        TraversalDescription td = graphDb.traversalDescription().depthFirst().relationships((RelationshipType)ConceptManager.EdgeTypes.HAS_ELEMENT).evaluator((Evaluator)new NodeLabelEvaluator(ConceptManager.TermLabel.AGGREGATE, true));
        return td;
    }

    public static TraversalDescription getTopAggregates(GraphDatabaseService graphDb) {
        TraversalDescription td = graphDb.traversalDescription().breadthFirst().relationships((RelationshipType)ConceptManager.EdgeTypes.HAS_ELEMENT).evaluator((Evaluator)new HasRelationShipEvaluator(Direction.INCOMING, new RelationshipType[]{ConceptManager.EdgeTypes.HAS_ELEMENT}, false));
        return td;
    }
}

