/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins;

import de.julielab.neo4j.plugins.ConceptManager;
import de.julielab.neo4j.plugins.auxiliaries.JSON;
import de.julielab.neo4j.plugins.auxiliaries.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.PredefinedTraversals;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.constants.semedico.NodeConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.TraversalMetadata;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.RecursiveMappingRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

@Description(value="This plugin offers access to facets for Semedico.")
public class FacetManager
extends ServerPlugin {
    public static final String KEY_FACETS = "facets";
    public static final String KEY_ID = "id";
    public static final String GET_FACETS = "get_facets";
    public static final String INSERT_FACETS = "insert_facets";
    public static final String GET_FACET_SIZE = "get_facet_size";
    public static final String PARAM_RETURN_HOLLOW_FACETS = "returnHollowFacets";
    private static final Logger log = Logger.getLogger(FacetManager.class.getName());

    @Name(value="get_facet_size")
    @Description(value="Returns the size of a facet by counting all the related children")
    @PluginTarget(value=GraphDatabaseService.class)
    public int getFacetSize(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="id") String fid) {
        return FacetManager.countFacetChildren(graphDb, fid);
    }

    @Name(value="insert_facets")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public ListRepresentation insertFacets(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="facets") String facetList) throws JSONException {
        JSONArray input = new JSONArray(new String(facetList));
        ArrayList<Node> facets = new ArrayList<Node>();
        for (int i = 0; i < input.length(); ++i) {
            JSONObject jsonFacet = input.getJSONObject(i);
            Node facet = FacetManager.createFacet(graphDb, jsonFacet);
            facets.add(facet);
        }
        try (Transaction tx = graphDb.beginTx();){
            ArrayList<RecursiveMappingRepresentation> facetRepList = new ArrayList<RecursiveMappingRepresentation>();
            for (Node facet : facets) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", facet.getProperty("name"));
                map.put(KEY_ID, facet.getProperty(KEY_ID));
                RecursiveMappingRepresentation facetResponseRep = new RecursiveMappingRepresentation(Representation.MAP, map);
                facetRepList.add(facetResponseRep);
            }
            ListRepresentation listRep = new ListRepresentation(Representation.MAP, facetRepList);
            tx.success();
            ListRepresentation listRepresentation = listRep;
            return listRepresentation;
        }
    }

    @Name(value="get_facets")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public MappingRepresentation getFacets(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="returnHollowFacets", optional=true) Boolean returnHollowfacets) {
        RecursiveMappingRepresentation facetGroupsRep;
        try (Transaction tx = graphDb.beginTx();){
            Node facetGroupsNode = FacetManager.getFacetGroupsNode(graphDb);
            TraversalDescription td = PredefinedTraversals.getFacetTraversal(graphDb);
            Traverser traverse = td.traverse(facetGroupsNode);
            HashMap<String, ArrayList<Node>> facetsByFacetGroupName = new HashMap<String, ArrayList<Node>>();
            HashMap<String, Node> facetGroupsMap = new HashMap<String, Node>();
            ArrayList facetGroupsWithFacetsList = new ArrayList();
            for (Path facetPath : traverse) {
                boolean isFacetWithoutPredefinedRoots;
                Node facet = facetPath.endNode();
                Object sourceType = facet.getProperty("sourceType");
                boolean bl = isFacetWithoutPredefinedRoots = sourceType.equals("strings") || sourceType.equals("facetAggregation") || sourceType.equals("flat");
                if (!isFacetWithoutPredefinedRoots) {
                    Iterator rootIt = facet.getRelationships(new RelationshipType[]{ConceptManager.EdgeTypes.HAS_ROOT_TERM}).iterator();
                    if (!rootIt.hasNext()) continue;
                    if (!returnHollowfacets.booleanValue()) {
                        boolean onlyHollowRoots = true;
                        while (rootIt.hasNext() && onlyHollowRoots) {
                            Node rootTerm = ((Relationship)rootIt.next()).getEndNode();
                            boolean isHollow = false;
                            for (Label label : rootTerm.getLabels()) {
                                if (!label.equals((Object)ConceptManager.TermLabel.HOLLOW)) continue;
                                isHollow = true;
                                break;
                            }
                            if (isHollow) continue;
                            onlyHollowRoots = false;
                        }
                        if (onlyHollowRoots) continue;
                    }
                }
                Iterable facetRels = facet.getRelationships(Direction.INCOMING, new RelationshipType[]{EdgeTypes.HAS_FACET});
                Iterator onlyHollowRoots = facetRels.iterator();
                while (onlyHollowRoots.hasNext()) {
                    Relationship facetRel = (Relationship)onlyHollowRoots.next();
                    Node facetGroupNode = facetRel.getStartNode();
                    String facetGroupName = (String)facetGroupNode.getProperty("name");
                    facetGroupsMap.put(facetGroupName, facetGroupNode);
                    ArrayList<Node> facets = (ArrayList<Node>)facetsByFacetGroupName.get(facetGroupName);
                    if (facets == null) {
                        facets = new ArrayList<Node>();
                        facetsByFacetGroupName.put(facetGroupName, facets);
                    }
                    facets.add(facet);
                }
            }
            for (String facetGroupName : facetsByFacetGroupName.keySet()) {
                Node facetGroupNode = (Node)facetGroupsMap.get(facetGroupName);
                Object facets = facetsByFacetGroupName.get(facetGroupName);
                HashMap<String, Object> facetGroupMap = new HashMap<String, Object>();
                for (String propKey : facetGroupNode.getPropertyKeys()) {
                    facetGroupMap.put(propKey, facetGroupNode.getProperty(propKey));
                }
                ArrayList<String> facetGroupLabels = new ArrayList<String>();
                for (Label label : facetGroupNode.getLabels()) {
                    facetGroupLabels.add(label.name());
                }
                facetGroupMap.put("labels", facetGroupLabels);
                facetGroupMap.put(KEY_FACETS, facets);
                facetGroupsWithFacetsList.add(facetGroupMap);
            }
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("facetGroups", facetGroupsWithFacetsList);
            facetGroupsRep = new RecursiveMappingRepresentation(Representation.MAP, ret);
            tx.success();
        }
        return facetGroupsRep;
    }

    public static Node createFacet(GraphDatabaseService graphDb, JSONObject jsonFacet) throws JSONException {
        log.info("Creating facet with the following data: " + jsonFacet);
        String sourceName = JSON.getString(jsonFacet, "sourceName");
        JSONArray generalLabels = JSON.getJSONArray(jsonFacet, "generalLabels");
        JSONArray uniqueLabels = JSON.getJSONArray(jsonFacet, "uniqueLabels");
        boolean isNoFacet = JSON.getBoolean(jsonFacet, "noFacet");
        JSONObject jsonFacetGroup = jsonFacet.getJSONObject("facetGroup");
        try (Transaction tx = graphDb.beginTx();){
            Label label;
            String labelString;
            int i;
            Node facetGroupsNode = isNoFacet ? FacetManager.getNoFacetGroupsNode(graphDb) : FacetManager.getFacetGroupsNode(graphDb);
            Node facetGroup = FacetManager.createFacetGroup(graphDb, facetGroupsNode, jsonFacetGroup);
            Node facet = graphDb.createNode(new Label[]{FacetLabel.FACET});
            PropertyUtilities.copyJSONObjectToPropertyContainer(jsonFacet, (PropertyContainer)facet, "noFacet", "generalLabels", "uniqueLabels", "facetGroup");
            String name = (String)PropertyUtilities.getNonNullNodeProperty((PropertyContainer)facet, "name");
            String sourceType = (String)PropertyUtilities.getNonNullNodeProperty((PropertyContainer)facet, "sourceType");
            if (!(sourceType.equals("flat") || sourceType.equals("hierarchical") || sourceType.equals("strings") || sourceType.equals("facetAggregation"))) {
                throw new IllegalArgumentException("Unknown source type \"" + sourceType + "\" on facet with name \"" + name + "\".");
            }
            if (sourceType.equals("facetAggregation") && (!jsonFacet.has("aggregationLabels") || jsonFacet.getJSONArray("aggregationLabels").length() == 0)) {
                throw new IllegalArgumentException("Facet shall be imported that is an aggregation of other facets but fails to specify with which label(s) the aggregated facets should be identified. JSON source was " + jsonFacet.toString(2));
            }
            String facetId = "fid" + SequenceManager.getNextSequenceValue(graphDb, "seqFacet");
            facet.setProperty(KEY_ID, (Object)facetId);
            PropertyUtilities.setNonNullNodeProperty((PropertyContainer)facet, "sourceName", sourceName, "facetTerms" + facetId);
            facetGroup.createRelationshipTo(facet, (RelationshipType)EdgeTypes.HAS_FACET);
            if (null != generalLabels) {
                for (i = 0; i < generalLabels.length(); ++i) {
                    labelString = generalLabels.getString(i);
                    label = DynamicLabel.label((String)labelString);
                    facet.addLabel(label);
                }
            }
            if (null != uniqueLabels) {
                for (i = 0; i < uniqueLabels.length(); ++i) {
                    labelString = uniqueLabels.getString(i);
                    label = DynamicLabel.label((String)labelString);
                    facet.addLabel(label);
                }
            }
            tx.success();
            Node node = facet;
            return node;
        }
    }

    private static int countFacetChildren(GraphDatabaseService graphDb, String fid) {
        int childCount = -1;
        try (Transaction tx = graphDb.beginTx();){
            DynamicRelationshipType dynRel = DynamicRelationshipType.withName((String)("IS_BROADER_THAN_" + fid));
            Node node = FacetManager.getFacetNode(graphDb, fid);
            Traverser traverser = graphDb.traversalDescription().breadthFirst().uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL).relationships((RelationshipType)ConceptManager.EdgeTypes.HAS_ROOT_TERM, Direction.OUTGOING).relationships((RelationshipType)dynRel, Direction.OUTGOING).traverse(node);
            for (Node n : traverser.nodes()) {
                ++childCount;
            }
        }
        return childCount;
    }

    private static Node getFacetGroup(GraphDatabaseService graphDb, Node facetGroupsNode, String facetGroupName) {
        TraversalDescription td = PredefinedTraversals.getFacetGroupTraversal(graphDb, facetGroupName);
        Traverser traverse = td.traverse(facetGroupsNode);
        TraversalMetadata metadata = traverse.metadata();
        if (metadata != null && metadata.getNumberOfPathsReturned() > 1) {
            throw new IllegalStateException("There is more than one path from the reference node to the facet group node with name '" + facetGroupName + "'.");
        }
        ResourceIterator pathIterator = traverse.iterator();
        Node facetGroupNode = null;
        while (pathIterator.hasNext()) {
            Path path = (Path)pathIterator.next();
            if (path.length() != 1) continue;
            facetGroupNode = path.endNode();
        }
        return facetGroupNode;
    }

    private static Node createFacetGroup(GraphDatabaseService graphDb, Node facetGroupsNode, JSONObject jsonFacetGroup) throws JSONException {
        JSONArray labels;
        String facetGroupName = jsonFacetGroup.getString("name");
        Node facetGroupNode = FacetManager.getFacetGroup(graphDb, facetGroupsNode, facetGroupName);
        if (null == facetGroupNode) {
            log.log(Level.FINE, "Facet group \"" + facetGroupName + "\" (ID: " + facetGroupName + ") does not exist and is created.");
            facetGroupNode = graphDb.createNode();
            PropertyUtilities.copyJSONObjectToPropertyContainer(jsonFacetGroup, (PropertyContainer)facetGroupNode, "generalLabels");
            int nextSequenceValue = SequenceManager.getNextSequenceValue(graphDb, "seqFacetGroup");
            facetGroupNode.setProperty(KEY_ID, (Object)("fgid" + nextSequenceValue));
            facetGroupsNode.createRelationshipTo(facetGroupNode, (RelationshipType)EdgeTypes.HAS_FACET_GROUP);
        }
        if (null != (labels = JSON.getJSONArray(jsonFacetGroup, "generalLabels"))) {
            for (int i = 0; i < labels.length(); ++i) {
                String labelString = labels.getString(i);
                Label label = DynamicLabel.label((String)labelString);
                facetGroupNode.addLabel(label);
            }
        }
        if (null == facetGroupNode.getProperty("position")) {
            throw new IllegalArgumentException("The facet group \"" + facetGroupName + "\" does not have the required property \"" + "position" + "\". It must either be passed with the inserted facets or already exist.");
        }
        return facetGroupNode;
    }

    public static Node getFacetGroupsNode(GraphDatabaseService graphDb) {
        Node facetGroupsNode = null;
        try (Transaction tx = graphDb.beginTx();){
            facetGroupsNode = NodeUtilities.findSingleNodeByLabelAndProperty(graphDb, NodeConstants.Labels.ROOT, "name", "facetGroups");
            if (null == facetGroupsNode) {
                facetGroupsNode = graphDb.createNode(new Label[]{NodeConstants.Labels.ROOT});
                facetGroupsNode.setProperty("name", (Object)"facetGroups");
            }
            tx.success();
        }
        return facetGroupsNode;
    }

    public static Node getNoFacetGroupsNode(GraphDatabaseService graphDb) {
        Node facetGroupsNode = null;
        try (Transaction tx = graphDb.beginTx();){
            facetGroupsNode = NodeUtilities.findSingleNodeByLabelAndProperty(graphDb, NodeConstants.Labels.ROOT, "name", "noFacet-Groups");
            if (null == facetGroupsNode) {
                facetGroupsNode = graphDb.createNode(new Label[]{NodeConstants.Labels.ROOT});
                facetGroupsNode.setProperty("name", (Object)"noFacet-Groups");
            }
            tx.success();
        }
        return facetGroupsNode;
    }

    public static Node getFacetNode(GraphDatabaseService graphDb, String facetId) {
        return NodeUtilities.findSingleNodeByLabelAndProperty(graphDb, FacetLabel.FACET, KEY_ID, facetId);
    }

    public static Node getNoFacet(GraphDatabaseService graphDb, String facetId) {
        Node noFacetNode = NodeUtilities.findSingleNodeByLabelAndProperty(graphDb, FacetLabel.NO_FACET, KEY_ID, facetId);
        if (null == noFacetNode) {
            Node facetNode = FacetManager.getFacetNode(graphDb, facetId);
            noFacetNode = NodeUtilities.copyNode(graphDb, facetNode);
            noFacetNode.addLabel((Label)FacetLabel.NO_FACET);
            Node noFacetGroupsNode = FacetManager.getNoFacetGroupsNode(graphDb);
            Node facetGroupNode = NodeUtilities.getSingleOtherNode(facetNode, EdgeTypes.HAS_FACET);
            Node noFacetGroupNode = FacetManager.getFacetGroup(graphDb, noFacetGroupsNode, (String)facetGroupNode.getProperty("name"));
            if (null == noFacetGroupNode) {
                noFacetGroupNode = NodeUtilities.copyNode(graphDb, facetGroupNode);
                noFacetGroupsNode.createRelationshipTo(noFacetGroupNode, (RelationshipType)EdgeTypes.HAS_FACET_GROUP);
            }
            noFacetGroupNode.createRelationshipTo(noFacetNode, (RelationshipType)EdgeTypes.HAS_FACET);
        }
        return noFacetNode;
    }

    public static enum FacetLabel implements Label
    {
        FACET,
        NO_FACET;

    }

    public static enum EdgeTypes implements RelationshipType
    {
        HAS_FACET_GROUP,
        HAS_FACET;

    }
}

