/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries.semedico;

import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;

public class NodeUtilities
extends de.julielab.neo4j.plugins.auxiliaries.NodeUtilities {
    public static String getNodeRelationshipsString(Node n) {
        ArrayList<String> relsStrings = new ArrayList<String>();
        for (Relationship r : n.getRelationships()) {
            Node src = r.getStartNode();
            Node tgt = r.getEndNode();
            String srcLabel = NodeUtilities.getNodeIdentifier(src);
            String tgtLabel = NodeUtilities.getNodeIdentifier(tgt);
            String rType = r.getType().name();
            relsStrings.add(srcLabel + "-" + rType + "->" + tgtLabel);
        }
        return StringUtils.join(relsStrings, (String)"\n");
    }

    public static String getNodeIdentifier(Node n) {
        String identifier = String.valueOf(n.getId());
        if (n.hasProperty("id")) {
            identifier = (String)n.getProperty("id");
        }
        if (n.hasProperty("sourceIds")) {
            identifier = ((String[])n.getProperty("sourceIds"))[0];
        }
        if (n.hasProperty("name")) {
            identifier = (String)n.getProperty("name");
        }
        if (n.hasProperty("preferredName")) {
            identifier = (String)n.getProperty("preferredName");
        }
        return "(" + identifier + ":" + StringUtils.join(n.getLabels().iterator(), (String)",") + ")";
    }

    public static Set<String> getSourcesForSourceId(Node conceptNode, String sourceId) {
        String[] conceptSources;
        HashSet<String> sourcesForSourceId = new HashSet<String>();
        String[] conceptSrcIds = (String[])conceptNode.getProperty("sourceIds");
        String[] stringArray = conceptSources = conceptNode.hasProperty("sources") ? (String[])conceptNode.getProperty("sources") : new String[]{};
        if (conceptSources.length > 0 && conceptSrcIds.length != conceptSources.length) {
            throw new IllegalStateException("Concept " + NodeUtilities.getNodePropertiesAsString((PropertyContainer)conceptNode) + " has a differing number of source IDs and sources.");
        }
        for (int i = 0; i < conceptSources.length; ++i) {
            String source = conceptSources[i];
            String conceptSrcId = conceptSrcIds[i];
            if (source == null || conceptSrcId == null || !conceptSrcId.equals(sourceId)) continue;
            sourcesForSourceId.add(source);
        }
        return sourcesForSourceId;
    }

    public static boolean isSourceUnique(Node conceptNode, String srcId) {
        String[] conceptSrcIds = (String[])conceptNode.getProperty("sourceIds");
        boolean[] conceptUniqueSrcIds = (boolean[])conceptNode.getProperty("uniqueSourceId");
        if (conceptSrcIds.length > 0 && conceptSrcIds.length != conceptUniqueSrcIds.length) {
            throw new IllegalStateException("Concept " + NodeUtilities.getNodePropertiesAsString((PropertyContainer)conceptNode) + " has a differing number of source IDs and unique source ID markers.");
        }
        for (int i = 0; i < conceptSrcIds.length; ++i) {
            if (!conceptSrcIds[i].equals(srcId) || !conceptUniqueSrcIds[i]) continue;
            return true;
        }
        return false;
    }

    public static Node mergeConceptNodesWithUniqueSourceId(String srcId, Index<Node> termIndex, List<Node> obsoleteNodes) {
        IndexHits conceptNodes = termIndex.get("sourceIds", (Object)srcId);
        Node firstNode = null;
        for (Node conceptNode : conceptNodes) {
            String conceptPrefName;
            if (firstNode == null) {
                firstNode = conceptNode;
                continue;
            }
            String firstNodePrefName = (String)firstNode.getProperty("preferredName");
            boolean addConceptPrefToSynonyms = !firstNodePrefName.equals(conceptPrefName = (String)conceptNode.getProperty("preferredName"));
            PropertyUtilities.mergePropertyContainerIntoPropertyContainer(conceptNode, firstNode, "generalLabels", "sourceIds", "sources", "synonyms", "relationships", "coordinates", "parentCoordinates");
            String[] conceptSrcIds = (String[])conceptNode.getProperty("sourceIds");
            String[] conceptSources = (String[])conceptNode.getProperty("sources");
            boolean[] conceptUniqueMarkers = (boolean[])conceptNode.getProperty("uniqueSourceId");
            for (int i = 0; i < conceptSrcIds.length; ++i) {
                String conceptSrcId = conceptSrcIds[i];
                String conceptSource = conceptSources[i];
                boolean conceptUniqueSrcId = conceptUniqueMarkers[i];
                int idIndex = NodeUtilities.findFirstValueInArrayProperty(firstNode, "sourceIds", conceptSrcId);
                int sourceIndex = NodeUtilities.findFirstValueInArrayProperty(firstNode, "sources", conceptSource);
                if (StringUtils.isBlank((String)srcId) || (idIndex != -1 || sourceIndex != -1) && idIndex == sourceIndex) continue;
                NodeUtilities.addToArrayProperty((PropertyContainer)firstNode, "sourceIds", conceptSrcId, true);
                NodeUtilities.addToArrayProperty((PropertyContainer)firstNode, "sources", conceptSource, true);
                NodeUtilities.addToArrayProperty((PropertyContainer)firstNode, "uniqueSourceId", conceptUniqueSrcId, true);
            }
            String[] conceptSynonyms = (String[])conceptNode.getProperty("synonyms");
            NodeUtilities.mergeArrayProperty((PropertyContainer)firstNode, "synonyms", conceptSynonyms);
            if (addConceptPrefToSynonyms) {
                NodeUtilities.addToArrayProperty((PropertyContainer)firstNode, "synonyms", conceptPrefName);
            }
            String[] conceptFacets = (String[])conceptNode.getProperty("facets");
            NodeUtilities.mergeArrayProperty((PropertyContainer)firstNode, "facets", conceptFacets);
            Iterable labels = conceptNode.getLabels();
            for (Label label : labels) {
                firstNode.addLabel(label);
            }
            obsoleteNodes.add(conceptNode);
        }
        return firstNode;
    }
}

