/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import de.julielab.neo4j.plugins.FacetManager;
import de.julielab.neo4j.plugins.auxiliaries.JSON;
import de.julielab.neo4j.plugins.auxiliaries.PropertyUtilities;
import de.julielab.neo4j.plugins.auxiliaries.RecursiveMappingRepresentation;
import de.julielab.neo4j.plugins.auxiliaries.semedico.CoordinatesMap;
import de.julielab.neo4j.plugins.auxiliaries.semedico.CoordinatesSet;
import de.julielab.neo4j.plugins.auxiliaries.semedico.NodeUtilities;
import de.julielab.neo4j.plugins.auxiliaries.semedico.PredefinedTraversals;
import de.julielab.neo4j.plugins.auxiliaries.semedico.SequenceManager;
import de.julielab.neo4j.plugins.auxiliaries.semedico.TermAggregateBuilder;
import de.julielab.neo4j.plugins.auxiliaries.semedico.TermVariantComparator;
import de.julielab.neo4j.plugins.constants.semedico.NodeConstants;
import de.julielab.neo4j.plugins.datarepresentation.AddToNonFacetGroupCommand;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportOptions;
import de.julielab.neo4j.plugins.datarepresentation.PushTermsToSetCommand;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.QueryParser;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;
import org.neo4j.tooling.GlobalGraphOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="This plugin discloses special operation for efficient access to the FacetTerms for Semedico.")
public class ConceptManager
extends ServerPlugin {
    private static final String UNKNOWN_TERM_SOURCE = "<unknown>";
    public static final String INSERT_MAPPINGS = "insert_mappings";
    public static final String BUILD_AGGREGATES_BY_NAME_AND_SYNONYMS = "build_aggregates_by_name_and_synonyms";
    public static final String BUILD_AGGREGATES_BY_MAPPINGS = "build_aggregates_by_mappings";
    public static final String DELETE_AGGREGATES = "delete_aggregates";
    public static final String COPY_AGGREGATE_PROPERTIES = "copy_aggregate_properties";
    public static final String CREATE_SCHEMA_INDEXES = "create_schema_indexes";
    public static final String GET_CHILDREN_OF_TERMS = "get_children_of_terms";
    public static final String GET_NUM_TERMS = "get_num_terms";
    public static final String GET_PATHS_FROM_FACETROOTS = "get_paths_to_facetroots";
    public static final String INSERT_TERMS = "insert_terms";
    public static final String GET_FACET_ROOTS = "get_facet_roots";
    public static final String ADD_TERM_VARIANTS = "add_term_variants";
    public static final String KEY_AMOUNT = "amount";
    public static final String KEY_CREATE_HOLLOW_PARENTS = "createHollowParents";
    public static final String KEY_FACET = "facet";
    public static final String KEY_FACET_ID = "facetId";
    public static final String KEY_FACET_IDS = "facetIds";
    public static final String KEY_FACET_PROP_KEY = "propertyKey";
    public static final String KEY_FACET_PROP_VALUE = "propertyValue";
    public static final String KEY_ID_TYPE = "idType";
    public static final String KEY_IMPORT_OPTIONS = "importOptions";
    public static final String KEY_LABEL = "label";
    public static final String KEY_SORT_RESULT = "sortResult";
    public static final String KEY_TERM_IDS = "termIds";
    public static final String KEY_MAX_ROOTS = "maxRoots";
    public static final String KEY_TERM_PROP_KEY = "termPropertyKey";
    public static final String KEY_TERM_PROP_VALUE = "termPropertyValue";
    public static final String KEY_TERM_PROP_VALUES = "termPropertyValues";
    public static final String KEY_TERM_PUSH_CMD = "termPushCommand";
    public static final String KEY_AGGREGATED_LABEL = "aggregatedLabel";
    public static final String KEY_ALLOWED_MAPPING_TYPES = "allowedMappingTypes";
    public static final String KEY_TERM_VARIANTS = "termVariants";
    public static final String KEY_TERM_ACRONYMS = "termAcronyms";
    public static final String KEY_TERMS = "terms";
    public static final String KEY_TIME = "time";
    public static final String KEY_MAPPINGS = "mappings";
    private static final Logger log = LoggerFactory.getLogger(ConceptManager.class);
    public static final String POP_TERMS_FROM_SET = "pop_terms_from_set";
    public static final String PUSH_TERMS_TO_SET = "push_terms_to_set";
    public static final String RET_KEY_CHILDREN = "children";
    public static final String RET_KEY_NUM_AGGREGATES = "numAggregates";
    public static final String RET_KEY_NUM_CREATED_RELS = "numCreatedRelationships";
    public static final String RET_KEY_NUM_CREATED_TERMS = "numCreatedTerms";
    public static final String RET_KEY_NUM_ELEMENTS = "numElements";
    public static final String RET_KEY_NUM_PROPERTIES = "numProperties";
    public static final String RET_KEY_PATHS = "paths";
    public static final String RET_KEY_RELTYPES = "reltypes";
    public static final String RET_KEY_TERMS = "terms";
    public static final String TERM_MANAGER_ENDPOINT = "db/data/ext/" + ConceptManager.class.getSimpleName() + "/graphdb/";
    private static final int TERM_INSERT_BATCH_SIZE = 10000;
    public static final String UPDATE_CHILDREN_INFORMATION = "update_children_information";

    @Name(value="build_aggregates_by_mappings")
    @Description(value="Creates term aggregates with respect to 'IS_MAPPED_TO' relationships.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void buildAggregatesByMappigs(@Source GraphDatabaseService graphDb, @Description(value="The allowed types for IS_MAPPED_TO relationships to be included in aggregation building.") @Parameter(name="allowedMappingTypes") String allowedMappingTypesArray, @Description(value="Label for terms that have been processed by the aggregation algorithm. Such terms can be aggregate terms (with the label AGGREGATE) or just plain terms (with the label TERM) that are not an element of an aggregate.") @Parameter(name="aggregatedLabel") String aggregatedTermsLabelString, @Description(value="Label to restrict the terms to that are considered for aggregation creation.") @Parameter(name="label", optional=true) String allowedTermLabelString) throws JSONException {
        JSONArray allowedMappingTypesJson = new JSONArray(allowedMappingTypesArray);
        HashSet<String> allowedMappingTypes = new HashSet<String>();
        for (int i = 0; i < allowedMappingTypesJson.length(); ++i) {
            allowedMappingTypes.add(allowedMappingTypesJson.getString(i));
        }
        Label aggregatedTermsLabel = DynamicLabel.label((String)aggregatedTermsLabelString);
        Label allowedTermLabel = StringUtils.isBlank((String)allowedTermLabelString) ? null : DynamicLabel.label((String)allowedTermLabelString);
        log.info("Creating mapping aggregates for terms with label " + allowedTermLabel + " and mapping types " + allowedMappingTypesJson);
        TermAggregateBuilder.buildAggregatesForMappings(graphDb, allowedMappingTypes, allowedTermLabel, aggregatedTermsLabel);
    }

    @Name(value="delete_aggregates")
    @Description(value="Deletes aggregates with respect to a specific aggregate label. Only real aggregates are actually deleted, plain terms that are 'their own' aggregates just lose the label.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void deleteAggregatesByMappigs(@Source GraphDatabaseService graphDb, @Description(value="Label for terms that have been processed by the aggregation algorithm. Such terms can be aggregate terms (with the label AGGREGATE) or just plain terms (with the label TERM) that are not an element of an aggregate.") @Parameter(name="aggregatedLabel") String aggregatedTermsLabelString) throws JSONException {
        Label aggregatedTermsLabel = DynamicLabel.label((String)aggregatedTermsLabelString);
        TermAggregateBuilder.deleteAggregates(graphDb, aggregatedTermsLabel);
    }

    @Name(value="build_aggregates_by_name_and_synonyms")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public void buildAggregatesByNameAndSynonyms(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="termPropertyKey") String termPropertyKey, @Description(value="TODO") @Parameter(name="termPropertyValues") String propertyValues) throws JSONException {
        JSONArray jsonPropertyValues = new JSONArray(propertyValues);
        TermAggregateBuilder.buildAggregatesForEqualNames(graphDb, termPropertyKey, jsonPropertyValues);
    }

    @Name(value="copy_aggregate_properties")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation copyAggregateProperties(@Source GraphDatabaseService graphDb) {
        int numAggregates = 0;
        TermAggregateBuilder.CopyAggregatePropertiesStatistics copyStats = new TermAggregateBuilder.CopyAggregatePropertiesStatistics();
        try (Transaction tx = graphDb.beginTx();){
            try (ResourceIterator aggregateIt = graphDb.findNodes((Label)TermLabel.AGGREGATE);){
                while (aggregateIt.hasNext()) {
                    Node aggregate = (Node)aggregateIt.next();
                    numAggregates += this.copyAggregatePropertiesRecursively(aggregate, copyStats, new HashSet<Node>());
                }
            }
            tx.success();
        }
        HashMap<String, Object> reportMap = new HashMap<String, Object>();
        reportMap.put(RET_KEY_NUM_AGGREGATES, numAggregates);
        reportMap.put(RET_KEY_NUM_ELEMENTS, copyStats.numElements);
        reportMap.put(RET_KEY_NUM_PROPERTIES, copyStats.numProperties);
        return new RecursiveMappingRepresentation(Representation.MAP, reportMap);
    }

    private int copyAggregatePropertiesRecursively(Node aggregate, TermAggregateBuilder.CopyAggregatePropertiesStatistics copyStats, Set<Node> alreadySeen) {
        if (alreadySeen.contains(aggregate)) {
            return 0;
        }
        ArrayList<Node> elementAggregates = new ArrayList<Node>();
        Iterable elementRels = aggregate.getRelationships(Direction.OUTGOING, new RelationshipType[]{EdgeTypes.HAS_ELEMENT});
        for (Relationship elementRel : elementRels) {
            Node endNode = elementRel.getEndNode();
            if (!endNode.hasLabel((Label)TermLabel.AGGREGATE) || alreadySeen.contains(endNode)) continue;
            elementAggregates.add(endNode);
        }
        for (Node elementAggregate : elementAggregates) {
            this.copyAggregatePropertiesRecursively(elementAggregate, copyStats, alreadySeen);
        }
        if (aggregate.hasProperty("copyProperties")) {
            String[] copyProperties = (String[])aggregate.getProperty("copyProperties");
            TermAggregateBuilder.copyAggregateProperties(aggregate, copyProperties, copyStats);
        }
        alreadySeen.add(aggregate);
        return alreadySeen.size();
    }

    private void createRelationships(GraphDatabaseService graphDb, JSONArray jsonTerms, Node facet, CoordinatesMap nodesByCoordinates, ImportOptions importOptions, InsertionReport insertionReport) throws JSONException {
        log.info("Creating relationship between inserted terms.");
        Index idIndex = graphDb.index().forNodes("termIndex");
        String facetId = null;
        if (null != facet) {
            facetId = (String)facet.getProperty("id");
        }
        DynamicRelationshipType relBroaderThanInFacet = null;
        if (null != facet) {
            relBroaderThanInFacet = DynamicRelationshipType.withName((String)(EdgeTypes.IS_BROADER_THAN.toString() + "_" + facetId));
        }
        AddToNonFacetGroupCommand noFacetCmd = importOptions.noFacetCmd;
        Node noFacet = null;
        int quarter = jsonTerms.length() / 4;
        int numQuarter = 1;
        long totalTime = 0L;
        long relCreationTime = 0L;
        for (int i = 0; i < jsonTerms.length(); ++i) {
            int j;
            long time = System.currentTimeMillis();
            JSONObject jsonTerm = jsonTerms.getJSONObject(i);
            if (JSON.getBoolean(jsonTerm, "aggregate") && !JSON.getBoolean(jsonTerm, "aggregateIncludeInHierarchy")) continue;
            JSONObject coordinates = jsonTerm.getJSONObject("coordinates");
            String srcId = coordinates.getString("sourceId");
            Node term = nodesByCoordinates.get(new ConceptCoordinates(coordinates));
            if (null == term && insertionReport.omittedTerms.contains(srcId)) continue;
            if (null == term) {
                throw new IllegalStateException("No node for source ID " + srcId + " was created but the respective concept is included into the data for import and it is unknown why no node instance was created.");
            }
            if (jsonTerm.has("parentCoordinates") && jsonTerm.getJSONArray("parentCoordinates").length() > 0) {
                JSONArray parentCoordinateArray = jsonTerm.getJSONArray("parentCoordinates");
                for (j = 0; j < parentCoordinateArray.length(); ++j) {
                    ConceptCoordinates parentCoordinates = new ConceptCoordinates(parentCoordinateArray.getJSONObject(j));
                    String parentSrcId = parentCoordinates.sourceId;
                    if (importOptions.cutParents.contains(parentSrcId)) {
                        log.debug("Concept node " + coordinates + " has a parent that is marked to be cut away. Concept will be a facet root.");
                        this.createRelationshipIfNotExists(facet, term, EdgeTypes.HAS_ROOT_TERM, insertionReport);
                        continue;
                    }
                    Node parent = nodesByCoordinates.get(parentCoordinates);
                    if (null == parent) {
                        throw new IllegalStateException("The parent node of concept " + coordinates + " should have been created in the insertTerms method before, but it is null. The parent coordinates are " + parentCoordinates);
                    }
                    if (insertionReport.importedCoordinates.contains(parentCoordinates) || insertionReport.existingConcepts.contains(parent)) {
                        log.debug("Parent with " + parentCoordinates + " was found by source ID for concept " + coordinates + ".");
                        long creationTime = System.currentTimeMillis();
                        this.createRelationshipIfNotExists(parent, term, EdgeTypes.IS_BROADER_THAN, insertionReport);
                        this.createRelationshipIfNotExists(parent, term, (RelationshipType)relBroaderThanInFacet, insertionReport);
                        relCreationTime += System.currentTimeMillis() - creationTime;
                    } else {
                        log.debug("Concept with source ID \"" + srcId + "\" referenced the term with source ID \"" + parentSrcId + "\" as its parent. However, that parent node does not exist.");
                        if (!importOptions.doNotCreateHollowParents) {
                            log.debug("Creating hollow parents is switched on. The parent will be created with the label \"" + (Object)((Object)TermLabel.HOLLOW) + "\" and be connected to the facet root.");
                            parent.addLabel((Label)TermLabel.TERM);
                            this.createRelationshipIfNotExists(parent, term, EdgeTypes.IS_BROADER_THAN, insertionReport);
                            this.createRelationshipIfNotExists(parent, term, (RelationshipType)relBroaderThanInFacet, insertionReport);
                            this.createRelationshipIfNotExists(facet, parent, EdgeTypes.HAS_ROOT_TERM, insertionReport);
                        } else {
                            log.warn("Creating hollow parents is switched off. Hence the term will be added as root term for its facet (\"" + facet.getProperty("name") + "\").");
                            this.createRelationshipIfNotExists(facet, term, EdgeTypes.HAS_ROOT_TERM, insertionReport);
                        }
                    }
                    if (null == parent || !parent.hasLabel((Label)TermLabel.AGGREGATE) || parent.hasLabel((Label)TermLabel.TERM)) continue;
                    throw new IllegalArgumentException("Concept with source ID " + srcId + " specifies source ID " + parentSrcId + " as parent. This node is an aggregate but not a TERM itself and thus is not included in the hierarchy and cannot be the conceptual parent of other concepts. To achieve this, import the aggregate with the property " + "aggregateIncludeInHierarchy" + " set to true or build the aggregates in a way that assignes the TERM label to them.");
                }
            } else if (noFacetCmd != null && noFacetCmd.getParentCriteria().contains((Object)AddToNonFacetGroupCommand.ParentCriterium.NO_PARENT)) {
                if (null != noFacetCmd && null == noFacet) {
                    noFacet = FacetManager.getNoFacet(graphDb, (String)facet.getProperty("id"));
                }
                this.createRelationshipIfNotExists(noFacet, term, EdgeTypes.HAS_ROOT_TERM, insertionReport);
            } else if (null != facet) {
                log.debug("Installing term with source ID " + srcId + " (ID: " + term.getProperty("id") + ") as root for facet " + facet.getProperty("name") + "(ID: " + facet.getProperty("id") + ")");
                this.createRelationshipIfNotExists(facet, term, EdgeTypes.HAS_ROOT_TERM, insertionReport);
            }
            if (jsonTerm.has("relationships")) {
                log.info("Adding explicitly specified relationships");
                JSONArray jsonRelationships = jsonTerm.getJSONArray("relationships");
                for (j = 0; j < jsonRelationships.length(); ++j) {
                    String targetSource;
                    JSONObject jsonRelationship = jsonRelationships.getJSONObject(j);
                    String rsTypeStr = jsonRelationship.getString("type");
                    String targetOrgId = JSON.getString(jsonRelationship, "targetOriginalId");
                    String targetOrgSource = JSON.getString(jsonRelationship, "targetOriginalSource");
                    String targetSrcId = JSON.getString(jsonRelationship, "targetSrcId");
                    Node target = this.lookupTerm(new ConceptCoordinates(targetSrcId, targetSource = JSON.getString(jsonRelationship, "targetSource"), targetOrgId, targetOrgSource, JSON.getBoolean(jsonTerm, "uniqueSourceId", false)), (Index<Node>)idIndex);
                    if (null == target) {
                        log.debug("Creating hollow relationship target with orig Id/orig source (" + targetOrgId + "," + targetOrgSource + ") and source Id/source : (" + targetSrcId + ", " + targetSource + ")");
                        target = graphDb.createNode(new Label[]{TermLabel.TERM, TermLabel.HOLLOW});
                        PropertyUtilities.addToArrayProperty((PropertyContainer)target, "sourceIds", targetSrcId);
                        PropertyUtilities.addToArrayProperty((PropertyContainer)target, "sources", targetSource);
                        if (null != targetOrgId) {
                            target.setProperty("originalId", (Object)targetOrgId);
                        }
                        if (null != targetOrgSource) {
                            target.setProperty("originalSource", (Object)targetOrgSource);
                        }
                        if (null != targetOrgId) {
                            idIndex.add((PropertyContainer)target, "originalId", (Object)targetOrgId);
                        }
                        if (null != targetSrcId) {
                            idIndex.add((PropertyContainer)target, "sourceIds", (Object)targetSrcId);
                        }
                    }
                    EdgeTypes type = EdgeTypes.valueOf(rsTypeStr);
                    Object[] properties = null;
                    if (jsonRelationship.has("properties")) {
                        JSONObject relProps = jsonRelationship.getJSONObject("properties");
                        JSONArray propNames = relProps.names();
                        properties = new Object[propNames.length() * 2];
                        for (int k = 0; k < propNames.length(); ++k) {
                            String propName = propNames.getString(k);
                            Object propValue = relProps.get(propName);
                            properties[2 * k] = propName;
                            properties[2 * k + 1] = propValue;
                        }
                    }
                    this.createRelationShipIfNotExists(term, target, type, insertionReport, Direction.OUTGOING, properties);
                    ++insertionReport.numRelationships;
                }
            }
            totalTime += System.currentTimeMillis() - time;
            if (i < numQuarter * quarter) continue;
            log.info("Finished " + 25 * numQuarter + "% of terms for relationship creation.");
            log.info("Relationship creation took " + relCreationTime + "ms.");
            log.info("Total time consumption for creation of " + insertionReport.numRelationships + " relationships until now: " + totalTime + "ms.");
            ++numQuarter;
        }
        log.info("Finished 100% of terms for relationship creation.");
    }

    private void createIndexIfAbsent(GraphDatabaseService graphDb, Label label, String key, boolean unique) {
        try (Transaction tx = graphDb.beginTx();){
            Schema schema = graphDb.schema();
            boolean indexExists = false;
            for (IndexDefinition id : schema.getIndexes(label)) {
                for (String propertyKey : id.getPropertyKeys()) {
                    if (!propertyKey.equals(key)) continue;
                    indexExists = true;
                }
            }
            if (!indexExists) {
                log.info("Creating index for label " + label + " on property " + key + " (unique: " + unique + ").");
                schema.constraintFor(label).assertPropertyIsUnique(key).create();
                tx.success();
            }
        }
    }

    private Relationship createRelationshipIfNotExists(Node source, Node target, RelationshipType type, InsertionReport insertionReport) {
        return this.createRelationShipIfNotExists(source, target, type, insertionReport, Direction.OUTGOING, new Object[0]);
    }

    private Relationship createRelationShipIfNotExists(Node source, Node target, RelationshipType type, InsertionReport insertionReport, Direction direction, Object ... properties) {
        if (null != properties && properties.length % 2 != 0) {
            throw new IllegalArgumentException("Property list must contain of key/value pairs but its length was odd.");
        }
        boolean relationShipExists = false;
        Relationship createdRelationship = null;
        if (insertionReport.relationshipAlreadyWasCreated(source, target, type)) {
            relationShipExists = true;
        } else if (insertionReport.existingConcepts.contains(source) && insertionReport.existingConcepts.contains(target)) {
            Iterable relationships = source.getRelationships(direction, new RelationshipType[]{type});
            for (Relationship relationship : relationships) {
                if (!relationship.getEndNode().equals(target)) continue;
                relationShipExists = true;
                if (PropertyUtilities.mergeProperties((PropertyContainer)relationship, properties)) continue;
                relationShipExists = false;
            }
        }
        if (!relationShipExists) {
            createdRelationship = source.createRelationshipTo(target, type);
            for (int i = 0; null != properties && i < properties.length; i += 2) {
                String key = (String)properties[i];
                Object value = properties[i + 1];
                createdRelationship.setProperty(key, value);
            }
            insertionReport.addCreatedRelationship(source, target, type);
            ++insertionReport.numRelationships;
        }
        return createdRelationship;
    }

    @Name(value="create_schema_indexes")
    @Description(value="Creates uniqueness constraints (and thus, indexes), on the following label / property combinations: TERM / id; TERM / originalId; FACET / id; NO_FACET / id; ROOT / name. This should be done after the main initial import because node insertion with uniqueness switched on costs significant insertion performance.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void createSchemaIndexes(@Source GraphDatabaseService graphDb) {
        this.createIndexIfAbsent(graphDb, TermLabel.TERM, "id", true);
        this.createIndexIfAbsent(graphDb, TermLabel.TERM, "originalId", true);
        this.createIndexIfAbsent(graphDb, FacetManager.FacetLabel.FACET, "id", true);
        this.createIndexIfAbsent(graphDb, FacetManager.FacetLabel.NO_FACET, "id", true);
        this.createIndexIfAbsent(graphDb, NodeConstants.Labels.ROOT, "name", true);
    }

    @Name(value="get_children_of_terms")
    @Description(value="Returns all non-hollow children of terms identified via the termIds parameter. The return format is a map from the children's id to respective child term. This endpoint has been created due to performance reasons. All tried Cypher queries to achieve the same behaviour were less performant (tested for version 2.0.0 M3).")
    @PluginTarget(value=GraphDatabaseService.class)
    public MappingRepresentation getChildrenOfTerms(@Source GraphDatabaseService graphDb, @Description(value="JSON array of term IDs for which to return their children.") @Parameter(name="termIds") String termIdArray, @Description(value="The label agsinst which the given term IDs are resolved. Defaults to 'TERM'.") @Parameter(name="label", optional=true) String labelString) throws JSONException {
        TermLabel label = TermLabel.TERM;
        if (!StringUtils.isBlank((String)labelString)) {
            label = DynamicLabel.label((String)labelString);
        }
        JSONArray termIds = new JSONArray(termIdArray);
        try (Transaction tx = graphDb.beginTx();){
            HashMap<String, Object> childrenByTermId = new HashMap<String, Object>();
            for (int i = 0; i < termIds.length(); ++i) {
                HashMap<String, ArrayList<String>> reltypesByNodeId = new HashMap<String, ArrayList<String>>();
                HashSet<Node> childList = new HashSet<Node>();
                String termId = termIds.getString(i);
                Node term = NodeUtilities.findSingleNodeByLabelAndProperty(graphDb, label, "id", termId);
                if (null == term) continue;
                for (Relationship rel : term.getRelationships(Direction.OUTGOING)) {
                    String reltype = rel.getType().name();
                    Node child = rel.getEndNode();
                    boolean isHollow = false;
                    for (Label l : child.getLabels()) {
                        if (!l.equals((Object)TermLabel.HOLLOW)) continue;
                        isHollow = true;
                    }
                    if (isHollow) continue;
                    String childId = (String)child.getProperty("id");
                    ArrayList<String> reltypeList = (ArrayList<String>)reltypesByNodeId.get(childId);
                    if (null == reltypeList) {
                        reltypeList = new ArrayList<String>();
                        reltypesByNodeId.put(childId, reltypeList);
                    }
                    reltypeList.add(reltype);
                    childList.add(child);
                }
                HashMap<String, Cloneable> childrenAndReltypes = new HashMap<String, Cloneable>();
                childrenAndReltypes.put(RET_KEY_CHILDREN, childList);
                childrenAndReltypes.put(RET_KEY_RELTYPES, reltypesByNodeId);
                childrenByTermId.put(termId, childrenAndReltypes);
            }
            RecursiveMappingRepresentation recursiveMappingRepresentation = new RecursiveMappingRepresentation(Representation.MAP, childrenByTermId);
            return recursiveMappingRepresentation;
        }
    }

    @Name(value="get_num_terms")
    @Description(value="Returns the number of terms in the database, i.e. the number of nodes with the \"TERM\" label.")
    @PluginTarget(value=GraphDatabaseService.class)
    public long getNumTerms(@Source GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable terms = GlobalGraphOperations.at((GraphDatabaseService)graphDb).getAllNodesWithLabel((Label)TermLabel.TERM);
            long count = 0L;
            for (Node term : terms) {
                ++count;
            }
            long l = count;
            return l;
        }
    }

    @Name(value="get_paths_to_facetroots")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation getPathsFromFacetroots(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="termIds") String termIdsJsonString, @Description(value="TODO") @Parameter(name="idType") String idType, @Description(value="TODO") @Parameter(name="sortResult") boolean sort, final @Description(value="TODO") @Parameter(name="facetId") String facetId) throws JSONException {
        JSONArray termIds = new JSONArray(termIdsJsonString);
        Evaluator rootTermEvaluator = new Evaluator(){

            public Evaluation evaluate(Path path) {
                Node endNode = path.endNode();
                Iterator iterator = endNode.getRelationships(new RelationshipType[]{EdgeTypes.HAS_ROOT_TERM}).iterator();
                if (iterator.hasNext()) {
                    String[] facetIds;
                    if (StringUtils.isBlank((String)facetId)) {
                        return Evaluation.INCLUDE_AND_CONTINUE;
                    }
                    for (String facetIdOfRootNode : facetIds = (String[])endNode.getProperty("facets")) {
                        if (!facetIdOfRootNode.equals(facetId)) continue;
                        return Evaluation.INCLUDE_AND_CONTINUE;
                    }
                }
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
        };
        EdgeTypes relType = StringUtils.isBlank((String)facetId) ? EdgeTypes.IS_BROADER_THAN : DynamicRelationshipType.withName((String)(EdgeTypes.IS_BROADER_THAN.name() + "_" + facetId));
        TraversalDescription td = graphDb.traversalDescription().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).depthFirst().relationships((RelationshipType)relType, Direction.INCOMING).evaluator(rootTermEvaluator);
        try (Transaction tx = graphDb.beginTx();){
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < termIds.length(); ++i) {
                String termId = termIds.getString(i);
                termId = QueryParser.escape((String)termId);
                sb.append(idType).append(":").append(termId);
                if (i >= termIds.length() - 1) continue;
                sb.append(" ");
            }
            String termQuery = sb.toString();
            Index termIndex = graphDb.index().forNodes("termIndex");
            IndexHits indexHits = termIndex.query((Object)termQuery);
            ResourceIterator startNodeIterator = indexHits.iterator();
            Node[] startNodes = new Node[indexHits.size()];
            for (int i = 0; i < indexHits.size(); ++i) {
                if (!startNodeIterator.hasNext()) {
                    throw new IllegalStateException(indexHits.size() + " index hits for start nodes expected but iterator expired unexpectedly.");
                }
                startNodes[i] = (Node)startNodeIterator.next();
            }
            Traverser traverse = td.traverse(startNodes);
            ArrayList<String[]> pathsTermIds = new ArrayList<String[]>();
            int c = 0;
            for (Path p : traverse) {
                log.info("Path nr. " + c++ + ":" + p.toString());
                String[] pathTermIds = new String[p.length() + 1];
                Iterator nodesIt = p.nodes().iterator();
                boolean error = false;
                for (int i = p.length(); i >= 0; --i) {
                    if (!nodesIt.hasNext()) {
                        throw new IllegalStateException("Length of path wrong, more nodes expected.");
                    }
                    Node n = (Node)nodesIt.next();
                    if (!n.hasProperty("id")) {
                        log.warn("Came across the term " + n + " (" + NodeUtilities.getNodePropertiesAsString((PropertyContainer)n) + ") when computing root paths. But this term does not have an ID.");
                        error = true;
                        break;
                    }
                    pathTermIds[i] = (String)n.getProperty("id");
                }
                if (error) continue;
                pathsTermIds.add(pathTermIds);
            }
            if (sort) {
                Collections.sort(pathsTermIds, new Comparator<String[]>(){

                    @Override
                    public int compare(String[] o1, String[] o2) {
                        return o1.length - o2.length;
                    }
                });
            }
            HashMap<String, Object> pathsWrappedInMap = new HashMap<String, Object>();
            pathsWrappedInMap.put(RET_KEY_PATHS, pathsTermIds);
            RecursiveMappingRepresentation recursiveMappingRepresentation = new RecursiveMappingRepresentation(Representation.MAP, pathsWrappedInMap);
            return recursiveMappingRepresentation;
        }
    }

    private void insertAggregateTerm(GraphDatabaseService graphDb, Index<Node> termIndex, JSONObject jsonTerm, CoordinatesMap nodesByCoordinates, InsertionReport insertionReport, ImportOptions importOptions) throws JSONException {
        JSONArray copyProperties;
        boolean includeAggreationInHierarchy;
        JSONObject aggCoordinates = jsonTerm.has("coordinates") ? jsonTerm.getJSONObject("coordinates") : new JSONObject();
        String aggOrgId = JSON.getString(aggCoordinates, "originalId");
        String aggOrgSource = JSON.getString(aggCoordinates, "originalSource");
        String aggSrcId = JSON.getString(aggCoordinates, "sourceId");
        String aggSource = JSON.getString(aggCoordinates, "source");
        if (null == aggSource) {
            aggSource = UNKNOWN_TERM_SOURCE;
        }
        log.debug("Looking up aggregate (" + aggOrgId + "," + aggOrgSource + ") / (" + aggSrcId + "," + aggSource + "), original/source coordinates.");
        Node aggregate = this.lookupTerm(new ConceptCoordinates(aggCoordinates, false), termIndex);
        if (null != aggregate) {
            String isHollowMessage = "";
            if (aggregate.hasLabel((Label)TermLabel.HOLLOW)) {
                isHollowMessage = ", however it is hollow and its properties will be set now.";
            }
            log.debug("    aggregate does already exist" + isHollowMessage);
            if (!aggregate.hasLabel((Label)TermLabel.HOLLOW)) {
                return;
            }
            aggregate.removeLabel((Label)TermLabel.HOLLOW);
            aggregate.addLabel((Label)TermLabel.AGGREGATE);
        }
        if (aggregate == null) {
            log.debug("    aggregate is being created");
            aggregate = graphDb.createNode(new Label[]{TermLabel.AGGREGATE});
        }
        boolean bl = includeAggreationInHierarchy = jsonTerm.has("aggregateIncludeInHierarchy") && jsonTerm.getBoolean("aggregateIncludeInHierarchy");
        if (includeAggreationInHierarchy) {
            aggregate.addLabel((Label)TermLabel.TERM);
        }
        JSONArray elementCoords = jsonTerm.getJSONArray("elementCoordinates");
        log.debug("    looking up aggregate elements");
        for (int i = 0; i < elementCoords.length(); ++i) {
            Node element;
            JSONObject elementCoord = elementCoords.getJSONObject(i);
            String elementSrcId = elementCoord.getString("id");
            String elementSource = elementCoord.getString("source");
            if (null == elementSource) {
                elementSource = UNKNOWN_TERM_SOURCE;
            }
            if (null != (element = nodesByCoordinates.get(new ConceptCoordinates(elementSrcId, elementSource, false)))) {
                String[] srcIds = (String[])element.getProperty("sourceIds");
                String[] sources = element.hasProperty("sources") ? (String[])element.getProperty("sources") : new String[]{};
                for (int j = 0; j < srcIds.length; ++j) {
                    String source;
                    String srcId = srcIds[j];
                    String string = source = sources.length > j ? sources[j] : null;
                    if (!srcId.equals(elementSrcId) || elementSource == null && source == null || elementSource.equals(source)) break;
                    element = null;
                }
                if (null != element) {
                    log.debug("\tFound element with source ID and source (" + elementSrcId + ", " + elementSource + ") in in-memory map.");
                }
            }
            if (null == element) {
                element = this.lookupTermBySourceId(elementSrcId, elementSource, false, termIndex);
            }
            if (null == element && importOptions.createHollowAggregateElements) {
                element = graphDb.createNode(new Label[]{TermLabel.TERM, TermLabel.HOLLOW});
                log.debug("    Creating HOLLOW element with source coordinates (" + elementSrcId + "," + elementSource + ")");
                PropertyUtilities.addToArrayProperty((PropertyContainer)element, "sourceIds", elementSrcId);
                PropertyUtilities.addToArrayProperty((PropertyContainer)element, "sources", elementSource);
                termIndex.add((PropertyContainer)element, "sourceIds", (Object)elementSrcId);
            }
            if (element == null) continue;
            aggregate.createRelationshipTo(element, (RelationshipType)EdgeTypes.HAS_ELEMENT);
        }
        if (null != aggSrcId) {
            int idIndex = PropertyUtilities.findFirstValueInArrayProperty(aggregate, "sourceIds", aggSrcId);
            int sourceIndex = PropertyUtilities.findFirstValueInArrayProperty(aggregate, "sources", aggSource);
            if (!StringUtils.isBlank((String)aggSrcId) && (idIndex == -1 && sourceIndex == -1 || idIndex != sourceIndex)) {
                PropertyUtilities.addToArrayProperty((PropertyContainer)aggregate, "sourceIds", aggSrcId, true);
                PropertyUtilities.addToArrayProperty((PropertyContainer)aggregate, "sources", aggSource, true);
            }
            nodesByCoordinates.put(new ConceptCoordinates(aggCoordinates), aggregate);
            termIndex.add((PropertyContainer)aggregate, "sourceIds", (Object)aggSrcId);
        }
        if (null != aggOrgId) {
            aggregate.setProperty("originalId", (Object)aggOrgId);
        }
        if (null != aggOrgSource) {
            aggregate.setProperty("originalSource", (Object)aggOrgSource);
        }
        if (null != (copyProperties = JSON.getJSONArray(jsonTerm, "copyProperties")) && copyProperties.length() > 0) {
            aggregate.setProperty("copyProperties", (Object)JSON.json2JavaArray(copyProperties, new Object[0]));
        }
        JSONArray generalLabels = JSON.getJSONArray(jsonTerm, "generalLabels");
        for (int i = 0; null != generalLabels && i < generalLabels.length(); ++i) {
            aggregate.addLabel(DynamicLabel.label((String)generalLabels.getString(i)));
        }
        String aggregateId = "atid" + SequenceManager.getNextSequenceValue(graphDb, "seqAggregateTerm");
        aggregate.setProperty("id", (Object)aggregateId);
        termIndex.add((PropertyContainer)aggregate, "id", (Object)aggregateId);
        ++insertionReport.numTerms;
    }

    private void insertFacetTerm(GraphDatabaseService graphDb, String facetId, Index<Node> termIndex, JSONObject jsonTerm, CoordinatesMap nodesByCoordinates, InsertionReport insertionReport, ImportOptions importOptions) throws JSONException {
        String prefName = JSON.getString(jsonTerm, "preferredName");
        JSONArray synonyms = JSON.getJSONArray(jsonTerm, "synonyms");
        JSONArray generalLabels = JSON.getJSONArray(jsonTerm, "generalLabels");
        JSONObject coordinatesJson = jsonTerm.getJSONObject("coordinates");
        ConceptCoordinates coordinates = new ConceptCoordinates(coordinatesJson);
        if (!jsonTerm.has("coordinates") || coordinatesJson.length() == 0) {
            throw new IllegalArgumentException("The concept " + jsonTerm.toString(2) + " does not specify coordinates.");
        }
        String srcId = importOptions.merge ? JSON.getString(coordinatesJson, "sourceId") : coordinatesJson.getString("sourceId");
        String orgId = JSON.getString(coordinatesJson, "originalId");
        String source = JSON.getString(coordinatesJson, "source");
        String orgSource = JSON.getString(coordinatesJson, "originalSource");
        boolean uniqueSourceId = JSON.getBoolean(coordinatesJson, "uniqueSourceId", false);
        boolean srcIduniqueMarkerChanged = false;
        if (StringUtils.isBlank((String)srcId) && !StringUtils.isBlank((String)orgId) && (StringUtils.isBlank((String)source) && !StringUtils.isBlank((String)orgSource) || source.equals(orgSource))) {
            srcId = orgId;
            source = orgSource;
        }
        if (StringUtils.isBlank((String)source)) {
            source = UNKNOWN_TERM_SOURCE;
        }
        if (StringUtils.isBlank((String)orgId) ^ StringUtils.isBlank((String)orgSource)) {
            throw new IllegalArgumentException("Term to be inserted defines only its original ID or its original source but not both. This is not allowed. The term data was: " + jsonTerm);
        }
        if (importOptions.merge && jsonTerm.has("parentCoordinates")) {
            throw new IllegalArgumentException("Term " + jsonTerm + " is supposed to be merged with an existing database term but defines parents. This is currently not supported in merging mode.");
        }
        Node term = nodesByCoordinates.get(coordinates);
        if (term == null && !importOptions.merge) {
            throw new IllegalStateException("No concept node was found or created for import concept with coordinates " + coordinatesJson + " and this is not a merging operation.");
        }
        if (term == null) {
            return;
        }
        if (term.hasLabel((Label)TermLabel.HOLLOW)) {
            log.debug("Got HOLLOW concept node with coordinates " + coordinatesJson + " and will create full concept.");
            term.removeLabel((Label)TermLabel.HOLLOW);
            term.addLabel((Label)TermLabel.TERM);
            Iterable relationships = term.getRelationships(new RelationshipType[]{EdgeTypes.HAS_ROOT_TERM});
            for (Relationship rel : relationships) {
                Node startNode = rel.getStartNode();
                if (!startNode.hasLabel((Label)FacetManager.FacetLabel.FACET)) continue;
                rel.delete();
            }
            String termId = "tid" + SequenceManager.getNextSequenceValue(graphDb, "seqTerm");
            term.setProperty("id", (Object)termId);
            termIndex.putIfAbsent((PropertyContainer)term, "id", (Object)termId);
        }
        if (!StringUtils.isBlank((String)coordinates.originalId) && !term.hasProperty("originalId")) {
            term.setProperty("originalId", (Object)coordinates.originalId);
            term.setProperty("originalSource", (Object)coordinates.originalSource);
        }
        PropertyUtilities.mergeJSONObjectIntoPropertyContainer(jsonTerm, (PropertyContainer)term, "generalLabels", "sourceIds", "sources", "synonyms", "coordinates", "parentCoordinates", "relationships");
        int idIndex = PropertyUtilities.findFirstValueInArrayProperty(term, "sourceIds", srcId);
        int sourceIndex = PropertyUtilities.findFirstValueInArrayProperty(term, "sources", source);
        if (!StringUtils.isBlank((String)srcId) && (idIndex == -1 && sourceIndex == -1 || idIndex != sourceIndex)) {
            if (term.hasProperty("sourceIds")) {
                srcIduniqueMarkerChanged = this.checkUniqueIdMarkerClash(term, srcId, uniqueSourceId);
            }
            PropertyUtilities.addToArrayProperty((PropertyContainer)term, "sourceIds", srcId, true);
            PropertyUtilities.addToArrayProperty((PropertyContainer)term, "sources", source, true);
            PropertyUtilities.addToArrayProperty((PropertyContainer)term, "uniqueSourceId", uniqueSourceId, true);
        }
        PropertyUtilities.mergeArrayProperty((PropertyContainer)term, "synonyms", JSON.json2JavaArray(synonyms, prefName));
        PropertyUtilities.addToArrayProperty((PropertyContainer)term, "facets", facetId);
        for (int i = 0; null != generalLabels && i < generalLabels.length(); ++i) {
            term.addLabel(DynamicLabel.label((String)generalLabels.getString(i)));
        }
        if (srcIduniqueMarkerChanged) {
            log.warn("Merging concept nodes with unique source ID " + srcId + " because on term with this source ID and source " + source + " the ID was declared non-unique in the past but unique now. Properties from all nodes are merged together and relationships are moved from obsolete nodes to the single remaining node. This is experimental and might lead to errors.");
            ArrayList<Node> obsoleteNodes = new ArrayList<Node>();
            Node mergedNode = NodeUtilities.mergeConceptNodesWithUniqueSourceId(srcId, termIndex, obsoleteNodes);
            for (Node obsoleteNode : obsoleteNodes) {
                Iterable relationships = obsoleteNode.getRelationships();
                for (Relationship rel : relationships) {
                    Node startNode = rel.getStartNode();
                    Node endNode = rel.getEndNode();
                    if (startNode.getId() == obsoleteNode.getId()) {
                        startNode = mergedNode;
                    }
                    if (endNode.getId() == obsoleteNode.getId()) {
                        endNode = mergedNode;
                    }
                    this.createRelationShipIfNotExists(startNode, endNode, rel.getType(), insertionReport, Direction.OUTGOING, rel.getAllProperties());
                    rel.delete();
                    obsoleteNode.delete();
                }
            }
        }
        if (StringUtils.isBlank((String)prefName) && !insertionReport.existingConcepts.contains(term)) {
            throw new IllegalArgumentException("Term has no property \"preferredName\": " + jsonTerm);
        }
    }

    private boolean checkUniqueIdMarkerClash(Node conceptNode, String srcId, boolean uniqueSourceId) {
        boolean uniqueOnConcept = NodeUtilities.isSourceUnique(conceptNode, srcId);
        return !uniqueOnConcept && uniqueOnConcept != uniqueSourceId;
    }

    private InsertionReport insertFacetTerms(GraphDatabaseService graphDb, JSONArray jsonTerms, String facetId, CoordinatesMap nodesByCoordinates, ImportOptions importOptions) throws JSONException {
        JSONObject jsonTerm;
        long time = System.currentTimeMillis();
        InsertionReport insertionReport = new InsertionReport();
        Index termIndex = null;
        IndexManager indexManager = graphDb.index();
        termIndex = indexManager.forNodes("termIndex");
        CoordinatesSet toBeCreated = new CoordinatesSet();
        if (!importOptions.merge) {
            for (int i = 0; i < jsonTerms.length(); ++i) {
                JSONObject jsonTerm2 = jsonTerms.getJSONObject(i);
                if (!jsonTerm2.has("parentCoordinates") || jsonTerm2.getJSONArray("parentCoordinates").length() <= 0) continue;
                JSONArray parentCoordinatesArray = jsonTerm2.getJSONArray("parentCoordinates");
                for (int j = 0; j < parentCoordinatesArray.length(); ++j) {
                    ConceptCoordinates parentCoordinates = new ConceptCoordinates(parentCoordinatesArray.getJSONObject(j));
                    Node parentNode = this.lookupTerm(parentCoordinates, (Index<Node>)termIndex);
                    if (parentNode != null) {
                        insertionReport.addExistingTerm(parentNode);
                        nodesByCoordinates.put(parentCoordinates, parentNode);
                        continue;
                    }
                    toBeCreated.add(parentCoordinates);
                }
            }
        }
        ArrayList<Integer> importConceptsToRemove = new ArrayList<Integer>();
        for (int i = 0; i < jsonTerms.length(); ++i) {
            jsonTerm = jsonTerms.getJSONObject(i);
            ConceptCoordinates coordinates = null;
            if (!jsonTerm.has("coordinates")) {
                if (JSON.getBoolean(jsonTerm, "aggregate")) continue;
                throw new IllegalArgumentException("Concept " + jsonTerm + " does not define concept coordinates.");
            }
            coordinates = new ConceptCoordinates(jsonTerm.getJSONObject("coordinates"));
            insertionReport.addImportedCoordinates(coordinates);
            if (nodesByCoordinates.containsKey(coordinates) || toBeCreated.contains(coordinates, true)) continue;
            Node conceptNode = this.lookupTerm(coordinates, (Index<Node>)termIndex);
            if (conceptNode != null) {
                insertionReport.addExistingTerm(conceptNode);
                nodesByCoordinates.put(coordinates, conceptNode);
                continue;
            }
            if (!importOptions.merge) {
                toBeCreated.add(coordinates);
                continue;
            }
            importConceptsToRemove.add(i);
        }
        for (ConceptCoordinates coordinates : toBeCreated) {
            Node conceptNode = this.registerNewHollowConceptNode(graphDb, coordinates, (Index<Node>)termIndex, new Label[0]);
            ++insertionReport.numTerms;
            nodesByCoordinates.put(coordinates, conceptNode);
        }
        log.info("removing " + importConceptsToRemove.size() + " input concepts that should be omitted because we are merging and don't have them in the database");
        for (int index = importConceptsToRemove.size() - 1; index >= 0; --index) {
            jsonTerms.remove(((Integer)importConceptsToRemove.get(index)).intValue());
        }
        importConceptsToRemove = null;
        log.info("Starting to insert " + jsonTerms.length() + " terms.");
        for (int i = 0; i < jsonTerms.length(); ++i) {
            jsonTerm = jsonTerms.getJSONObject(i);
            boolean isAggregate = JSON.getBoolean(jsonTerm, "aggregate");
            if (isAggregate) {
                this.insertAggregateTerm(graphDb, (Index<Node>)termIndex, jsonTerm, nodesByCoordinates, insertionReport, importOptions);
                continue;
            }
            this.insertFacetTerm(graphDb, facetId, (Index<Node>)termIndex, jsonTerm, nodesByCoordinates, insertionReport, importOptions);
        }
        log.debug(jsonTerms.length() + " terms inserted.");
        time = System.currentTimeMillis() - time;
        log.info(insertionReport.numTerms + " new terms - but not yet relationships - have been inserted. This took " + time + " ms (" + time / 1000L + " s)");
        return insertionReport;
    }

    private Node registerNewHollowConceptNode(GraphDatabaseService graphDb, ConceptCoordinates coordinates, Index<Node> termIndex, Label ... additionalLabels) {
        Node node = graphDb.createNode(new Label[]{TermLabel.HOLLOW});
        for (int i = 0; i < additionalLabels.length; ++i) {
            Label label = additionalLabels[i];
            node.addLabel(label);
        }
        log.debug("Created new HOLLOW concept node for coordinates " + coordinates + "");
        if (!StringUtils.isBlank((String)coordinates.originalId)) {
            node.setProperty("originalId", (Object)coordinates.originalId);
            node.setProperty("originalSource", (Object)coordinates.originalSource);
        }
        node.setProperty("sourceIds", (Object)new String[]{coordinates.sourceId});
        node.setProperty("sources", (Object)new String[]{coordinates.source});
        node.setProperty("uniqueSourceId", (Object)new boolean[]{coordinates.uniqueSourceId});
        if (!StringUtils.isBlank((String)coordinates.sourceId)) {
            termIndex.putIfAbsent((PropertyContainer)node, "sourceIds", (Object)coordinates.sourceId);
        }
        if (!StringUtils.isBlank((String)coordinates.originalId)) {
            termIndex.putIfAbsent((PropertyContainer)node, "originalId", (Object)coordinates.originalId);
        }
        return node;
    }

    public Representation insertFacetTerms(GraphDatabaseService graphDb, String termsAndFacetJson) throws JSONException {
        JSONObject input = new JSONObject(termsAndFacetJson);
        JSONObject jsonFacet = JSON.getJSONObject(input, KEY_FACET);
        JSONArray jsonTerms = input.getJSONArray("terms");
        JSONObject importOptionsJson = JSON.getJSONObject(input, KEY_IMPORT_OPTIONS);
        return this.insertFacetTerms(graphDb, jsonFacet != null ? jsonFacet.toString() : null, jsonTerms.toString(), importOptionsJson != null ? importOptionsJson.toString() : null);
    }

    @Name(value="insert_terms")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation insertFacetTerms(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="facet", optional=true) String facetJson, @Description(value="TODO") @Parameter(name="terms", optional=true) String termsJson, @Description(value="TODO") @Parameter(name="importOptions", optional=true) String importOptionsJsonString) throws JSONException {
        ImportOptions importOptions;
        log.info("insert_terms was called");
        long time = System.currentTimeMillis();
        Gson gson = new Gson();
        log.debug("Parsing input.");
        JSONObject jsonFacet = null;
        JSONArray jsonTerms = null;
        JSONObject importOptionsJson = null;
        JSONObject jSONObject = jsonFacet = !StringUtils.isEmpty((String)facetJson) ? new JSONObject(facetJson) : null;
        if (null != termsJson) {
            jsonTerms = new JSONArray(termsJson);
            log.info("Got " + jsonTerms.length() + " input concepts for import.");
        } else {
            log.info("Got 0 input concepts for import.");
        }
        if (null != importOptionsJsonString) {
            importOptionsJson = new JSONObject(importOptionsJsonString);
            importOptions = gson.fromJson(importOptionsJson.toString(), ImportOptions.class);
        } else {
            importOptions = new ImportOptions();
        }
        HashMap<String, Object> report = new HashMap<String, Object>();
        InsertionReport insertionReport = new InsertionReport();
        log.debug("Beginning processing of term insertion.");
        try (Transaction tx = graphDb.beginTx();){
            Node facet = null;
            String facetId = null;
            log.debug("Handling import of facet.");
            if (null != jsonFacet && jsonFacet.has("id")) {
                facetId = jsonFacet.getString("id");
                log.info("Facet ID " + facetId + " has been given to add the terms to.");
                boolean isNoFacet = JSON.getBoolean(jsonFacet, "noFacet");
                facet = isNoFacet ? FacetManager.getNoFacet(graphDb, facetId) : FacetManager.getFacetNode(graphDb, facetId);
                if (null == facet) {
                    throw new IllegalArgumentException("The facet with ID \"" + facetId + "\" was not found. You must pass the ID of an existing facet or deliver all information required to create the facet from scratch. Then, the facetId must not be included in the request, it will be created dynamically.");
                }
            } else if (null != jsonFacet && jsonFacet.has("name")) {
                ResourceIterator facetIterator = graphDb.findNodes((Label)FacetManager.FacetLabel.FACET);
                while (facetIterator.hasNext() && !(facet = (Node)facetIterator.next()).getProperty("name").equals(jsonFacet.getString("name"))) {
                    facet = null;
                }
            }
            if (null != jsonFacet && null == facet) {
                facet = FacetManager.createFacet(graphDb, jsonFacet);
            }
            if (null != facet) {
                facetId = (String)facet.getProperty("id");
                log.debug("Facet " + facetId + " was successfully created or determined by ID.");
            } else {
                log.debug("No facet was specified for this import. This is currently equivalent to specifying the merge import option, i.e. concept properties will be merged but no new nodes or relationships will be created.");
                importOptions.merge = true;
            }
            if (null != jsonTerms) {
                log.debug("Beginning to create term nodes and relationships.");
                CoordinatesMap nodesByCoordinates = new CoordinatesMap();
                insertionReport = this.insertFacetTerms(graphDb, jsonTerms, facetId, nodesByCoordinates, importOptions);
                if (!nodesByCoordinates.isEmpty() && !importOptions.merge) {
                    this.createRelationships(graphDb, jsonTerms, facet, nodesByCoordinates, importOptions, insertionReport);
                } else {
                    log.info("This is a property merging import, no relationships are created.");
                }
                time = System.currentTimeMillis() - time;
                report.put(RET_KEY_NUM_CREATED_TERMS, insertionReport.numTerms);
                report.put(RET_KEY_NUM_CREATED_RELS, insertionReport.numRelationships);
                report.put(KEY_FACET_ID, facetId);
                report.put(KEY_TIME, time);
                log.debug("Done creating terms and relationships.");
            } else {
                log.info("No terms were included in the request.");
            }
            tx.success();
        }
        log.info("Term insertion complete.");
        log.info("insert_terms is finished processing after " + time + " ms. " + insertionReport.numTerms + " terms and " + insertionReport.numRelationships + " relationships have been created.");
        return new RecursiveMappingRepresentation(Representation.MAP, report);
    }

    private Node lookupTerm(ConceptCoordinates coordinates, Index<Node> termIndex) {
        Node term;
        String orgId = coordinates.originalId;
        String orgSource = coordinates.originalSource;
        String srcId = coordinates.sourceId;
        String source = coordinates.source;
        boolean uniqueSourceId = coordinates.uniqueSourceId;
        log.debug("Looking up term via original ID and source ({}, {}) and source ID and source ({}, {}).", new Object[]{orgId, orgSource, srcId, source});
        if (!(null != orgId && null != orgSource || null != srcId && null != source)) {
            log.debug("Neither original ID and original source nor source ID and source were given, returning null.");
            return null;
        }
        Node node = term = null != orgId ? (Node)termIndex.get("originalId", (Object)orgId).getSingle() : null;
        if (term != null) {
            log.debug("Found term by original ID " + orgId);
        }
        if (null != term) {
            if (!PropertyUtilities.hasSamePropertyValue((PropertyContainer)term, "originalSource", orgSource)) {
                log.debug("Original source doesn't match; requested: " + orgSource + ", found term has: " + NodeUtilities.getString(term, "originalSource"));
                term = null;
            } else {
                log.debug("Found existing term for original ID " + orgId + " and original source " + orgSource);
            }
        }
        if (null == term && null != srcId && null != (term = this.lookupTermBySourceId(srcId, source, uniqueSourceId, termIndex))) {
            Object existingOrgId = NodeUtilities.getNonNullNodeProperty((PropertyContainer)term, "originalId");
            Object existingOrgSrc = NodeUtilities.getNonNullNodeProperty((PropertyContainer)term, "originalSource");
            if (!(null == existingOrgId || null == existingOrgSrc || null == orgId || null == orgSource || existingOrgId.equals(orgId) && existingOrgSrc.equals(orgSource))) {
                throw new IllegalStateException(String.format("Inconsistent data: A newly imported term has original ID, original source (%s, %s) and source ID, source (%s, %s); the latter matches the found term with ID %s but a this term has an original ID and source (%s, %s)", orgId, orgSource, srcId, source, NodeUtilities.getNonNullNodeProperty((PropertyContainer)term, "id"), existingOrgId, existingOrgSrc));
            }
        }
        if (null == term) {
            log.debug("    Did not find an existing term with original ID and source ({}, {}) or source ID and source ({}, {}).", new Object[]{orgId, orgSource, srcId, source});
        }
        return term;
    }

    private Node lookupTermBySourceId(String srcId, String source, boolean uniqueSourceId, Index<Node> termIndex) {
        log.debug("Trying to look up existing term by source ID and source ({}, {})", (Object)srcId, (Object)source);
        IndexHits indexHits = termIndex.get("sourceIds", (Object)srcId);
        if (!indexHits.hasNext()) {
            log.debug("    Did not find any term with source ID " + srcId);
        }
        Node soughtConcept = null;
        boolean uniqueSourceIdNodeFound = false;
        while (indexHits.hasNext()) {
            Set<String> sources;
            boolean uniqueOnConceptNode;
            Node conceptNode = (Node)indexHits.next();
            if (null == conceptNode) continue;
            if (uniqueSourceId && (uniqueOnConceptNode = NodeUtilities.isSourceUnique(conceptNode, srcId))) {
                if (soughtConcept == null) {
                    soughtConcept = conceptNode;
                } else if (uniqueSourceIdNodeFound) {
                    throw new IllegalStateException("There are multiple concept nodes with unique source ID " + srcId + ". This means that some sources define the ID as unique and others not. This can lead to an inconsistent database as happened in this case.");
                }
                log.debug("    Found existing term with unique source ID " + srcId + " which matches given unique source ID");
                uniqueSourceIdNodeFound = true;
            }
            if (!(sources = NodeUtilities.getSourcesForSourceId(conceptNode, srcId)).contains(source)) {
                log.debug("    Did not find a match for source ID " + srcId + " and source " + source);
                conceptNode = null;
            } else {
                log.debug("    Found existing term for source ID " + srcId + " and source " + source);
            }
            if (soughtConcept == null) {
                soughtConcept = conceptNode;
                continue;
            }
            if (uniqueSourceIdNodeFound) continue;
            throw new IllegalStateException("There are multiple concept nodes with source ID " + srcId + " and source " + source);
        }
        return soughtConcept;
    }

    @Name(value="pop_terms_from_set")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public Representation popTermsFromSet(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="label") String labelString, @Description(value="TODO") @Parameter(name="amount") int amount) {
        Label label = DynamicLabel.label((String)labelString);
        ArrayList<Node> poppedTerms = new ArrayList<Node>(amount);
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable nodesWithLabel = GlobalGraphOperations.at((GraphDatabaseService)graphDb).getAllNodesWithLabel(label);
            Node term = null;
            ResourceIterator it = nodesWithLabel.iterator();
            for (int popCount = 0; it.hasNext() && popCount < amount; ++popCount) {
                term = (Node)it.next();
                poppedTerms.add(term);
            }
            tx.success();
        }
        tx = graphDb.beginTx();
        var7_7 = null;
        try {
            for (Node term : poppedTerms) {
                term.removeLabel(label);
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("terms", poppedTerms);
        return new RecursiveMappingRepresentation(Representation.MAP, retMap);
    }

    @Name(value="push_terms_to_set")
    @Description(value="TODO")
    @PluginTarget(value=GraphDatabaseService.class)
    public long pushTermsToSet(@Source GraphDatabaseService graphDb, @Description(value="TODO") @Parameter(name="termPushCommand") String termPushCommandString, @Description(value="The amount of terms to push into the set. If equal or less than zero or omitted, all terms will be pushed.") @Parameter(name="amount", optional=true) Integer amount) {
        Gson gson = new Gson();
        PushTermsToSetCommand cmd = gson.fromJson(termPushCommandString, PushTermsToSetCommand.class);
        Label setLabel = DynamicLabel.label((String)cmd.setName);
        HashSet<String> facetsWithSpecifiedGeneralLabel = new HashSet<String>();
        PushTermsToSetCommand.TermSelectionDefinition eligibleTermDefinition = cmd.eligibleTermDefinition;
        PushTermsToSetCommand.TermSelectionDefinition excludeDefinition = cmd.excludeTermDefinition;
        Label facetLabel = null;
        if (null != eligibleTermDefinition && null != eligibleTermDefinition.facetLabel) {
            facetLabel = DynamicLabel.label((String)eligibleTermDefinition.facetLabel);
        }
        String facetPropertyKey = null != eligibleTermDefinition ? eligibleTermDefinition.facetPropertyKey : "*";
        String facetPropertyValue = null != eligibleTermDefinition ? eligibleTermDefinition.facetPropertyValue : "*";
        try (Transaction tx = graphDb.beginTx();){
            Node facetGroupsNode = FacetManager.getFacetGroupsNode(graphDb);
            TraversalDescription facetTraversal = PredefinedTraversals.getFacetTraversal(graphDb, facetPropertyKey, facetPropertyValue);
            Traverser traverse = facetTraversal.traverse(facetGroupsNode);
            for (Path path : traverse) {
                Node facetNode = path.endNode();
                if (null != facetLabel && !facetNode.hasLabel(facetLabel)) continue;
                facetsWithSpecifiedGeneralLabel.add((String)facetNode.getProperty("id"));
            }
            tx.success();
        }
        log.info("Determined " + facetsWithSpecifiedGeneralLabel.size() + " facets with given restrictions.");
        long numberOfTermsAdded = 0L;
        long numberOfTermsToAdd = null != amount && amount > 0 ? (long)amount.intValue() : Long.MAX_VALUE;
        Transaction tx = graphDb.beginTx();
        Object object = null;
        try {
            TermLabel eligibleTermLabel = TermLabel.TERM;
            if (null != eligibleTermDefinition && !StringUtils.isBlank((String)eligibleTermDefinition.termLabel)) {
                eligibleTermLabel = DynamicLabel.label((String)eligibleTermDefinition.termLabel);
            }
            ResourceIterable allTerms = GlobalGraphOperations.at((GraphDatabaseService)graphDb).getAllNodesWithLabel((Label)eligibleTermLabel);
            ResourceIterator termIt = allTerms.iterator();
            while (termIt.hasNext() && numberOfTermsAdded < numberOfTermsToAdd) {
                for (int i = 0; termIt.hasNext() && i < 10000 && numberOfTermsAdded < numberOfTermsToAdd; ++i) {
                    Node term = (Node)termIt.next();
                    if (null != excludeDefinition) {
                        Label termLabel;
                        boolean exclude = false;
                        String termPropertyKey = excludeDefinition.termPropertyKey;
                        String termPropertyValue = excludeDefinition.termPropertyValue;
                        Label label = termLabel = excludeDefinition.termLabel == null ? null : DynamicLabel.label((String)excludeDefinition.termLabel);
                        if (term.hasProperty(termPropertyKey)) {
                            Object property = term.getProperty(termPropertyKey);
                            if (property.getClass().isArray()) {
                                Object[] propertyArray;
                                for (Object o : propertyArray = (Object[])property) {
                                    if (!o.equals(termPropertyValue)) continue;
                                    exclude = true;
                                    break;
                                }
                            } else if (property.equals(termPropertyValue)) {
                                exclude = true;
                            }
                        }
                        if (term.hasLabel(termLabel)) {
                            exclude = true;
                        }
                        if (exclude) continue;
                    }
                    boolean hasFacetWithCorrectGeneralLabel = false;
                    if (null != eligibleTermDefinition) {
                        String[] facetIds;
                        if (term.hasLabel((Label)TermLabel.HOLLOW)) continue;
                        if (!term.hasProperty("facets")) {
                            log.warn("Term with internal ID " + term.getId() + " has no facets property.");
                            continue;
                        }
                        for (String facetId : facetIds = (String[])term.getProperty("facets")) {
                            if (!facetsWithSpecifiedGeneralLabel.contains(facetId)) continue;
                            hasFacetWithCorrectGeneralLabel = true;
                            break;
                        }
                    }
                    if (!hasFacetWithCorrectGeneralLabel && null != eligibleTermDefinition) continue;
                    term.addLabel(setLabel);
                    ++numberOfTermsAdded;
                }
            }
            tx.success();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        log.info("Finished pushing " + numberOfTermsAdded + " terms to set \"" + cmd.setName + "\".");
        return numberOfTermsAdded;
    }

    @Name(value="update_children_information")
    @Description(value="Updates - or creates - the information which term has children in which facets. This information is used in Semedico to either render an 'opening' arrow next to a term to display its children, or no 'drill-down' option depending on whether the term in question has children in the facet it is shown in or not.")
    @PluginTarget(value=GraphDatabaseService.class)
    public String updateChildrenInformation(@Source GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterator termIt = graphDb.findNodes((Label)TermLabel.TERM);
            while (termIt.hasNext()) {
                Node term = (Node)termIt.next();
                Iterator relIt = term.getRelationships(Direction.OUTGOING).iterator();
                HashSet<String> facetsContainingChildren = new HashSet<String>();
                while (relIt.hasNext()) {
                    String[] typeNameParts;
                    String lastPart;
                    Relationship rel = (Relationship)relIt.next();
                    String type = rel.getType().name();
                    if (!type.startsWith(EdgeTypes.IS_BROADER_THAN.toString()) || !(lastPart = (typeNameParts = type.split("_"))[typeNameParts.length - 1]).startsWith("fid")) continue;
                    facetsContainingChildren.add(lastPart);
                }
                if (facetsContainingChildren.size() == 0 && term.hasProperty("childrenInFacets")) {
                    term.removeProperty("childrenInFacets");
                    continue;
                }
                if (facetsContainingChildren.size() <= 0) continue;
                term.setProperty("childrenInFacets", (Object)facetsContainingChildren.toArray(new String[facetsContainingChildren.size()]));
            }
            tx.success();
            String string = "success";
            return string;
        }
    }

    @Name(value="include_terms")
    @Description(value="This is only a remedy for a problem we shouldnt have, delete in the future.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void includeTerms(@Source GraphDatabaseService graphDb) throws JSONException {
        Label includeLabel = DynamicLabel.label((String)"INCLUDE");
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable terms = GlobalGraphOperations.at((GraphDatabaseService)graphDb).getAllNodesWithLabel(includeLabel);
            for (Node term : terms) {
                term.removeLabel(includeLabel);
            }
            tx.success();
        }
        HashSet<String> facetIds = new HashSet<String>();
        try (Transaction tx = graphDb.beginTx();){
            Node facetGroupsNode = FacetManager.getFacetGroupsNode(graphDb);
            TraversalDescription facetTraversal = PredefinedTraversals.getFacetTraversal(graphDb, null, null);
            Traverser traverse = facetTraversal.traverse(facetGroupsNode);
            for (Path path : traverse) {
                Node facetNode = path.endNode();
                facetIds.add((String)facetNode.getProperty("id"));
            }
            log.info("Including terms from facets " + facetIds);
            tx.success();
        }
        tx = graphDb.beginTx();
        var5_5 = null;
        try {
            ResourceIterable terms = GlobalGraphOperations.at((GraphDatabaseService)graphDb).getAllNodesWithLabel((Label)TermLabel.TERM);
            block29: for (Node term : terms) {
                if (!term.hasProperty("facets")) {
                    log.info("Doesnt have facets: " + PropertyUtilities.getNodePropertiesAsString((PropertyContainer)term));
                    continue;
                }
                String[] facets = (String[])term.getProperty("facets");
                for (int i = 0; i < facets.length; ++i) {
                    String string = facets[i];
                    if (!facetIds.contains(string)) continue;
                    term.addLabel(includeLabel);
                    continue block29;
                }
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Name(value="exclude_terms")
    @Description(value="This is only a remedy for a problem we shouldnt have, delete in the future.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void excludeTerms(@Source GraphDatabaseService graphDb) throws JSONException {
        ResourceIterable terms;
        Label includeLabel = DynamicLabel.label((String)"INCLUDE");
        Label excludeLabel = DynamicLabel.label((String)"EXCLUDE");
        Label mappingAggregateLabel = DynamicLabel.label((String)"MAPPING_AGGREGATE");
        try (Transaction tx = graphDb.beginTx();){
            terms = GlobalGraphOperations.at((GraphDatabaseService)graphDb).getAllNodesWithLabel((Label)TermLabel.TERM);
            for (Node term : terms) {
                if (!term.hasLabel(includeLabel)) {
                    term.addLabel(excludeLabel);
                    term.removeLabel(mappingAggregateLabel);
                    term.removeLabel((Label)TermLabel.AGGREGATE);
                    term.removeLabel((Label)TermLabel.TERM);
                    continue;
                }
                term.addLabel(mappingAggregateLabel);
            }
            tx.success();
        }
        tx = graphDb.beginTx();
        var6_6 = null;
        try {
            terms = GlobalGraphOperations.at((GraphDatabaseService)graphDb).getAllNodesWithLabel((Label)TermLabel.AGGREGATE);
            for (Node a : terms) {
                a.removeLabel((Label)TermLabel.AGGREGATE);
                a.removeLabel(mappingAggregateLabel);
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Name(value="insert_mappings")
    @Description(value="Adds a set of term mappings to the database. Here, a 'mapping' between two terms means that those terms are 'similar' to one another. The actual similarity - e.g. 'equal' or 'related' - is defined by the type of the mapping. Here, all mappings are interpreted as being symmetric. That does not mean that two relationships are created but that reading commands don't care about the relationship direction.")
    @PluginTarget(value=GraphDatabaseService.class)
    public int insertMappings(@Source GraphDatabaseService graphDb, @Description(value="An array of mappings in JSON format. Each mapping is an object with the keys for \"id1\", \"id2\" and \"mappingType\", respectively.") @Parameter(name="mappings") String mappingsJson) throws JSONException {
        JSONArray mappings = new JSONArray(mappingsJson);
        log.info("Starting to insert " + mappings.length() + " mappings.");
        try (Transaction tx = graphDb.beginTx();){
            Index termIndex = graphDb.index().forNodes("termIndex");
            HashMap<String, Node> nodesBySrcId = new HashMap<String, Node>(mappings.length());
            InsertionReport insertionReport = new InsertionReport();
            for (int i = 0; i < mappings.length(); ++i) {
                Node n2;
                JSONObject mapping = mappings.getJSONObject(i);
                String id1 = mapping.getString("id1");
                String id2 = mapping.getString("id2");
                String mappingType = mapping.getString("mappingType");
                log.debug("Inserting mapping " + id1 + " -" + mappingType + "- " + id2);
                if (StringUtils.isBlank((String)id1)) {
                    throw new IllegalArgumentException("id1 in mapping \"" + mapping + "\" is missing.");
                }
                if (StringUtils.isBlank((String)id2)) {
                    throw new IllegalArgumentException("id2 in mapping \"" + mapping + "\" is missing.");
                }
                if (StringUtils.isBlank((String)mappingType)) {
                    throw new IllegalArgumentException("mappingType in mapping \"" + mapping + "\" is missing.");
                }
                Node n1 = (Node)nodesBySrcId.get(id1);
                if (null == n1) {
                    IndexHits indexHits = termIndex.get("sourceIds", (Object)id1);
                    if (indexHits.size() > 1) {
                        log.error("More than one node for source ID {}", (Object)id1);
                        for (Node n : indexHits) {
                            log.error(NodeUtilities.getNodePropertiesAsString((PropertyContainer)n));
                        }
                        throw new IllegalStateException("More than one node for source ID " + id1);
                    }
                    n1 = (Node)indexHits.getSingle();
                    if (null == n1) {
                        log.warn("There is no term with source ID \"" + id1 + "\" as required by the mapping \"" + mapping + "\" Mapping is skipped.");
                        continue;
                    }
                    nodesBySrcId.put(id1, n1);
                }
                if (null == (n2 = (Node)nodesBySrcId.get(id2))) {
                    n2 = (Node)termIndex.get("sourceIds", (Object)id2).getSingle();
                    if (null == n2) {
                        log.warn("There is no term with source ID \"" + id2 + "\" as required by the mapping \"" + mapping + "\" Mapping is skipped.");
                        continue;
                    }
                    nodesBySrcId.put(id2, n2);
                }
                if (mappingType.equalsIgnoreCase("LOOM")) {
                    String facet;
                    int j;
                    String[] n1Facets = (String[])n1.getProperty("facets");
                    String[] n2Facets = (String[])n2.getProperty("facets");
                    HashSet<String> n1FacetSet = new HashSet<String>();
                    HashSet<String> n2FacetSet = new HashSet<String>();
                    for (j = 0; j < n1Facets.length; ++j) {
                        facet = n1Facets[j];
                        n1FacetSet.add(facet);
                    }
                    for (j = 0; j < n2Facets.length; ++j) {
                        facet = n2Facets[j];
                        n2FacetSet.add(facet);
                    }
                    if (!Sets.intersection(n1FacetSet, n2FacetSet).isEmpty()) {
                        log.debug("Omitting LOOM mapping between " + id1 + " and " + id2 + " because both concepts appear in the same terminology. We assume that the terminology does not have two equal terms and that LOOM is wrong here.");
                        continue;
                    }
                }
                insertionReport.addExistingTerm(n1);
                insertionReport.addExistingTerm(n2);
                this.createRelationShipIfNotExists(n1, n2, EdgeTypes.IS_MAPPED_TO, insertionReport, Direction.BOTH, "mappingType", new String[]{mappingType});
            }
            tx.success();
            log.info(insertionReport.numRelationships + " of " + mappings.length() + " new mappings successfully added.");
            int n = insertionReport.numRelationships;
            return n;
        }
    }

    @Name(value="get_facet_roots")
    @Description(value="Returns root terms for the facets with specified IDs. Can also be restricted to particular roots which is useful for facets that have a lot of roots.")
    @PluginTarget(value=GraphDatabaseService.class)
    public MappingRepresentation getFacetRoots(@Source GraphDatabaseService graphDb, @Description(value="An array of facet IDs in JSON format.") @Parameter(name="facetIds") String facetIdsJson, @Description(value="An array of term IDs to restrict the retrieval to.") @Parameter(name="termIds", optional=true) String termIdsJson, @Description(value="Restricts the facets to those that have at most the specified number of roots.") @Parameter(name="maxRoots", optional=true) long maxRoots) throws JSONException {
        HashMap<String, Object> facetRoots = new HashMap<String, Object>();
        JSONArray facetIdsArray = new JSONArray(facetIdsJson);
        HashSet<String> requestedFacetIds = new HashSet<String>();
        for (int i = 0; i < facetIdsArray.length(); ++i) {
            requestedFacetIds.add(facetIdsArray.getString(i));
        }
        HashMap requestedTermIds = null;
        if (!StringUtils.isBlank((String)termIdsJson) && !termIdsJson.equals("null")) {
            JSONObject termIdsObject = new JSONObject(termIdsJson);
            requestedTermIds = new HashMap();
            JSONArray facetIds = termIdsObject.names();
            for (int i = 0; null != facetIds && i < facetIds.length(); ++i) {
                String facetId = facetIds.getString(i);
                JSONArray requestedRootIdsForFacet = termIdsObject.getJSONArray(facetId);
                HashSet<String> idSet = new HashSet<String>();
                for (int j = 0; j < requestedRootIdsForFacet.length(); ++j) {
                    idSet.add(requestedRootIdsForFacet.getString(j));
                }
                requestedTermIds.put(facetId, idSet);
            }
        }
        try (Transaction tx = graphDb.beginTx();){
            log.info("Returning roots for facets " + requestedFacetIds);
            Node facetGroupsNode = FacetManager.getFacetGroupsNode(graphDb);
            TraversalDescription facetTraversal = PredefinedTraversals.getFacetTraversal(graphDb, null, null);
            Traverser traverse = facetTraversal.traverse(facetGroupsNode);
            for (Path path : traverse) {
                Node facetNode = path.endNode();
                String facetId = (String)facetNode.getProperty("id");
                if (maxRoots > 0L && facetNode.hasProperty("numRoots") && (Long)facetNode.getProperty("numRoots") > maxRoots) {
                    log.info("Skipping facet with ID " + facetId + " because it has more than " + maxRoots + " root terms (" + facetNode.getProperty("numRoots") + ").");
                }
                Set requestedIdSet = null;
                if (null != requestedTermIds) {
                    requestedIdSet = (Set)requestedTermIds.get(facetId);
                }
                if (!requestedFacetIds.contains(facetId)) continue;
                ArrayList<Node> roots = new ArrayList<Node>();
                Iterable relationships = facetNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{EdgeTypes.HAS_ROOT_TERM});
                for (Relationship rel : relationships) {
                    String rootId;
                    Node rootTerm = rel.getEndNode();
                    boolean include = true;
                    if (null != requestedIdSet && !requestedIdSet.contains(rootId = (String)rootTerm.getProperty("id"))) {
                        include = false;
                    }
                    if (!include) continue;
                    roots.add(rootTerm);
                }
                if (!(roots.isEmpty() || maxRoots > 0L && (long)roots.size() > maxRoots)) {
                    facetRoots.put(facetId, roots);
                    continue;
                }
                log.info("Skipping facet with ID " + facetId + " because it has more than " + maxRoots + " root terms (" + roots.size() + ").");
            }
            tx.success();
        }
        return new RecursiveMappingRepresentation(Representation.MAP, facetRoots);
    }

    @Name(value="add_term_variants")
    @Description(value="Allows to add writing variants and acronyms to concepts in the database. For each type of data (variants and acronyms) there is a parameter of its own. It is allowed to omit a parameter value. The expected format is {'tid1': {'docID1': {'variant1': count1, 'variant2': count2, ...}, 'docID2': {...}}, 'tid2':...} for both variants and acronyms.")
    @PluginTarget(value=GraphDatabaseService.class)
    public void addWritingVariants(@Source GraphDatabaseService graphDb, @Description(value="A JSON object mapping term IDs to an array of writing variants to add to the existing writing variants.") @Parameter(name="termVariants", optional=true) String termVariants, @Description(value="A JSON object mapping term IDs to an array of acronyms to add to the existing term acronyms.") @Parameter(name="termAcronyms", optional=true) String termAcronyms) throws JSONException {
        if (null != termVariants) {
            this.addConceptVariant(graphDb, termVariants, "writingVariants");
        }
        if (null != termAcronyms) {
            this.addConceptVariant(graphDb, termAcronyms, "acronyms");
        }
    }

    private void addConceptVariant(GraphDatabaseService graphDb, String termVariants, String type) {
        EdgeTypes variantRelationshipType;
        MorphoLabel variantNodeLabel;
        MorphoLabel variantsAggregationLabel;
        if (type.equals("writingVariants")) {
            variantsAggregationLabel = MorphoLabel.WRITING_VARIANTS;
            variantNodeLabel = MorphoLabel.WRITING_VARIANT;
            variantRelationshipType = EdgeTypes.HAS_VARIANTS;
        } else if (type.equals("acronyms")) {
            variantsAggregationLabel = MorphoLabel.ACRONYMS;
            variantNodeLabel = MorphoLabel.ACRONYM;
            variantRelationshipType = EdgeTypes.HAS_ACRONYMS;
        } else {
            throw new IllegalArgumentException("Unknown lexico-morphological type \"" + type + "\".");
        }
        try (StringReader stringReader = new StringReader(termVariants);){
            JsonReader jsonReader = new JsonReader(stringReader);
            try (Transaction tx = graphDb.beginTx();){
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    Node variantsNode;
                    String termId = jsonReader.nextName();
                    HashMap variantCountsInDocs = new HashMap();
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        String docId = jsonReader.nextName();
                        jsonReader.beginObject();
                        TreeMap<String, Integer> variantCounts = new TreeMap<String, Integer>(new TermVariantComparator());
                        while (jsonReader.hasNext()) {
                            String variant = jsonReader.nextName();
                            int count = jsonReader.nextInt();
                            if (variantCounts.containsKey(variant)) {
                                Integer currentCount = (Integer)variantCounts.get(variant);
                                variantCounts.put(variant, currentCount + count);
                                continue;
                            }
                            variantCounts.put(variant, count);
                        }
                        jsonReader.endObject();
                        variantCountsInDocs.put(docId, variantCounts);
                    }
                    jsonReader.endObject();
                    if (variantCountsInDocs.isEmpty()) {
                        log.debug("Term with ID " + termId + " has no writing variants / acronyms attached.");
                        continue;
                    }
                    Node term = graphDb.findNode((Label)TermLabel.TERM, "id", (Object)termId);
                    if (null == term) {
                        log.warn("Term with ID " + termId + " was not found, cannot add writing variants / acronyms.");
                        continue;
                    }
                    Relationship hasVariantsRel = term.getSingleRelationship((RelationshipType)variantRelationshipType, Direction.OUTGOING);
                    if (null == hasVariantsRel) {
                        variantsNode = graphDb.createNode(new Label[]{variantsAggregationLabel});
                        hasVariantsRel = term.createRelationshipTo(variantsNode, (RelationshipType)variantRelationshipType);
                    }
                    variantsNode = hasVariantsRel.getEndNode();
                    for (String docId : variantCountsInDocs.keySet()) {
                        Map variantCounts = (Map)variantCountsInDocs.get(docId);
                        for (String variant : variantCounts.keySet()) {
                            String normalizedVariant = TermVariantComparator.normalizeVariant(variant);
                            Node variantNode = graphDb.findNode((Label)variantNodeLabel, "id", (Object)normalizedVariant);
                            if (null == variantNode) {
                                variantNode = graphDb.createNode(new Label[]{variantNodeLabel});
                                variantNode.setProperty("id", (Object)normalizedVariant);
                                variantNode.setProperty("name", (Object)variant);
                            }
                            Relationship specificElementRel = null;
                            for (Relationship elementRel : variantNode.getRelationships(Direction.INCOMING, new RelationshipType[]{EdgeTypes.HAS_ELEMENT})) {
                                if (!elementRel.getStartNode().equals(variantsNode) || !elementRel.getEndNode().equals(variantNode)) continue;
                                specificElementRel = elementRel;
                                break;
                            }
                            if (null == specificElementRel) {
                                specificElementRel = variantsNode.createRelationshipTo(variantNode, (RelationshipType)EdgeTypes.HAS_ELEMENT);
                                specificElementRel.setProperty("documents", (Object)new String[0]);
                                specificElementRel.setProperty("counts", (Object)new int[0]);
                            }
                            Object[] documents = (String[])specificElementRel.getProperty("documents");
                            int[] counts = (int[])specificElementRel.getProperty("counts");
                            int docIndex = Arrays.binarySearch(documents, docId);
                            Integer count = (Integer)variantCounts.get(variant);
                            if (docIndex >= 0) {
                                counts[docIndex] = count;
                                continue;
                            }
                            int insertionPoint = -1 * (docIndex + 1);
                            String[] newDocuments = new String[documents.length + 1];
                            int[] newCounts = new int[newDocuments.length];
                            if (insertionPoint > 0) {
                                System.arraycopy(documents, 0, newDocuments, 0, insertionPoint);
                                System.arraycopy(counts, 0, newCounts, 0, insertionPoint);
                            }
                            newDocuments[insertionPoint] = docId;
                            newCounts[insertionPoint] = count;
                            if (insertionPoint < documents.length) {
                                System.arraycopy(documents, insertionPoint, newDocuments, insertionPoint + 1, documents.length - insertionPoint);
                                System.arraycopy(counts, insertionPoint, newCounts, insertionPoint + 1, counts.length - insertionPoint);
                            }
                            specificElementRel.setProperty("documents", (Object)newDocuments);
                            specificElementRel.setProperty("counts", (Object)newCounts);
                        }
                    }
                }
                jsonReader.endObject();
                jsonReader.close();
                tx.success();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String[] getPropertyValueOfElements(Node aggregate, String property) {
        if (!aggregate.hasLabel((Label)TermLabel.AGGREGATE)) {
            throw new IllegalArgumentException("Node " + NodeUtilities.getNodePropertiesAsString((PropertyContainer)aggregate) + " is not an aggregate.");
        }
        Iterable elementRels = aggregate.getRelationships(Direction.OUTGOING, new RelationshipType[]{EdgeTypes.HAS_ELEMENT});
        ArrayList<String> elementValues = new ArrayList<String>();
        for (Relationship elementRel : elementRels) {
            String[] value = NodeUtilities.getNodePropertyAsStringArrayValue(elementRel.getEndNode(), property);
            for (int i = 0; value != null && i < value.length; ++i) {
                elementValues.add(value[i]);
            }
        }
        return elementValues.isEmpty() ? null : elementValues.toArray(new String[elementValues.size()]);
    }

    public static enum MorphoLabel implements Label
    {
        WRITING_VARIANTS,
        ACRONYMS,
        WRITING_VARIANT,
        ACRONYM;

    }

    public static enum TermLabel implements Label
    {
        AGGREGATE,
        AGGREGATE_EQUAL_NAMES,
        HOLLOW,
        TERM,
        EVENT_TERM,
        AGGREGATE_ELEMENT;

    }

    private class InsertionReport {
        public Set<String> createdRelationshipsCache = new HashSet<String>();
        public Set<Node> existingConcepts = new HashSet<Node>();
        public Set<String> omittedTerms = new HashSet<String>();
        public CoordinatesSet importedCoordinates = new CoordinatesSet();
        public int numRelationships = 0;
        public int numTerms = 0;

        private InsertionReport() {
        }

        public void addCreatedRelationship(Node source, Node target, RelationshipType type) {
            this.createdRelationshipsCache.add(this.getRelationshipIdentifier(source, target, type));
        }

        public void addExistingTerm(Node term) {
            this.existingConcepts.add(term);
        }

        private String getRelationshipIdentifier(Node source, Node target, RelationshipType type) {
            return source.getId() + type.name() + target.getId();
        }

        public boolean relationshipAlreadyWasCreated(Node source, Node target, RelationshipType type) {
            return this.createdRelationshipsCache.contains(this.getRelationshipIdentifier(source, target, type));
        }

        public void addImportedCoordinates(ConceptCoordinates coordinates) {
            this.importedCoordinates.add(coordinates);
        }
    }

    public static enum EdgeTypes implements RelationshipType
    {
        HAS_ELEMENT,
        HAS_ROOT_TERM,
        HAS_SAME_NAMES,
        IS_BROADER_THAN,
        IS_MAPPED_TO,
        HAS_VARIANTS,
        HAS_ACRONYMS;

    }
}

