/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.ahocorasick;

import com.google.gson.Gson;
import de.julielab.neo4j.plugins.ahocorasick.ACProperties;
import de.julielab.neo4j.plugins.ahocorasick.ACUtil;
import de.julielab.neo4j.plugins.ahocorasick.property.ACDictionary;
import de.julielab.neo4j.plugins.ahocorasick.property.ACEntry;
import de.julielab.neo4j.plugins.ahocorasick.property.ACMatch;
import de.julielab.neo4j.plugins.ahocorasick.property.ACQuery;
import java.util.Iterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

public class ACSearch
extends ServerPlugin {
    public static final int FULL_WITH_OVERLAPPING = 0;
    public static final int FULL_WITHOUT_OVERLAPPING = 1;
    public static final int PROGRESSIV = 2;
    public static final String MATCH = "match";
    public static final String BEGIN = "begin";
    public static final String END = "end";
    public static final String NODE = "node";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Name(value="get_entry")
    @Description(value="Get ACEntry as Json String.")
    @PluginTarget(value=GraphDatabaseService.class)
    public static String getCompleteEntry(@Source GraphDatabaseService graphDb, @Description(value="ACDictionary as JSONString") @Parameter(name="dict") String dictJSON, @Description(value="Entry to Change") @Parameter(name="entry") String entry) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, JSONException {
        Transaction tx = graphDb.beginTx();
        try {
            Node node;
            ACDictionary dict = new ACDictionary(new JSONObject(dictJSON));
            Node root = ACUtil.getRootNode(graphDb, dict.name());
            if (root != null && ACUtil.toLong((node = ACUtil.getExactNode(dict, graphDb, root, entry)).getProperty("property_number_Output")) > 0L) {
                ACEntry acEntry = new ACEntry(entry);
                JSONObject jsonOb = new JSONObject(String.valueOf(node.getProperty("property_Output")));
                JSONObject attributes = new JSONObject(jsonOb.getString(entry));
                Iterator iter = attributes.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    acEntry.addAttribute(key, attributes.getString(key));
                }
                String string = new Gson().toJson((Object)acEntry);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            tx.success();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Name(value="search")
    @Description(value="Get all matches of the query with the dictionary but without overlapping.")
    @PluginTarget(value=GraphDatabaseService.class)
    public static String search(@Source GraphDatabaseService graphDb, @Description(value="ACDictionary as JSONString") @Parameter(name="dict") String dictJSON, @Description(value="Queries to look for substrings") @Parameter(name="queries") String queryJSON) throws JSONException {
        Transaction tx = graphDb.beginTx();
        ACDictionary dict = new ACDictionary(new JSONObject(dictJSON));
        ACQuery queryOb = new ACQuery(new JSONObject(queryJSON));
        String[] query = queryOb.getQuery();
        Node root = ACUtil.getRootNode(graphDb, dict.name());
        if (ACUtil.isDictTreePrepared(root)) {
            try {
                Node currentState = root;
                if (currentState == null) {
                    String string = null;
                    return string;
                }
                if (!ACUtil.isDictTreePrepared(currentState)) {
                    String string = null;
                    return string;
                }
                long beginLast = 0L;
                long endLast = 0L;
                ACMatch matchOld = null;
                block13: for (int i = 0; i < query.length; ++i) {
                    String letter = query[i];
                    Node toNode = null;
                    while ((toNode = ACUtil.getNextNodeSearch(dict, graphDb, currentState, letter)) == null) {
                        if (dict.isLocalSearch()) {
                            JSONObject obBetween = new JSONObject(String.valueOf(currentState.getProperty("property_relationship")));
                            currentState = graphDb.getNodeById(obBetween.getLong(ACProperties.EdgeTypes.FAIL.toString()));
                            continue;
                        }
                        currentState = currentState.getSingleRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.OUTGOING).getEndNode();
                    }
                    currentState = toNode;
                    int numberFounds = (Integer)currentState.getProperty("property_number_Output");
                    if (numberFounds <= 0) continue;
                    long beginLongest = 0L;
                    long endLongest = 0L;
                    ACMatch matchLongest = null;
                    JSONObject jsonObOut = new JSONObject(String.valueOf(currentState.getProperty("property_Output")));
                    Iterator iterOut = jsonObOut.keys();
                    block15: while (iterOut.hasNext()) {
                        String key = (String)iterOut.next();
                        Object attributesEl = jsonObOut.get(key);
                        if (!attributesEl.getClass().equals(JSONObject.class)) continue;
                        JSONObject attributesJsonOb = (JSONObject)attributesEl;
                        ACEntry entry = new ACEntry(key);
                        Iterator iterAtt = attributesJsonOb.keys();
                        while (iterAtt.hasNext()) {
                            String keyAt = (String)iterAtt.next();
                            entry.addAttribute(keyAt, attributesJsonOb.getString(keyAt).replaceAll("\"", ""));
                        }
                        long begin = i + 1 - key.length();
                        long end = i + 1;
                        ACMatch match = new ACMatch(entry, begin, end);
                        switch (queryOb.getMode()) {
                            case 0: {
                                queryOb.addMatch(match);
                                continue block15;
                            }
                        }
                        if (end - begin <= endLongest - beginLongest) continue;
                        beginLongest = begin;
                        endLongest = end;
                        matchLongest = match;
                    }
                    switch (queryOb.getMode()) {
                        case 1: {
                            if (endLast <= beginLongest) {
                                beginLast = beginLongest;
                                endLast = endLongest;
                                if (matchOld != null) {
                                    queryOb.addMatch(matchOld);
                                }
                                matchOld = matchLongest;
                                continue block13;
                            }
                            if (beginLongest > endLast || endLast - beginLast >= endLongest - beginLongest) continue block13;
                            beginLast = beginLongest;
                            endLast = endLongest;
                            matchOld = matchLongest;
                            continue block13;
                        }
                        case 2: {
                            queryOb.addMatch(matchLongest);
                            String string = queryOb.toJSONString();
                            return string;
                        }
                    }
                }
                if (queryOb.getMode() == 1) {
                    queryOb.addMatch(matchOld);
                }
                String string = queryOb.toJSONString();
                return string;
            }
            finally {
                tx.success();
            }
        }
        return "";
    }
}

