/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.ahocorasick.property;

import com.google.gson.Gson;
import de.julielab.neo4j.plugins.ahocorasick.property.ACMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

public class ACQuery {
    private String[] query;
    private List<ACMatch> matches;
    private int mode;
    private final String QUERY = "query";
    private final String MATCHES = "matches";
    private final String MODE = "mode";
    public static final int FULL_WITH_OVERLAPPING = 0;
    public static final int FULL_WITHOUT_OVERLAPPING = 1;
    public static final int PROGRESSIV = 2;

    public ACQuery(String[] query, int mode) {
        this.query = query;
        this.mode = mode;
        this.matches = new ArrayList<ACMatch>();
    }

    public ACQuery(String query, int mode) {
        this(Arrays.copyOfRange(query.split(""), 1, query.length() + 1), mode);
    }

    public ACQuery(JSONObject ob) throws JSONException {
        int i;
        JSONArray array = (JSONArray)ob.get("query");
        this.query = new String[array.length()];
        for (i = 0; i < this.query.length; ++i) {
            this.query[i] = array.getString(i);
        }
        this.mode = ob.getInt("mode");
        array = (JSONArray)ob.get("matches");
        this.matches = new ArrayList<ACMatch>();
        for (i = 0; i < array.length(); ++i) {
            this.matches.add(new ACMatch((JSONObject)array.get(i)));
        }
    }

    public void addMatch(ACMatch match) {
        this.matches.add(match);
    }

    public String[] getQuery() {
        return this.query;
    }

    public int getMode() {
        return this.mode;
    }

    public List<ACMatch> getAllMatches() {
        return this.matches;
    }

    public String toJSONString() {
        Gson g = new Gson();
        return g.toJson(this);
    }
}

