/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.ahocorasick.property;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

public class ACEntry {
    private final String entry;
    private Map<String, Object> attributes;
    private String[] tokens;

    public ACEntry(String entry) {
        this.entry = entry;
        this.attributes = new HashMap<String, Object>();
        this.tokens = entry.split("");
        this.tokens = Arrays.copyOfRange(this.tokens, 1, this.tokens.length);
    }

    public ACEntry(String entry, String[] tokens) {
        this.entry = entry;
        this.attributes = new HashMap<String, Object>();
        this.tokens = tokens;
    }

    public ACEntry(JSONObject entry) throws JSONException {
        this.entry = entry.getString("entry");
        this.attributes = ((JSONObject)entry.get("attributes")).toMap();
        JSONArray array = (JSONArray)entry.get("tokens");
        this.tokens = new String[array.length()];
        for (int i = 0; i < this.tokens.length; ++i) {
            this.tokens[i] = array.getString(i);
        }
    }

    public String entryString() {
        return this.entry;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public boolean deleteAttribute(String key) {
        this.attributes.remove(key);
        return !this.hasAttribute(key);
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(this.attributes);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }
}

