/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.ahocorasick;

import de.julielab.neo4j.plugins.ahocorasick.ACProperties;
import de.julielab.neo4j.plugins.ahocorasick.ACUtil;
import de.julielab.neo4j.plugins.ahocorasick.property.ACDictionary;
import de.julielab.neo4j.plugins.ahocorasick.property.ACEntry;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

public class ACFactoryEmbedded
extends ServerPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Name(value="create_dict_tree")
    @Description(value="Creates a new root of a DictTree, where entries could be add. If root already existsthen the function returns false.")
    @PluginTarget(value=GraphDatabaseService.class)
    public static boolean createDictTree(@Source GraphDatabaseService graphDb, @Description(value="ACDictionary as string.") @Parameter(name="name") String jsonACDict) throws JSONException {
        ACDictionary dict = new ACDictionary(new JSONObject(jsonACDict));
        try (Transaction tx = graphDb.beginTx();){
            if (ACUtil.getRootNode(graphDb, dict.name()) == null) {
                Node root = graphDb.createNode(new Label[]{ACProperties.LabelTypes.DICTIONARY});
                root.setProperty("dict_name", (Object)dict.name());
                root.setProperty("nodes_in_Tree", (Object)1);
                root.setProperty("number_of_entries", (Object)0);
                root.setProperty("prepared", (Object)false);
                root.setProperty("modeCreate", (Object)dict.getCreateMode());
                root.setProperty("modeSearch", (Object)dict.isLocalSearch());
                root.setProperty("property_state", (Object)0);
                root.setProperty("property_depth", (Object)0);
                root.setProperty("property_number_Output", (Object)0);
                JSONObject jsonRelMap = new JSONObject();
                root.setProperty("property_relationship", (Object)jsonRelMap.toString());
                root.setProperty("property_number_next", (Object)0);
                IndexManager manager = graphDb.index();
                Index index = manager.forNodes("index_dic");
                index.add((PropertyContainer)root, "dict_name", (Object)dict.name());
                tx.success();
                boolean bl = true;
                return bl;
            }
            tx.failure();
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Name(value="delete_dict_tree")
    @Description(value="Deletes a complete DictTree in a GraphDatabase.")
    @PluginTarget(value=GraphDatabaseService.class)
    public static boolean deleteDictTree(@Source GraphDatabaseService graphDb, @Description(value="Name of the dictionary.") @Parameter(name="name") String name) throws IOException {
        long groupCounter = 0L;
        long maxGroupCount = 20000L;
        try (Transaction tx = graphDb.beginTx();){
            Node root = ACUtil.getRootNode(graphDb, name);
            if (root == null) {
                tx.failure();
                boolean bl = false;
                return bl;
            }
            IndexManager indMan = graphDb.index();
            Index index = indMan.forNodes("index_dic");
            index.remove((PropertyContainer)root);
            ArrayDeque<Node> queue = new ArrayDeque<Node>();
            queue.add(root);
            while (!queue.isEmpty()) {
                Node node = (Node)queue.pop();
                for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                    if (!rel.getType().name().equals(ACProperties.getFailName())) {
                        queue.add(rel.getEndNode());
                    }
                    rel.delete();
                }
                node.delete();
                if (++groupCounter < 20000L) continue;
                groupCounter = 0L;
                tx.success();
                tx.close();
                tx = graphDb.beginTx();
            }
            tx.success();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Name(value="add_list_to_dicttree")
    @Description(value="Adds a list of entries to a DictTree.")
    @PluginTarget(value=GraphDatabaseService.class)
    public static boolean addListToDictTree(@Source GraphDatabaseService graphDb, @Description(value="ACDictionary as string.") @Parameter(name="name") String jsonACDict, @Description(value="The dictionary entries as a JSONArray of the form[{'entry':'entry1','attributes':{'attribute1':'attValue1','attribute2':'attValue2'}}]") @Parameter(name="dictEntries") String listEntries) throws JSONException, IOException {
        try (Transaction tx = graphDb.beginTx();){
            ACDictionary dict = new ACDictionary(new JSONObject(jsonACDict));
            JSONArray entries = new JSONArray(listEntries);
            Node root = ACUtil.getRootNode(graphDb, dict.name());
            if (root != null && !ACUtil.isDictTreePrepared(root)) {
                for (int i = 0; i < entries.length(); ++i) {
                    JSONObject entryJSON = entries.getJSONObject(i);
                    ACEntry entry = new ACEntry(entryJSON);
                    ACFactoryEmbedded.addEntryToTree(graphDb, dict, root, entry);
                }
                tx.success();
                boolean bl = true;
                return bl;
            }
            tx.failure();
            boolean bl = false;
            return bl;
        }
    }

    private static List<Node> addEntryToTree(GraphDatabaseService graphDb, ACDictionary dict, Node root, ACEntry entry) throws JSONException {
        String[] toAdd = entry.getTokens();
        ArrayList<Node> nodesNew = new ArrayList<Node>();
        long newState = ACUtil.toLong(root.getProperty("nodes_in_Tree"));
        int j = 0;
        Node node = root;
        Node nodeNext = ACUtil.getNextNodeCreate(dict, graphDb, null, node, toAdd[j]);
        while (nodeNext != null) {
            node = nodeNext;
            if (++j == toAdd.length) break;
            nodeNext = ACUtil.getNextNodeCreate(dict, graphDb, null, node, toAdd[j]);
        }
        for (int p = j; p < toAdd.length; ++p) {
            Node newNode = graphDb.createNode();
            JSONObject jsonRelMap = new JSONObject();
            newNode.setProperty("property_state", (Object)newState);
            newNode.setProperty("property_number_Output", (Object)0);
            newNode.setProperty("property_depth", (Object)p);
            newNode.setProperty("property_number_next", (Object)0);
            newNode.setProperty("property_relationship", (Object)jsonRelMap.toString());
            Relationship rel = node.createRelationshipTo(newNode, (RelationshipType)ACProperties.EdgeTypes.NEXT);
            rel.setProperty("letter", (Object)toAdd[p]);
            ACUtil.updateAddNode(dict, node, newNode, toAdd[p]);
            ACUtil.increaseNumberNext(node);
            nodesNew.add(newNode);
            node = newNode;
            ++newState;
        }
        ACUtil.addOutput(node, entry);
        if (ACUtil.isDictTreePrepared(root)) {
            if (node.hasRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.OUTGOING)) {
                Node nodeEnd = node.getSingleRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.OUTGOING).getEndNode();
                ACUtil.unionOutput(node, nodeEnd);
            }
            while (node.hasRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.INCOMING)) {
                Node nodeStart = node.getSingleRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.INCOMING).getStartNode();
                ACUtil.unionOutput(nodeStart, node);
                node = nodeStart;
            }
        }
        root.setProperty("nodes_in_Tree", (Object)newState);
        root.setProperty("number_of_entries", (Object)(ACUtil.toLong(root.getProperty("number_of_entries")) + 1L));
        return nodesNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Name(value="add_list_to_prepared_dicttree")
    @Description(value="Adds entries from a list to the DictTree.")
    @PluginTarget(value=GraphDatabaseService.class)
    public static boolean addListToPreparedDictTree(@Source GraphDatabaseService graphDb, @Description(value="ACDictionary as string.") @Parameter(name="name") String jsonACDict, @Description(value="The dictionary entries as a JSON map of the form{'dictEntries':[{'entry':'entry1','attributes':{'attribute1':'attValue1','attribute2':'attValue2'}}]}") @Parameter(name="dictEntries") String dictEntries) throws JSONException {
        try (Transaction tx = graphDb.beginTx();){
            ACDictionary dict = new ACDictionary(new JSONObject(jsonACDict));
            ArrayList<Node> nodesNew = new ArrayList<Node>();
            JSONArray entries = new JSONArray(dictEntries);
            Node root = ACUtil.getRootNode(graphDb, dict.name());
            if (root != null && ACUtil.isDictTreePrepared(root)) {
                for (int i = 0; i < entries.length(); ++i) {
                    JSONObject entryJSON = entries.getJSONObject(i);
                    ACEntry entry = new ACEntry(entryJSON);
                    nodesNew.addAll(ACFactoryEmbedded.addEntryToTree(graphDb, dict, root, entry));
                }
                Comparator<Node> comper = ACUtil.getComperator();
                Collections.sort(nodesNew, comper);
                for (int i = 0; i < nodesNew.size(); ++i) {
                    Node node = (Node)nodesNew.get(i);
                    HashMap<String, Object> nodeBeforeInfo = ACFactoryEmbedded.getNodeBefore(node);
                    Node nodeBefore = (Node)nodeBeforeInfo.get("property_state");
                    String relLetter = (String)nodeBeforeInfo.get("relation_typ");
                    if (nodeBefore.equals(root)) {
                        node.createRelationshipTo(root, (RelationshipType)ACProperties.EdgeTypes.FAIL);
                        ACUtil.updateAddNode(dict, node, root, ACProperties.getFailName());
                        ACUtil.increaseNumberNext(node);
                    } else {
                        Node state = null;
                        state = dict.isLocalSearch() ? graphDb.getNodeById(ACUtil.getFailNode(nodeBefore, root)) : (nodeBefore.getId() != root.getId() ? nodeBefore.getSingleRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.OUTGOING).getEndNode() : root);
                        Node toNode = null;
                        while ((toNode = ACUtil.getNextNodeSearch(dict, graphDb, state, relLetter)) == null) {
                            state = graphDb.getNodeById(ACUtil.getFailNode(state, root));
                        }
                        node.createRelationshipTo(toNode, (RelationshipType)ACProperties.EdgeTypes.FAIL);
                        ACUtil.updateAddNode(dict, node, toNode, ACProperties.getFailName());
                        ACUtil.increaseNumberNext(node);
                        ACUtil.unionOutput(node, toNode);
                        if (toNode.getId() != root.getId()) {
                            JSONObject jsonRelMap = new JSONObject(String.valueOf(node.getProperty("property_relationship")));
                            jsonRelMap.putOpt(ACProperties.getFailName(), (Object)toNode.getId());
                            node.setProperty("property_relationship", (Object)jsonRelMap.toString());
                        }
                    }
                    Stack<Node> stack = new Stack<Node>();
                    Iterator iterFailRelations = nodeBefore.getRelationships(Direction.INCOMING, new RelationshipType[]{ACProperties.EdgeTypes.FAIL}).iterator();
                    while (iterFailRelations.hasNext()) {
                        stack.add(((Relationship)iterFailRelations.next()).getStartNode());
                    }
                    while (!stack.isEmpty()) {
                        Node n = (Node)stack.pop();
                        Node nEnd = null;
                        nEnd = ACUtil.getNextNodeCreate(dict, graphDb, root, n, relLetter);
                        if (nEnd != null && nEnd.hasRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.OUTGOING)) {
                            ACUtil.subtractOutput(nEnd, nEnd.getSingleRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.OUTGOING).getEndNode());
                            nEnd.getSingleRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.OUTGOING).delete();
                            nEnd.createRelationshipTo(node, (RelationshipType)ACProperties.EdgeTypes.FAIL);
                            ACUtil.unionOutput(nEnd, node);
                            ACUtil.updateAddNode(dict, nEnd, node, ACProperties.getFailName());
                            JSONObject jsonRelMap = new JSONObject(String.valueOf(nEnd.getProperty("property_relationship")));
                            if (jsonRelMap.has(ACProperties.getFailName())) {
                                jsonRelMap.remove(ACProperties.getFailName());
                            }
                            if (node.getId() != root.getId()) {
                                jsonRelMap.putOnce(ACProperties.getFailName(), (Object)node.getId());
                            }
                            nEnd.setProperty("property_relationship", (Object)jsonRelMap.toString());
                            continue;
                        }
                        if (!n.hasRelationship(Direction.INCOMING, new RelationshipType[]{ACProperties.EdgeTypes.FAIL})) continue;
                        iterFailRelations = n.getRelationships(Direction.INCOMING, new RelationshipType[]{ACProperties.EdgeTypes.FAIL}).iterator();
                        while (iterFailRelations.hasNext()) {
                            stack.add(((Relationship)iterFailRelations.next()).getStartNode());
                        }
                    }
                }
                tx.success();
                boolean bl = true;
                return bl;
            }
            tx.failure();
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Name(value="prepare_dicttree_for_search")
    @Description(value="Sets all Fail-Relation in the DictTree for searching.")
    @PluginTarget(value=GraphDatabaseService.class)
    public static boolean prepareDictTreeForSearch(@Source GraphDatabaseService graphDb, @Description(value="ACDictionary as string.") @Parameter(name="name") String jsonACDict) throws IOException, JSONException {
        Transaction tx = graphDb.beginTx();
        long groupCounter = 0L;
        long maxGroupCount = 20000L;
        try {
            ArrayDeque<Long> queue;
            ACDictionary dict = new ACDictionary(new JSONObject(jsonACDict));
            Node root = ACUtil.getRootNode(graphDb, dict.name());
            int counter = 0;
            if (ACUtil.isDictTreePrepared(root)) {
                boolean bl = false;
                return bl;
            }
            if (dict.getCreateMode() != 0) {
                queue = new ArrayDeque<Long>();
                for (Relationship rel : root.getRelationships(Direction.OUTGOING)) {
                    Node endNode = rel.getEndNode();
                    endNode.createRelationshipTo(root, (RelationshipType)ACProperties.EdgeTypes.FAIL);
                    queue.add(endNode.getId());
                    endNode.setProperty("property_number_next", (Object)(ACUtil.toLong(endNode.getProperty("property_number_next")) + 1L));
                    JSONObject jsonRelMap = new JSONObject(String.valueOf(endNode.getProperty("property_relationship")));
                    jsonRelMap.putOnce(ACProperties.getFailName(), (Object)root.getId());
                    endNode.setProperty("property_relationship", (Object)jsonRelMap.toString());
                    ++counter;
                }
                while (!queue.isEmpty()) {
                    Node node = graphDb.getNodeById(((Long)queue.pop()).longValue());
                    JSONObject ob = new JSONObject(String.valueOf(node.getProperty("property_relationship")));
                    for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                        if (rel.getType().name().equals(ACProperties.EdgeTypes.FAIL.name())) continue;
                        Node endNode = rel.getEndNode();
                        queue.add(endNode.getId());
                        Node state = graphDb.getNodeById(ACUtil.toLong(ob.get(ACProperties.EdgeTypes.FAIL.name())));
                        Node toNode = null;
                        while ((toNode = ACUtil.getNextNodeCreate(dict, graphDb, root, state, (String)rel.getProperty("letter"))) == null) {
                            JSONObject obBetween = new JSONObject(String.valueOf(state.getProperty("property_relationship")));
                            state = root;
                            if (!obBetween.has(ACProperties.EdgeTypes.FAIL.name())) continue;
                            state = graphDb.getNodeById(obBetween.getLong(ACProperties.EdgeTypes.FAIL.name()));
                        }
                        endNode.createRelationshipTo(toNode, (RelationshipType)ACProperties.EdgeTypes.FAIL);
                        endNode.setProperty("property_number_next", (Object)(ACUtil.toLong(endNode.getProperty("property_number_next")) + 1L));
                        JSONObject jsonRelMap = new JSONObject(String.valueOf(endNode.getProperty("property_relationship")));
                        jsonRelMap.putOnce(ACProperties.getFailName(), (Object)toNode.getId());
                        endNode.setProperty("property_relationship", (Object)jsonRelMap.toString());
                        ACUtil.unionOutput(endNode, toNode);
                        if (++counter % 10000 != 0) continue;
                        System.out.println(counter);
                    }
                }
            } else {
                queue = new ArrayDeque();
                for (Relationship rel : root.getRelationships(Direction.OUTGOING)) {
                    Node endNode = rel.getEndNode();
                    endNode.createRelationshipTo(root, (RelationshipType)ACProperties.EdgeTypes.FAIL);
                    queue.add(endNode.getId());
                    endNode.setProperty("property_number_next", (Object)(ACUtil.toLong(endNode.getProperty("property_number_next")) + 1L));
                    ++counter;
                }
                while (!queue.isEmpty()) {
                    Node node = graphDb.getNodeById(((Long)queue.pop()).longValue());
                    for (Relationship typ : node.getRelationships(Direction.OUTGOING)) {
                        Node endNode = typ.getEndNode();
                        if (typ.getType().name().equals(ACProperties.EdgeTypes.FAIL.name())) continue;
                        queue.add(endNode.getId());
                        Node state = node.getSingleRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.OUTGOING).getEndNode();
                        Node toNode = null;
                        while ((toNode = ACUtil.getNextNodeCreate(dict, graphDb, root, state, (String)typ.getProperty("letter"))) == null) {
                            state = state.getSingleRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.OUTGOING).getEndNode();
                        }
                        endNode.createRelationshipTo(toNode, (RelationshipType)ACProperties.EdgeTypes.FAIL);
                        endNode.setProperty("property_number_next", (Object)(ACUtil.toLong(endNode.getProperty("property_number_next")) + 1L));
                        ACUtil.unionOutput(endNode, toNode);
                        if (++counter % 10000 != 0) continue;
                        System.out.println(counter);
                    }
                }
            }
            root.setProperty("prepared", (Object)true);
            tx.success();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);
            tx.failure();
            boolean bl = false;
            return bl;
        }
        finally {
            tx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Name(value="unprepare_dicttree")
    @Description(value="Deletes all Fail-Relation in the DictTree.")
    @PluginTarget(value=GraphDatabaseService.class)
    public static boolean unprepareDictTree(@Source GraphDatabaseService graphDb, @Description(value="Name of the dictionary.") @Parameter(name="name") String name) throws IOException, JSONException {
        try (Transaction tx = graphDb.beginTx();){
            Node root = ACUtil.getRootNode(graphDb, name);
            if (!ACUtil.isDictTreePrepared(root)) {
                boolean bl = false;
                return bl;
            }
            ArrayDeque<Node> queue = new ArrayDeque<Node>();
            queue.add(root);
            long groupCounter = 0L;
            long maxGroupCount = 20000L;
            while (!queue.isEmpty()) {
                Node node = (Node)queue.pop();
                for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                    if (rel.getType().name().equals(ACProperties.getFailName())) {
                        rel.delete();
                        ACUtil.decreaseNumberNext(node);
                        continue;
                    }
                    queue.add(rel.getEndNode());
                }
                if (ACUtil.toLong(node.getProperty("property_number_Output")) > 1L) {
                    String original = String.valueOf(node.getProperty("property_original"));
                    JSONObject ob = new JSONObject(String.valueOf(node.getProperty("property_Output")));
                    Iterator iterOb = ob.keys();
                    while (iterOb.hasNext()) {
                        String key = (String)iterOb.next();
                        if (key.startsWith("property_") || key.equals(original)) continue;
                        iterOb.remove();
                        node.setProperty("property_number_Output", (Object)((Integer)node.getProperty("property_number_Output") - 1));
                    }
                    node.setProperty("property_Output", (Object)ob.toString());
                }
                if (++groupCounter <= 20000L) continue;
                tx.success();
                tx.close();
                groupCounter = 0L;
                tx = graphDb.beginTx();
            }
            root.setProperty("prepared", (Object)false);
            tx.success();
            boolean bl = true;
            return bl;
        }
    }

    private static HashMap<String, Object> getNodeBefore(Node node) {
        for (Relationship rel : node.getRelationships(Direction.INCOMING)) {
            if (rel.getType().equals((Object)ACProperties.EdgeTypes.FAIL)) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("relation_typ", rel.getProperty("letter"));
            map.put("property_state", rel.getStartNode());
            return map;
        }
        return null;
    }
}

