/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.ahocorasick.property;

import com.google.gson.Gson;
import de.julielab.neo4j.plugins.ahocorasick.ACFactoryBatch;
import de.julielab.neo4j.plugins.ahocorasick.ACFactoryEmbedded;
import de.julielab.neo4j.plugins.ahocorasick.property.ACDictionary;
import de.julielab.neo4j.plugins.ahocorasick.property.ACGlobalMap;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.lucene.unsafe.batchinsert.LuceneBatchInserterIndexProvider;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserterIndex;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class ACDataBase {
    private final String path;
    private BatchInserter batch;
    private GraphDatabaseService graphDb;
    private Hashtable<String, ACGlobalMap> globalMaps;

    public ACDataBase(String path) {
        this.path = path;
        this.batch = null;
        this.graphDb = null;
        this.globalMaps = new Hashtable();
    }

    public BatchInserter startBatchInserter() {
        if (this.batch == null) {
            new BatchInserters();
            this.batch = BatchInserters.inserter((String)this.path);
        }
        return this.batch;
    }

    public boolean stopBatchInserter() {
        if (this.batch != null) {
            this.batch.shutdown();
            this.batch = null;
            return true;
        }
        return false;
    }

    public GraphDatabaseService startGraphDatabase() {
        if (this.graphDb == null) {
            this.graphDb = new GraphDatabaseFactory().newEmbeddedDatabase(this.path);
            return this.graphDb;
        }
        return this.graphDb;
    }

    public boolean stopGraphDatabase() {
        if (this.graphDb != null) {
            this.graphDb.shutdown();
            this.graphDb = null;
            return true;
        }
        return false;
    }

    public boolean addDict(ACDictionary dict) throws JSONException {
        boolean succes = false;
        if (this.graphDb != null) {
            Gson g = new Gson();
            succes = ACFactoryEmbedded.createDictTree(this.graphDb, g.toJson((Object)dict));
        }
        if (this.batch != null) {
            succes = ACFactoryBatch.createDictTree(this.batch, dict);
        }
        return succes;
    }

    public ACDictionary getDict(String name) {
        if (this.graphDb != null) {
            IndexManager manager = this.graphDb.index();
            Index index = manager.forNodes("index_dic");
            IndexHits hits = index.get("dict_name", (Object)name);
            Node node = (Node)hits.getSingle();
            ACDictionary dictEntry = new ACDictionary((String)node.getProperty("dict_name"), (Integer)node.getProperty("modeCreate"), (Integer)node.getProperty("modeSearch"));
            return dictEntry;
        }
        if (this.batch != null) {
            LuceneBatchInserterIndexProvider indexProvider = new LuceneBatchInserterIndexProvider(this.batch);
            BatchInserterIndex dict = indexProvider.nodeIndex("index_dic", MapUtil.stringMap((String[])new String[]{"type", "exact"}));
            IndexHits hits = dict.get("dict_name", (Object)name);
            Long id = (Long)hits.getSingle();
            Map properties = this.batch.getNodeProperties(id.longValue());
            ACDictionary dictEntry = new ACDictionary((String)properties.get("dict_name"), (Integer)properties.get("modeCreate"), (Integer)properties.get("modeSearch"));
            return dictEntry;
        }
        return null;
    }

    public boolean deleteDict(String name) throws IOException {
        boolean succes;
        return this.graphDb != null && (succes = ACFactoryEmbedded.deleteDictTree(this.graphDb, name));
    }

    public ACGlobalMap getMap(String name) {
        if (!this.globalMaps.containsKey(name)) {
            this.addMap(name, new ACGlobalMap());
        }
        return this.globalMaps.get(name);
    }

    public void addMap(String name, ACGlobalMap map) {
        this.globalMaps.put(name, map);
    }

    public void deleteMap(String name) {
        this.globalMaps.remove(name);
    }
}

