/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.json;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAwareEx;

public class JsonPathCLI {
    private static Set<Class<?>> wrapperTypes = JsonPathCLI.getWrapperTypes();

    public static void main(String[] args) {
        if (args.length == 1 && (args[0].toLowerCase().equals("help") || args[0].toLowerCase().equals("h"))) {
            System.err.println("Help on JsonPath expression syntax: http://goessner.net/articles/JsonPath/, https://github.com/json-path/JsonPath");
            System.err.println("To see tool usage, start the tool without any parameters.");
            System.exit(1);
        }
        if (args.length < 2) {
            System.err.println("Usage: " + JsonPathCLI.class.getSimpleName() + " <json file> <'for each' json path> <json paths evaluated on 'for each' outcomes>");
            System.exit(1);
        }
        String jsonFilePath = args[0];
        try {
            BufferedInputStream is = FileUtilities.getInputStreamFromFile(new File(jsonFilePath));
            DocumentContext parse = JsonPath.parse(is);
            JsonPathCLI cli = new JsonPathCLI();
            List<List<?>> values = cli.applyJsonPath(args, parse);
            for (List<?> recordValue : values) {
                System.out.println(recordValue.stream().map(String::valueOf).collect(Collectors.joining(", ")));
            }
        }
        catch (IOException e) {
            System.err.println("IOException occured: " + e.getMessage());
        }
    }

    public List<List<?>> applyJsonPath(String[] args, ReadContext parse) {
        ArrayList ret;
        block12: {
            String currentJsonPath = args[1];
            ReadContext currentParse = parse;
            ret = new ArrayList();
            try {
                Object read = currentParse.read(currentJsonPath, new Predicate[0]);
                if (null == read) {
                    return ret;
                }
                if (read.getClass().equals(JSONArray.class) && 2 < args.length) {
                    List obLst = (List)read;
                    if (obLst.size() <= 0) break block12;
                    for (Object ob : obLst) {
                        ArrayList<Object> elements = new ArrayList<Object>();
                        if (!wrapperTypes.contains(ob.getClass())) {
                            for (int j = 2; j < args.length; ++j) {
                                try {
                                    if (ob instanceof JSONAwareEx) {
                                        JSONAwareEx ex = (JSONAwareEx)ob;
                                        currentParse = JsonPath.parse(ex.toJSONString());
                                    } else {
                                        currentParse = JsonPath.parse(ob);
                                    }
                                    currentJsonPath = args[j];
                                    Object innerRead = currentParse.read(currentJsonPath, new Predicate[0]);
                                    elements.add(innerRead);
                                    continue;
                                }
                                catch (PathNotFoundException e) {
                                    System.err.println("Inner JsonPath \"" + currentJsonPath + "\" was not found in " + args[0] + ". JSON was: \"" + currentParse.json() + "\". The record is omitted.");
                                    elements.clear();
                                    break;
                                }
                            }
                        } else {
                            elements.add(ob);
                        }
                        if (elements.isEmpty()) continue;
                        ret.add(elements);
                    }
                    break block12;
                }
                System.out.println(read);
            }
            catch (PathNotFoundException e) {
                System.err.println("JsonPath \"" + currentJsonPath + "\" was not found in " + args[0] + ". JSON was: \"" + currentParse.json() + "\".");
            }
        }
        return ret;
    }

    private static Set<Class<?>> getWrapperTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(Void.class);
        ret.add(String.class);
        return ret;
    }
}

