/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.prerequisites;

import de.julielab.java.utilities.prerequisites.NullChecker;
import de.julielab.java.utilities.prerequisites.ParameterChecker;
import de.julielab.java.utilities.prerequisites.PrerequisiteChecker;
import de.julielab.java.utilities.prerequisites.SupplierChecker;
import java.util.Collection;
import java.util.function.Supplier;

public class EmptyChecker
extends ParameterChecker {
    public EmptyChecker(PrerequisiteChecker prerequisiteChecker, Collection ... objects) {
        super(prerequisiteChecker, objects);
    }

    public EmptyChecker(PrerequisiteChecker prerequisiteChecker, Supplier<Collection<?>>[] suppliers) {
        super(prerequisiteChecker, suppliers);
    }

    static void check(PrerequisiteChecker prerequisiteChecker, Collection collection, String name) {
        NullChecker.check(prerequisiteChecker, collection, name);
        if (collection.isEmpty()) {
            prerequisiteChecker.addErrorMessage("The collection with name \"" + name + "\" is empty.");
        }
    }

    @Override
    public void check() {
        for (int i = 0; i < this.items.length; ++i) {
            Object object = this.items[i];
            String name = this.getName(i);
            NullChecker.check(this.prerequisiteChecker, object, name);
            if (object instanceof Supplier) {
                SupplierChecker.get(this.prerequisiteChecker, (Supplier)object, name).ifPresent(o -> EmptyChecker.check(this.prerequisiteChecker, (Collection)o, name));
                continue;
            }
            if (!(object instanceof Collection)) {
                this.prerequisiteChecker.addErrorMessage("The item with name \"" + name + "\" is not a collection. But the supplier was given to the EmptyChecker.");
                continue;
            }
            EmptyChecker.check(this.prerequisiteChecker, (Collection)object, name);
        }
    }
}

