/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.index;

import com.google.gson.Gson;
import de.julielab.java.utilities.IOStreamUtilities;
import de.julielab.java.utilities.UriUtilities;
import de.julielab.java.utilities.index.IStringArrayMapProvider;
import de.julielab.java.utilities.index.IndexCreationException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class StringArrayMapProvider
implements IStringArrayMapProvider {
    protected final Logger log;
    protected Map<String, String[]> map;
    private String multiValueDelimiterRegex = "[|,;]";
    private Set<String> eligibleKeys = Collections.emptySet();
    private int[] keyIndices = new int[]{0};
    private int[] valueIndices = new int[]{1};

    public StringArrayMapProvider(Logger log) {
        this.log = log;
        this.map = new HashMap<String, String[]>();
    }

    public Set<String> getEligibleKeys() {
        return this.eligibleKeys;
    }

    public void setEligibleKeys(Set<String> eligibleKeys) {
        this.eligibleKeys = eligibleKeys;
    }

    public String getMultiValueDelimiterRegex() {
        return this.multiValueDelimiterRegex;
    }

    public void setMultiValueDelimiterRegex(String multiValueDelimiterRegex) {
        this.multiValueDelimiterRegex = multiValueDelimiterRegex;
    }

    protected void put(String term, String[] addonArray) {
        this.map.put(term, addonArray);
    }

    @Override
    public void load(URI uri) throws IndexCreationException {
        this.log.info("Loading key-multiple values mapping from " + uri);
        try {
            BufferedInputStream inputStream = UriUtilities.getInputStreamFromUri(uri);
            this.load(inputStream);
        }
        catch (IndexCreationException e) {
            this.log.error("Could not create index from URI {}", (Object)uri, (Object)e);
            throw e;
        }
        catch (Exception e) {
            throw new IndexCreationException("Could not create index from " + uri, e);
        }
    }

    public int[] getValueIndices() {
        return this.valueIndices;
    }

    @Override
    public void setValueIndices(int ... valueIndices) {
        this.valueIndices = valueIndices;
    }

    public int[] getKeyIndices() {
        return this.keyIndices;
    }

    @Override
    public void setKeyIndices(int ... keyIndex) {
        this.keyIndices = keyIndex;
    }

    @Override
    public void load(InputStream inputStream) throws IndexCreationException {
        int addons = 0;
        int lineNr = 0;
        int maxIndex = Math.max(IntStream.of(this.keyIndices).max().getAsInt(), IntStream.of(this.valueIndices).max().getAsInt());
        String line = null;
        try (BufferedReader br = IOStreamUtilities.getReaderFromInputStream(inputStream);){
            Iterator lineIt = br.lines().iterator();
            while (lineIt.hasNext()) {
                ++lineNr;
                line = (String)lineIt.next();
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                String[] mapping = line.split("\t", maxIndex + 2);
                if (mapping.length <= maxIndex) {
                    throw new IllegalArgumentException("Format problem with string array map line " + line + ": " + (maxIndex + 1) + " columns are expected but got " + mapping.length + ".");
                }
                Stream<Object> keys = Stream.empty();
                for (int keyIndex : this.keyIndices) {
                    keys = this.splitFieldIntoInternedStrings(mapping, null, keyIndex);
                }
                if (!this.eligibleKeys.isEmpty()) {
                    keys = keys.filter(this.eligibleKeys::contains);
                }
                Stream<String> values = Stream.empty();
                for (int valueIndex : this.valueIndices) {
                    values = this.splitFieldIntoInternedStrings(mapping, values, valueIndex);
                }
                String[] finalValues = (String[])values.toArray(String[]::new);
                addons += finalValues.length;
                keys.peek(key -> this.log.trace("key: {} -> values: {}", key, (Object)finalValues)).forEach(key -> this.put((String)key, finalValues));
                if (!this.log.isDebugEnabled() || lineNr % 10000 != 0) continue;
                this.log.debug("Processed {} lines", (Object)lineNr);
            }
            this.log.info("Loaded {} values for {} keys.", (Object)addons, (Object)this.map.size());
        }
        catch (Exception e) {
            this.log.error("Exception at line {} of input file: {}", (Object)lineNr, line);
            throw new IndexCreationException(e);
        }
    }

    @NotNull
    private Stream<String> splitFieldIntoInternedStrings(String[] mapping, Stream<String> values, int valueIndex) {
        Stream<String> stream = values = values != null ? values : Stream.empty();
        if (mapping[valueIndex].startsWith("[") && mapping[valueIndex].endsWith("]")) {
            Gson gson = new Gson();
            values = Stream.concat(values, Arrays.stream((String[])gson.fromJson(mapping[valueIndex], String[].class)));
        } else {
            values = Stream.concat(values, Arrays.stream(mapping[valueIndex].split(this.multiValueDelimiterRegex)));
        }
        return values.map(String::trim).filter(Predicate.not(String::isEmpty)).map(String::intern);
    }

    @Override
    public Map<String, String[]> getMap() {
        return this.map;
    }
}

