/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.julielab.java.utilities.cache.CacheAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteCacheAccess<K, V>
extends CacheAccess<K, V> {
    private static final Logger log = LoggerFactory.getLogger(RemoteCacheAccess.class);
    private final String keySerializer;
    private final String valueSerializer;
    private final String host;
    private final int port;
    private ObjectOutputStream oos;
    private ObjectInputStream ois;
    private boolean connectionOpen = false;
    private final Cache<K, V> memCache;

    public RemoteCacheAccess(String cacheId, String cacheRegion, String keySerializer, String valueSerializer, String host, int port) {
        this(cacheId, cacheRegion, keySerializer, valueSerializer, host, port, 100L);
    }

    public RemoteCacheAccess(String cacheId, String cacheRegion, String keySerializer, String valueSerializer, String host, int port, long memCacheSize) {
        super(cacheId, cacheRegion);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.host = host;
        this.port = port;
        this.memCache = CacheBuilder.newBuilder().maximumSize(memCacheSize).build();
    }

    public void establishConnection() {
        if (this.connectionOpen) {
            return;
        }
        try {
            log.debug("Establishing new connection to cache server at {}:{} for cache ID {} and region {}", new Object[]{this.host, this.port, this.cacheId, this.cacheRegion});
            Socket s = this.getSocket();
            this.oos = new ObjectOutputStream(s.getOutputStream());
            this.ois = new ObjectInputStream(s.getInputStream());
            this.connectionOpen = true;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Socket getSocket() {
        try {
            return new Socket(InetAddress.getByName(this.host), this.port);
        }
        catch (IOException e) {
            log.error("Could not create a socket to {}:{}", new Object[]{this.host, this.port, e});
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized V get(K key) {
        Object value = this.memCache.getIfPresent(key);
        if (value == null) {
            this.establishConnection();
            try {
                this.writeDefaultInformation("get", key, this.oos);
                value = this.ois.readObject();
                if (value != null) {
                    this.memCache.put(key, value);
                }
            }
            catch (IOException e) {
                log.trace("Closing connection to {}:{}, cache ID {} and region {} due to exception in get().", new Object[]{this.host, this.port, this.cacheId, this.cacheRegion, e});
                try {
                    this.oos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.ois.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.connectionOpen = false;
                throw new IllegalStateException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return (V)value;
    }

    private void writeDefaultInformation(String method, K key, ObjectOutputStream oos) throws IOException {
        oos.writeUTF(method);
        oos.writeUTF(this.cacheId);
        oos.writeUTF(this.cacheRegion);
        oos.writeUTF(this.keySerializer);
        oos.writeUTF(this.valueSerializer);
        oos.writeObject(key);
    }

    @Override
    public synchronized boolean put(K key, V value) {
        this.establishConnection();
        try {
            if (value != null) {
                this.memCache.put(key, value);
            }
            this.writeDefaultInformation("put", key, this.oos);
            this.oos.writeObject(value);
            this.oos.flush();
            String response = this.ois.readUTF();
            if (response.equalsIgnoreCase("FAILURE")) {
                Exception e = (Exception)this.ois.readObject();
                log.error("Could not put data into the remote cache:", (Throwable)e);
            }
            return response.equals("OK");
        }
        catch (IOException e) {
            log.trace("Closing connection to {}:{}, cache ID {} and region {} due to exception in put().", new Object[]{this.host, this.port, this.cacheId, this.cacheRegion, e});
            this.connectionOpen = false;
            try {
                this.oos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public synchronized void commit() {
        this.establishConnection();
        try {
            this.writeDefaultInformation("put", null, this.oos);
            this.oos.close();
            this.ois.close();
            this.connectionOpen = false;
        }
        catch (IOException e) {
            log.trace("Closing connection to {}:{}, cache ID {} and region {} due to exception in commit().", new Object[]{this.host, this.port, this.cacheId, this.cacheRegion, e});
            try {
                this.oos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.ois.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.connectionOpen = false;
            e.printStackTrace();
        }
    }
}

