/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities;

import java.io.File;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;

public class ConfigurationUtilities {
    public static final String LS = System.getProperty("line.separator");

    public static <T> T requirePresent(String key, Function<String, T> f) throws ConfigurationException {
        T value = f.apply(key);
        if (value == null) {
            throw new ConfigurationException("The passed configuration does not have a value for key " + key + ".");
        }
        return value;
    }

    private static void requireNonNull(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new ConfigurationException("The passed configuration is null.");
        }
    }

    public static void checkParameters(HierarchicalConfiguration<ImmutableNode> importConfig, String ... parameters) throws ConfigurationException {
        ArrayList<String> parameterNotFound = new ArrayList<String>();
        for (String parameter : parameters) {
            if (importConfig.getProperty(parameter) != null) continue;
            parameterNotFound.add(parameter);
        }
        if (!parameterNotFound.isEmpty()) {
            throw new ConfigurationException("The following required parameters are not set in the configuration:" + LS + parameterNotFound.stream().collect(Collectors.joining(LS)));
        }
    }

    public static void checkFilesExist(HierarchicalConfiguration<ImmutableNode> importConfig, String ... parameters) throws ConfigurationException {
        ConfigurationUtilities.checkParameters(importConfig, parameters);
        ArrayList<String> parameterNotFound = new ArrayList<String>();
        for (String parameter : parameters) {
            if (new File(importConfig.getString(parameter)).exists()) continue;
            parameterNotFound.add(parameter);
        }
        if (!parameterNotFound.isEmpty()) {
            throw new ConfigurationException("The following required files given by the configuration do not exist: " + LS + parameterNotFound.stream().collect(Collectors.joining(LS)));
        }
    }

    public static XMLConfiguration loadXmlConfiguration(File configurationFile) throws ConfigurationException {
        try {
            Parameters params = new Parameters();
            FileBasedConfigurationBuilder configBuilder = new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((XMLBuilderParameters)params.xml().setExpressionEngine((ExpressionEngine)new XPathExpressionEngine())).setFile(configurationFile)});
            return (XMLConfiguration)configBuilder.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public static String dot(String ... keys) {
        return Stream.of(keys).collect(Collectors.joining("."));
    }

    public static String slash(String ... keys) {
        return Stream.of(keys).collect(Collectors.joining("/"));
    }

    public static String ws(String baseElement, String newElement) {
        return baseElement + " " + newElement;
    }

    public static String last(String path) {
        return path + "[last()]";
    }
}

