/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities;

import de.julielab.java.utilities.UriUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileUtilities {
    public static BufferedInputStream getInputStreamFromFile(File file) throws IOException {
        InputStream is = new FileInputStream(file);
        String lcfn = file.getName().toLowerCase();
        if (lcfn.contains(".gz") || lcfn.contains(".gzip")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedInputStream(is);
    }

    public static BufferedOutputStream getOutputStreamToFile(File file) throws IOException {
        OutputStream os = new FileOutputStream(file);
        String lcfn = file.getName().toLowerCase();
        if (lcfn.contains(".gz") || lcfn.contains(".gzip")) {
            os = new GZIPOutputStream(os);
        }
        return new BufferedOutputStream(os);
    }

    public static BufferedReader getReaderFromFile(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)FileUtilities.getInputStreamFromFile(file), "UTF-8"));
    }

    public static BufferedWriter getWriterToFile(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)FileUtilities.getOutputStreamToFile(file), "UTF-8"));
    }

    public static void createJarFile(File outputFile, File ... files) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        try (JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(outputFile), manifest);){
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                FileUtilities.addFileToJarOutputStream(file, new StringBuilder(), target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFileToJarOutputStream(File source, StringBuilder rootPath, JarOutputStream target) throws IOException {
        try (BufferedInputStream in = null;){
            int count;
            String name;
            String string = name = rootPath.length() > 0 ? rootPath + source.getName() : source.getName();
            if (source.isDirectory()) {
                if (!name.isEmpty()) {
                    if (!name.endsWith("/")) {
                        name = name + "/";
                    }
                    JarEntry entry = new JarEntry(name);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                rootPath.append(name);
                for (File nestedFile : source.listFiles()) {
                    FileUtilities.addFileToJarOutputStream(nestedFile, rootPath, target);
                }
                return;
            }
            JarEntry entry = new JarEntry(name);
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            in = new BufferedInputStream(new FileInputStream(source));
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
    }

    public static InputStream findResource(String name) throws IOException {
        File file;
        InputStream is = null;
        if (is == null && (file = new File(name)).exists()) {
            is = FileUtilities.getInputStreamFromFile(file);
        }
        if (is == null) {
            try {
                URI uri = new URI(name);
                if (uri.isAbsolute()) {
                    is = UriUtilities.getInputStreamFromUri(uri);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (is == null && (is = FileUtilities.class.getResourceAsStream(name.startsWith("/") ? name : "/" + name)) != null && (name.toLowerCase().contains(".gz") || name.toLowerCase().contains(".gzip"))) {
            is = new GZIPInputStream(is);
        }
        return is;
    }
}

