/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.concepts.db.application;

import de.julielab.concepts.db.application.CLIParameters;
import de.julielab.concepts.db.application.OptionalStringArrayOptionHandler;
import de.julielab.concepts.db.core.services.ConceptCreationService;
import de.julielab.concepts.db.core.services.ConceptInsertionService;
import de.julielab.concepts.db.core.services.DataExportService;
import de.julielab.concepts.db.core.services.DatabaseOperationService;
import de.julielab.concepts.db.core.services.VersioningService;
import de.julielab.concepts.util.ConceptCreationException;
import de.julielab.concepts.util.ConceptDatabaseConnectionException;
import de.julielab.concepts.util.ConceptInsertionException;
import de.julielab.concepts.util.DataExportException;
import de.julielab.concepts.util.DatabaseOperationException;
import de.julielab.concepts.util.FacetCreationException;
import de.julielab.concepts.util.VersioningException;
import de.julielab.java.utilities.ConfigurationUtilities;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionHandlerRegistry;
import org.kohsuke.args4j.ParserProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptDatabaseApplication {
    private static final Logger log = LoggerFactory.getLogger(ConceptDatabaseApplication.class);

    public static void main(String[] args) throws DataExportException, ConceptDatabaseConnectionException, VersioningException {
        OptionHandlerRegistry.getRegistry().registerHandler(String[].class, OptionalStringArrayOptionHandler.class);
        ParserProperties parserProperties = ParserProperties.defaults();
        parserProperties.withUsageWidth(120);
        CLIParameters options = new CLIParameters();
        CmdLineParser parser = new CmdLineParser((Object)options, parserProperties);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getLocalizedMessage());
            parser.printUsage((OutputStream)System.err);
            System.exit(2);
        }
        if (args.length == 0) {
            parser.printUsage((OutputStream)System.out);
            System.exit(1);
        }
        File configFile = options.configurationFile;
        log.debug("Reading configuration from {}", (Object)configFile);
        try {
            XMLConfiguration configuration = ConfigurationUtilities.loadXmlConfiguration((File)configFile);
            ConceptDatabaseApplication.run(options, configuration);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("The configuration file " + configFile.getAbsolutePath() + " could not be loaded.", e);
        }
        catch (ConceptCreationException e) {
            log.error("Database creation could not be completed because the concept creation failed.", (Throwable)e);
        }
        catch (FacetCreationException e) {
            log.error("Database creation could not be completed because the facet creation failed.", (Throwable)e);
        }
        catch (ConceptInsertionException e) {
            log.error("Concept insertion failed", (Throwable)e);
        }
        catch (DatabaseOperationException e) {
            log.error("Database operation could not be completed.", (Throwable)e);
        }
    }

    private static void run(CLIParameters parameters, XMLConfiguration configuration) throws ConceptCreationException, FacetCreationException, ConceptInsertionException, DataExportException, ConceptDatabaseConnectionException, VersioningException, DatabaseOperationException {
        HierarchicalConfiguration connectionConfiguration = configuration.configurationAt("connection");
        if (parameters.doPreparation != null || parameters.doAll != null) {
            ConceptDatabaseApplication.doOperations(parameters, configuration, (HierarchicalConfiguration<ImmutableNode>)connectionConfiguration, "preparations");
        }
        if (parameters.doImport != null || parameters.doAll != null) {
            ConceptDatabaseApplication.doImports(parameters, configuration, (HierarchicalConfiguration<ImmutableNode>)connectionConfiguration);
        }
        if (parameters.doOperation != null || parameters.doAll != null) {
            ConceptDatabaseApplication.doOperations(parameters, configuration, (HierarchicalConfiguration<ImmutableNode>)connectionConfiguration, "operations");
        }
        if (!parameters.noVersioning && (parameters.doVersioning || parameters.doAll != null)) {
            HierarchicalConfiguration versioningConfig = configuration.configurationAt("versioning");
            VersioningService.getInstance((HierarchicalConfiguration)connectionConfiguration).setVersion(versioningConfig);
        }
        if (parameters.doExport != null || parameters.doAll != null) {
            ConceptDatabaseApplication.doExports(parameters, configuration, (HierarchicalConfiguration<ImmutableNode>)connectionConfiguration);
        }
    }

    private static void doExports(CLIParameters parameters, XMLConfiguration configuration, HierarchicalConfiguration<ImmutableNode> connectionConfiguration) throws DataExportException, ConceptDatabaseConnectionException {
        List<String> selectedSteps;
        DataExportService dataExportService = DataExportService.getInstance(connectionConfiguration);
        List<HierarchicalConfiguration> applicableExports = new ArrayList();
        List<String> list = selectedSteps = !ConceptDatabaseApplication.isUnspecified(parameters.doExport) ? parameters.doExport : parameters.doAll;
        if (!ConceptDatabaseApplication.isUnspecified(selectedSteps)) {
            for (String exportName : selectedSteps) {
                try {
                    HierarchicalConfiguration exportConfig = configuration.configurationAt(ConfigurationUtilities.slash((String[])new String[]{"exports", "export[@name='" + exportName + "']"}));
                    applicableExports.add(exportConfig);
                }
                catch (ConfigurationRuntimeException e) {
                    if (ConceptDatabaseApplication.isUnspecified(parameters.doExport)) continue;
                    log.warn("There is no export with name {} in the configuration file.", (Object)exportName);
                    log.trace("Exception was: ", (Throwable)e);
                }
            }
        } else {
            applicableExports = configuration.configurationsAt(ConfigurationUtilities.slash((String[])new String[]{"exports", "export"}));
        }
        for (HierarchicalConfiguration exportConfig : applicableExports) {
            dataExportService.exportData(exportConfig);
        }
    }

    private static void doOperations(CLIParameters parameters, XMLConfiguration configuration, HierarchicalConfiguration<ImmutableNode> connectionConfiguration, String baseElementName) throws DatabaseOperationException {
        List<String> selectedSteps;
        DatabaseOperationService operationService = DatabaseOperationService.getInstance(connectionConfiguration);
        List<HierarchicalConfiguration> applicableOperations = new ArrayList();
        List<String> list = selectedSteps = !ConceptDatabaseApplication.isUnspecified(parameters.doOperation) ? parameters.doOperation : parameters.doAll;
        if (!ConceptDatabaseApplication.isUnspecified(selectedSteps)) {
            for (String importerName : selectedSteps) {
                try {
                    HierarchicalConfiguration operationConfig = configuration.configurationAt(ConfigurationUtilities.slash((String[])new String[]{baseElementName, "operation[@name='" + importerName + "']"}));
                    applicableOperations.add(operationConfig);
                }
                catch (ConfigurationRuntimeException e) {
                    if (ConceptDatabaseApplication.isUnspecified(parameters.doOperation)) continue;
                    log.warn("There is no operation with name {} in the configuration file.", (Object)importerName);
                    log.trace("Exception was: ", (Throwable)e);
                }
            }
        } else {
            applicableOperations = configuration.configurationsAt(ConfigurationUtilities.slash((String[])new String[]{baseElementName, "operation"}));
        }
        for (HierarchicalConfiguration operationConfig : applicableOperations) {
            operationService.operate(operationConfig);
        }
    }

    private static void doImports(CLIParameters parameters, XMLConfiguration configuration, HierarchicalConfiguration<ImmutableNode> connectionConfiguration) throws ConceptCreationException, FacetCreationException, ConceptInsertionException {
        List<String> selectedSteps;
        ConceptCreationService conceptCreationService = ConceptCreationService.getInstance();
        ConceptInsertionService insertionService = ConceptInsertionService.getInstance(connectionConfiguration);
        List<HierarchicalConfiguration> applicableImports = new ArrayList();
        List<String> list = selectedSteps = !ConceptDatabaseApplication.isUnspecified(parameters.doImport) ? parameters.doImport : parameters.doAll;
        if (!ConceptDatabaseApplication.isUnspecified(selectedSteps)) {
            for (String importerName : selectedSteps) {
                try {
                    HierarchicalConfiguration importConfig = configuration.configurationAt(ConfigurationUtilities.slash((String[])new String[]{"imports", "import[@name='" + importerName + "']"}));
                    applicableImports.add(importConfig);
                }
                catch (ConfigurationRuntimeException e) {
                    if (ConceptDatabaseApplication.isUnspecified(parameters.doImport)) continue;
                    log.warn("There is no import with name {} in the configuration file.", (Object)importerName);
                    log.trace("Exception was: ", (Throwable)e);
                }
            }
        } else {
            applicableImports = configuration.configurationsAt(ConfigurationUtilities.slash((String[])new String[]{"imports", "import"}));
        }
        for (HierarchicalConfiguration importConfig : applicableImports) {
            Stream concepts = conceptCreationService.createConcepts(importConfig);
            insertionService.insertConcepts(importConfig, concepts);
        }
    }

    private static boolean isUnspecified(List<String> selectedStepNames) {
        if (selectedStepNames == null) {
            return true;
        }
        return StringUtils.isEmpty((String)selectedStepNames.get(0));
    }
}

