/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.concepts.db.creators;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.julielab.concepts.db.core.services.FacetCreationService;
import de.julielab.concepts.db.core.spi.ConceptCreator;
import de.julielab.concepts.db.creators.Forest;
import de.julielab.concepts.db.creators.Node;
import de.julielab.concepts.util.ConceptCreationException;
import de.julielab.concepts.util.FacetCreationException;
import de.julielab.java.utilities.ConfigurationUtilities;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcept;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcepts;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacet;
import de.julielab.neo4j.plugins.datarepresentation.ImportOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NCBIGeneConceptCreator
implements ConceptCreator {
    public static final String SEMEDICO_RESOURCE_MANAGEMENT_SOURCE = "Semedico Resource Management";
    public static final String NCBI_GENE_SOURCE = "NCBI Gene";
    public static final String BASEPATH = "basepath";
    public static final String GENE_INFO = "gene_info";
    public static final String GENEDESCRIPTIONS = "genedescriptions";
    public static final String ORGANISMLIST = "organismlist";
    public static final String ORGANISMNAMES = "organismnames";
    public static final String GENE_GROUP = "gene_group";
    public static final String HOMOLOGENE_PREFIX = "homologene";
    public static final String GENE_GROUP_PREFIX = "genegroup";
    public static final String TOP_ORTHOLOGY_PREFIX = "toporthology";
    public static final String TOP_HOMOLOGY_PREFIX = "tophomology";
    private int homologeneAggregateCounter;
    private int orthologAggregateCounter;
    private int topOrthologAggregateCounter;
    private int topHomologyAggregateCounter;
    private Logger log = LoggerFactory.getLogger(NCBIGeneConceptCreator.class);

    public NCBIGeneConceptCreator() {
        this.resetCounters();
    }

    public static ConceptCoordinates getGeneCoordinates(String originalId) {
        return new ConceptCoordinates(originalId, NCBI_GENE_SOURCE, originalId, NCBI_GENE_SOURCE);
    }

    private void resetCounters() {
        this.homologeneAggregateCounter = 0;
        this.orthologAggregateCounter = 0;
        this.topOrthologAggregateCounter = 0;
        this.topHomologyAggregateCounter = 0;
    }

    private Stream<ImportConcept> createHomologyAggregates(Stream<ImportConcept> conceptStream, Set<String> totalGeneIds, Map<ConceptCoordinates, ImportConcept> termsByGeneId, File geneGroup) throws IOException {
        HashMultimap genes2Aggregate = HashMultimap.create();
        Forest geneHierarchy = new Forest();
        List<String> aggregateCopyProperties = Arrays.asList("preferredName", "facets");
        Stream<ImportConcept> processedConceptStream = this.createGeneOrthologyAggregates(conceptStream, totalGeneIds, (Multimap<String, ConceptCoordinates>)genes2Aggregate, geneHierarchy, geneGroup, termsByGeneId, aggregateCopyProperties);
        return this.createTopHomologyAggregates(processedConceptStream, geneHierarchy, (Multimap<String, ConceptCoordinates>)genes2Aggregate, aggregateCopyProperties);
    }

    private void checkfornullparentcoords(Map<ConceptCoordinates, ImportConcept> termsByGeneId) {
        for (ImportConcept c : termsByGeneId.values()) {
            if (c.parentCoordinates != null) continue;
            throw new IllegalArgumentException(c.coordinates.toString());
        }
    }

    private Stream<ImportConcept> createTopHomologyAggregates(Stream<ImportConcept> processedConceptStream, Forest geneHierarchy, Multimap<String, ConceptCoordinates> genes2Aggregate, List<String> aggregateCopyProperties) {
        Stream.Builder<ImportConcept> topHomologyStreamBuilder = Stream.builder();
        for (String geneId : genes2Aggregate.keySet()) {
            Set<ImportConcept> topAggregates;
            Optional<Node> topHomologyAggregateOpt = geneHierarchy.getRoots(NCBIGeneConceptCreator.getGeneCoordinates(geneId)).stream().filter(c -> c.getConcept() != null).filter(c -> c.getConcept().coordinates.sourceId.startsWith(TOP_HOMOLOGY_PREFIX)).findAny();
            if (topHomologyAggregateOpt.isPresent() && !topHomologyAggregateOpt.get().getId().sourceId.startsWith(TOP_HOMOLOGY_PREFIX) || (topAggregates = this.findTopOrthologsAndHomologyAggregates(geneId, geneHierarchy)).size() <= 1) continue;
            ImportConcept topHomologyAggregate = new ImportConcept(topAggregates.stream().map(ic -> ic.coordinates).collect(Collectors.toList()), aggregateCopyProperties);
            topHomologyAggregate.coordinates = new ConceptCoordinates();
            topHomologyAggregate.coordinates.sourceId = TOP_HOMOLOGY_PREFIX + this.topHomologyAggregateCounter;
            topHomologyAggregate.coordinates.source = SEMEDICO_RESOURCE_MANAGEMENT_SOURCE;
            topHomologyAggregate.aggregateIncludeInHierarchy = true;
            topHomologyAggregate.generalLabels = Arrays.asList("AGGREGATE_TOP_HOMOLOGY", "NO_PROCESSING_GAZETTEER");
            topHomologyStreamBuilder.accept(topHomologyAggregate);
            ConceptCoordinates topHomologyCoordinates = topHomologyAggregateOpt.get().getConcept().coordinates;
            topAggregates.forEach(agg -> agg.addParent(topHomologyCoordinates));
            ++this.topHomologyAggregateCounter;
        }
        return Stream.concat(processedConceptStream, topHomologyStreamBuilder.build());
    }

    private Set<ImportConcept> findTopOrthologsAndHomologyAggregates(String geneId, Forest geneHierarchy) {
        Set<Node> roots = geneHierarchy.getRoots(NCBIGeneConceptCreator.getGeneCoordinates(geneId));
        return roots.stream().map(Node::getConcept).filter(Objects::nonNull).filter(c -> c.coordinates.sourceId.startsWith(GENE_GROUP_PREFIX)).collect(Collectors.toSet());
    }

    private Stream<ImportConcept> createGeneOrthologyAggregates(Stream<ImportConcept> conceptStream, Set<String> totalGeneIds, Multimap<String, ConceptCoordinates> genes2Aggregate, Forest geneHierarchy, File geneGroup, Map<ConceptCoordinates, ImportConcept> termsByGeneId, List<String> aggregateCopyProperties) throws IOException {
        ConceptCoordinates clusterCoordinates;
        HashMap<String, Set> geneGroupOrthologs = new HashMap<String, Set>();
        Iterator iterator = FileUtilities.getReaderFromFile((File)geneGroup).lines().iterator();
        while (iterator.hasNext()) {
            String geneGroupLine = (String)iterator.next();
            if (geneGroupLine.startsWith("#")) continue;
            String[] geneGroupRecord = geneGroupLine.split("\t");
            if (geneGroupRecord.length < 5) {
                throw new IllegalArgumentException("The line " + geneGroupLine + " does not have at least 5 tab-separated columns.");
            }
            String relationship = geneGroupRecord[2];
            if (!relationship.equals("Ortholog")) continue;
            String gene1 = geneGroupRecord[1].intern();
            String gene2 = geneGroupRecord[4].intern();
            geneGroupOrthologs.compute(gene1, (gene, set) -> {
                HashSet<String> newset = set;
                if (newset == null) {
                    newset = new HashSet<String>();
                }
                newset.add(gene2);
                return newset;
            });
        }
        this.log.info("Got {} orthology groups from gene_ortholog file {}", (Object)geneGroupOrthologs.size(), (Object)geneGroup);
        HashMultimap genes2OrthoAggregate = HashMultimap.create();
        Stream.Builder<ImportConcept> aggregatesStreamBuilder = Stream.builder();
        for (String geneGroupId : geneGroupOrthologs.keySet()) {
            Collection mappingTargets = (Collection)geneGroupOrthologs.get(geneGroupId);
            ArrayList<String> groupGeneIds = new ArrayList<String>(mappingTargets.size() + 1);
            ArrayList<ConceptCoordinates> groupGeneCoords = new ArrayList<ConceptCoordinates>(mappingTargets.size() + 1);
            for (String geneId : mappingTargets) {
                if (!totalGeneIds.contains(geneId)) continue;
                groupGeneIds.add(geneId);
                groupGeneCoords.add(NCBIGeneConceptCreator.getGeneCoordinates(geneId));
            }
            if (totalGeneIds.contains(geneGroupId)) {
                groupGeneIds.add(geneGroupId);
                groupGeneCoords.add(NCBIGeneConceptCreator.getGeneCoordinates(geneGroupId));
            }
            if (groupGeneCoords.size() <= 1) continue;
            ImportConcept orthologyCluster = new ImportConcept(groupGeneCoords, aggregateCopyProperties);
            orthologyCluster.coordinates = new ConceptCoordinates();
            orthologyCluster.coordinates.sourceId = (GENE_GROUP_PREFIX + geneGroupId).intern();
            orthologyCluster.coordinates.source = "GeneOrthology";
            orthologyCluster.coordinates.originalSource = "GeneOrthology";
            orthologyCluster.coordinates.originalId = geneGroupId;
            orthologyCluster.aggregateIncludeInHierarchy = true;
            orthologyCluster.generalLabels = Arrays.asList("AGGREGATE_GENEGROUP", "NO_PROCESSING_GAZETTEER");
            aggregatesStreamBuilder.accept(orthologyCluster);
            ++this.orthologAggregateCounter;
            for (String geneId : groupGeneIds) {
                genes2OrthoAggregate.put((Object)geneId, (Object)orthologyCluster);
                clusterCoordinates = new ConceptCoordinates(orthologyCluster.coordinates.sourceId, orthologyCluster.coordinates.source, true);
                genes2Aggregate.put((Object)geneId, (Object)clusterCoordinates);
                geneHierarchy.addNode(NCBIGeneConceptCreator.getGeneCoordinates(geneId), geneHierarchy.addNode(clusterCoordinates));
            }
        }
        conceptStream = conceptStream.map(arg_0 -> NCBIGeneConceptCreator.lambda$createGeneOrthologyAggregates$6((Multimap)genes2OrthoAggregate, arg_0));
        HashMap<ConceptCoordinates, ImportConcept> orthoAgg2TopOrtho = new HashMap<ConceptCoordinates, ImportConcept>();
        for (String geneid : genes2OrthoAggregate.keySet()) {
            ImportConcept cluster2;
            Collection clusters = genes2OrthoAggregate.get((Object)geneid);
            if (clusters.size() <= 1) continue;
            ImportConcept topOrthologyAggregate = null;
            TreeSet<ImportConcept> seenOrthologyClusters = new TreeSet<ImportConcept>(Comparator.comparingLong(System::identityHashCode));
            Iterator iterator2 = clusters.iterator();
            while (iterator2.hasNext() && (topOrthologyAggregate = this.findTopOrtholog(cluster2 = (ImportConcept)iterator2.next(), seenOrthologyClusters, (Multimap<String, ImportConcept>)genes2OrthoAggregate, orthoAgg2TopOrtho)) == null) {
            }
            if (topOrthologyAggregate == null) {
                topOrthologyAggregate = new ImportConcept(new ArrayList(), aggregateCopyProperties);
                topOrthologyAggregate.coordinates = new ConceptCoordinates();
                topOrthologyAggregate.coordinates.sourceId = TOP_ORTHOLOGY_PREFIX + this.topOrthologAggregateCounter;
                topOrthologyAggregate.coordinates.source = SEMEDICO_RESOURCE_MANAGEMENT_SOURCE;
                topOrthologyAggregate.aggregateIncludeInHierarchy = true;
                topOrthologyAggregate.generalLabels = Arrays.asList("AGGREGATE_TOP_ORTHOLOGY", "NO_PROCESSING_GAZETTEER");
                aggregatesStreamBuilder.accept(topOrthologyAggregate);
                ++this.topOrthologAggregateCounter;
            }
            for (ImportConcept cluster2 : clusters) {
                clusterCoordinates = cluster2.coordinates;
                if (!topOrthologyAggregate.elementCoordinates.contains(clusterCoordinates)) {
                    topOrthologyAggregate.elementCoordinates.add(clusterCoordinates);
                }
                orthoAgg2TopOrtho.put(clusterCoordinates, topOrthologyAggregate);
                cluster2.addParent(topOrthologyAggregate.coordinates);
                geneHierarchy.addNode(cluster2.coordinates).addParent(geneHierarchy.addNode(topOrthologyAggregate.coordinates));
            }
        }
        return Stream.concat(conceptStream, aggregatesStreamBuilder.build());
    }

    private ImportConcept findTopOrtholog(ImportConcept orthologyCluster, Set<ImportConcept> seenOrthologyClusters, Multimap<String, ImportConcept> genes2OrthoAggregate, Map<ConceptCoordinates, ImportConcept> orthoAgg2TopOrtho) {
        ImportConcept topOrtholog = orthoAgg2TopOrtho.get(orthologyCluster.coordinates);
        seenOrthologyClusters.add(orthologyCluster);
        if (topOrtholog == null) {
            for (ConceptCoordinates element : orthologyCluster.elementCoordinates) {
                Collection orthologyClustersOfElement = genes2OrthoAggregate.get((Object)element.originalId);
                for (ImportConcept orthologyClusterOfElement : orthologyClustersOfElement) {
                    if (seenOrthologyClusters.contains(orthologyClusterOfElement)) continue;
                    seenOrthologyClusters.add(orthologyClusterOfElement);
                    topOrtholog = this.findTopOrtholog(orthologyClusterOfElement, seenOrthologyClusters, genes2OrthoAggregate, orthoAgg2TopOrtho);
                    if (topOrtholog == null) continue;
                    return topOrtholog;
                }
            }
        }
        return topOrtholog;
    }

    private Stream<ImportConcept> setSpeciesQualifier(Stream<ImportConcept> conceptStream, File ncbiTaxNames, @Deprecated Map<String, String> geneId2Tax, @Deprecated Collection<ImportConcept> geneTerms) throws IOException {
        HashMap<String, TaxonomyRecord> taxNameRecords = new HashMap<String, TaxonomyRecord>();
        Iterator lineIt = FileUtilities.getReaderFromFile((File)ncbiTaxNames).lines().iterator();
        while (lineIt.hasNext()) {
            String recordString = (String)lineIt.next();
            String[] split = recordString.split("(\t\\|\t)|(\t\\|)");
            String taxId = split[0].intern();
            String name = split[1].intern();
            String nameClass = split[3].intern();
            TaxonomyRecord record = (TaxonomyRecord)taxNameRecords.get(taxId);
            if (null == record) {
                record = new TaxonomyRecord(taxId);
                taxNameRecords.put(taxId, record);
            }
            if (nameClass.equals("scientific name")) {
                record.scientificName = name;
                continue;
            }
            if (!nameClass.equals("genbank common name")) continue;
            record.geneBankCommonName = name;
        }
        return conceptStream.map(gene -> {
            String taxId = (String)gene.getAuxProperty("taxId");
            TaxonomyRecord taxonomyRecord = (TaxonomyRecord)taxNameRecords.get(taxId);
            if (null != taxonomyRecord) {
                Object speciesQualifier = taxonomyRecord.scientificName;
                if (null != taxonomyRecord.geneBankCommonName) {
                    speciesQualifier = (String)speciesQualifier + (" (" + taxonomyRecord.geneBankCommonName + ")").intern();
                }
                gene.addQualifier((String)speciesQualifier);
                gene.displayName = gene.prefName + " [" + taxonomyRecord.scientificName;
                if (null != taxonomyRecord.geneBankCommonName) {
                    gene.displayName = gene.displayName + " (" + taxonomyRecord.geneBankCommonName + ")";
                }
                gene.displayName = gene.displayName + "]";
            } else {
                this.log.warn("No NCBI Taxonomy name record was found for the taxonomy ID {}", (Object)taxId);
            }
            return gene;
        });
    }

    protected Stream<ImportConcept> convertGeneInfoToTerms(File geneInfo, final Set<String> organismSet, File geneDescriptions) throws IOException {
        Iterator lineIt = FileUtilities.getReaderFromFile((File)geneDescriptions).lines().iterator();
        final HashMap<String, String> gene2Summary = new HashMap<String, String>();
        while (lineIt.hasNext()) {
            String line = (String)lineIt.next();
            String[] split = line.split("\t");
            String geneId = split[0].intern();
            String summary = split[1].intern();
            gene2Summary.put(geneId, summary);
        }
        final BufferedReader bw = FileUtilities.getReaderFromFile((File)geneInfo);
        final Iterator it = bw.lines().filter(record -> !record.startsWith("#")).iterator();
        Iterator<ImportConcept> geneIterator = new Iterator<ImportConcept>(){

            @Override
            public boolean hasNext() {
                boolean hasNext = it.hasNext();
                if (!hasNext) {
                    try {
                        bw.close();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                return hasNext;
            }

            @Override
            public ImportConcept next() {
                if (this.hasNext()) {
                    String record = (String)it.next();
                    ImportConcept geneconcept = NCBIGeneConceptCreator.this.createGeneTerm(record, gene2Summary);
                    String[] split = record.split("\t", 2);
                    String taxId = split[0].intern();
                    if (organismSet.contains(taxId) || organismSet.isEmpty()) {
                        geneconcept.putAuxProperty("taxId", (Object)taxId);
                        return geneconcept;
                    }
                }
                return null;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(geneIterator, 0), false).filter(Objects::nonNull);
    }

    private ImportConcept createGeneTerm(String record, Map<String, String> gene2Summary) {
        String[] split = record.split("\t");
        ArrayList<String> synonyms = new ArrayList<String>();
        String prefName = split[2];
        String fullname = split[11];
        if (prefName.length() < 3 && fullname.length() > 2) {
            prefName = fullname;
        } else {
            synonyms.add(fullname);
        }
        String ncbiDescription = split[8];
        if (prefName.length() < 3 && ncbiDescription.length() > 2) {
            prefName = ncbiDescription;
        }
        String originalId = split[1].intern();
        String synonymString = split[4];
        String otherDesignations = split[13];
        String[] synonymSplit = synonymString.split("\\|");
        for (int i = 0; i < synonymSplit.length; ++i) {
            String synonym = synonymSplit[i].intern();
            synonyms.add(synonym);
        }
        String[] otherDesignationsSplit = otherDesignations.split("\\|");
        for (int i = 0; i < otherDesignationsSplit.length; ++i) {
            String synonym = otherDesignationsSplit[i];
            synonyms.add(synonym.intern());
        }
        String description = gene2Summary.get(originalId);
        if (description != null) {
            description = description.intern();
        }
        Iterator synonymIt = synonyms.iterator();
        while (synonymIt.hasNext()) {
            if (((String)synonymIt.next()).length() >= 2) continue;
            synonymIt.remove();
        }
        ImportConcept geneTerm = new ImportConcept(prefName, synonyms, description, NCBIGeneConceptCreator.getGeneCoordinates(originalId));
        geneTerm.addGeneralLabel(new String[]{ConceptLabels.NO_PROCESSING_GAZETTEER.toString(), ConceptLabels.ID_MAP_NCBI_GENES.toString()});
        return geneTerm;
    }

    public void exposeParameters(String basePath, HierarchicalConfiguration<ImmutableNode> template) {
        String base = ConfigurationUtilities.slash((String[])new String[]{basePath, "concepts", "creator", "configuration"});
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "concepts", "creator", "name"}), (Object)this.getName());
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, BASEPATH}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, GENE_INFO}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, GENEDESCRIPTIONS}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, ORGANISMLIST}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, ORGANISMNAMES}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, GENE_GROUP}), (Object)"");
        FacetCreationService.getInstance().exposeParameters(basePath, template);
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "facetgroup", "name"}), (Object)"Biology");
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "name"}), (Object)"Genes");
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "sourcetype"}), (Object)"hierarchical");
    }

    public Stream<ImportConcepts> createConcepts(HierarchicalConfiguration<ImmutableNode> importConfig) throws ConceptCreationException, FacetCreationException {
        this.resetCounters();
        String confPath = ConfigurationUtilities.slash((String[])new String[]{"concepts", "creator", "configuration"});
        try {
            ConfigurationUtilities.checkParameters(importConfig, (String[])new String[]{ConfigurationUtilities.slash((String[])new String[]{confPath, GENE_INFO}), ConfigurationUtilities.slash((String[])new String[]{confPath, GENEDESCRIPTIONS}), ConfigurationUtilities.slash((String[])new String[]{confPath, ORGANISMLIST}), ConfigurationUtilities.slash((String[])new String[]{confPath, ORGANISMNAMES}), ConfigurationUtilities.slash((String[])new String[]{confPath, GENE_GROUP})});
        }
        catch (ConfigurationException e) {
            throw new ConceptCreationException((Throwable)e);
        }
        String basepath = importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, BASEPATH}), "");
        File geneInfo = this.resolvePath(basepath, importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, GENE_INFO})));
        File geneDescriptions = this.resolvePath(basepath, importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, GENEDESCRIPTIONS})));
        File organisms = this.resolvePath(basepath, importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, ORGANISMLIST})));
        File ncbiTaxNames = this.resolvePath(basepath, importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, ORGANISMNAMES})));
        File geneGroup = this.resolvePath(basepath, importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, GENE_GROUP})));
        ArrayList<File> notFound = new ArrayList<File>();
        for (File f : Arrays.asList(geneInfo, geneDescriptions, organisms, ncbiTaxNames, geneGroup)) {
            if (f.exists()) continue;
            notFound.add(f);
        }
        if (!notFound.isEmpty()) {
            throw new ConceptCreationException("The following files do not exist: " + notFound.stream().map(File::getAbsolutePath).collect(Collectors.joining(System.getProperty("line.separator"))));
        }
        try {
            this.log.info("Beginning import of NCBI Genes.");
            this.log.info("Reading the set of organisms to import genes of from {}.", (Object)organisms);
            Set<String> organismSet = FileUtilities.getReaderFromFile((File)organisms).lines().map(String::intern).collect(Collectors.toSet());
            this.log.info("Retrieved {} taxonomy IDs.", (Object)organismSet.size());
            this.log.info("Reading the set of valid gene IDs from {}.", (Object)geneInfo);
            Set<String> totalGeneIds = this.getTotalGeneIds(geneInfo, organismSet);
            this.log.info("Got {} gene IDs.", (Object)totalGeneIds.size());
            HashMap<String, String> geneId2Tax = new HashMap<String, String>();
            HashMap<ConceptCoordinates, ImportConcept> conceptsByGeneId = new HashMap<ConceptCoordinates, ImportConcept>();
            this.log.info("Creating a stream converting NCBI Gene's gene_info file into nodes for the concept graph.");
            Stream<ImportConcept> conceptStream = this.convertGeneInfoToTerms(geneInfo, organismSet, geneDescriptions);
            conceptStream = this.setSpeciesQualifier(conceptStream, ncbiTaxNames, geneId2Tax, conceptsByGeneId.values());
            this.log.info("Creating homology aggregates");
            conceptStream = this.createHomologyAggregates(conceptStream, totalGeneIds, conceptsByGeneId, geneGroup);
            this.log.info("Created {} homology aggregates", (Object)this.homologeneAggregateCounter);
            this.log.info("Created {} orthology aggregates", (Object)this.orthologAggregateCounter);
            this.log.info("Created {} top-homology aggregates, governing homologene and orthology aggregates", (Object)this.topHomologyAggregateCounter);
            ImportFacet facet = FacetCreationService.getInstance().createFacet(importConfig);
            ImportOptions options = new ImportOptions();
            options.createHollowAggregateElements = true;
            options.doNotCreateHollowParents = false;
            ImportConcepts importConcepts = new ImportConcepts(conceptStream, facet);
            importConcepts.setNumConcepts((long)(totalGeneIds.size() + this.homologeneAggregateCounter + this.orthologAggregateCounter + this.topHomologyAggregateCounter));
            importConcepts.setImportOptions(options);
            return Stream.of(importConcepts);
        }
        catch (IOException e) {
            throw new ConceptCreationException((Throwable)e);
        }
    }

    private Set<String> getTotalGeneIds(File geneInfo, Set<String> organismSet) throws IOException {
        try (BufferedReader bw = FileUtilities.getReaderFromFile((File)geneInfo);){
            Set<String> set = bw.lines().filter(record -> !record.startsWith("#")).map(record -> record.split("\t", 3)).filter(split -> organismSet.contains(split[0]) || organismSet.isEmpty()).map(split -> split[1].intern()).collect(Collectors.toSet());
            return set;
        }
    }

    private File resolvePath(String basepath, String filepath) {
        String delimiter = !basepath.endsWith(File.separator) && !filepath.startsWith(File.separator) ? File.separator : "";
        String path = new File(filepath).isAbsolute() ? filepath : basepath + delimiter + filepath;
        return new File(path);
    }

    public String getName() {
        return "NCBIGeneConceptCreator";
    }

    private static /* synthetic */ ImportConcept lambda$createGeneOrthologyAggregates$6(Multimap genes2OrthoAggregate, ImportConcept gene) {
        Collection orthoAggregates = genes2OrthoAggregate.get((Object)gene.coordinates.originalId);
        for (ImportConcept orthoAggregate : orthoAggregates) {
            gene.addParent(orthoAggregate.coordinates);
            if (orthoAggregates.size() <= 1) continue;
            gene.addGeneralLabel(new String[]{ConceptLabels.NO_QUERY_DICTIONARY.name(), ConceptLabels.NO_SUGGESTIONS.name()});
        }
        return gene;
    }

    private class HomologeneRecord {
        String taxId;
        String geneId;
        String groupId;

        public HomologeneRecord(String[] record) {
            this.groupId = record[0].intern();
            this.taxId = record[1].intern();
            this.geneId = record[2].intern();
        }
    }

    private class TaxonomyRecord {
        String taxId;
        String scientificName;
        String geneBankCommonName;

        public TaxonomyRecord(String taxId) {
            this.taxId = taxId.intern();
        }
    }

    private static enum ConceptLabels {
        NO_PROCESSING_GAZETTEER,
        NO_SUGGESTIONS,
        NO_QUERY_DICTIONARY,
        ID_MAP_NCBI_GENES;

    }
}

