/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.concepts.db.creators;

import de.julielab.concepts.db.creators.Node;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcept;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Forest {
    private Map<ConceptCoordinates, Node> id2node = new HashMap<ConceptCoordinates, Node>();

    public Node addNode(ConceptCoordinates id) {
        Node n = this.id2node.get(id);
        if (n == null) {
            n = new Node(id);
            this.id2node.put(id, n);
        }
        return n;
    }

    public Node addNode(ImportConcept concept) {
        return this.addNode(concept.coordinates, concept.parentCoordinates);
    }

    public Node addNode(ConceptCoordinates id, Iterable<ConceptCoordinates> parentIds) {
        Node n = this.addNode(id);
        for (ConceptCoordinates pId : parentIds) {
            n.addParent(this.addNode(pId));
        }
        return n;
    }

    public Node addNode(ConceptCoordinates id, ConceptCoordinates parentId) {
        Node n = this.addNode(id);
        Node pn = this.addNode(parentId);
        n.addParent(pn);
        return n;
    }

    public Node addNode(ConceptCoordinates id, Node parent) {
        Node n = this.addNode(id);
        n.addParent(parent);
        return n;
    }

    public Set<Node> getRoots(ConceptCoordinates id) {
        Node n = this.id2node.get(id);
        if (n == null) {
            return Collections.emptySet();
        }
        if (n.getParents() == null || n.getParents().isEmpty()) {
            return Set.of(n);
        }
        return n.getParents().stream().map(Node::getId).map(this::getRoots).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Optional<Node> getRoot(ConceptCoordinates geneId) {
        Set<Node> roots = this.getRoots(geneId);
        if (roots.size() > 1) {
            throw new IllegalStateException("A single root for geneId " + geneId + " was expected but there were " + roots.size() + ".");
        }
        return roots.stream().findAny();
    }
}

